/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.finder.PrimitiveWrapperMap;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Insets;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuShortcut;
import java.awt.Window;
import java.awt.font.TextAttribute;
import java.beans.ConstructorProperties;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.EventHandler;
import java.beans.Expression;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PersistenceDelegate;
import java.beans.Statement;
import java.beans.XMLEncoder;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.ToolTipManager;
import javax.swing.border.MatteBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.tree.DefaultMutableTreeNode;
import sun.reflect.misc.ReflectUtil;

class MetaData {
    private static final Map<String, Field> fields = Collections.synchronizedMap(new WeakHashMap());
    private static Hashtable<String, PersistenceDelegate> internalPersistenceDelegates = new Hashtable();
    private static PersistenceDelegate nullPersistenceDelegate = new NullPersistenceDelegate();
    private static PersistenceDelegate enumPersistenceDelegate = new EnumPersistenceDelegate();
    private static PersistenceDelegate primitivePersistenceDelegate = new PrimitivePersistenceDelegate();
    private static PersistenceDelegate defaultPersistenceDelegate = new DefaultPersistenceDelegate();
    private static PersistenceDelegate arrayPersistenceDelegate;
    private static PersistenceDelegate proxyPersistenceDelegate;

    MetaData() {
    }

    public static synchronized PersistenceDelegate getPersistenceDelegate(Class type) {
        if (type == null) {
            return nullPersistenceDelegate;
        }
        if (Enum.class.isAssignableFrom(type)) {
            return enumPersistenceDelegate;
        }
        if (null != XMLEncoder.primitiveTypeFor(type)) {
            return primitivePersistenceDelegate;
        }
        if (type.isArray()) {
            if (arrayPersistenceDelegate == null) {
                arrayPersistenceDelegate = new ArrayPersistenceDelegate();
            }
            return arrayPersistenceDelegate;
        }
        try {
            if (Proxy.isProxyClass(type)) {
                if (proxyPersistenceDelegate == null) {
                    proxyPersistenceDelegate = new ProxyPersistenceDelegate();
                }
                return proxyPersistenceDelegate;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        String typeName = type.getName();
        PersistenceDelegate pd = (PersistenceDelegate)MetaData.getBeanAttribute(type, "persistenceDelegate");
        if (pd == null) {
            pd = internalPersistenceDelegates.get(typeName);
            if (pd != null) {
                return pd;
            }
            internalPersistenceDelegates.put(typeName, defaultPersistenceDelegate);
            try {
                String name = type.getName();
                Class<?> c = Class.forName("java.beans.MetaData$" + name.replace('.', '_') + "_PersistenceDelegate");
                pd = (PersistenceDelegate)c.newInstance();
                internalPersistenceDelegates.put(typeName, pd);
            }
            catch (ClassNotFoundException e) {
                String[] properties = MetaData.getConstructorProperties(type);
                if (properties != null) {
                    pd = new DefaultPersistenceDelegate(properties);
                    internalPersistenceDelegates.put(typeName, pd);
                }
            }
            catch (Exception e) {
                System.err.println("Internal error: " + e);
            }
        }
        return pd != null ? pd : defaultPersistenceDelegate;
    }

    private static String[] getConstructorProperties(Class<?> type) {
        String[] names = null;
        int length = 0;
        for (Constructor<?> constructor : type.getConstructors()) {
            String[] value = MetaData.getAnnotationValue(constructor);
            if (value == null || length >= value.length || !MetaData.isValid(constructor, value)) continue;
            names = value;
            length = value.length;
        }
        return names;
    }

    private static String[] getAnnotationValue(Constructor<?> constructor) {
        ConstructorProperties annotation = constructor.getAnnotation(ConstructorProperties.class);
        return annotation != null ? annotation.value() : null;
    }

    private static boolean isValid(Constructor<?> constructor, String[] names) {
        Class<?>[] parameters = constructor.getParameterTypes();
        if (names.length != parameters.length) {
            return false;
        }
        for (String name : names) {
            if (name != null) continue;
            return false;
        }
        return true;
    }

    private static Object getBeanAttribute(Class<?> type, String attribute) {
        try {
            return Introspector.getBeanInfo(type).getBeanDescriptor().getValue(attribute);
        }
        catch (IntrospectionException exception) {
            return null;
        }
    }

    static Object getPrivateFieldValue(Object instance, String name) {
        Field field = fields.get(name);
        if (field == null) {
            int index = name.lastIndexOf(46);
            final String className = name.substring(0, index);
            final String fieldName = name.substring(1 + index);
            field = AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    try {
                        Field field = Class.forName(className).getDeclaredField(fieldName);
                        field.setAccessible(true);
                        return field;
                    }
                    catch (ClassNotFoundException exception) {
                        throw new IllegalStateException("Could not find class", exception);
                    }
                    catch (NoSuchFieldException exception) {
                        throw new IllegalStateException("Could not find field", exception);
                    }
                }
            });
            fields.put(name, field);
        }
        try {
            return field.get(instance);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalStateException("Could not get value of the field", exception);
        }
    }

    static {
        internalPersistenceDelegates.put("java.net.URI", new PrimitivePersistenceDelegate());
        internalPersistenceDelegates.put("javax.swing.plaf.BorderUIResource$MatteBorderUIResource", new javax_swing_border_MatteBorder_PersistenceDelegate());
        internalPersistenceDelegates.put("javax.swing.plaf.FontUIResource", new java_awt_Font_PersistenceDelegate());
        internalPersistenceDelegates.put("javax.swing.KeyStroke", new java_awt_AWTKeyStroke_PersistenceDelegate());
        internalPersistenceDelegates.put("java.sql.Date", new java_util_Date_PersistenceDelegate());
        internalPersistenceDelegates.put("java.sql.Time", new java_util_Date_PersistenceDelegate());
        internalPersistenceDelegates.put("java.util.JumboEnumSet", new java_util_EnumSet_PersistenceDelegate());
        internalPersistenceDelegates.put("java.util.RegularEnumSet", new java_util_EnumSet_PersistenceDelegate());
    }

    static final class sun_swing_PrintColorUIResource_PersistenceDelegate
    extends PersistenceDelegate {
        sun_swing_PrintColorUIResource_PersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance.equals(newInstance);
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Color color = (Color)oldInstance;
            Object[] args = new Object[]{color.getRGB()};
            return new Expression(color, ColorUIResource.class, "new", args);
        }
    }

    static final class javax_swing_border_MatteBorder_PersistenceDelegate
    extends PersistenceDelegate {
        javax_swing_border_MatteBorder_PersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            MatteBorder border = (MatteBorder)oldInstance;
            Insets insets = border.getBorderInsets();
            Object object = border.getTileIcon();
            if (object == null) {
                object = border.getMatteColor();
            }
            Object[] args = new Object[]{insets.top, insets.left, insets.bottom, insets.right, object};
            return new Expression(border, border.getClass(), "new", args);
        }
    }

    static final class javax_swing_JMenu_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        javax_swing_JMenu_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            JMenu m = (JMenu)oldInstance;
            Component[] c = m.getMenuComponents();
            for (int i = 0; i < c.length; ++i) {
                javax_swing_JMenu_PersistenceDelegate.invokeStatement(oldInstance, "add", new Object[]{c[i]}, out);
            }
        }
    }

    static final class javax_swing_Box_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        javax_swing_Box_PersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return super.mutatesTo(oldInstance, newInstance) && this.getAxis(oldInstance).equals(this.getAxis(newInstance));
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{this.getAxis(oldInstance)});
        }

        private Integer getAxis(Object object) {
            Box box = (Box)object;
            return (Integer)MetaData.getPrivateFieldValue(box.getLayout(), "javax.swing.BoxLayout.axis");
        }
    }

    static final class javax_swing_JTabbedPane_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        javax_swing_JTabbedPane_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            JTabbedPane p = (JTabbedPane)oldInstance;
            for (int i = 0; i < p.getTabCount(); ++i) {
                javax_swing_JTabbedPane_PersistenceDelegate.invokeStatement(oldInstance, "addTab", new Object[]{p.getTitleAt(i), p.getIconAt(i), p.getComponentAt(i)}, out);
            }
        }
    }

    static final class javax_swing_ToolTipManager_PersistenceDelegate
    extends PersistenceDelegate {
        javax_swing_ToolTipManager_PersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, ToolTipManager.class, "sharedInstance", new Object[0]);
        }
    }

    static final class javax_swing_tree_DefaultMutableTreeNode_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        javax_swing_tree_DefaultMutableTreeNode_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            DefaultMutableTreeNode m = (DefaultMutableTreeNode)oldInstance;
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)newInstance;
            for (int i = n.getChildCount(); i < m.getChildCount(); ++i) {
                javax_swing_tree_DefaultMutableTreeNode_PersistenceDelegate.invokeStatement(oldInstance, "add", new Object[]{m.getChildAt(i)}, out);
            }
        }
    }

    static final class javax_swing_DefaultComboBoxModel_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        javax_swing_DefaultComboBoxModel_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            DefaultComboBoxModel m = (DefaultComboBoxModel)oldInstance;
            for (int i = 0; i < m.getSize(); ++i) {
                javax_swing_DefaultComboBoxModel_PersistenceDelegate.invokeStatement(oldInstance, "addElement", new Object[]{m.getElementAt(i)}, out);
            }
        }
    }

    static final class javax_swing_DefaultListModel_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        javax_swing_DefaultListModel_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            DefaultListModel m = (DefaultListModel)oldInstance;
            DefaultListModel n = (DefaultListModel)newInstance;
            for (int i = n.getSize(); i < m.getSize(); ++i) {
                javax_swing_DefaultListModel_PersistenceDelegate.invokeStatement(oldInstance, "add", new Object[]{m.getElementAt(i)}, out);
            }
        }
    }

    static final class javax_swing_JFrame_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        javax_swing_JFrame_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            Window oldC = (Window)oldInstance;
            Window newC = (Window)newInstance;
            boolean oldV = oldC.isVisible();
            boolean newV = newC.isVisible();
            if (newV != oldV) {
                boolean executeStatements = out.executeStatements;
                out.executeStatements = false;
                javax_swing_JFrame_PersistenceDelegate.invokeStatement(oldInstance, "setVisible", new Object[]{oldV}, out);
                out.executeStatements = executeStatements;
            }
        }
    }

    static final class java_awt_GridBagLayout_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        java_awt_GridBagLayout_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            if (java_awt_GridBagLayout_PersistenceDelegate.getHashtable(newInstance).isEmpty()) {
                for (Map.Entry<?, ?> entry : java_awt_GridBagLayout_PersistenceDelegate.getHashtable(oldInstance).entrySet()) {
                    Object[] args = new Object[]{entry.getKey(), entry.getValue()};
                    java_awt_GridBagLayout_PersistenceDelegate.invokeStatement(oldInstance, "addLayoutComponent", args, out);
                }
            }
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return super.mutatesTo(oldInstance, newInstance) && java_awt_GridBagLayout_PersistenceDelegate.getHashtable(newInstance).isEmpty();
        }

        private static Hashtable<?, ?> getHashtable(Object instance) {
            return (Hashtable)MetaData.getPrivateFieldValue(instance, "java.awt.GridBagLayout.comptable");
        }
    }

    static final class java_awt_CardLayout_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        java_awt_CardLayout_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            if (java_awt_CardLayout_PersistenceDelegate.getVector(newInstance).isEmpty()) {
                for (Object card : java_awt_CardLayout_PersistenceDelegate.getVector(oldInstance)) {
                    Object[] args = new Object[]{MetaData.getPrivateFieldValue(card, "java.awt.CardLayout$Card.name"), MetaData.getPrivateFieldValue(card, "java.awt.CardLayout$Card.comp")};
                    java_awt_CardLayout_PersistenceDelegate.invokeStatement(oldInstance, "addLayoutComponent", args, out);
                }
            }
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return super.mutatesTo(oldInstance, newInstance) && java_awt_CardLayout_PersistenceDelegate.getVector(newInstance).isEmpty();
        }

        private static Vector<?> getVector(Object instance) {
            return (Vector)MetaData.getPrivateFieldValue(instance, "java.awt.CardLayout.vector");
        }
    }

    static final class java_awt_BorderLayout_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        private static final String[] CONSTRAINTS = new String[]{"North", "South", "East", "West", "Center", "First", "Last", "Before", "After"};

        java_awt_BorderLayout_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            BorderLayout oldLayout = (BorderLayout)oldInstance;
            BorderLayout newLayout = (BorderLayout)newInstance;
            for (String constraints : CONSTRAINTS) {
                Component oldC = oldLayout.getLayoutComponent(constraints);
                Component newC = newLayout.getLayoutComponent(constraints);
                if (oldC == null || newC != null) continue;
                java_awt_BorderLayout_PersistenceDelegate.invokeStatement(oldInstance, "addLayoutComponent", new Object[]{oldC, constraints}, out);
            }
        }
    }

    static final class java_awt_List_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        java_awt_List_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            List m = (List)oldInstance;
            List n = (List)newInstance;
            for (int i = n.getItemCount(); i < m.getItemCount(); ++i) {
                java_awt_List_PersistenceDelegate.invokeStatement(oldInstance, "add", new Object[]{m.getItem(i)}, out);
            }
        }
    }

    static final class java_awt_MenuBar_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        java_awt_MenuBar_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            MenuBar m = (MenuBar)oldInstance;
            MenuBar n = (MenuBar)newInstance;
            for (int i = n.getMenuCount(); i < m.getMenuCount(); ++i) {
                java_awt_MenuBar_PersistenceDelegate.invokeStatement(oldInstance, "add", new Object[]{m.getMenu(i)}, out);
            }
        }
    }

    static final class java_awt_Menu_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        java_awt_Menu_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            Menu m = (Menu)oldInstance;
            Menu n = (Menu)newInstance;
            for (int i = n.getItemCount(); i < m.getItemCount(); ++i) {
                java_awt_Menu_PersistenceDelegate.invokeStatement(oldInstance, "add", new Object[]{m.getItem(i)}, out);
            }
        }
    }

    static final class java_awt_Choice_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        java_awt_Choice_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            Choice m = (Choice)oldInstance;
            Choice n = (Choice)newInstance;
            for (int i = n.getItemCount(); i < m.getItemCount(); ++i) {
                java_awt_Choice_PersistenceDelegate.invokeStatement(oldInstance, "add", new Object[]{m.getItem(i)}, out);
            }
        }
    }

    static final class java_awt_Container_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        java_awt_Container_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            super.initialize(type, oldInstance, newInstance, out);
            if (oldInstance instanceof JScrollPane) {
                return;
            }
            Container oldC = (Container)oldInstance;
            Component[] oldChildren = oldC.getComponents();
            Container newC = (Container)newInstance;
            Component[] newChildren = newC == null ? new Component[]{} : newC.getComponents();
            BorderLayout layout = oldC.getLayout() instanceof BorderLayout ? (BorderLayout)oldC.getLayout() : null;
            JLayeredPane oldLayeredPane = oldInstance instanceof JLayeredPane ? (JLayeredPane)oldInstance : null;
            for (int i = newChildren.length; i < oldChildren.length; ++i) {
                Object[] objectArray;
                if (layout != null) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = oldChildren[i];
                    objectArray = objectArray2;
                    objectArray2[1] = layout.getConstraints(oldChildren[i]);
                } else if (oldLayeredPane != null) {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = oldChildren[i];
                    objectArray3[1] = oldLayeredPane.getLayer(oldChildren[i]);
                    objectArray = objectArray3;
                    objectArray3[2] = -1;
                } else {
                    Object[] objectArray4 = new Object[1];
                    objectArray = objectArray4;
                    objectArray4[0] = oldChildren[i];
                }
                Object[] args = objectArray;
                java_awt_Container_PersistenceDelegate.invokeStatement(oldInstance, "add", args, out);
            }
        }
    }

    static final class java_awt_Component_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        java_awt_Component_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Container p;
            super.initialize(type, oldInstance, newInstance, out);
            Component c = (Component)oldInstance;
            Component c2 = (Component)newInstance;
            if (!(oldInstance instanceof Window)) {
                Font newFont;
                Color newForeground;
                Color newBackground;
                Color oldBackground = c.isBackgroundSet() ? c.getBackground() : null;
                Color color = newBackground = c2.isBackgroundSet() ? c2.getBackground() : null;
                if (!Objects.equals(oldBackground, newBackground)) {
                    java_awt_Component_PersistenceDelegate.invokeStatement(oldInstance, "setBackground", new Object[]{oldBackground}, out);
                }
                Color oldForeground = c.isForegroundSet() ? c.getForeground() : null;
                Color color2 = newForeground = c2.isForegroundSet() ? c2.getForeground() : null;
                if (!Objects.equals(oldForeground, newForeground)) {
                    java_awt_Component_PersistenceDelegate.invokeStatement(oldInstance, "setForeground", new Object[]{oldForeground}, out);
                }
                Font oldFont = c.isFontSet() ? c.getFont() : null;
                Font font = newFont = c2.isFontSet() ? c2.getFont() : null;
                if (!Objects.equals(oldFont, newFont)) {
                    java_awt_Component_PersistenceDelegate.invokeStatement(oldInstance, "setFont", new Object[]{oldFont}, out);
                }
            }
            if ((p = c.getParent()) == null || p.getLayout() == null) {
                boolean locationCorrect = c.getLocation().equals(c2.getLocation());
                boolean sizeCorrect = c.getSize().equals(c2.getSize());
                if (!locationCorrect && !sizeCorrect) {
                    java_awt_Component_PersistenceDelegate.invokeStatement(oldInstance, "setBounds", new Object[]{c.getBounds()}, out);
                } else if (!locationCorrect) {
                    java_awt_Component_PersistenceDelegate.invokeStatement(oldInstance, "setLocation", new Object[]{c.getLocation()}, out);
                } else if (!sizeCorrect) {
                    java_awt_Component_PersistenceDelegate.invokeStatement(oldInstance, "setSize", new Object[]{c.getSize()}, out);
                }
            }
        }
    }

    static final class java_awt_MenuShortcut_PersistenceDelegate
    extends PersistenceDelegate {
        java_awt_MenuShortcut_PersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance.equals(newInstance);
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            MenuShortcut m = (MenuShortcut)oldInstance;
            return new Expression(oldInstance, m.getClass(), "new", new Object[]{new Integer(m.getKey()), m.usesShiftModifier()});
        }
    }

    static final class java_awt_font_TextAttribute_PersistenceDelegate
    extends StaticFieldsPersistenceDelegate {
        java_awt_font_TextAttribute_PersistenceDelegate() {
        }
    }

    static final class java_awt_SystemColor_PersistenceDelegate
    extends StaticFieldsPersistenceDelegate {
        java_awt_SystemColor_PersistenceDelegate() {
        }
    }

    static class StaticFieldsPersistenceDelegate
    extends PersistenceDelegate {
        StaticFieldsPersistenceDelegate() {
        }

        protected void installFields(Encoder out, Class<?> cls) {
            if (Modifier.isPublic(cls.getModifiers()) && ReflectUtil.isPackageAccessible(cls)) {
                Field[] fields = cls.getFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    if (!Object.class.isAssignableFrom(field.getType())) continue;
                    out.writeExpression(new Expression(field, "get", new Object[]{null}));
                }
            }
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            throw new RuntimeException("Unrecognized instance: " + oldInstance);
        }

        @Override
        public void writeObject(Object oldInstance, Encoder out) {
            if (out.getAttribute(this) == null) {
                out.setAttribute(this, Boolean.TRUE);
                this.installFields(out, oldInstance.getClass());
            }
            super.writeObject(oldInstance, out);
        }
    }

    static final class java_awt_AWTKeyStroke_PersistenceDelegate
    extends PersistenceDelegate {
        java_awt_AWTKeyStroke_PersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance.equals(newInstance);
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            AWTKeyStroke key = (AWTKeyStroke)oldInstance;
            char ch = key.getKeyChar();
            int code = key.getKeyCode();
            int mask = key.getModifiers();
            boolean onKeyRelease = key.isOnKeyRelease();
            Object[] args = null;
            if (ch == '\uffff') {
                Object[] objectArray;
                if (!onKeyRelease) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = code;
                    objectArray = objectArray2;
                    objectArray2[1] = mask;
                } else {
                    Object[] objectArray3 = new Object[3];
                    objectArray3[0] = code;
                    objectArray3[1] = mask;
                    objectArray = objectArray3;
                    objectArray3[2] = onKeyRelease;
                }
                args = objectArray;
            } else if (code == 0) {
                if (!onKeyRelease) {
                    Object[] objectArray;
                    if (mask == 0) {
                        Object[] objectArray4 = new Object[1];
                        objectArray = objectArray4;
                        objectArray4[0] = Character.valueOf(ch);
                    } else {
                        Object[] objectArray5 = new Object[2];
                        objectArray5[0] = Character.valueOf(ch);
                        objectArray = objectArray5;
                        objectArray5[1] = mask;
                    }
                    args = objectArray;
                } else if (mask == 0) {
                    args = new Object[]{Character.valueOf(ch), onKeyRelease};
                }
            }
            if (args == null) {
                throw new IllegalStateException("Unsupported KeyStroke: " + key);
            }
            Class<?> type = key.getClass();
            String name = type.getName();
            int index = name.lastIndexOf(46) + 1;
            if (index > 0) {
                name = name.substring(index);
            }
            return new Expression(key, type, "get" + name, args);
        }
    }

    static final class java_awt_Font_PersistenceDelegate
    extends PersistenceDelegate {
        java_awt_Font_PersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance.equals(newInstance);
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Font font = (Font)oldInstance;
            int count = 0;
            String family = null;
            int style = 0;
            int size = 12;
            Map<TextAttribute, ?> basic2 = font.getAttributes();
            HashMap clone = new HashMap(basic2.size());
            for (TextAttribute key : basic2.keySet()) {
                Number number;
                Object value = basic2.get(key);
                if (value != null) {
                    clone.put(key, value);
                }
                if (key == TextAttribute.FAMILY) {
                    if (!(value instanceof String)) continue;
                    ++count;
                    family = (String)value;
                    continue;
                }
                if (key == TextAttribute.WEIGHT) {
                    if (TextAttribute.WEIGHT_REGULAR.equals(value)) {
                        ++count;
                        continue;
                    }
                    if (!TextAttribute.WEIGHT_BOLD.equals(value)) continue;
                    ++count;
                    style |= 1;
                    continue;
                }
                if (key == TextAttribute.POSTURE) {
                    if (TextAttribute.POSTURE_REGULAR.equals(value)) {
                        ++count;
                        continue;
                    }
                    if (!TextAttribute.POSTURE_OBLIQUE.equals(value)) continue;
                    ++count;
                    style |= 2;
                    continue;
                }
                if (key != TextAttribute.SIZE || !(value instanceof Number) || (float)(size = (number = (Number)value).intValue()) != number.floatValue()) continue;
                ++count;
            }
            Class<?> type = font.getClass();
            if (count == clone.size()) {
                return new Expression(font, type, "new", new Object[]{family, style, size});
            }
            if (type == Font.class) {
                return new Expression(font, type, "getFont", new Object[]{clone});
            }
            return new Expression(font, type, "new", new Object[]{Font.getFont(clone)});
        }
    }

    static final class java_awt_Insets_PersistenceDelegate
    extends PersistenceDelegate {
        java_awt_Insets_PersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance.equals(newInstance);
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Insets insets = (Insets)oldInstance;
            Object[] args = new Object[]{insets.top, insets.left, insets.bottom, insets.right};
            return new Expression(insets, insets.getClass(), "new", args);
        }
    }

    static final class java_beans_beancontext_BeanContextSupport_PersistenceDelegate
    extends java_util_Collection_PersistenceDelegate {
        java_beans_beancontext_BeanContextSupport_PersistenceDelegate() {
        }
    }

    static final class java_util_Hashtable_PersistenceDelegate
    extends java_util_Map_PersistenceDelegate {
        java_util_Hashtable_PersistenceDelegate() {
        }
    }

    static final class java_util_AbstractMap_PersistenceDelegate
    extends java_util_Map_PersistenceDelegate {
        java_util_AbstractMap_PersistenceDelegate() {
        }
    }

    static final class java_util_AbstractList_PersistenceDelegate
    extends java_util_List_PersistenceDelegate {
        java_util_AbstractList_PersistenceDelegate() {
        }
    }

    static final class java_util_AbstractCollection_PersistenceDelegate
    extends java_util_Collection_PersistenceDelegate {
        java_util_AbstractCollection_PersistenceDelegate() {
        }
    }

    static class java_util_Map_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        java_util_Map_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Map oldMap = (Map)oldInstance;
            Map newMap = (Map)newInstance;
            if (newMap != null) {
                for (Object newKey : newMap.keySet().toArray()) {
                    if (oldMap.containsKey(newKey)) continue;
                    java_util_Map_PersistenceDelegate.invokeStatement(oldInstance, "remove", new Object[]{newKey}, out);
                }
            }
            for (Object oldKey : oldMap.keySet()) {
                Expression oldGetExp = new Expression(oldInstance, "get", new Object[]{oldKey});
                Expression newGetExp = new Expression(newInstance, "get", new Object[]{oldKey});
                try {
                    Object oldValue = oldGetExp.getValue();
                    Object newValue = newGetExp.getValue();
                    out.writeExpression(oldGetExp);
                    if (!Objects.equals(newValue, out.get(oldValue))) {
                        java_util_Map_PersistenceDelegate.invokeStatement(oldInstance, "put", new Object[]{oldKey, oldValue}, out);
                        continue;
                    }
                    if (newValue != null || newMap.containsKey(oldKey)) continue;
                    java_util_Map_PersistenceDelegate.invokeStatement(oldInstance, "put", new Object[]{oldKey, oldValue}, out);
                }
                catch (Exception e) {
                    out.getExceptionListener().exceptionThrown(e);
                }
            }
        }
    }

    static class java_util_List_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        java_util_List_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            int i;
            int newSize;
            java.util.List oldO = (java.util.List)oldInstance;
            java.util.List newO = (java.util.List)newInstance;
            int oldSize = oldO.size();
            int n = newSize = newO == null ? 0 : newO.size();
            if (oldSize < newSize) {
                java_util_List_PersistenceDelegate.invokeStatement(oldInstance, "clear", new Object[0], out);
                newSize = 0;
            }
            for (i = 0; i < newSize; ++i) {
                Integer index = new Integer(i);
                Expression oldGetExp = new Expression(oldInstance, "get", new Object[]{index});
                Expression newGetExp = new Expression(newInstance, "get", new Object[]{index});
                try {
                    Object oldValue = oldGetExp.getValue();
                    Object newValue = newGetExp.getValue();
                    out.writeExpression(oldGetExp);
                    if (Objects.equals(newValue, out.get(oldValue))) continue;
                    java_util_List_PersistenceDelegate.invokeStatement(oldInstance, "set", new Object[]{index, oldValue}, out);
                    continue;
                }
                catch (Exception e) {
                    out.getExceptionListener().exceptionThrown(e);
                }
            }
            for (i = newSize; i < oldSize; ++i) {
                java_util_List_PersistenceDelegate.invokeStatement(oldInstance, "add", new Object[]{oldO.get(i)}, out);
            }
        }
    }

    static class java_util_Collection_PersistenceDelegate
    extends DefaultPersistenceDelegate {
        java_util_Collection_PersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            Collection oldO = (Collection)oldInstance;
            Collection newO = (Collection)newInstance;
            if (newO.size() != 0) {
                java_util_Collection_PersistenceDelegate.invokeStatement(oldInstance, "clear", new Object[0], out);
            }
            Iterator i = oldO.iterator();
            while (i.hasNext()) {
                java_util_Collection_PersistenceDelegate.invokeStatement(oldInstance, "add", new Object[]{i.next()}, out);
            }
        }
    }

    static final class java_util_EnumSet_PersistenceDelegate
    extends PersistenceDelegate {
        java_util_EnumSet_PersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return super.mutatesTo(oldInstance, newInstance) && java_util_EnumSet_PersistenceDelegate.getType(oldInstance) == java_util_EnumSet_PersistenceDelegate.getType(newInstance);
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, EnumSet.class, "noneOf", new Object[]{java_util_EnumSet_PersistenceDelegate.getType(oldInstance)});
        }

        private static Object getType(Object instance) {
            return MetaData.getPrivateFieldValue(instance, "java.util.EnumSet.elementType");
        }
    }

    static final class java_util_EnumMap_PersistenceDelegate
    extends PersistenceDelegate {
        java_util_EnumMap_PersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return super.mutatesTo(oldInstance, newInstance) && java_util_EnumMap_PersistenceDelegate.getType(oldInstance) == java_util_EnumMap_PersistenceDelegate.getType(newInstance);
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, EnumMap.class, "new", new Object[]{java_util_EnumMap_PersistenceDelegate.getType(oldInstance)});
        }

        private static Object getType(Object instance) {
            return MetaData.getPrivateFieldValue(instance, "java.util.EnumMap.keyType");
        }
    }

    private static abstract class java_util_Collections
    extends PersistenceDelegate {
        private java_util_Collections() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            if (!super.mutatesTo(oldInstance, newInstance)) {
                return false;
            }
            if (oldInstance instanceof java.util.List || oldInstance instanceof Set || oldInstance instanceof Map) {
                return oldInstance.equals(newInstance);
            }
            Collection oldC = (Collection)oldInstance;
            Collection newC = (Collection)newInstance;
            return oldC.size() == newC.size() && oldC.containsAll(newC);
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
        }

        static final class CheckedSortedMap_PersistenceDelegate
        extends java_util_Collections {
            CheckedSortedMap_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                Object keyType = MetaData.getPrivateFieldValue(oldInstance, "java.util.Collections$CheckedMap.keyType");
                Object valueType = MetaData.getPrivateFieldValue(oldInstance, "java.util.Collections$CheckedMap.valueType");
                TreeMap map = new TreeMap((SortedMap)oldInstance);
                return new Expression(oldInstance, Collections.class, "checkedSortedMap", new Object[]{map, keyType, valueType});
            }
        }

        static final class CheckedMap_PersistenceDelegate
        extends java_util_Collections {
            CheckedMap_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                Object keyType = MetaData.getPrivateFieldValue(oldInstance, "java.util.Collections$CheckedMap.keyType");
                Object valueType = MetaData.getPrivateFieldValue(oldInstance, "java.util.Collections$CheckedMap.valueType");
                HashMap map = new HashMap((Map)oldInstance);
                return new Expression(oldInstance, Collections.class, "checkedMap", new Object[]{map, keyType, valueType});
            }
        }

        static final class CheckedSortedSet_PersistenceDelegate
        extends java_util_Collections {
            CheckedSortedSet_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                Object type = MetaData.getPrivateFieldValue(oldInstance, "java.util.Collections$CheckedCollection.type");
                TreeSet set = new TreeSet((SortedSet)oldInstance);
                return new Expression(oldInstance, Collections.class, "checkedSortedSet", new Object[]{set, type});
            }
        }

        static final class CheckedSet_PersistenceDelegate
        extends java_util_Collections {
            CheckedSet_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                Object type = MetaData.getPrivateFieldValue(oldInstance, "java.util.Collections$CheckedCollection.type");
                HashSet set = new HashSet((Set)oldInstance);
                return new Expression(oldInstance, Collections.class, "checkedSet", new Object[]{set, type});
            }
        }

        static final class CheckedRandomAccessList_PersistenceDelegate
        extends java_util_Collections {
            CheckedRandomAccessList_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                Object type = MetaData.getPrivateFieldValue(oldInstance, "java.util.Collections$CheckedCollection.type");
                ArrayList list = new ArrayList((Collection)oldInstance);
                return new Expression(oldInstance, Collections.class, "checkedList", new Object[]{list, type});
            }
        }

        static final class CheckedList_PersistenceDelegate
        extends java_util_Collections {
            CheckedList_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                Object type = MetaData.getPrivateFieldValue(oldInstance, "java.util.Collections$CheckedCollection.type");
                LinkedList list = new LinkedList((Collection)oldInstance);
                return new Expression(oldInstance, Collections.class, "checkedList", new Object[]{list, type});
            }
        }

        static final class CheckedCollection_PersistenceDelegate
        extends java_util_Collections {
            CheckedCollection_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                Object type = MetaData.getPrivateFieldValue(oldInstance, "java.util.Collections$CheckedCollection.type");
                ArrayList list = new ArrayList((Collection)oldInstance);
                return new Expression(oldInstance, Collections.class, "checkedCollection", new Object[]{list, type});
            }
        }

        static final class SynchronizedSortedMap_PersistenceDelegate
        extends java_util_Collections {
            SynchronizedSortedMap_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                TreeMap map = new TreeMap((SortedMap)oldInstance);
                return new Expression(oldInstance, Collections.class, "synchronizedSortedMap", new Object[]{map});
            }
        }

        static final class SynchronizedMap_PersistenceDelegate
        extends java_util_Collections {
            SynchronizedMap_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                HashMap map = new HashMap((Map)oldInstance);
                return new Expression(oldInstance, Collections.class, "synchronizedMap", new Object[]{map});
            }
        }

        static final class SynchronizedSortedSet_PersistenceDelegate
        extends java_util_Collections {
            SynchronizedSortedSet_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                TreeSet set = new TreeSet((SortedSet)oldInstance);
                return new Expression(oldInstance, Collections.class, "synchronizedSortedSet", new Object[]{set});
            }
        }

        static final class SynchronizedSet_PersistenceDelegate
        extends java_util_Collections {
            SynchronizedSet_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                HashSet set = new HashSet((Set)oldInstance);
                return new Expression(oldInstance, Collections.class, "synchronizedSet", new Object[]{set});
            }
        }

        static final class SynchronizedRandomAccessList_PersistenceDelegate
        extends java_util_Collections {
            SynchronizedRandomAccessList_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                ArrayList list = new ArrayList((Collection)oldInstance);
                return new Expression(oldInstance, Collections.class, "synchronizedList", new Object[]{list});
            }
        }

        static final class SynchronizedList_PersistenceDelegate
        extends java_util_Collections {
            SynchronizedList_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                LinkedList list = new LinkedList((Collection)oldInstance);
                return new Expression(oldInstance, Collections.class, "synchronizedList", new Object[]{list});
            }
        }

        static final class SynchronizedCollection_PersistenceDelegate
        extends java_util_Collections {
            SynchronizedCollection_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                ArrayList list = new ArrayList((Collection)oldInstance);
                return new Expression(oldInstance, Collections.class, "synchronizedCollection", new Object[]{list});
            }
        }

        static final class UnmodifiableSortedMap_PersistenceDelegate
        extends java_util_Collections {
            UnmodifiableSortedMap_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                TreeMap map = new TreeMap((SortedMap)oldInstance);
                return new Expression(oldInstance, Collections.class, "unmodifiableSortedMap", new Object[]{map});
            }
        }

        static final class UnmodifiableMap_PersistenceDelegate
        extends java_util_Collections {
            UnmodifiableMap_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                HashMap map = new HashMap((Map)oldInstance);
                return new Expression(oldInstance, Collections.class, "unmodifiableMap", new Object[]{map});
            }
        }

        static final class UnmodifiableSortedSet_PersistenceDelegate
        extends java_util_Collections {
            UnmodifiableSortedSet_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                TreeSet set = new TreeSet((SortedSet)oldInstance);
                return new Expression(oldInstance, Collections.class, "unmodifiableSortedSet", new Object[]{set});
            }
        }

        static final class UnmodifiableSet_PersistenceDelegate
        extends java_util_Collections {
            UnmodifiableSet_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                HashSet set = new HashSet((Set)oldInstance);
                return new Expression(oldInstance, Collections.class, "unmodifiableSet", new Object[]{set});
            }
        }

        static final class UnmodifiableRandomAccessList_PersistenceDelegate
        extends java_util_Collections {
            UnmodifiableRandomAccessList_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                ArrayList list = new ArrayList((Collection)oldInstance);
                return new Expression(oldInstance, Collections.class, "unmodifiableList", new Object[]{list});
            }
        }

        static final class UnmodifiableList_PersistenceDelegate
        extends java_util_Collections {
            UnmodifiableList_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                LinkedList list = new LinkedList((Collection)oldInstance);
                return new Expression(oldInstance, Collections.class, "unmodifiableList", new Object[]{list});
            }
        }

        static final class UnmodifiableCollection_PersistenceDelegate
        extends java_util_Collections {
            UnmodifiableCollection_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                ArrayList list = new ArrayList((Collection)oldInstance);
                return new Expression(oldInstance, Collections.class, "unmodifiableCollection", new Object[]{list});
            }
        }

        static final class SingletonMap_PersistenceDelegate
        extends java_util_Collections {
            SingletonMap_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                Map map = (Map)oldInstance;
                Object key = map.keySet().iterator().next();
                return new Expression(oldInstance, Collections.class, "singletonMap", new Object[]{key, map.get(key)});
            }
        }

        static final class SingletonSet_PersistenceDelegate
        extends java_util_Collections {
            SingletonSet_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                Set set = (Set)oldInstance;
                return new Expression(oldInstance, Collections.class, "singleton", new Object[]{set.iterator().next()});
            }
        }

        static final class SingletonList_PersistenceDelegate
        extends java_util_Collections {
            SingletonList_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                java.util.List list = (java.util.List)oldInstance;
                return new Expression(oldInstance, Collections.class, "singletonList", new Object[]{list.get(0)});
            }
        }

        static final class EmptyMap_PersistenceDelegate
        extends java_util_Collections {
            EmptyMap_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, Collections.class, "emptyMap", null);
            }
        }

        static final class EmptySet_PersistenceDelegate
        extends java_util_Collections {
            EmptySet_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, Collections.class, "emptySet", null);
            }
        }

        static final class EmptyList_PersistenceDelegate
        extends java_util_Collections {
            EmptyList_PersistenceDelegate() {
            }

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, Collections.class, "emptyList", null);
            }
        }
    }

    static final class java_sql_Timestamp_PersistenceDelegate
    extends java_util_Date_PersistenceDelegate {
        private static final Method getNanosMethod = java_sql_Timestamp_PersistenceDelegate.getNanosMethod();

        java_sql_Timestamp_PersistenceDelegate() {
        }

        private static Method getNanosMethod() {
            try {
                Class<?> c = Class.forName("java.sql.Timestamp", true, null);
                return c.getMethod("getNanos", new Class[0]);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }

        private static int getNanos(Object obj) {
            if (getNanosMethod == null) {
                throw new AssertionError((Object)"Should not get here");
            }
            try {
                return (Integer)getNanosMethod.invoke(obj, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException iae) {
                throw new AssertionError((Object)iae);
            }
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            int nanos = java_sql_Timestamp_PersistenceDelegate.getNanos(oldInstance);
            if (nanos != java_sql_Timestamp_PersistenceDelegate.getNanos(newInstance)) {
                out.writeStatement(new Statement(oldInstance, "setNanos", new Object[]{nanos}));
            }
        }
    }

    static class java_util_Date_PersistenceDelegate
    extends PersistenceDelegate {
        java_util_Date_PersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            if (!super.mutatesTo(oldInstance, newInstance)) {
                return false;
            }
            Date oldDate = (Date)oldInstance;
            Date newDate = (Date)newInstance;
            return oldDate.getTime() == newDate.getTime();
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Date date = (Date)oldInstance;
            return new Expression(date, date.getClass(), "new", new Object[]{date.getTime()});
        }
    }

    static final class java_lang_reflect_Method_PersistenceDelegate
    extends PersistenceDelegate {
        java_lang_reflect_Method_PersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance.equals(newInstance);
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Method m = (Method)oldInstance;
            return new Expression(oldInstance, m.getDeclaringClass(), "getMethod", new Object[]{m.getName(), m.getParameterTypes()});
        }
    }

    static final class java_lang_reflect_Field_PersistenceDelegate
    extends PersistenceDelegate {
        java_lang_reflect_Field_PersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance.equals(newInstance);
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Field f = (Field)oldInstance;
            return new Expression(oldInstance, f.getDeclaringClass(), "getField", new Object[]{f.getName()});
        }
    }

    static final class java_lang_Class_PersistenceDelegate
    extends PersistenceDelegate {
        java_lang_Class_PersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance.equals(newInstance);
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Class c = (Class)oldInstance;
            if (c.isPrimitive()) {
                Field field = null;
                try {
                    field = PrimitiveWrapperMap.getType(c.getName()).getDeclaredField("TYPE");
                }
                catch (NoSuchFieldException ex) {
                    System.err.println("Unknown primitive type: " + c);
                }
                return new Expression(oldInstance, field, "get", new Object[]{null});
            }
            if (oldInstance == String.class) {
                return new Expression(oldInstance, "", "getClass", new Object[0]);
            }
            if (oldInstance == Class.class) {
                return new Expression(oldInstance, String.class, "getClass", new Object[0]);
            }
            Expression newInstance = new Expression(oldInstance, Class.class, "forName", new Object[]{c.getName()});
            newInstance.loader = c.getClassLoader();
            return newInstance;
        }
    }

    static final class java_lang_String_PersistenceDelegate
    extends PersistenceDelegate {
        java_lang_String_PersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return null;
        }

        @Override
        public void writeObject(Object oldInstance, Encoder out) {
        }
    }

    static final class ProxyPersistenceDelegate
    extends PersistenceDelegate {
        ProxyPersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Class<?> type = oldInstance.getClass();
            Proxy p = (Proxy)oldInstance;
            InvocationHandler ih = Proxy.getInvocationHandler(p);
            if (ih instanceof EventHandler) {
                EventHandler eh = (EventHandler)ih;
                Vector<Object> args = new Vector<Object>();
                args.add(type.getInterfaces()[0]);
                args.add(eh.getTarget());
                args.add(eh.getAction());
                if (eh.getEventPropertyName() != null) {
                    args.add(eh.getEventPropertyName());
                }
                if (eh.getListenerMethodName() != null) {
                    args.setSize(4);
                    args.add(eh.getListenerMethodName());
                }
                return new Expression(oldInstance, EventHandler.class, "create", args.toArray());
            }
            return new Expression(oldInstance, Proxy.class, "newProxyInstance", new Object[]{type.getClassLoader(), type.getInterfaces(), ih});
        }
    }

    static final class ArrayPersistenceDelegate
    extends PersistenceDelegate {
        ArrayPersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return newInstance != null && oldInstance.getClass() == newInstance.getClass() && Array.getLength(oldInstance) == Array.getLength(newInstance);
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Class<?> oldClass = oldInstance.getClass();
            return new Expression(oldInstance, Array.class, "newInstance", new Object[]{oldClass.getComponentType(), new Integer(Array.getLength(oldInstance))});
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
            int n = Array.getLength(oldInstance);
            for (int i = 0; i < n; ++i) {
                Integer index = new Integer(i);
                Expression oldGetExp = new Expression(oldInstance, "get", new Object[]{index});
                Expression newGetExp = new Expression(newInstance, "get", new Object[]{index});
                try {
                    Object oldValue = oldGetExp.getValue();
                    Object newValue = newGetExp.getValue();
                    out.writeExpression(oldGetExp);
                    if (Objects.equals(newValue, out.get(oldValue))) continue;
                    DefaultPersistenceDelegate.invokeStatement(oldInstance, "set", new Object[]{index, oldValue}, out);
                    continue;
                }
                catch (Exception e) {
                    out.getExceptionListener().exceptionThrown(e);
                }
            }
        }
    }

    static final class PrimitivePersistenceDelegate
    extends PersistenceDelegate {
        PrimitivePersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance.equals(newInstance);
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return new Expression(oldInstance, oldInstance.getClass(), "new", new Object[]{oldInstance.toString()});
        }
    }

    static final class EnumPersistenceDelegate
    extends PersistenceDelegate {
        EnumPersistenceDelegate() {
        }

        @Override
        protected boolean mutatesTo(Object oldInstance, Object newInstance) {
            return oldInstance == newInstance;
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            Enum e = (Enum)oldInstance;
            return new Expression(e, Enum.class, "valueOf", new Object[]{e.getDeclaringClass(), e.name()});
        }
    }

    static final class NullPersistenceDelegate
    extends PersistenceDelegate {
        NullPersistenceDelegate() {
        }

        @Override
        protected void initialize(Class<?> type, Object oldInstance, Object newInstance, Encoder out) {
        }

        @Override
        protected Expression instantiate(Object oldInstance, Encoder out) {
            return null;
        }

        @Override
        public void writeObject(Object oldInstance, Encoder out) {
        }
    }
}

