/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.BoundMethodHandle;
import java.lang.invoke.DelegatingMethodHandle;
import java.lang.invoke.ForceInline;
import java.lang.invoke.InvokerBytecodeGenerator;
import java.lang.invoke.LambdaForm;
import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SimpleMethodHandle;
import java.lang.invoke.Stable;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Array;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import sun.invoke.empty.Empty;
import sun.invoke.util.ValueConversions;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

abstract class MethodHandleImpl {
    private static final int MAX_ARITY;
    private static final Function<MethodHandle, LambdaForm> PRODUCE_BLOCK_INLINING_FORM;
    private static final Function<MethodHandle, LambdaForm> PRODUCE_REINVOKER_FORM;
    static MethodHandle[] FAKE_METHOD_HANDLE_INVOKE;
    private static final Object[] NO_ARGS_ARRAY;
    private static final int FILL_ARRAYS_COUNT = 11;
    private static final int LEFT_ARGS = 10;
    private static final MethodHandle[] FILL_ARRAY_TO_RIGHT;
    private static final ClassValue<MethodHandle[]> TYPED_COLLECTORS;
    static final int MAX_JVM_ARITY = 255;

    MethodHandleImpl() {
    }

    static void initStatics() {
        MemberName.Factory.INSTANCE.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static MethodHandle makeArrayElementAccessor(Class<?> arrayClass, boolean isSetter) {
        int cacheIndex;
        if (arrayClass == Object[].class) {
            return isSetter ? ArrayAccessor.OBJECT_ARRAY_SETTER : ArrayAccessor.OBJECT_ARRAY_GETTER;
        }
        if (!arrayClass.isArray()) {
            throw MethodHandleStatics.newIllegalArgumentException("not an array: " + arrayClass);
        }
        MethodHandle[] cache = ArrayAccessor.TYPED_ACCESSORS.get(arrayClass);
        MethodHandle mh = cache[cacheIndex = isSetter ? 1 : 0];
        if (mh != null) {
            return mh;
        }
        mh = ArrayAccessor.getAccessor(arrayClass, isSetter);
        MethodType correctType = ArrayAccessor.correctType(arrayClass, isSetter);
        if (mh.type() != correctType) {
            assert (mh.type().parameterType(0) == Object[].class);
            assert ((isSetter ? mh.type().parameterType(2) : mh.type().returnType()) == Object.class);
            assert (isSetter || correctType.parameterType(0).getComponentType() == correctType.returnType());
            mh = mh.viewAsType(correctType, false);
        }
        mh = MethodHandleImpl.makeIntrinsic(mh, isSetter ? Intrinsic.ARRAY_STORE : Intrinsic.ARRAY_LOAD);
        MethodHandle[] methodHandleArray = cache;
        synchronized (cache) {
            if (cache[cacheIndex] == null) {
                cache[cacheIndex] = mh;
            } else {
                mh = cache[cacheIndex];
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return mh;
        }
    }

    static MethodHandle makePairwiseConvert(MethodHandle target, MethodType srcType, boolean strict, boolean monobox) {
        MethodType dstType = target.type();
        if (srcType == dstType) {
            return target;
        }
        return MethodHandleImpl.makePairwiseConvertByEditor(target, srcType, strict, monobox);
    }

    private static int countNonNull(Object[] array) {
        int count = 0;
        for (Object x : array) {
            if (x == null) continue;
            ++count;
        }
        return count;
    }

    static MethodHandle makePairwiseConvertByEditor(MethodHandle target, MethodType srcType, boolean strict, boolean monobox) {
        Object[] convSpecs = MethodHandleImpl.computeValueConversions(srcType, target.type(), strict, monobox);
        int convCount = MethodHandleImpl.countNonNull(convSpecs);
        if (convCount == 0) {
            return target.viewAsType(srcType, strict);
        }
        MethodType basicSrcType = srcType.basicType();
        MethodType midType = target.type().basicType();
        BoundMethodHandle mh = target.rebind();
        for (int i = 0; i < convSpecs.length - 1; ++i) {
            Object convSpec = convSpecs[i];
            if (convSpec == null) continue;
            MethodHandle fn = convSpec instanceof Class ? Lazy.MH_castReference.bindTo(convSpec) : (MethodHandle)convSpec;
            Class<?> newType = basicSrcType.parameterType(i);
            midType = --convCount == 0 ? srcType : midType.changeParameterType(i, newType);
            LambdaForm form2 = mh.editor().filterArgumentForm(1 + i, LambdaForm.BasicType.basicType(newType));
            mh = mh.copyWithExtendL(midType, form2, fn);
            mh = mh.rebind();
        }
        Object convSpec = convSpecs[convSpecs.length - 1];
        if (convSpec != null) {
            LambdaForm form2;
            Object fn = convSpec instanceof Class ? (convSpec == Void.TYPE ? null : Lazy.MH_castReference.bindTo(convSpec)) : (MethodHandle)convSpec;
            Class<?> newType = basicSrcType.returnType();
            assert (--convCount == 0);
            midType = srcType;
            if (fn != null) {
                mh = mh.rebind();
                form2 = mh.editor().filterReturnForm(LambdaForm.BasicType.basicType(newType), false);
                mh = mh.copyWithExtendL(midType, form2, fn);
            } else {
                form2 = mh.editor().filterReturnForm(LambdaForm.BasicType.basicType(newType), true);
                mh = mh.copyWith(midType, form2);
            }
        }
        assert (convCount == 0);
        assert (mh.type().equals((Object)srcType));
        return mh;
    }

    static MethodHandle makePairwiseConvertIndirect(MethodHandle target, MethodType srcType, boolean strict, boolean monobox) {
        boolean retVoid;
        assert (target.type().parameterCount() == srcType.parameterCount());
        Object[] convSpecs = MethodHandleImpl.computeValueConversions(srcType, target.type(), strict, monobox);
        int INARG_COUNT = srcType.parameterCount();
        int convCount = MethodHandleImpl.countNonNull(convSpecs);
        boolean retConv = convSpecs[INARG_COUNT] != null;
        boolean bl = retVoid = srcType.returnType() == Void.TYPE;
        if (retConv && retVoid) {
            --convCount;
            retConv = false;
        }
        boolean IN_MH = false;
        boolean INARG_BASE = true;
        int INARG_LIMIT = 1 + INARG_COUNT;
        int NAME_LIMIT = INARG_LIMIT + convCount + 1;
        int RETURN_CONV = !retConv ? -1 : NAME_LIMIT - 1;
        int OUT_CALL = (!retConv ? NAME_LIMIT : RETURN_CONV) - 1;
        int RESULT = retVoid ? -1 : NAME_LIMIT - 1;
        MethodType lambdaType = srcType.basicType().invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(NAME_LIMIT - INARG_LIMIT, lambdaType);
        boolean OUTARG_BASE = false;
        Object[] outArgs = new Object[0 + INARG_COUNT];
        int nameCursor = INARG_LIMIT;
        for (int i = 0; i < INARG_COUNT; ++i) {
            LambdaForm.Name conv;
            Object convSpec = convSpecs[i];
            if (convSpec == null) {
                outArgs[0 + i] = names[1 + i];
                continue;
            }
            if (convSpec instanceof Class) {
                Class convClass = (Class)convSpec;
                conv = new LambdaForm.Name(Lazy.MH_castReference, convClass, names[1 + i]);
            } else {
                MethodHandle fn = (MethodHandle)convSpec;
                conv = new LambdaForm.Name(fn, names[1 + i]);
            }
            assert (names[nameCursor] == null);
            names[nameCursor++] = conv;
            assert (outArgs[0 + i] == null);
            outArgs[0 + i] = conv;
        }
        assert (nameCursor == OUT_CALL);
        names[OUT_CALL] = new LambdaForm.Name(target, outArgs);
        Object convSpec = convSpecs[INARG_COUNT];
        if (!retConv) {
            assert (OUT_CALL == names.length - 1);
        } else {
            LambdaForm.Name conv;
            if (convSpec == Void.TYPE) {
                conv = new LambdaForm.Name(LambdaForm.constantZero(LambdaForm.BasicType.basicType(srcType.returnType())), new Object[0]);
            } else if (convSpec instanceof Class) {
                Class convClass = (Class)convSpec;
                conv = new LambdaForm.Name(Lazy.MH_castReference, convClass, names[OUT_CALL]);
            } else {
                MethodHandle fn = (MethodHandle)convSpec;
                conv = fn.type().parameterCount() == 0 ? new LambdaForm.Name(fn, new Object[0]) : new LambdaForm.Name(fn, names[OUT_CALL]);
            }
            assert (names[RETURN_CONV] == null);
            names[RETURN_CONV] = conv;
            assert (RETURN_CONV == names.length - 1);
        }
        LambdaForm form = new LambdaForm("convert", lambdaType.parameterCount(), names, RESULT);
        return SimpleMethodHandle.make(srcType, form);
    }

    @ForceInline
    static <T, U> T castReference(Class<? extends T> t, U x) {
        if (x != null && !t.isInstance(x)) {
            throw MethodHandleImpl.newClassCastException(t, x);
        }
        return (T)x;
    }

    private static ClassCastException newClassCastException(Class<?> t, Object obj) {
        return new ClassCastException("Cannot cast " + obj.getClass().getName() + " to " + t.getName());
    }

    static Object[] computeValueConversions(MethodType srcType, MethodType dstType, boolean strict, boolean monobox) {
        int INARG_COUNT = srcType.parameterCount();
        Object[] convSpecs = new Object[INARG_COUNT + 1];
        for (int i = 0; i <= INARG_COUNT; ++i) {
            Class<?> dst;
            boolean isRet = i == INARG_COUNT;
            Class<?> src = isRet ? dstType.returnType() : srcType.parameterType(i);
            Class<?> clazz = dst = isRet ? srcType.returnType() : dstType.parameterType(i);
            if (VerifyType.isNullConversion(src, dst, strict)) continue;
            convSpecs[i] = MethodHandleImpl.valueConversion(src, dst, strict, monobox);
        }
        return convSpecs;
    }

    static MethodHandle makePairwiseConvert(MethodHandle target, MethodType srcType, boolean strict) {
        return MethodHandleImpl.makePairwiseConvert(target, srcType, strict, false);
    }

    static Object valueConversion(Class<?> src, Class<?> dst, boolean strict, boolean monobox) {
        MethodHandle fn;
        assert (!VerifyType.isNullConversion(src, dst, strict));
        if (dst == Void.TYPE) {
            return dst;
        }
        if (src.isPrimitive()) {
            if (src == Void.TYPE) {
                return Void.TYPE;
            }
            if (dst.isPrimitive()) {
                fn = ValueConversions.convertPrimitive(src, dst);
            } else {
                Wrapper wsrc = Wrapper.forPrimitiveType(src);
                fn = ValueConversions.boxExact(wsrc);
                assert (fn.type().parameterType(0) == wsrc.primitiveType());
                assert (fn.type().returnType() == wsrc.wrapperType());
                if (!VerifyType.isNullConversion(wsrc.wrapperType(), dst, strict)) {
                    MethodType mt = MethodType.methodType(dst, src);
                    fn = strict ? fn.asType(mt) : MethodHandleImpl.makePairwiseConvert(fn, mt, false);
                }
            }
        } else if (dst.isPrimitive()) {
            Wrapper wdst = Wrapper.forPrimitiveType(dst);
            fn = monobox || src == wdst.wrapperType() ? ValueConversions.unboxExact(wdst, strict) : (strict ? ValueConversions.unboxWiden(wdst) : ValueConversions.unboxCast(wdst));
        } else {
            return dst;
        }
        assert (fn.type().parameterCount() <= 1) : "pc" + Arrays.asList(src.getSimpleName(), dst.getSimpleName(), fn);
        return fn;
    }

    static MethodHandle makeVarargsCollector(MethodHandle target, Class<?> arrayType) {
        int last;
        MethodType type = target.type();
        if (type.parameterType(last = type.parameterCount() - 1) != arrayType) {
            target = target.asType(type.changeParameterType(last, arrayType));
        }
        target = target.asFixedArity();
        return new AsVarargsCollector(target, arrayType);
    }

    static MethodHandle makeSpreadArguments(MethodHandle target, Class<?> spreadArgType, int spreadArgPos, int spreadArgCount) {
        MethodType targetType = target.type();
        for (int i = 0; i < spreadArgCount; ++i) {
            Class<Object> arg = VerifyType.spreadArgElementType(spreadArgType, i);
            if (arg == null) {
                arg = Object.class;
            }
            targetType = targetType.changeParameterType(spreadArgPos + i, arg);
        }
        target = target.asType(targetType);
        MethodType srcType = targetType.replaceParameterTypes(spreadArgPos, spreadArgPos + spreadArgCount, spreadArgType);
        MethodType lambdaType = srcType.invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(spreadArgCount + 2, lambdaType);
        int nameCursor = lambdaType.parameterCount();
        int[] indexes = new int[targetType.parameterCount()];
        int i = 0;
        int argIndex = 1;
        while (i < targetType.parameterCount() + 1) {
            Class<?> src = lambdaType.parameterType(i);
            if (i == spreadArgPos) {
                MethodHandle aload = MethodHandles.arrayElementGetter(spreadArgType);
                LambdaForm.Name array = names[argIndex];
                names[nameCursor++] = new LambdaForm.Name(Lazy.NF_checkSpreadArgument, array, spreadArgCount);
                for (int j = 0; j < spreadArgCount; ++j) {
                    indexes[i] = nameCursor;
                    names[nameCursor++] = new LambdaForm.Name(aload, array, j);
                    ++i;
                }
            } else if (i < indexes.length) {
                indexes[i] = argIndex;
            }
            ++i;
            ++argIndex;
        }
        assert (nameCursor == names.length - 1);
        LambdaForm.Name[] targetArgs = new LambdaForm.Name[targetType.parameterCount()];
        for (int i2 = 0; i2 < targetType.parameterCount(); ++i2) {
            int idx = indexes[i2];
            targetArgs[i2] = names[idx];
        }
        names[names.length - 1] = new LambdaForm.Name(target, (Object[])targetArgs);
        LambdaForm form = new LambdaForm("spread", lambdaType.parameterCount(), names);
        return SimpleMethodHandle.make(srcType, form);
    }

    static void checkSpreadArgument(Object av, int n) {
        int len;
        if (av == null ? n == 0 : (av instanceof Object[] ? (len = ((Object[])av).length) == n : (len = Array.getLength(av)) == n)) {
            return;
        }
        throw MethodHandleStatics.newIllegalArgumentException("array is not of length " + n);
    }

    static MethodHandle makeCollectArguments(MethodHandle target, MethodHandle collector, int collectArgPos, boolean retainOriginalArgs) {
        MethodType targetType = target.type();
        MethodType collectorType = collector.type();
        int collectArgCount = collectorType.parameterCount();
        Class<?> collectValType = collectorType.returnType();
        int collectValCount = collectValType == Void.TYPE ? 0 : 1;
        MethodType srcType = targetType.dropParameterTypes(collectArgPos, collectArgPos + collectValCount);
        if (!retainOriginalArgs) {
            srcType = srcType.insertParameterTypes(collectArgPos, collectorType.parameterList());
        }
        MethodType lambdaType = srcType.invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(2, lambdaType);
        int collectNamePos = names.length - 2;
        int targetNamePos = names.length - 1;
        LambdaForm.Name[] collectorArgs = Arrays.copyOfRange(names, 1 + collectArgPos, 1 + collectArgPos + collectArgCount);
        names[collectNamePos] = new LambdaForm.Name(collector, (Object[])collectorArgs);
        LambdaForm.Name[] targetArgs = new LambdaForm.Name[targetType.parameterCount()];
        int inputArgPos = 1;
        int targetArgPos = 0;
        int chunk = collectArgPos;
        System.arraycopy(names, inputArgPos, targetArgs, targetArgPos, chunk);
        inputArgPos += chunk;
        targetArgPos += chunk;
        if (collectValType != Void.TYPE) {
            targetArgs[targetArgPos++] = names[collectNamePos];
        }
        chunk = collectArgCount;
        if (retainOriginalArgs) {
            System.arraycopy(names, inputArgPos, targetArgs, targetArgPos, chunk);
            targetArgPos += chunk;
        }
        inputArgPos += chunk;
        chunk = targetArgs.length - targetArgPos;
        System.arraycopy(names, inputArgPos, targetArgs, targetArgPos, chunk);
        assert (inputArgPos + chunk == collectNamePos);
        names[targetNamePos] = new LambdaForm.Name(target, (Object[])targetArgs);
        LambdaForm form = new LambdaForm("collect", lambdaType.parameterCount(), names);
        return SimpleMethodHandle.make(srcType, form);
    }

    @LambdaForm.Hidden
    static MethodHandle selectAlternative(boolean testResult, MethodHandle target, MethodHandle fallback) {
        if (testResult) {
            return target;
        }
        return fallback;
    }

    @LambdaForm.Hidden
    static boolean profileBoolean(boolean result, int[] counters) {
        int idx = result ? 1 : 0;
        try {
            counters[idx] = Math.addExact(counters[idx], 1);
        }
        catch (ArithmeticException e) {
            counters[idx] = counters[idx] / 2;
        }
        return result;
    }

    static MethodHandle makeGuardWithTest(MethodHandle test, MethodHandle target, MethodHandle fallback) {
        BoundMethodHandle mh;
        MethodType type = target.type();
        assert (test.type().equals((Object)type.changeReturnType(Boolean.TYPE)) && fallback.type().equals((Object)type));
        MethodType basicType = type.basicType();
        LambdaForm form = MethodHandleImpl.makeGuardWithTestForm(basicType);
        try {
            if (MethodHandleStatics.PROFILE_GWT) {
                int[] counts = new int[2];
                mh = BoundMethodHandle.speciesData_LLLL().constructor().invokeBasic(type, form, test, MethodHandleImpl.profile(target), MethodHandleImpl.profile(fallback), counts);
            } else {
                mh = BoundMethodHandle.speciesData_LLL().constructor().invokeBasic(type, form, test, MethodHandleImpl.profile(target), MethodHandleImpl.profile(fallback));
            }
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        assert (mh.type() == type);
        return mh;
    }

    static MethodHandle profile(MethodHandle target) {
        if (MethodHandleStatics.DONT_INLINE_THRESHOLD >= 0) {
            return MethodHandleImpl.makeBlockInlningWrapper(target);
        }
        return target;
    }

    static MethodHandle makeBlockInlningWrapper(MethodHandle target) {
        LambdaForm lform = PRODUCE_BLOCK_INLINING_FORM.apply(target);
        return new CountingWrapper(target, lform, PRODUCE_BLOCK_INLINING_FORM, PRODUCE_REINVOKER_FORM, MethodHandleStatics.DONT_INLINE_THRESHOLD);
    }

    static LambdaForm makeGuardWithTestForm(MethodType basicType) {
        int ARG_LIMIT;
        LambdaForm lform = basicType.form().cachedLambdaForm(17);
        if (lform != null) {
            return lform;
        }
        boolean THIS_MH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + basicType.parameterCount();
        int GET_TEST = nameCursor++;
        int GET_TARGET = nameCursor++;
        int GET_FALLBACK = nameCursor++;
        int GET_COUNTERS = MethodHandleStatics.PROFILE_GWT ? nameCursor++ : -1;
        int CALL_TEST = nameCursor++;
        int PROFILE = GET_COUNTERS != -1 ? nameCursor++ : -1;
        int TEST = nameCursor - 1;
        int SELECT_ALT = nameCursor++;
        int CALL_TARGET = nameCursor++;
        assert (CALL_TARGET == SELECT_ALT + 1);
        MethodType lambdaType = basicType.invokerType();
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, lambdaType);
        BoundMethodHandle.SpeciesData data = GET_COUNTERS != -1 ? BoundMethodHandle.speciesData_LLLL() : BoundMethodHandle.speciesData_LLL();
        names[0] = names[0].withConstraint(data);
        names[GET_TEST] = new LambdaForm.Name(data.getterFunction(0), names[0]);
        names[GET_TARGET] = new LambdaForm.Name(data.getterFunction(1), names[0]);
        names[GET_FALLBACK] = new LambdaForm.Name(data.getterFunction(2), names[0]);
        if (GET_COUNTERS != -1) {
            names[GET_COUNTERS] = new LambdaForm.Name(data.getterFunction(3), names[0]);
        }
        Object[] invokeArgs = Arrays.copyOfRange(names, 0, ARG_LIMIT, Object[].class);
        MethodType testType = basicType.changeReturnType(Boolean.TYPE).basicType();
        invokeArgs[0] = names[GET_TEST];
        names[CALL_TEST] = new LambdaForm.Name(testType, invokeArgs);
        if (PROFILE != -1) {
            names[PROFILE] = new LambdaForm.Name(Lazy.NF_profileBoolean, names[CALL_TEST], names[GET_COUNTERS]);
        }
        names[SELECT_ALT] = new LambdaForm.Name(Lazy.MH_selectAlternative, names[TEST], names[GET_TARGET], names[GET_FALLBACK]);
        invokeArgs[0] = names[SELECT_ALT];
        names[CALL_TARGET] = new LambdaForm.Name(basicType, invokeArgs);
        lform = new LambdaForm("guard", lambdaType.parameterCount(), names, true);
        return basicType.form().setCachedLambdaForm(17, lform);
    }

    private static LambdaForm makeGuardWithCatchForm(MethodType basicType) {
        int ARG_LIMIT;
        MethodType lambdaType = basicType.invokerType();
        LambdaForm lform = basicType.form().cachedLambdaForm(16);
        if (lform != null) {
            return lform;
        }
        boolean THIS_MH = false;
        boolean ARG_BASE = true;
        int nameCursor = ARG_LIMIT = 1 + basicType.parameterCount();
        int GET_TARGET = nameCursor++;
        int GET_CLASS = nameCursor++;
        int GET_CATCHER = nameCursor++;
        int GET_COLLECT_ARGS = nameCursor++;
        int GET_UNBOX_RESULT = nameCursor++;
        int BOXED_ARGS = nameCursor++;
        int TRY_CATCH = nameCursor++;
        int UNBOX_RESULT = nameCursor++;
        LambdaForm.Name[] names = LambdaForm.arguments(nameCursor - ARG_LIMIT, lambdaType);
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLLLL();
        names[0] = names[0].withConstraint(data);
        names[GET_TARGET] = new LambdaForm.Name(data.getterFunction(0), names[0]);
        names[GET_CLASS] = new LambdaForm.Name(data.getterFunction(1), names[0]);
        names[GET_CATCHER] = new LambdaForm.Name(data.getterFunction(2), names[0]);
        names[GET_COLLECT_ARGS] = new LambdaForm.Name(data.getterFunction(3), names[0]);
        names[GET_UNBOX_RESULT] = new LambdaForm.Name(data.getterFunction(4), names[0]);
        MethodType collectArgsType = basicType.changeReturnType(Object.class);
        MethodHandle invokeBasic = MethodHandles.basicInvoker(collectArgsType);
        Object[] args = new Object[invokeBasic.type().parameterCount()];
        args[0] = names[GET_COLLECT_ARGS];
        System.arraycopy(names, 1, args, 1, ARG_LIMIT - 1);
        names[BOXED_ARGS] = new LambdaForm.Name(MethodHandleImpl.makeIntrinsic(invokeBasic, Intrinsic.GUARD_WITH_CATCH), args);
        Object[] gwcArgs = new Object[]{names[GET_TARGET], names[GET_CLASS], names[GET_CATCHER], names[BOXED_ARGS]};
        names[TRY_CATCH] = new LambdaForm.Name(Lazy.NF_guardWithCatch, gwcArgs);
        MethodHandle invokeBasicUnbox = MethodHandles.basicInvoker(MethodType.methodType(basicType.rtype(), Object.class));
        Object[] unboxArgs = new Object[]{names[GET_UNBOX_RESULT], names[TRY_CATCH]};
        names[UNBOX_RESULT] = new LambdaForm.Name(invokeBasicUnbox, unboxArgs);
        lform = new LambdaForm("guardWithCatch", lambdaType.parameterCount(), names);
        return basicType.form().setCachedLambdaForm(16, lform);
    }

    static MethodHandle makeGuardWithCatch(MethodHandle target, Class<? extends Throwable> exType, MethodHandle catcher) {
        BoundMethodHandle mh;
        MethodHandle unboxResult;
        MethodType type = target.type();
        LambdaForm form = MethodHandleImpl.makeGuardWithCatchForm(type.basicType());
        MethodType varargsType = type.changeReturnType(Object[].class);
        MethodHandle collectArgs = MethodHandleImpl.varargsArray(type.parameterCount()).asType(varargsType);
        Class<?> rtype = type.returnType();
        if (rtype.isPrimitive()) {
            if (rtype == Void.TYPE) {
                unboxResult = ValueConversions.ignore();
            } else {
                Wrapper w = Wrapper.forPrimitiveType(type.returnType());
                unboxResult = ValueConversions.unboxExact(w);
            }
        } else {
            unboxResult = MethodHandles.identity(Object.class);
        }
        BoundMethodHandle.SpeciesData data = BoundMethodHandle.speciesData_LLLLL();
        try {
            mh = data.constructor().invokeBasic(type, form, target, exType, catcher, collectArgs, unboxResult);
        }
        catch (Throwable ex) {
            throw MethodHandleStatics.uncaughtException(ex);
        }
        assert (mh.type() == type);
        return mh;
    }

    @LambdaForm.Hidden
    static Object guardWithCatch(MethodHandle target, Class<? extends Throwable> exType, MethodHandle catcher, Object ... av) throws Throwable {
        try {
            return target.asFixedArity().invokeWithArguments(av);
        }
        catch (Throwable t) {
            if (!exType.isInstance(t)) {
                throw t;
            }
            return catcher.asFixedArity().invokeWithArguments(MethodHandleImpl.prepend(t, av));
        }
    }

    @LambdaForm.Hidden
    private static Object[] prepend(Object elem, Object[] array) {
        Object[] newArray = new Object[array.length + 1];
        newArray[0] = elem;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    static MethodHandle throwException(MethodType type) {
        assert (Throwable.class.isAssignableFrom(type.parameterType(0)));
        int arity = type.parameterCount();
        if (arity > 1) {
            MethodHandle mh = MethodHandleImpl.throwException(type.dropParameterTypes(1, arity));
            mh = MethodHandles.dropArguments(mh, 1, type.parameterList().subList(1, arity));
            return mh;
        }
        return MethodHandleImpl.makePairwiseConvert(Lazy.NF_throwException.resolvedHandle(), type, false, true);
    }

    static <T extends Throwable> Empty throwException(T t) throws T {
        throw t;
    }

    static MethodHandle fakeMethodHandleInvoke(MemberName method) {
        int idx;
        assert (method.isMethodHandleInvoke());
        switch (method.getName()) {
            case "invoke": {
                idx = 0;
                break;
            }
            case "invokeExact": {
                idx = 1;
                break;
            }
            default: {
                throw new InternalError(method.getName());
            }
        }
        MethodHandle mh = FAKE_METHOD_HANDLE_INVOKE[idx];
        if (mh != null) {
            return mh;
        }
        MethodType type = MethodType.methodType(Object.class, UnsupportedOperationException.class, MethodHandle.class, Object[].class);
        mh = MethodHandleImpl.throwException(type);
        mh = mh.bindTo(new UnsupportedOperationException("cannot reflectively invoke MethodHandle"));
        if (!method.getInvocationType().equals((Object)mh.type())) {
            throw new InternalError(method.toString());
        }
        mh = mh.withInternalMemberName(method, false);
        mh = mh.asVarargsCollector(Object[].class);
        assert (method.isVarargs());
        MethodHandleImpl.FAKE_METHOD_HANDLE_INVOKE[idx] = mh;
        return mh;
    }

    static MethodHandle bindCaller(MethodHandle mh, Class<?> hostClass) {
        return BindCaller.bindCaller(mh, hostClass);
    }

    static MethodHandle makeWrappedMember(MethodHandle target, MemberName member, boolean isInvokeSpecial) {
        if (member.equals(target.internalMemberName()) && isInvokeSpecial == target.isInvokeSpecial()) {
            return target;
        }
        return new WrappedMember(target, target.type(), member, isInvokeSpecial, null);
    }

    static MethodHandle makeIntrinsic(MethodHandle target, Intrinsic intrinsicName) {
        if (intrinsicName == target.intrinsicName()) {
            return target;
        }
        return new IntrinsicMethodHandle(target, intrinsicName);
    }

    static MethodHandle makeIntrinsic(MethodType type, LambdaForm form, Intrinsic intrinsicName) {
        return new IntrinsicMethodHandle(SimpleMethodHandle.make(type, form), intrinsicName);
    }

    private static MethodHandle findCollector(String name, int nargs, Class<?> rtype, Class<?> ... ptypes) {
        MethodType type = MethodType.genericMethodType(nargs).changeReturnType(rtype).insertParameterTypes(0, ptypes);
        try {
            return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MethodHandleImpl.class, name, type);
        }
        catch (ReflectiveOperationException ex) {
            return null;
        }
    }

    private static Object[] makeArray(Object ... args) {
        return args;
    }

    private static Object[] array() {
        return NO_ARGS_ARRAY;
    }

    private static Object[] array(Object a0) {
        return MethodHandleImpl.makeArray(a0);
    }

    private static Object[] array(Object a0, Object a1) {
        return MethodHandleImpl.makeArray(a0, a1);
    }

    private static Object[] array(Object a0, Object a1, Object a2) {
        return MethodHandleImpl.makeArray(a0, a1, a2);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3, a4);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3, a4, a5);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3, a4, a5, a6);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3, a4, a5, a6, a7);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3, a4, a5, a6, a7, a8);
    }

    private static Object[] array(Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9) {
        return MethodHandleImpl.makeArray(a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
    }

    private static MethodHandle[] makeArrays() {
        MethodHandle mh;
        ArrayList<MethodHandle> mhs = new ArrayList<MethodHandle>();
        while ((mh = MethodHandleImpl.findCollector("array", mhs.size(), Object[].class, new Class[0])) != null) {
            mh = MethodHandleImpl.makeIntrinsic(mh, Intrinsic.NEW_ARRAY);
            mhs.add(mh);
        }
        assert (mhs.size() == 11);
        return mhs.toArray(new MethodHandle[MAX_ARITY + 1]);
    }

    private static Object[] fillNewArray(Integer len, Object[] args) {
        Object[] a = new Object[len.intValue()];
        MethodHandleImpl.fillWithArguments(a, 0, args);
        return a;
    }

    private static Object[] fillNewTypedArray(Object[] example, Integer len, Object[] args) {
        Object[] a = Arrays.copyOf(example, (int)len);
        assert (a.getClass() != Object[].class);
        MethodHandleImpl.fillWithArguments(a, 0, args);
        return a;
    }

    private static void fillWithArguments(Object[] a, int pos, Object ... args) {
        System.arraycopy(args, 0, a, pos, args.length);
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0) {
        MethodHandleImpl.fillWithArguments(a, pos, a0);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3, a4);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5, a6);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5, a6, a7);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5, a6, a7, a8);
        return a;
    }

    private static Object[] fillArray(Integer pos, Object[] a, Object a0, Object a1, Object a2, Object a3, Object a4, Object a5, Object a6, Object a7, Object a8, Object a9) {
        MethodHandleImpl.fillWithArguments(a, pos, a0, a1, a2, a3, a4, a5, a6, a7, a8, a9);
        return a;
    }

    private static MethodHandle[] makeFillArrays() {
        MethodHandle mh;
        ArrayList<MethodHandle> mhs = new ArrayList<MethodHandle>();
        mhs.add(null);
        while ((mh = MethodHandleImpl.findCollector("fillArray", mhs.size(), Object[].class, Integer.class, Object[].class)) != null) {
            mhs.add(mh);
        }
        assert (mhs.size() == 11);
        return mhs.toArray(new MethodHandle[0]);
    }

    private static Object copyAsPrimitiveArray(Wrapper w, Object ... boxes) {
        Object a = w.makeArray(boxes.length);
        w.copyArrayUnboxing(boxes, 0, a, 0, boxes.length);
        return a;
    }

    static MethodHandle varargsArray(int nargs) {
        MethodHandle mh = Lazy.ARRAYS[nargs];
        if (mh != null) {
            return mh;
        }
        mh = MethodHandleImpl.findCollector("array", nargs, Object[].class, new Class[0]);
        if (mh != null) {
            mh = MethodHandleImpl.makeIntrinsic(mh, Intrinsic.NEW_ARRAY);
        }
        if (mh != null) {
            MethodHandle methodHandle = mh;
            Lazy.ARRAYS[nargs] = methodHandle;
            return methodHandle;
        }
        mh = MethodHandleImpl.buildVarargsArray(Lazy.MH_fillNewArray, Lazy.MH_arrayIdentity, nargs);
        assert (MethodHandleImpl.assertCorrectArity(mh, nargs));
        MethodHandle methodHandle = mh = MethodHandleImpl.makeIntrinsic(mh, Intrinsic.NEW_ARRAY);
        Lazy.ARRAYS[nargs] = methodHandle;
        return methodHandle;
    }

    private static boolean assertCorrectArity(MethodHandle mh, int arity) {
        assert (mh.type().parameterCount() == arity) : "arity != " + arity + ": " + mh;
        return true;
    }

    static <T> T[] identity(T[] x) {
        return x;
    }

    private static MethodHandle buildVarargsArray(MethodHandle newArray, MethodHandle finisher, int nargs) {
        int leftLen = Math.min(nargs, 10);
        int rightLen = nargs - leftLen;
        MethodHandle leftCollector = newArray.bindTo(nargs);
        leftCollector = leftCollector.asCollector(Object[].class, leftLen);
        MethodHandle mh = finisher;
        if (rightLen > 0) {
            MethodHandle rightFiller = MethodHandleImpl.fillToRight(10 + rightLen);
            mh = mh == Lazy.MH_arrayIdentity ? rightFiller : MethodHandles.collectArguments(mh, 0, rightFiller);
        }
        mh = mh == Lazy.MH_arrayIdentity ? leftCollector : MethodHandles.collectArguments(mh, 0, leftCollector);
        return mh;
    }

    private static MethodHandle fillToRight(int nargs) {
        MethodHandle filler = FILL_ARRAY_TO_RIGHT[nargs];
        if (filler != null) {
            return filler;
        }
        filler = MethodHandleImpl.buildFiller(nargs);
        assert (MethodHandleImpl.assertCorrectArity(filler, nargs - 10 + 1));
        MethodHandleImpl.FILL_ARRAY_TO_RIGHT[nargs] = filler;
        return MethodHandleImpl.FILL_ARRAY_TO_RIGHT[nargs];
    }

    private static MethodHandle buildFiller(int nargs) {
        if (nargs <= 10) {
            return Lazy.MH_arrayIdentity;
        }
        int CHUNK = 10;
        int rightLen = nargs % 10;
        int midLen = nargs - rightLen;
        if (rightLen == 0) {
            rightLen = 10;
            midLen = nargs - 10;
            if (FILL_ARRAY_TO_RIGHT[midLen] == null) {
                for (int j = 0; j < midLen; j += 10) {
                    if (j <= 10) continue;
                    MethodHandleImpl.fillToRight(j);
                }
            }
        }
        if (midLen < 10) {
            midLen = 10;
            rightLen = nargs - 10;
        }
        assert (rightLen > 0);
        MethodHandle midFill = MethodHandleImpl.fillToRight(midLen);
        MethodHandle rightFill = Lazy.FILL_ARRAYS[rightLen].bindTo(midLen);
        assert (midFill.type().parameterCount() == 1 + midLen - 10);
        assert (rightFill.type().parameterCount() == 1 + rightLen);
        if (midLen == 10) {
            return rightFill;
        }
        return MethodHandles.collectArguments(rightFill, 0, midFill);
    }

    static MethodHandle varargsArray(Class<?> arrayType, int nargs) {
        MethodHandle mh;
        Class<?> elemType = arrayType.getComponentType();
        if (elemType == null) {
            throw new IllegalArgumentException("not an array: " + arrayType);
        }
        if (nargs >= 126) {
            int slots = nargs;
            int MAX_ARRAY_SLOTS = 254;
            if (slots <= 254 && elemType.isPrimitive()) {
                slots *= Wrapper.forPrimitiveType(elemType).stackSlots();
            }
            if (slots > 254) {
                throw new IllegalArgumentException("too many arguments: " + arrayType.getSimpleName() + ", length " + nargs);
            }
        }
        if (elemType == Object.class) {
            return MethodHandleImpl.varargsArray(nargs);
        }
        MethodHandle[] cache = TYPED_COLLECTORS.get(elemType);
        MethodHandle methodHandle = mh = nargs < cache.length ? cache[nargs] : null;
        if (mh != null) {
            return mh;
        }
        if (nargs == 0) {
            Object example = Array.newInstance(arrayType.getComponentType(), 0);
            mh = MethodHandles.constant(arrayType, example);
        } else if (elemType.isPrimitive()) {
            MethodHandle builder = Lazy.MH_fillNewArray;
            MethodHandle producer = MethodHandleImpl.buildArrayProducer(arrayType);
            mh = MethodHandleImpl.buildVarargsArray(builder, producer, nargs);
        } else {
            Class<Object[]> objArrayType = arrayType.asSubclass(Object[].class);
            T[] example = Arrays.copyOf(NO_ARGS_ARRAY, 0, objArrayType);
            MethodHandle builder = Lazy.MH_fillNewTypedArray.bindTo(example);
            MethodHandle producer = Lazy.MH_arrayIdentity;
            mh = MethodHandleImpl.buildVarargsArray(builder, producer, nargs);
        }
        mh = mh.asType(MethodType.methodType(arrayType, Collections.nCopies(nargs, elemType)));
        mh = MethodHandleImpl.makeIntrinsic(mh, Intrinsic.NEW_ARRAY);
        assert (MethodHandleImpl.assertCorrectArity(mh, nargs));
        if (nargs < cache.length) {
            cache[nargs] = mh;
        }
        return mh;
    }

    private static MethodHandle buildArrayProducer(Class<?> arrayType) {
        Class<?> elemType = arrayType.getComponentType();
        assert (elemType.isPrimitive());
        return Lazy.MH_copyAsPrimitiveArray.bindTo((Object)Wrapper.forPrimitiveType(elemType));
    }

    static void assertSame(Object mh1, Object mh2) {
        if (mh1 != mh2) {
            String msg = String.format("mh1 != mh2: mh1 = %s (form: %s); mh2 = %s (form: %s)", mh1, ((MethodHandle)mh1).form, mh2, ((MethodHandle)mh2).form);
            throw MethodHandleStatics.newInternalError(msg);
        }
    }

    static /* synthetic */ MethodHandle[] access$000() {
        return MethodHandleImpl.makeArrays();
    }

    static /* synthetic */ MethodHandle[] access$100() {
        return MethodHandleImpl.makeFillArrays();
    }

    static {
        final Object[] values = new Object[]{255};
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                values[0] = Integer.getInteger(MethodHandleImpl.class.getName() + ".MAX_ARITY", 255);
                return null;
            }
        });
        MAX_ARITY = (Integer)values[0];
        PRODUCE_BLOCK_INLINING_FORM = new Function<MethodHandle, LambdaForm>(){

            @Override
            public LambdaForm apply(MethodHandle target) {
                return DelegatingMethodHandle.makeReinvokerForm(target, 9, CountingWrapper.class, "reinvoker.dontInline", false, DelegatingMethodHandle.NF_getTarget, CountingWrapper.NF_maybeStopCounting);
            }
        };
        PRODUCE_REINVOKER_FORM = new Function<MethodHandle, LambdaForm>(){

            @Override
            public LambdaForm apply(MethodHandle target) {
                return DelegatingMethodHandle.makeReinvokerForm(target, 8, DelegatingMethodHandle.class, DelegatingMethodHandle.NF_getTarget);
            }
        };
        FAKE_METHOD_HANDLE_INVOKE = new MethodHandle[2];
        NO_ARGS_ARRAY = new Object[0];
        FILL_ARRAY_TO_RIGHT = new MethodHandle[MAX_ARITY + 1];
        TYPED_COLLECTORS = new ClassValue<MethodHandle[]>(){

            @Override
            protected MethodHandle[] computeValue(Class<?> type) {
                return new MethodHandle[256];
            }
        };
    }

    private static final class IntrinsicMethodHandle
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private final Intrinsic intrinsicName;

        IntrinsicMethodHandle(MethodHandle target, Intrinsic intrinsicName) {
            super(target.type(), target);
            this.target = target;
            this.intrinsicName = intrinsicName;
        }

        @Override
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        Intrinsic intrinsicName() {
            return this.intrinsicName;
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            this.asTypeCache = this.target.asType(newType);
            return this.asTypeCache;
        }

        @Override
        String internalProperties() {
            return super.internalProperties() + "\n& Intrinsic=" + (Object)((Object)this.intrinsicName);
        }

        @Override
        public MethodHandle asCollector(Class<?> arrayType, int arrayLength) {
            if (this.intrinsicName == Intrinsic.IDENTITY) {
                MethodType resultType = this.type().asCollectorType(arrayType, arrayLength);
                MethodHandle newArray = MethodHandleImpl.varargsArray(arrayType, arrayLength);
                return newArray.asType(resultType);
            }
            return super.asCollector(arrayType, arrayLength);
        }
    }

    static enum Intrinsic {
        SELECT_ALTERNATIVE,
        GUARD_WITH_CATCH,
        NEW_ARRAY,
        ARRAY_LOAD,
        ARRAY_STORE,
        IDENTITY,
        ZERO,
        NONE;

    }

    private static final class WrappedMember
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private final MemberName member;
        private final Class<?> callerClass;
        private final boolean isInvokeSpecial;

        private WrappedMember(MethodHandle target, MethodType type, MemberName member, boolean isInvokeSpecial, Class<?> callerClass) {
            super(type, target);
            this.target = target;
            this.member = member;
            this.callerClass = callerClass;
            this.isInvokeSpecial = isInvokeSpecial;
        }

        @Override
        MemberName internalMemberName() {
            return this.member;
        }

        @Override
        Class<?> internalCallerClass() {
            return this.callerClass;
        }

        @Override
        boolean isInvokeSpecial() {
            return this.isInvokeSpecial;
        }

        @Override
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            this.asTypeCache = this.target.asType(newType);
            return this.asTypeCache;
        }
    }

    private static class BindCaller {
        private static ClassValue<MethodHandle> CV_makeInjectedInvoker = new ClassValue<MethodHandle>(){

            @Override
            protected MethodHandle computeValue(Class<?> hostClass) {
                return BindCaller.makeInjectedInvoker(hostClass);
            }
        };
        private static final MethodHandle MH_checkCallerClass;
        private static final byte[] T_BYTES;

        private BindCaller() {
        }

        static MethodHandle bindCaller(MethodHandle mh, Class<?> hostClass) {
            if (hostClass == null || hostClass.isArray() || hostClass.isPrimitive() || hostClass.getName().startsWith("java.") || hostClass.getName().startsWith("sun.")) {
                throw new InternalError();
            }
            MethodHandle vamh = BindCaller.prepareForInvoker(mh);
            MethodHandle bccInvoker = CV_makeInjectedInvoker.get(hostClass);
            return BindCaller.restoreToType(bccInvoker.bindTo(vamh), mh, hostClass);
        }

        private static MethodHandle makeInjectedInvoker(Class<?> hostClass) {
            MethodHandle bccInvoker;
            Class<?> bcc = MethodHandleStatics.UNSAFE.defineAnonymousClass(hostClass, T_BYTES, null);
            if (hostClass.getClassLoader() != bcc.getClassLoader()) {
                throw new InternalError(hostClass.getName() + " (CL)");
            }
            try {
                if (hostClass.getProtectionDomain() != bcc.getProtectionDomain()) {
                    throw new InternalError(hostClass.getName() + " (PD)");
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            try {
                MethodHandle init = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(bcc, "init", MethodType.methodType(Void.TYPE));
                init.invokeExact();
            }
            catch (Throwable ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
            try {
                MethodType invokerMT = MethodType.methodType(Object.class, MethodHandle.class, Object[].class);
                bccInvoker = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(bcc, "invoke_V", invokerMT);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
            try {
                MethodHandle vamh = BindCaller.prepareForInvoker(MH_checkCallerClass);
                Object object = bccInvoker.invokeExact(vamh, new Object[]{hostClass, bcc});
            }
            catch (Throwable ex) {
                throw new InternalError(ex);
            }
            return bccInvoker;
        }

        private static MethodHandle prepareForInvoker(MethodHandle mh) {
            mh = mh.asFixedArity();
            MethodType mt = mh.type();
            int arity = mt.parameterCount();
            MethodHandle vamh = mh.asType(mt.generic());
            vamh.internalForm().compileToBytecode();
            vamh = vamh.asSpreader(Object[].class, arity);
            vamh.internalForm().compileToBytecode();
            return vamh;
        }

        private static MethodHandle restoreToType(MethodHandle vamh, MethodHandle original, Class<?> hostClass) {
            MethodType type = original.type();
            MethodHandle mh = vamh.asCollector(Object[].class, type.parameterCount());
            MemberName member = original.internalMemberName();
            mh = mh.asType(type);
            mh = new WrappedMember(mh, type, member, original.isInvokeSpecial(), hostClass);
            return mh;
        }

        @CallerSensitive
        private static boolean checkCallerClass(Class<?> expected, Class<?> expected2) {
            Class<?> actual = Reflection.getCallerClass();
            if (actual != expected && actual != expected2) {
                throw new InternalError("found " + actual.getName() + ", expected " + expected.getName() + (expected == expected2 ? "" : ", or else " + expected2.getName()));
            }
            return true;
        }

        static {
            Class<BindCaller> THIS_CLASS = BindCaller.class;
            assert (BindCaller.checkCallerClass(THIS_CLASS, THIS_CLASS));
            try {
                MH_checkCallerClass = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(THIS_CLASS, "checkCallerClass", MethodType.methodType(Boolean.TYPE, Class.class, Class.class));
                assert (MH_checkCallerClass.invokeExact(THIS_CLASS, THIS_CLASS));
            }
            catch (Throwable ex) {
                throw new InternalError(ex);
            }
            final Object[] values = new Object[]{null};
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        Class<T> tClass = T.class;
                        String tName = tClass.getName();
                        String tResource = tName.substring(tName.lastIndexOf(46) + 1) + ".class";
                        URLConnection uconn = tClass.getResource(tResource).openConnection();
                        int len = uconn.getContentLength();
                        byte[] bytes = new byte[len];
                        try (InputStream str = uconn.getInputStream();){
                            int nr = str.read(bytes);
                            if (nr != len) {
                                throw new IOException(tResource);
                            }
                        }
                        values[0] = bytes;
                    }
                    catch (IOException ex) {
                        throw new InternalError(ex);
                    }
                    return null;
                }
            });
            T_BYTES = (byte[])values[0];
        }

        private static class T {
            private T() {
            }

            static void init() {
            }

            static Object invoke_V(MethodHandle vamh, Object[] args) throws Throwable {
                return vamh.invokeExact(args);
            }
        }
    }

    static class CountingWrapper
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private int count;
        private Function<MethodHandle, LambdaForm> countingFormProducer;
        private Function<MethodHandle, LambdaForm> nonCountingFormProducer;
        private volatile boolean isCounting;
        static final LambdaForm.NamedFunction NF_maybeStopCounting;

        private CountingWrapper(MethodHandle target, LambdaForm lform, Function<MethodHandle, LambdaForm> countingFromProducer, Function<MethodHandle, LambdaForm> nonCountingFormProducer, int count) {
            super(target.type(), lform);
            this.target = target;
            this.count = count;
            this.countingFormProducer = countingFromProducer;
            this.nonCountingFormProducer = nonCountingFormProducer;
            this.isCounting = count > 0;
        }

        @Override
        @LambdaForm.Hidden
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            MethodHandle wrapper;
            MethodHandle newTarget = this.target.asType(newType);
            if (this.isCounting) {
                LambdaForm lform = this.countingFormProducer.apply(newTarget);
                wrapper = new CountingWrapper(newTarget, lform, this.countingFormProducer, this.nonCountingFormProducer, MethodHandleStatics.DONT_INLINE_THRESHOLD);
            } else {
                wrapper = newTarget;
            }
            this.asTypeCache = wrapper;
            return this.asTypeCache;
        }

        boolean countDown() {
            if (this.count <= 0) {
                if (this.isCounting) {
                    this.isCounting = false;
                    return true;
                }
                return false;
            }
            --this.count;
            return false;
        }

        @LambdaForm.Hidden
        static void maybeStopCounting(Object o1) {
            CountingWrapper wrapper = (CountingWrapper)o1;
            if (wrapper.countDown()) {
                LambdaForm lform = wrapper.nonCountingFormProducer.apply(wrapper.target);
                lform.compileToBytecode();
                wrapper.updateForm(lform);
            }
        }

        static {
            Class<CountingWrapper> THIS_CLASS = CountingWrapper.class;
            try {
                NF_maybeStopCounting = new LambdaForm.NamedFunction(THIS_CLASS.getDeclaredMethod("maybeStopCounting", Object.class));
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
        }
    }

    static class Lazy {
        private static final Class<?> MHI = MethodHandleImpl.class;
        private static final MethodHandle[] ARRAYS = MethodHandleImpl.access$000();
        private static final MethodHandle[] FILL_ARRAYS = MethodHandleImpl.access$100();
        static final LambdaForm.NamedFunction NF_checkSpreadArgument;
        static final LambdaForm.NamedFunction NF_guardWithCatch;
        static final LambdaForm.NamedFunction NF_throwException;
        static final LambdaForm.NamedFunction NF_profileBoolean;
        static final MethodHandle MH_castReference;
        static final MethodHandle MH_selectAlternative;
        static final MethodHandle MH_copyAsPrimitiveArray;
        static final MethodHandle MH_fillNewTypedArray;
        static final MethodHandle MH_fillNewArray;
        static final MethodHandle MH_arrayIdentity;

        Lazy() {
        }

        static {
            try {
                NF_checkSpreadArgument = new LambdaForm.NamedFunction(MHI.getDeclaredMethod("checkSpreadArgument", Object.class, Integer.TYPE));
                NF_guardWithCatch = new LambdaForm.NamedFunction(MHI.getDeclaredMethod("guardWithCatch", MethodHandle.class, Class.class, MethodHandle.class, Object[].class));
                NF_throwException = new LambdaForm.NamedFunction(MHI.getDeclaredMethod("throwException", Throwable.class));
                NF_profileBoolean = new LambdaForm.NamedFunction(MHI.getDeclaredMethod("profileBoolean", Boolean.TYPE, int[].class));
                NF_checkSpreadArgument.resolve();
                NF_guardWithCatch.resolve();
                NF_throwException.resolve();
                NF_profileBoolean.resolve();
                MH_castReference = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MHI, "castReference", MethodType.methodType(Object.class, Class.class, Object.class));
                MH_copyAsPrimitiveArray = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MHI, "copyAsPrimitiveArray", MethodType.methodType(Object.class, Wrapper.class, Object[].class));
                MH_arrayIdentity = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MHI, "identity", MethodType.methodType(Object[].class, Object[].class));
                MH_fillNewArray = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MHI, "fillNewArray", MethodType.methodType(Object[].class, Integer.class, Object[].class));
                MH_fillNewTypedArray = MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MHI, "fillNewTypedArray", MethodType.methodType(Object[].class, Object[].class, Integer.class, Object[].class));
                MH_selectAlternative = MethodHandleImpl.makeIntrinsic(MethodHandles.Lookup.IMPL_LOOKUP.findStatic(MHI, "selectAlternative", MethodType.methodType(MethodHandle.class, Boolean.TYPE, MethodHandle.class, MethodHandle.class)), Intrinsic.SELECT_ALTERNATIVE);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.newInternalError(ex);
            }
        }
    }

    private static final class AsVarargsCollector
    extends DelegatingMethodHandle {
        private final MethodHandle target;
        private final Class<?> arrayType;
        @Stable
        private MethodHandle asCollectorCache;

        AsVarargsCollector(MethodHandle target, Class<?> arrayType) {
            this(target.type(), target, arrayType);
        }

        AsVarargsCollector(MethodType type, MethodHandle target, Class<?> arrayType) {
            super(type, target);
            this.target = target;
            this.arrayType = arrayType;
            this.asCollectorCache = target.asCollector(arrayType, 0);
        }

        @Override
        public boolean isVarargsCollector() {
            return true;
        }

        @Override
        protected MethodHandle getTarget() {
            return this.target;
        }

        @Override
        public MethodHandle asFixedArity() {
            return this.target;
        }

        @Override
        MethodHandle setVarargs(MemberName member) {
            if (member.isVarargs()) {
                return this;
            }
            return this.asFixedArity();
        }

        @Override
        public MethodHandle asTypeUncached(MethodType newType) {
            MethodHandle collector;
            MethodType type = this.type();
            int collectArg = type.parameterCount() - 1;
            int newArity = newType.parameterCount();
            if (newArity == collectArg + 1 && type.parameterType(collectArg).isAssignableFrom(newType.parameterType(collectArg))) {
                this.asTypeCache = this.asFixedArity().asType(newType);
                return this.asTypeCache;
            }
            MethodHandle acc = this.asCollectorCache;
            if (acc != null && acc.type().parameterCount() == newArity) {
                this.asTypeCache = acc.asType(newType);
                return this.asTypeCache;
            }
            int arrayLength = newArity - collectArg;
            try {
                collector = this.asFixedArity().asCollector(this.arrayType, arrayLength);
                assert (collector.type().parameterCount() == newArity) : "newArity=" + newArity + " but collector=" + collector;
            }
            catch (IllegalArgumentException ex) {
                throw new WrongMethodTypeException("cannot build collector", ex);
            }
            this.asCollectorCache = collector;
            this.asTypeCache = collector.asType(newType);
            return this.asTypeCache;
        }

        @Override
        boolean viewAsTypeChecks(MethodType newType, boolean strict) {
            super.viewAsTypeChecks(newType, true);
            if (strict) {
                return true;
            }
            assert (this.type().lastParameterType().getComponentType().isAssignableFrom(newType.lastParameterType().getComponentType())) : Arrays.asList(this, newType);
            return true;
        }
    }

    static final class ArrayAccessor {
        static final int GETTER_INDEX = 0;
        static final int SETTER_INDEX = 1;
        static final int INDEX_LIMIT = 2;
        static final ClassValue<MethodHandle[]> TYPED_ACCESSORS = new ClassValue<MethodHandle[]>(){

            @Override
            protected MethodHandle[] computeValue(Class<?> type) {
                return new MethodHandle[2];
            }
        };
        static final MethodHandle OBJECT_ARRAY_GETTER;
        static final MethodHandle OBJECT_ARRAY_SETTER;

        ArrayAccessor() {
        }

        static int getElementI(int[] a, int i) {
            return a[i];
        }

        static long getElementJ(long[] a, int i) {
            return a[i];
        }

        static float getElementF(float[] a, int i) {
            return a[i];
        }

        static double getElementD(double[] a, int i) {
            return a[i];
        }

        static boolean getElementZ(boolean[] a, int i) {
            return a[i];
        }

        static byte getElementB(byte[] a, int i) {
            return a[i];
        }

        static short getElementS(short[] a, int i) {
            return a[i];
        }

        static char getElementC(char[] a, int i) {
            return a[i];
        }

        static Object getElementL(Object[] a, int i) {
            return a[i];
        }

        static void setElementI(int[] a, int i, int x) {
            a[i] = x;
        }

        static void setElementJ(long[] a, int i, long x) {
            a[i] = x;
        }

        static void setElementF(float[] a, int i, float x) {
            a[i] = x;
        }

        static void setElementD(double[] a, int i, double x) {
            a[i] = x;
        }

        static void setElementZ(boolean[] a, int i, boolean x) {
            a[i] = x;
        }

        static void setElementB(byte[] a, int i, byte x) {
            a[i] = x;
        }

        static void setElementS(short[] a, int i, short x) {
            a[i] = x;
        }

        static void setElementC(char[] a, int i, char x) {
            a[i] = x;
        }

        static void setElementL(Object[] a, int i, Object x) {
            a[i] = x;
        }

        static String name(Class<?> arrayClass, boolean isSetter) {
            Class<?> elemClass = arrayClass.getComponentType();
            if (elemClass == null) {
                throw MethodHandleStatics.newIllegalArgumentException("not an array", arrayClass);
            }
            return (!isSetter ? "getElement" : "setElement") + Wrapper.basicTypeChar(elemClass);
        }

        static MethodType type(Class<?> arrayClass, boolean isSetter) {
            Class<Object> elemClass = arrayClass.getComponentType();
            Class<Object> arrayArgClass = arrayClass;
            if (!elemClass.isPrimitive()) {
                arrayArgClass = Object[].class;
                elemClass = Object.class;
            }
            return !isSetter ? MethodType.methodType(elemClass, arrayArgClass, Integer.TYPE) : MethodType.methodType(Void.TYPE, arrayArgClass, Integer.TYPE, elemClass);
        }

        static MethodType correctType(Class<?> arrayClass, boolean isSetter) {
            Class<?> elemClass = arrayClass.getComponentType();
            return !isSetter ? MethodType.methodType(elemClass, arrayClass, Integer.TYPE) : MethodType.methodType(Void.TYPE, arrayClass, Integer.TYPE, elemClass);
        }

        static MethodHandle getAccessor(Class<?> arrayClass, boolean isSetter) {
            String name = ArrayAccessor.name(arrayClass, isSetter);
            MethodType type = ArrayAccessor.type(arrayClass, isSetter);
            try {
                return MethodHandles.Lookup.IMPL_LOOKUP.findStatic(ArrayAccessor.class, name, type);
            }
            catch (ReflectiveOperationException ex) {
                throw MethodHandleStatics.uncaughtException(ex);
            }
        }

        static {
            MethodHandle[] cache = TYPED_ACCESSORS.get(Object[].class);
            cache[0] = OBJECT_ARRAY_GETTER = MethodHandleImpl.makeIntrinsic(ArrayAccessor.getAccessor(Object[].class, false), Intrinsic.ARRAY_LOAD);
            cache[1] = OBJECT_ARRAY_SETTER = MethodHandleImpl.makeIntrinsic(ArrayAccessor.getAccessor(Object[].class, true), Intrinsic.ARRAY_STORE);
            assert (InvokerBytecodeGenerator.isStaticallyInvocable(OBJECT_ARRAY_GETTER.internalMemberName()));
            assert (InvokerBytecodeGenerator.isStaticallyInvocable(OBJECT_ARRAY_SETTER.internalMemberName()));
        }
    }
}

