/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketOption;
import jdk.net.ExtendedSocketOptions;
import jdk.net.SocketFlow;
import sun.net.ExtendedOptionsImpl;

class PlainSocketImpl
extends AbstractPlainSocketImpl {
    PlainSocketImpl() {
    }

    PlainSocketImpl(FileDescriptor fd) {
        this.fd = fd;
    }

    @Override
    protected <T> void setOption(SocketOption<T> name, T value) throws IOException {
        if (!name.equals(ExtendedSocketOptions.SO_FLOW_SLA)) {
            super.setOption(name, value);
        } else {
            if (this.isClosedOrPending()) {
                throw new SocketException("Socket closed");
            }
            ExtendedOptionsImpl.checkSetOptionPermission(name);
            ExtendedOptionsImpl.checkValueType(value, SocketFlow.class);
            ExtendedOptionsImpl.setFlowOption(this.getFileDescriptor(), (SocketFlow)value);
        }
    }

    @Override
    protected <T> T getOption(SocketOption<T> name) throws IOException {
        if (!name.equals(ExtendedSocketOptions.SO_FLOW_SLA)) {
            return super.getOption(name);
        }
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket closed");
        }
        ExtendedOptionsImpl.checkGetOptionPermission(name);
        SocketFlow flow = SocketFlow.create();
        ExtendedOptionsImpl.getFlowOption(this.getFileDescriptor(), flow);
        return (T)flow;
    }

    @Override
    protected void socketSetOption(int opt, boolean b, Object val) throws SocketException {
        block2: {
            try {
                this.socketSetOption0(opt, b, val);
            }
            catch (SocketException se) {
                if (this.socket != null && this.socket.isConnected()) break block2;
                throw se;
            }
        }
    }

    @Override
    native void socketCreate(boolean var1) throws IOException;

    @Override
    native void socketConnect(InetAddress var1, int var2, int var3) throws IOException;

    @Override
    native void socketBind(InetAddress var1, int var2) throws IOException;

    @Override
    native void socketListen(int var1) throws IOException;

    @Override
    native void socketAccept(SocketImpl var1) throws IOException;

    @Override
    native int socketAvailable() throws IOException;

    @Override
    native void socketClose0(boolean var1) throws IOException;

    @Override
    native void socketShutdown(int var1) throws IOException;

    static native void initProto();

    native void socketSetOption0(int var1, boolean var2, Object var3) throws SocketException;

    @Override
    native int socketGetOption(int var1, Object var2) throws SocketException;

    @Override
    native void socketSendUrgentData(int var1) throws IOException;

    static {
        PlainSocketImpl.initProto();
    }
}

