/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.sctp;

import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.AssociationChangeNotification;
import sun.nio.ch.sctp.SctpNotification;

public class AssociationChange
extends AssociationChangeNotification
implements SctpNotification {
    private static final int SCTP_COMM_UP = 1;
    private static final int SCTP_COMM_LOST = 2;
    private static final int SCTP_RESTART = 3;
    private static final int SCTP_SHUTDOWN = 4;
    private static final int SCTP_CANT_START = 5;
    private Association association;
    private int assocId;
    private AssociationChangeNotification.AssocChangeEvent event;
    private int maxOutStreams;
    private int maxInStreams;

    private AssociationChange(int assocId, int intEvent, int maxOutStreams, int maxInStreams) {
        switch (intEvent) {
            case 1: {
                this.event = AssociationChangeNotification.AssocChangeEvent.COMM_UP;
                break;
            }
            case 2: {
                this.event = AssociationChangeNotification.AssocChangeEvent.COMM_LOST;
                break;
            }
            case 3: {
                this.event = AssociationChangeNotification.AssocChangeEvent.RESTART;
                break;
            }
            case 4: {
                this.event = AssociationChangeNotification.AssocChangeEvent.SHUTDOWN;
                break;
            }
            case 5: {
                this.event = AssociationChangeNotification.AssocChangeEvent.CANT_START;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown Association Change Event type: " + intEvent));
            }
        }
        this.assocId = assocId;
        this.maxOutStreams = maxOutStreams;
        this.maxInStreams = maxInStreams;
    }

    @Override
    public int assocId() {
        return this.assocId;
    }

    @Override
    public void setAssociation(Association association) {
        this.association = association;
    }

    @Override
    public Association association() {
        assert (this.association != null);
        return this.association;
    }

    @Override
    public AssociationChangeNotification.AssocChangeEvent event() {
        return this.event;
    }

    int maxOutStreams() {
        return this.maxOutStreams;
    }

    int maxInStreams() {
        return this.maxInStreams;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(" [");
        sb.append("Association:").append(this.association);
        sb.append(", Event: ").append((Object)this.event).append("]");
        return sb.toString();
    }
}

