/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.file.FileSystemException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Objects;
import sun.nio.fs.AbstractPath;
import sun.nio.fs.AbstractWatchService;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixUriUtils;
import sun.nio.fs.Util;

class UnixPath
extends AbstractPath {
    private static ThreadLocal<SoftReference<CharsetEncoder>> encoder = new ThreadLocal();
    private final UnixFileSystem fs;
    private final byte[] path;
    private volatile String stringValue;
    private int hash;
    private volatile int[] offsets;

    UnixPath(UnixFileSystem fs, byte[] path) {
        this.fs = fs;
        this.path = path;
    }

    UnixPath(UnixFileSystem fs, String input) {
        this(fs, UnixPath.encode(fs, UnixPath.normalizeAndCheck(input)));
    }

    static String normalizeAndCheck(String input) {
        int n = input.length();
        int prevChar = 0;
        for (int i = 0; i < n; ++i) {
            char c = input.charAt(i);
            if (c == '/' && prevChar == 47) {
                return UnixPath.normalize(input, n, i - 1);
            }
            UnixPath.checkNotNul(input, c);
            prevChar = c;
        }
        if (prevChar == 47) {
            return UnixPath.normalize(input, n, n - 1);
        }
        return input;
    }

    private static void checkNotNul(String input, char c) {
        if (c == '\u0000') {
            throw new InvalidPathException(input, "Nul character not allowed");
        }
    }

    private static String normalize(String input, int len, int off) {
        int n;
        if (len == 0) {
            return input;
        }
        for (n = len; n > 0 && input.charAt(n - 1) == '/'; --n) {
        }
        if (n == 0) {
            return "/";
        }
        StringBuilder sb = new StringBuilder(input.length());
        if (off > 0) {
            sb.append(input.substring(0, off));
        }
        int prevChar = 0;
        for (int i = off; i < n; ++i) {
            char c = input.charAt(i);
            if (c == '/' && prevChar == 47) continue;
            UnixPath.checkNotNul(input, c);
            sb.append(c);
            prevChar = c;
        }
        return sb.toString();
    }

    private static byte[] encode(UnixFileSystem fs, String input) {
        boolean error;
        CharsetEncoder ce;
        SoftReference<CharsetEncoder> ref = encoder.get();
        CharsetEncoder charsetEncoder = ce = ref != null ? ref.get() : null;
        if (ce == null) {
            ce = Util.jnuEncoding().newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            encoder.set(new SoftReference<CharsetEncoder>(ce));
        }
        char[] ca = fs.normalizeNativePath(input.toCharArray());
        byte[] ba = new byte[(int)((double)ca.length * (double)ce.maxBytesPerChar())];
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(ca);
        ce.reset();
        CoderResult cr = ce.encode(cb, bb, true);
        if (!cr.isUnderflow()) {
            error = true;
        } else {
            cr = ce.flush(bb);
            boolean bl = error = !cr.isUnderflow();
        }
        if (error) {
            throw new InvalidPathException(input, "Malformed input or input contains unmappable characters");
        }
        int len = bb.position();
        if (len != ba.length) {
            ba = Arrays.copyOf(ba, len);
        }
        return ba;
    }

    byte[] asByteArray() {
        return this.path;
    }

    byte[] getByteArrayForSysCalls() {
        if (this.getFileSystem().needToResolveAgainstDefaultDirectory()) {
            return UnixPath.resolve(this.getFileSystem().defaultDirectory(), this.path);
        }
        if (!this.isEmpty()) {
            return this.path;
        }
        byte[] here = new byte[]{46};
        return here;
    }

    String getPathForExceptionMessage() {
        return this.toString();
    }

    String getPathForPermissionCheck() {
        if (this.getFileSystem().needToResolveAgainstDefaultDirectory()) {
            return Util.toString(this.getByteArrayForSysCalls());
        }
        return this.toString();
    }

    static UnixPath toUnixPath(Path obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        if (!(obj instanceof UnixPath)) {
            throw new ProviderMismatchException();
        }
        return (UnixPath)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOffsets() {
        if (this.offsets == null) {
            int count = 0;
            int index = 0;
            if (this.isEmpty()) {
                count = 1;
            } else {
                while (index < this.path.length) {
                    byte c;
                    if ((c = this.path[index++]) == 47) continue;
                    ++count;
                    while (index < this.path.length && this.path[index] != 47) {
                        ++index;
                    }
                }
            }
            int[] result = new int[count];
            count = 0;
            index = 0;
            while (index < this.path.length) {
                byte c = this.path[index];
                if (c == 47) {
                    ++index;
                    continue;
                }
                result[count++] = index++;
                while (index < this.path.length && this.path[index] != 47) {
                    ++index;
                }
            }
            UnixPath unixPath = this;
            synchronized (unixPath) {
                if (this.offsets == null) {
                    this.offsets = result;
                }
            }
        }
    }

    private boolean isEmpty() {
        return this.path.length == 0;
    }

    private UnixPath emptyPath() {
        return new UnixPath(this.getFileSystem(), new byte[0]);
    }

    @Override
    public UnixFileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public UnixPath getRoot() {
        if (this.path.length > 0 && this.path[0] == 47) {
            return this.getFileSystem().rootDirectory();
        }
        return null;
    }

    @Override
    public UnixPath getFileName() {
        this.initOffsets();
        int count = this.offsets.length;
        if (count == 0) {
            return null;
        }
        if (count == 1 && this.path.length > 0 && this.path[0] != 47) {
            return this;
        }
        int lastOffset = this.offsets[count - 1];
        int len = this.path.length - lastOffset;
        byte[] result = new byte[len];
        System.arraycopy(this.path, lastOffset, result, 0, len);
        return new UnixPath(this.getFileSystem(), result);
    }

    @Override
    public UnixPath getParent() {
        this.initOffsets();
        int count = this.offsets.length;
        if (count == 0) {
            return null;
        }
        int len = this.offsets[count - 1] - 1;
        if (len <= 0) {
            return this.getRoot();
        }
        byte[] result = new byte[len];
        System.arraycopy(this.path, 0, result, 0, len);
        return new UnixPath(this.getFileSystem(), result);
    }

    @Override
    public int getNameCount() {
        this.initOffsets();
        return this.offsets.length;
    }

    @Override
    public UnixPath getName(int index) {
        this.initOffsets();
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index >= this.offsets.length) {
            throw new IllegalArgumentException();
        }
        int begin = this.offsets[index];
        int len = index == this.offsets.length - 1 ? this.path.length - begin : this.offsets[index + 1] - begin - 1;
        byte[] result = new byte[len];
        System.arraycopy(this.path, begin, result, 0, len);
        return new UnixPath(this.getFileSystem(), result);
    }

    @Override
    public UnixPath subpath(int beginIndex, int endIndex) {
        this.initOffsets();
        if (beginIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (beginIndex >= this.offsets.length) {
            throw new IllegalArgumentException();
        }
        if (endIndex > this.offsets.length) {
            throw new IllegalArgumentException();
        }
        if (beginIndex >= endIndex) {
            throw new IllegalArgumentException();
        }
        int begin = this.offsets[beginIndex];
        int len = endIndex == this.offsets.length ? this.path.length - begin : this.offsets[endIndex] - begin - 1;
        byte[] result = new byte[len];
        System.arraycopy(this.path, begin, result, 0, len);
        return new UnixPath(this.getFileSystem(), result);
    }

    @Override
    public boolean isAbsolute() {
        return this.path.length > 0 && this.path[0] == 47;
    }

    private static byte[] resolve(byte[] base, byte[] child) {
        byte[] result;
        int baseLength = base.length;
        int childLength = child.length;
        if (childLength == 0) {
            return base;
        }
        if (baseLength == 0 || child[0] == 47) {
            return child;
        }
        if (baseLength == 1 && base[0] == 47) {
            result = new byte[childLength + 1];
            result[0] = 47;
            System.arraycopy(child, 0, result, 1, childLength);
        } else {
            result = new byte[baseLength + 1 + childLength];
            System.arraycopy(base, 0, result, 0, baseLength);
            result[base.length] = 47;
            System.arraycopy(child, 0, result, baseLength + 1, childLength);
        }
        return result;
    }

    @Override
    public UnixPath resolve(Path obj) {
        byte[] other = UnixPath.toUnixPath((Path)obj).path;
        if (other.length > 0 && other[0] == 47) {
            return (UnixPath)obj;
        }
        byte[] result = UnixPath.resolve(this.path, other);
        return new UnixPath(this.getFileSystem(), result);
    }

    UnixPath resolve(byte[] other) {
        return this.resolve(new UnixPath(this.getFileSystem(), other));
    }

    @Override
    public UnixPath relativize(Path obj) {
        int dotdots;
        int i;
        int cn;
        UnixPath other = UnixPath.toUnixPath(obj);
        if (other.equals(this)) {
            return this.emptyPath();
        }
        if (this.isAbsolute() != other.isAbsolute()) {
            throw new IllegalArgumentException("'other' is different type of Path");
        }
        if (this.isEmpty()) {
            return other;
        }
        int bn = this.getNameCount();
        int n = bn > (cn = other.getNameCount()) ? cn : bn;
        for (i = 0; i < n && this.getName(i).equals(other.getName(i)); ++i) {
        }
        if (i < cn) {
            UnixPath remainder = other.subpath(i, cn);
            if (dotdots == 0) {
                return remainder;
            }
            boolean isOtherEmpty = other.isEmpty();
            int len = dotdots * 3 + remainder.path.length;
            if (isOtherEmpty) {
                assert (remainder.isEmpty());
                --len;
            }
            byte[] result = new byte[len];
            int pos = 0;
            while (dotdots > 0) {
                result[pos++] = 46;
                result[pos++] = 46;
                if (isOtherEmpty) {
                    if (dotdots > 1) {
                        result[pos++] = 47;
                    }
                } else {
                    result[pos++] = 47;
                }
                --dotdots;
            }
            System.arraycopy(remainder.path, 0, result, pos, remainder.path.length);
            return new UnixPath(this.getFileSystem(), result);
        }
        byte[] result = new byte[dotdots * 3 - 1];
        int pos = 0;
        for (dotdots = bn - i; dotdots > 0; --dotdots) {
            result[pos++] = 46;
            result[pos++] = 46;
            if (dotdots <= 1) continue;
            result[pos++] = 47;
        }
        return new UnixPath(this.getFileSystem(), result);
    }

    @Override
    public Path normalize() {
        int count = this.getNameCount();
        if (count == 0 || this.isEmpty()) {
            return this;
        }
        boolean[] ignore = new boolean[count];
        int[] size = new int[count];
        int remaining = count;
        boolean hasDotDot = false;
        boolean isAbsolute = this.isAbsolute();
        for (int i = 0; i < count; ++i) {
            int begin = this.offsets[i];
            int len = i == this.offsets.length - 1 ? this.path.length - begin : this.offsets[i + 1] - begin - 1;
            size[i] = len;
            if (this.path[begin] != 46) continue;
            if (len == 1) {
                ignore[i] = true;
                --remaining;
                continue;
            }
            if (this.path[begin + 1] != 46) continue;
            hasDotDot = true;
        }
        if (hasDotDot) {
            int prevRemaining;
            do {
                prevRemaining = remaining;
                int prevName = -1;
                for (int i = 0; i < count; ++i) {
                    if (ignore[i]) continue;
                    if (size[i] != 2) {
                        prevName = i;
                        continue;
                    }
                    int begin = this.offsets[i];
                    if (this.path[begin] != 46 || this.path[begin + 1] != 46) {
                        prevName = i;
                        continue;
                    }
                    if (prevName >= 0) {
                        ignore[prevName] = true;
                        ignore[i] = true;
                        remaining -= 2;
                        prevName = -1;
                        continue;
                    }
                    if (!isAbsolute) continue;
                    boolean hasPrevious = false;
                    for (int j = 0; j < i; ++j) {
                        if (ignore[j]) continue;
                        hasPrevious = true;
                        break;
                    }
                    if (hasPrevious) continue;
                    ignore[i] = true;
                    --remaining;
                }
            } while (prevRemaining > remaining);
        }
        if (remaining == count) {
            return this;
        }
        if (remaining == 0) {
            return isAbsolute ? this.getFileSystem().rootDirectory() : this.emptyPath();
        }
        int len = remaining - 1;
        if (isAbsolute) {
            ++len;
        }
        for (int i = 0; i < count; ++i) {
            if (ignore[i]) continue;
            len += size[i];
        }
        byte[] result = new byte[len];
        int pos = 0;
        if (isAbsolute) {
            result[pos++] = 47;
        }
        for (int i = 0; i < count; ++i) {
            if (ignore[i]) continue;
            System.arraycopy(this.path, this.offsets[i], result, pos, size[i]);
            pos += size[i];
            if (--remaining <= 0) continue;
            result[pos++] = 47;
        }
        return new UnixPath(this.getFileSystem(), result);
    }

    @Override
    public boolean startsWith(Path other) {
        int i;
        if (!(Objects.requireNonNull(other) instanceof UnixPath)) {
            return false;
        }
        UnixPath that = (UnixPath)other;
        if (that.path.length > this.path.length) {
            return false;
        }
        int thisOffsetCount = this.getNameCount();
        int thatOffsetCount = that.getNameCount();
        if (thatOffsetCount == 0 && this.isAbsolute()) {
            return !that.isEmpty();
        }
        if (thatOffsetCount > thisOffsetCount) {
            return false;
        }
        if (thatOffsetCount == thisOffsetCount && this.path.length != that.path.length) {
            return false;
        }
        for (i = 0; i < thatOffsetCount; ++i) {
            Integer o2;
            Integer o1 = this.offsets[i];
            if (o1.equals(o2 = Integer.valueOf(that.offsets[i]))) continue;
            return false;
        }
        for (i = 0; i < that.path.length; ++i) {
            if (this.path[i] == that.path[i]) continue;
            return false;
        }
        return i >= this.path.length || this.path[i] == 47;
    }

    @Override
    public boolean endsWith(Path other) {
        int thisPos;
        int thatPos;
        if (!(Objects.requireNonNull(other) instanceof UnixPath)) {
            return false;
        }
        UnixPath that = (UnixPath)other;
        int thatLen = that.path.length;
        int thisLen = this.path.length;
        if (thatLen > thisLen) {
            return false;
        }
        if (thisLen > 0 && thatLen == 0) {
            return false;
        }
        if (that.isAbsolute() && !this.isAbsolute()) {
            return false;
        }
        int thisOffsetCount = this.getNameCount();
        int thatOffsetCount = that.getNameCount();
        if (thatOffsetCount > thisOffsetCount) {
            return false;
        }
        if (thatOffsetCount == thisOffsetCount) {
            if (thisOffsetCount == 0) {
                return true;
            }
            int expectedLen = thisLen;
            if (this.isAbsolute() && !that.isAbsolute()) {
                --expectedLen;
            }
            if (thatLen != expectedLen) {
                return false;
            }
        } else if (that.isAbsolute()) {
            return false;
        }
        if (thatLen - (thatPos = that.offsets[0]) != thisLen - (thisPos = this.offsets[thisOffsetCount - thatOffsetCount])) {
            return false;
        }
        while (thatPos < thatLen) {
            if (this.path[thisPos++] == that.path[thatPos++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Path other) {
        int len1 = this.path.length;
        int len2 = ((UnixPath)other).path.length;
        int n = Math.min(len1, len2);
        byte[] v1 = this.path;
        byte[] v2 = ((UnixPath)other).path;
        for (int k = 0; k < n; ++k) {
            int c1 = v1[k] & 0xFF;
            int c2 = v2[k] & 0xFF;
            if (c1 == c2) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    @Override
    public boolean equals(Object ob) {
        if (ob != null && ob instanceof UnixPath) {
            return this.compareTo((Path)ob) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            for (int i = 0; i < this.path.length; ++i) {
                h = 31 * h + (this.path[i] & 0xFF);
            }
            this.hash = h;
        }
        return h;
    }

    @Override
    public String toString() {
        if (this.stringValue == null) {
            this.stringValue = this.fs.normalizeJavaPath(Util.toString(this.path));
        }
        return this.stringValue;
    }

    int openForAttributeAccess(boolean followLinks) throws IOException {
        int flags = 0;
        if (!followLinks) {
            flags |= 0x8000;
        }
        try {
            return UnixNativeDispatcher.open(this, flags, 0);
        }
        catch (UnixException x) {
            if (this.getFileSystem().isSolaris() && x.errno() == 22) {
                x.setError(40);
            }
            if (x.errno() == 40) {
                throw new FileSystemException(this.getPathForExceptionMessage(), null, x.getMessage() + " or unable to access attributes of symbolic link");
            }
            x.rethrowAsIOException(this);
            return -1;
        }
    }

    void checkRead() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkRead(this.getPathForPermissionCheck());
        }
    }

    void checkWrite() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkWrite(this.getPathForPermissionCheck());
        }
    }

    void checkDelete() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkDelete(this.getPathForPermissionCheck());
        }
    }

    @Override
    public UnixPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPropertyAccess("user.dir");
        }
        return new UnixPath(this.getFileSystem(), UnixPath.resolve(this.getFileSystem().defaultDirectory(), this.path));
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        this.checkRead();
        UnixPath absolute = this.toAbsolutePath();
        if (Util.followLinks(options)) {
            try {
                byte[] rp = UnixNativeDispatcher.realpath(absolute);
                return new UnixPath(this.getFileSystem(), rp);
            }
            catch (UnixException x) {
                x.rethrowAsIOException(this);
            }
        }
        UnixPath result = this.fs.rootDirectory();
        for (int i = 0; i < absolute.getNameCount(); ++i) {
            UnixPath element = absolute.getName(i);
            if (element.asByteArray().length == 1 && element.asByteArray()[0] == 46) continue;
            if (element.asByteArray().length == 2 && element.asByteArray()[0] == 46 && element.asByteArray()[1] == 46) {
                UnixFileAttributes attrs = null;
                try {
                    attrs = UnixFileAttributes.get(result, false);
                }
                catch (UnixException x) {
                    x.rethrowAsIOException(result);
                }
                if (!attrs.isSymbolicLink()) {
                    if ((result = result.getParent()) != null) continue;
                    result = this.fs.rootDirectory();
                    continue;
                }
            }
            result = result.resolve(element);
        }
        try {
            UnixFileAttributes.get(result, false);
        }
        catch (UnixException x) {
            x.rethrowAsIOException(result);
        }
        return result;
    }

    @Override
    public URI toUri() {
        return UnixUriUtils.toUri(this);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        if (watcher == null) {
            throw new NullPointerException();
        }
        if (!(watcher instanceof AbstractWatchService)) {
            throw new ProviderMismatchException();
        }
        this.checkRead();
        return ((AbstractWatchService)watcher).register(this, events, modifiers);
    }
}

