/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.MultiDocPrintService;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.HashPrintServiceAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterURI;
import sun.print.BackgroundLookupListener;
import sun.print.BackgroundServiceLookup;
import sun.print.CUPSPrinter;
import sun.print.IPPPrintService;
import sun.print.UnixPrintService;
import sun.security.action.GetPropertyAction;

public class PrintServiceLookupProvider
extends PrintServiceLookup
implements BackgroundServiceLookup,
Runnable {
    private String defaultPrinter;
    private PrintService defaultPrintService;
    private PrintService[] printServices;
    private Vector lookupListeners = null;
    private static String debugPrefix;
    private static boolean pollServices;
    private static final int DEFAULT_MINREFRESH = 120;
    private static int minRefreshTime;
    static String osname;
    String[] lpNameComAix = new String[]{"/usr/bin/lsallq", "/usr/bin/lpstat -W -p|/usr/bin/expand|/usr/bin/cut -f1 -d' '", "/usr/bin/lpstat -W -d|/usr/bin/expand|/usr/bin/cut -f1 -d' '", "/usr/bin/lpstat -W -v"};
    private static final int aix_lsallq = 0;
    private static final int aix_lpstat_p = 1;
    private static final int aix_lpstat_d = 2;
    private static final int aix_lpstat_v = 3;
    private static int aix_defaultPrinterEnumeration;
    static final int UNINITIALIZED = -1;
    static final int BSD_LPD = 0;
    static final int BSD_LPD_NG = 1;
    static int cmdIndex;
    String[] lpcFirstCom = new String[]{"/usr/sbin/lpc status | grep : | sed -ne '1,1 s/://p'", "/usr/sbin/lpc status | grep -E '^[ 0-9a-zA-Z_-]*@' | awk -F'@' '{print $1}'"};
    String[] lpcAllCom = new String[]{"/usr/sbin/lpc status all | grep : | sed -e 's/://'", "/usr/sbin/lpc status all | grep -E '^[ 0-9a-zA-Z_-]*@' | awk -F'@' '{print $1}' | sort"};
    String[] lpcNameCom = new String[]{"| grep : | sed -ne 's/://p'", "| grep -E '^[ 0-9a-zA-Z_-]*@' | awk -F'@' '{print $1}'"};

    static boolean isMac() {
        return osname.startsWith("Mac");
    }

    static boolean isSysV() {
        return osname.equals("SunOS");
    }

    static boolean isLinux() {
        return osname.equals("Linux");
    }

    static boolean isBSD() {
        return osname.equals("Linux") || osname.contains("OS X");
    }

    static boolean isAIX() {
        return osname.equals("AIX");
    }

    static int getBSDCommandIndex() {
        String command = "/usr/sbin/lpc status all";
        String[] names = PrintServiceLookupProvider.execCmd(command);
        if (names == null || names.length == 0) {
            return 1;
        }
        for (int i = 0; i < names.length; ++i) {
            if (names[i].indexOf(64) == -1) continue;
            return 1;
        }
        return 0;
    }

    public PrintServiceLookupProvider() {
        if (pollServices) {
            PrinterChangeListener thr = new PrinterChangeListener();
            thr.setDaemon(true);
            thr.start();
            IPPPrintService.debug_println(debugPrefix + "polling turned on");
        }
    }

    @Override
    public synchronized PrintService[] getPrintServices() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        if (this.printServices == null || !pollServices) {
            this.refreshServices();
        }
        if (this.printServices == null) {
            return new PrintService[0];
        }
        return (PrintService[])this.printServices.clone();
    }

    private int addPrintServiceToList(ArrayList printerList, PrintService ps) {
        int index = printerList.indexOf(ps);
        if (CUPSPrinter.isCupsRunning() && index != -1) {
            PrinterURI uri = ps.getAttribute(PrinterURI.class);
            if (uri.getURI().getHost().equals("localhost")) {
                IPPPrintService.debug_println(debugPrefix + "duplicate PrintService, ignoring the new local printer: " + ps);
                return index;
            }
            PrintService oldPS = (PrintService)printerList.get(index);
            uri = oldPS.getAttribute(PrinterURI.class);
            if (uri.getURI().getHost().equals("localhost")) {
                IPPPrintService.debug_println(debugPrefix + "duplicate PrintService, removing existing local printer: " + oldPS);
                printerList.remove(oldPS);
            } else {
                return index;
            }
        }
        printerList.add(ps);
        return printerList.size() - 1;
    }

    public synchronized void refreshServices() {
        String[] printers = null;
        String[] printerURIs = null;
        try {
            this.getDefaultPrintService();
        }
        catch (Throwable t) {
            IPPPrintService.debug_println(debugPrefix + "Exception getting default printer : " + t);
        }
        if (CUPSPrinter.isCupsRunning()) {
            try {
                printerURIs = CUPSPrinter.getAllPrinters();
                IPPPrintService.debug_println("CUPS URIs = " + printerURIs);
                if (printerURIs != null) {
                    for (int p = 0; p < printerURIs.length; ++p) {
                        IPPPrintService.debug_println("URI=" + printerURIs[p]);
                    }
                }
            }
            catch (Throwable t) {
                IPPPrintService.debug_println(debugPrefix + "Exception getting all CUPS printers : " + t);
            }
            if (printerURIs != null && printerURIs.length > 0) {
                printers = new String[printerURIs.length];
                for (int i = 0; i < printerURIs.length; ++i) {
                    int lastIndex = printerURIs[i].lastIndexOf("/");
                    printers[i] = printerURIs[i].substring(lastIndex + 1);
                }
            }
        } else {
            printers = PrintServiceLookupProvider.isMac() || PrintServiceLookupProvider.isSysV() ? this.getAllPrinterNamesSysV() : (PrintServiceLookupProvider.isAIX() ? this.getAllPrinterNamesAIX() : this.getAllPrinterNamesBSD());
        }
        if (printers == null) {
            if (this.defaultPrintService != null) {
                this.printServices = new PrintService[1];
                this.printServices[0] = this.defaultPrintService;
            } else {
                this.printServices = null;
            }
            return;
        }
        ArrayList<PrintService> printerList = new ArrayList<PrintService>();
        int defaultIndex = -1;
        for (int p = 0; p < printers.length; ++p) {
            int j;
            if (printers[p] == null) continue;
            if (this.defaultPrintService != null && printers[p].equals(this.getPrinterDestName(this.defaultPrintService))) {
                defaultIndex = this.addPrintServiceToList(printerList, this.defaultPrintService);
                continue;
            }
            if (this.printServices == null) {
                IPPPrintService.debug_println(debugPrefix + "total# of printers = " + printers.length);
                if (CUPSPrinter.isCupsRunning()) {
                    try {
                        this.addPrintServiceToList(printerList, new IPPPrintService(printers[p], printerURIs[p], true));
                    }
                    catch (Exception e) {
                        IPPPrintService.debug_println(debugPrefix + " getAllPrinters Exception " + e);
                    }
                    continue;
                }
                printerList.add(new UnixPrintService(printers[p]));
                continue;
            }
            for (j = 0; j < this.printServices.length; ++j) {
                if (this.printServices[j] == null || !printers[p].equals(this.getPrinterDestName(this.printServices[j]))) continue;
                printerList.add(this.printServices[j]);
                this.printServices[j] = null;
                break;
            }
            if (j != this.printServices.length) continue;
            if (CUPSPrinter.isCupsRunning()) {
                try {
                    this.addPrintServiceToList(printerList, new IPPPrintService(printers[p], printerURIs[p], true));
                }
                catch (Exception e) {
                    IPPPrintService.debug_println(debugPrefix + " getAllPrinters Exception " + e);
                }
                continue;
            }
            printerList.add(new UnixPrintService(printers[p]));
        }
        if (this.printServices != null) {
            for (int j = 0; j < this.printServices.length; ++j) {
                if (!(this.printServices[j] instanceof UnixPrintService) || this.printServices[j].equals(this.defaultPrintService)) continue;
                ((UnixPrintService)this.printServices[j]).invalidateService();
            }
        }
        if (defaultIndex == -1 && this.defaultPrintService != null) {
            defaultIndex = this.addPrintServiceToList(printerList, this.defaultPrintService);
        }
        this.printServices = printerList.toArray(new PrintService[0]);
        if (defaultIndex > 0) {
            PrintService saveService = this.printServices[0];
            this.printServices[0] = this.printServices[defaultIndex];
            this.printServices[defaultIndex] = saveService;
        }
    }

    private boolean matchesAttributes(PrintService service, PrintServiceAttributeSet attributes) {
        Attribute[] attrs = attributes.toArray();
        for (int i = 0; i < attrs.length; ++i) {
            Attribute serviceAttr = service.getAttribute(attrs[i].getCategory());
            if (serviceAttr != null && serviceAttr.equals(attrs[i])) continue;
            return false;
        }
        return true;
    }

    private boolean checkPrinterName(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '-' || c == '_' || c == '.' || c == '/') continue;
            return false;
        }
        return true;
    }

    private String getPrinterDestName(PrintService ps) {
        if (PrintServiceLookupProvider.isMac()) {
            return ((IPPPrintService)ps).getDest();
        }
        return ps.getName();
    }

    private PrintService getServiceByName(PrinterName nameAttr) {
        String name = nameAttr.getValue();
        if (name == null || name.equals("") || !this.checkPrinterName(name)) {
            return null;
        }
        if (this.printServices != null) {
            for (PrintService printService : this.printServices) {
                PrinterName printerName = printService.getAttribute(PrinterName.class);
                if (!printerName.getValue().equals(name)) continue;
                return printService;
            }
        }
        if (CUPSPrinter.isCupsRunning()) {
            try {
                return new IPPPrintService(name, new URL("http://" + CUPSPrinter.getServer() + ":" + CUPSPrinter.getPort() + "/" + name));
            }
            catch (Exception e) {
                IPPPrintService.debug_println(debugPrefix + " getServiceByName Exception " + e);
            }
        }
        PrintService printer = null;
        printer = PrintServiceLookupProvider.isMac() || PrintServiceLookupProvider.isSysV() ? this.getNamedPrinterNameSysV(name) : (PrintServiceLookupProvider.isAIX() ? this.getNamedPrinterNameAIX(name) : this.getNamedPrinterNameBSD(name));
        return printer;
    }

    private PrintService[] getPrintServices(PrintServiceAttributeSet serviceSet) {
        int i;
        PrintService defService;
        if (serviceSet == null || serviceSet.isEmpty()) {
            return this.getPrintServices();
        }
        PrinterName name = (PrinterName)serviceSet.get(PrinterName.class);
        if (name != null && (defService = this.getDefaultPrintService()) != null) {
            PrinterName defName = defService.getAttribute(PrinterName.class);
            if (defName != null && name.equals(defName)) {
                if (this.matchesAttributes(defService, serviceSet)) {
                    PrintService[] services = new PrintService[]{defService};
                    return services;
                }
                return new PrintService[0];
            }
            PrintService service = this.getServiceByName(name);
            if (service != null && this.matchesAttributes(service, serviceSet)) {
                PrintService[] services = new PrintService[]{service};
                return services;
            }
            return new PrintService[0];
        }
        Vector<PrintService> matchedServices = new Vector<PrintService>();
        PrintService[] services = this.getPrintServices();
        for (i = 0; i < services.length; ++i) {
            if (!this.matchesAttributes(services[i], serviceSet)) continue;
            matchedServices.add(services[i]);
        }
        services = new PrintService[matchedServices.size()];
        for (i = 0; i < services.length; ++i) {
            services[i] = (PrintService)matchedServices.elementAt(i);
        }
        return services;
    }

    @Override
    public PrintService[] getPrintServices(DocFlavor flavor, AttributeSet attributes) {
        PrintService[] services;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        HashPrintRequestAttributeSet requestSet = null;
        HashPrintServiceAttributeSet serviceSet = null;
        if (attributes != null && !attributes.isEmpty()) {
            requestSet = new HashPrintRequestAttributeSet();
            serviceSet = new HashPrintServiceAttributeSet();
            Attribute[] attrs = attributes.toArray();
            for (int i = 0; i < attrs.length; ++i) {
                if (attrs[i] instanceof PrintRequestAttribute) {
                    requestSet.add(attrs[i]);
                    continue;
                }
                if (!(attrs[i] instanceof PrintServiceAttribute)) continue;
                serviceSet.add(attrs[i]);
            }
        }
        if ((services = this.getPrintServices(serviceSet)).length == 0) {
            return services;
        }
        if (CUPSPrinter.isCupsRunning()) {
            ArrayList<PrintService> matchingServices = new ArrayList<PrintService>();
            for (int i = 0; i < services.length; ++i) {
                try {
                    if (services[i].getUnsupportedAttributes(flavor, requestSet) != null) continue;
                    matchingServices.add(services[i]);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            services = new PrintService[matchingServices.size()];
            return matchingServices.toArray(services);
        }
        PrintService service = services[0];
        if ((flavor == null || service.isDocFlavorSupported(flavor)) && service.getUnsupportedAttributes(flavor, requestSet) == null) {
            return services;
        }
        return new PrintService[0];
    }

    @Override
    public MultiDocPrintService[] getMultiDocPrintServices(DocFlavor[] flavors, AttributeSet attributes) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        return new MultiDocPrintService[0];
    }

    @Override
    public synchronized PrintService getDefaultPrintService() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        this.defaultPrintService = null;
        String psuri = null;
        IPPPrintService.debug_println("isRunning ? " + CUPSPrinter.isCupsRunning());
        if (CUPSPrinter.isCupsRunning()) {
            String[] printerInfo = CUPSPrinter.getDefaultPrinter();
            if (printerInfo != null && printerInfo.length >= 2) {
                this.defaultPrinter = printerInfo[0];
                psuri = printerInfo[1];
            }
        } else {
            this.defaultPrinter = PrintServiceLookupProvider.isMac() || PrintServiceLookupProvider.isSysV() ? PrintServiceLookupProvider.getDefaultPrinterNameSysV() : (PrintServiceLookupProvider.isAIX() ? this.getDefaultPrinterNameAIX() : this.getDefaultPrinterNameBSD());
        }
        if (this.defaultPrinter == null) {
            return null;
        }
        this.defaultPrintService = null;
        if (this.printServices != null) {
            for (int j = 0; j < this.printServices.length; ++j) {
                if (!this.defaultPrinter.equals(this.getPrinterDestName(this.printServices[j]))) continue;
                this.defaultPrintService = this.printServices[j];
                break;
            }
        }
        if (this.defaultPrintService == null) {
            if (CUPSPrinter.isCupsRunning()) {
                try {
                    IPPPrintService defaultPS = psuri != null && !psuri.startsWith("file") ? new IPPPrintService(this.defaultPrinter, psuri, true) : new IPPPrintService(this.defaultPrinter, new URL("http://" + CUPSPrinter.getServer() + ":" + CUPSPrinter.getPort() + "/" + this.defaultPrinter));
                    this.defaultPrintService = defaultPS;
                }
                catch (Exception exception) {}
            } else {
                this.defaultPrintService = new UnixPrintService(this.defaultPrinter);
            }
        }
        return this.defaultPrintService;
    }

    @Override
    public synchronized void getServicesInbackground(BackgroundLookupListener listener) {
        if (this.printServices != null) {
            listener.notifyServices(this.printServices);
        } else if (this.lookupListeners == null) {
            this.lookupListeners = new Vector();
            this.lookupListeners.add(listener);
            Thread lookupThread = new Thread(this);
            lookupThread.start();
        } else {
            this.lookupListeners.add(listener);
        }
    }

    private PrintService[] copyOf(PrintService[] inArr) {
        if (inArr == null || inArr.length == 0) {
            return inArr;
        }
        PrintService[] outArr = new PrintService[inArr.length];
        System.arraycopy(inArr, 0, outArr, 0, inArr.length);
        return outArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PrintService[] services = this.getPrintServices();
        PrintServiceLookupProvider printServiceLookupProvider = this;
        synchronized (printServiceLookupProvider) {
            for (int i = 0; i < this.lookupListeners.size(); ++i) {
                BackgroundLookupListener listener = (BackgroundLookupListener)this.lookupListeners.elementAt(i);
                listener.notifyServices(this.copyOf(services));
            }
            this.lookupListeners = null;
        }
    }

    private String getDefaultPrinterNameBSD() {
        String[] names;
        if (cmdIndex == -1) {
            cmdIndex = PrintServiceLookupProvider.getBSDCommandIndex();
        }
        if ((names = PrintServiceLookupProvider.execCmd(this.lpcFirstCom[cmdIndex])) == null || names.length == 0) {
            return null;
        }
        if (cmdIndex == 1 && names[0].startsWith("missingprinter")) {
            return null;
        }
        return names[0];
    }

    private PrintService getNamedPrinterNameBSD(String name) {
        String command;
        String[] result;
        if (cmdIndex == -1) {
            cmdIndex = PrintServiceLookupProvider.getBSDCommandIndex();
        }
        if ((result = PrintServiceLookupProvider.execCmd(command = "/usr/sbin/lpc status " + name + this.lpcNameCom[cmdIndex])) == null || !result[0].equals(name)) {
            return null;
        }
        return new UnixPrintService(name);
    }

    private String[] getAllPrinterNamesBSD() {
        String[] names;
        if (cmdIndex == -1) {
            cmdIndex = PrintServiceLookupProvider.getBSDCommandIndex();
        }
        if ((names = PrintServiceLookupProvider.execCmd(this.lpcAllCom[cmdIndex])) == null || names.length == 0) {
            return null;
        }
        return names;
    }

    static String getDefaultPrinterNameSysV() {
        String defaultPrinter = "lp";
        String command = "/usr/bin/lpstat -d";
        String[] names = PrintServiceLookupProvider.execCmd(command);
        if (names == null || names.length == 0) {
            return defaultPrinter;
        }
        int index = names[0].indexOf(":");
        if (index == -1 || names[0].length() <= index + 1) {
            return null;
        }
        String name = names[0].substring(index + 1).trim();
        if (name.length() == 0) {
            return null;
        }
        return name;
    }

    private PrintService getNamedPrinterNameSysV(String name) {
        String command = "/usr/bin/lpstat -v " + name;
        String[] result = PrintServiceLookupProvider.execCmd(command);
        if (result == null || result[0].indexOf("unknown printer") > 0) {
            return null;
        }
        return new UnixPrintService(name);
    }

    private String[] getAllPrinterNamesSysV() {
        String defaultPrinter = "lp";
        String command = "/usr/bin/lpstat -v|/usr/bin/expand|/usr/bin/cut -f3 -d' ' |/usr/bin/cut -f1 -d':' | /usr/bin/sort";
        String[] names = PrintServiceLookupProvider.execCmd(command);
        ArrayList<String> printerNames = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].equals("_default") || names[i].equals(defaultPrinter) || names[i].equals("")) continue;
            printerNames.add(names[i]);
        }
        return printerNames.toArray(new String[printerNames.size()]);
    }

    private String getDefaultPrinterNameAIX() {
        String[] names = PrintServiceLookupProvider.execCmd(this.lpNameComAix[2]);
        if ((names = UnixPrintService.filterPrinterNamesAIX(names)) == null || names.length != 1) {
            return null;
        }
        return names[0];
    }

    private PrintService getNamedPrinterNameAIX(String name) {
        String[] result = PrintServiceLookupProvider.execCmd(this.lpNameComAix[3] + name);
        if ((result = UnixPrintService.filterPrinterNamesAIX(result)) == null || result.length != 1) {
            return null;
        }
        return new UnixPrintService(name);
    }

    private String[] getAllPrinterNamesAIX() {
        String[] names = PrintServiceLookupProvider.execCmd(this.lpNameComAix[aix_defaultPrinterEnumeration]);
        names = UnixPrintService.filterPrinterNamesAIX(names);
        ArrayList<String> printerNames = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            printerNames.add(names[i]);
        }
        return printerNames.toArray(new String[printerNames.size()]);
    }

    static String[] execCmd(String command) {
        ArrayList results = null;
        try {
            final String[] cmd = new String[3];
            if (PrintServiceLookupProvider.isSysV() || PrintServiceLookupProvider.isAIX()) {
                cmd[0] = "/usr/bin/sh";
                cmd[1] = "-c";
                cmd[2] = "env LC_ALL=C " + command;
            } else {
                cmd[0] = "/bin/sh";
                cmd[1] = "-c";
                cmd[2] = "LC_ALL=C " + command;
            }
            results = (ArrayList)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    BufferedReader bufferedReader = null;
                    File f = Files.createTempFile("prn", "xc", new FileAttribute[0]).toFile();
                    cmd[2] = cmd[2] + ">" + f.getAbsolutePath();
                    Process proc = Runtime.getRuntime().exec(cmd);
                    try {
                        boolean done = false;
                        while (!done) {
                            try {
                                proc.waitFor();
                                done = true;
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (proc.exitValue() == 0) {
                            String line;
                            FileReader reader = new FileReader(f);
                            bufferedReader = new BufferedReader(reader);
                            ArrayList<String> results = new ArrayList<String>();
                            while ((line = bufferedReader.readLine()) != null) {
                                results.add(line);
                            }
                            ArrayList<String> arrayList = results;
                            return arrayList;
                        }
                    }
                    finally {
                        f.delete();
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        proc.getInputStream().close();
                        proc.getErrorStream().close();
                        proc.getOutputStream().close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        if (results == null) {
            return new String[0];
        }
        return results.toArray(new String[results.size()]);
    }

    static {
        String aixPrinterEnumerator;
        String refreshTimeStr;
        debugPrefix = "PrintServiceLookupProvider>> ";
        pollServices = true;
        minRefreshTime = 120;
        aix_defaultPrinterEnumeration = 0;
        String pollStr = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.print.polling"));
        if (pollStr != null) {
            if (pollStr.equalsIgnoreCase("true")) {
                pollServices = true;
            } else if (pollStr.equalsIgnoreCase("false")) {
                pollServices = false;
            }
        }
        if ((refreshTimeStr = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.print.minRefreshTime"))) != null) {
            try {
                minRefreshTime = new Integer(refreshTimeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (minRefreshTime < 120) {
                minRefreshTime = 120;
            }
        }
        osname = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (PrintServiceLookupProvider.isAIX() && (aixPrinterEnumerator = AccessController.doPrivileged(new GetPropertyAction("sun.java2d.print.aix.lpstat"))) != null) {
            if (aixPrinterEnumerator.equalsIgnoreCase("lpstat")) {
                aix_defaultPrinterEnumeration = 1;
            } else if (aixPrinterEnumerator.equalsIgnoreCase("lsallq")) {
                aix_defaultPrinterEnumeration = 0;
            }
        }
        cmdIndex = -1;
    }

    private class PrinterChangeListener
    extends Thread {
        private PrinterChangeListener() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    PrintServiceLookupProvider.this.refreshServices();
                }
                catch (Exception se) {
                    IPPPrintService.debug_println(debugPrefix + "Exception in refresh thread.");
                    break;
                }
                int refreshSecs = PrintServiceLookupProvider.this.printServices != null && PrintServiceLookupProvider.this.printServices.length > minRefreshTime ? PrintServiceLookupProvider.this.printServices.length : minRefreshTime;
                try {
                    PrinterChangeListener.sleep(refreshSecs * 1000);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
    }
}

