/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import sun.security.util.Debug;
import sun.security.util.ECKeySizeParameterSpec;

public class ECUtil {
    private static final Debug debug = Debug.getInstance("ecc");

    public static ECPoint decodePoint(byte[] data, EllipticCurve curve) throws IOException {
        if (data.length == 0 || data[0] != 4) {
            throw new IOException("Only uncompressed point format supported");
        }
        int n = (data.length - 1) / 2;
        if (n != curve.getField().getFieldSize() + 7 >> 3) {
            throw new IOException("Point does not match field size");
        }
        byte[] xb = Arrays.copyOfRange(data, 1, 1 + n);
        byte[] yb = Arrays.copyOfRange(data, n + 1, n + 1 + n);
        return new ECPoint(new BigInteger(1, xb), new BigInteger(1, yb));
    }

    public static byte[] encodePoint(ECPoint point, EllipticCurve curve) {
        int n = curve.getField().getFieldSize() + 7 >> 3;
        byte[] xb = ECUtil.trimZeroes(point.getAffineX().toByteArray());
        byte[] yb = ECUtil.trimZeroes(point.getAffineY().toByteArray());
        if (xb.length > n || yb.length > n) {
            throw new RuntimeException("Point coordinates do not match field size");
        }
        byte[] b = new byte[1 + (n << 1)];
        b[0] = 4;
        System.arraycopy(xb, 0, b, n - xb.length + 1, xb.length);
        System.arraycopy(yb, 0, b, b.length - yb.length, yb.length);
        return b;
    }

    public static byte[] trimZeroes(byte[] b) {
        int i;
        for (i = 0; i < b.length - 1 && b[i] == 0; ++i) {
        }
        if (i == 0) {
            return b;
        }
        return Arrays.copyOfRange(b, i, b.length);
    }

    public static AlgorithmParameters getECParameters(Provider p) {
        return ECUtil.getECParameters(p, false);
    }

    public static AlgorithmParameters getECParameters(Provider p, boolean throwException) {
        try {
            if (p != null) {
                return AlgorithmParameters.getInstance("EC", p);
            }
            return AlgorithmParameters.getInstance("EC");
        }
        catch (NoSuchAlgorithmException nsae) {
            if (throwException) {
                throw new RuntimeException(nsae);
            }
            if (debug != null) {
                debug.println("Provider unavailable: " + nsae);
            }
            return null;
        }
    }

    public static byte[] encodeECParameterSpec(Provider p, ECParameterSpec spec) {
        AlgorithmParameters parameters = ECUtil.getECParameters(p, true);
        try {
            parameters.init(spec);
        }
        catch (InvalidParameterSpecException ipse) {
            throw new RuntimeException("Not a known named curve: " + spec);
        }
        try {
            return parameters.getEncoded();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider p, ECParameterSpec spec) {
        AlgorithmParameters parameters = ECUtil.getECParameters(p);
        if (parameters == null) {
            return null;
        }
        try {
            parameters.init(spec);
            return parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException ipse) {
            if (debug != null) {
                debug.println("Invalid parameter specification: " + ipse);
            }
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider p, byte[] params) throws IOException {
        AlgorithmParameters parameters = ECUtil.getECParameters(p);
        if (parameters == null) {
            return null;
        }
        parameters.init(params);
        try {
            return parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException ipse) {
            if (debug != null) {
                debug.println("Invalid parameter specification: " + ipse);
            }
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider p, String name) {
        AlgorithmParameters parameters = ECUtil.getECParameters(p);
        if (parameters == null) {
            return null;
        }
        try {
            parameters.init(new ECGenParameterSpec(name));
            return parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException ipse) {
            if (debug != null) {
                debug.println("Invalid parameter specification: " + ipse);
            }
            return null;
        }
    }

    public static ECParameterSpec getECParameterSpec(Provider p, int keySize) {
        AlgorithmParameters parameters = ECUtil.getECParameters(p);
        if (parameters == null) {
            return null;
        }
        try {
            parameters.init(new ECKeySizeParameterSpec(keySize));
            return parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (InvalidParameterSpecException ipse) {
            if (debug != null) {
                debug.println("Invalid parameter specification: " + ipse);
            }
            return null;
        }
    }

    public static String getCurveName(Provider p, ECParameterSpec spec) {
        ECGenParameterSpec nameSpec;
        AlgorithmParameters parameters = ECUtil.getECParameters(p);
        if (parameters == null) {
            return null;
        }
        try {
            parameters.init(spec);
            nameSpec = parameters.getParameterSpec(ECGenParameterSpec.class);
        }
        catch (InvalidParameterSpecException ipse) {
            if (debug != null) {
                debug.println("Invalid parameter specification: " + ipse);
            }
            return null;
        }
        if (nameSpec == null) {
            return null;
        }
        return nameSpec.getName();
    }

    private ECUtil() {
    }
}

