/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BerDecoder;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.naming.CommunicationException;

final class LdapRequest {
    private static final BerDecoder EOF = new BerDecoder(new byte[0], -1, 0);
    LdapRequest next;
    final int msgId;
    private final BlockingQueue<BerDecoder> replies;
    private volatile boolean cancelled;
    private volatile boolean closed;
    private volatile boolean completed;
    private final boolean pauseAfterReceipt;

    LdapRequest(int msgId, boolean pause, int replyQueueCapacity) {
        this.msgId = msgId;
        this.pauseAfterReceipt = pause;
        this.replies = replyQueueCapacity == -1 ? new LinkedBlockingQueue<BerDecoder>() : new LinkedBlockingQueue<BerDecoder>(8 * replyQueueCapacity / 10);
    }

    void cancel() {
        this.cancelled = true;
        this.replies.offer(EOF);
    }

    synchronized void close() {
        this.closed = true;
        this.replies.offer(EOF);
    }

    private boolean isClosed() {
        return this.closed && (this.replies.size() == 0 || this.replies.peek() == EOF);
    }

    synchronized boolean addReplyBer(BerDecoder ber) {
        if (this.cancelled || this.closed) {
            return false;
        }
        try {
            ber.parseSeq(null);
            ber.parseInt();
            this.completed = ber.peekByte() == 101;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ber.reset();
        try {
            this.replies.put(ber);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.pauseAfterReceipt;
    }

    BerDecoder getReplyBer(long millis) throws CommunicationException, InterruptedException {
        BerDecoder result;
        if (this.cancelled) {
            throw new CommunicationException("Request: " + this.msgId + " cancelled");
        }
        if (this.isClosed()) {
            return null;
        }
        BerDecoder berDecoder = result = millis > 0L ? this.replies.poll(millis, TimeUnit.MILLISECONDS) : this.replies.take();
        if (this.cancelled) {
            throw new CommunicationException("Request: " + this.msgId + " cancelled");
        }
        return result == EOF ? null : result;
    }

    boolean hasSearchCompleted() {
        return this.completed;
    }
}

