/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Vector;
import javax.sql.rowset.RowSetWarning;
import javax.sql.rowset.serial.SerialException;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;
import sun.reflect.misc.ReflectUtil;

public class SerialJavaObject
implements Serializable,
Cloneable {
    private Object obj;
    private transient Field[] fields;
    static final long serialVersionUID = -1465795139032831023L;
    Vector<RowSetWarning> chain;

    public SerialJavaObject(Object obj) throws SerialException {
        Class<?> c = obj.getClass();
        if (!(obj instanceof Serializable)) {
            this.setWarning(new RowSetWarning("Warning, the object passed to the constructor does not implement Serializable"));
        }
        this.fields = c.getFields();
        if (SerialJavaObject.hasStaticFields(this.fields)) {
            throw new SerialException("Located static fields in object instance. Cannot serialize");
        }
        this.obj = obj;
    }

    public Object getObject() throws SerialException {
        return this.obj;
    }

    @CallerSensitive
    public Field[] getFields() throws SerialException {
        if (this.fields != null) {
            Class<?> caller;
            Class<?> c = this.obj.getClass();
            SecurityManager sm = System.getSecurityManager();
            if (sm != null && ReflectUtil.needsPackageAccessCheck((caller = Reflection.getCallerClass()).getClassLoader(), c.getClassLoader())) {
                ReflectUtil.checkPackageAccess(c);
            }
            return c.getFields();
        }
        throw new SerialException("SerialJavaObject does not contain a serialized object instance");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SerialJavaObject) {
            SerialJavaObject sjo = (SerialJavaObject)o;
            return this.obj.equals(sjo.obj);
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.obj.hashCode();
    }

    public Object clone() {
        try {
            SerialJavaObject sjo = (SerialJavaObject)super.clone();
            sjo.fields = Arrays.copyOf(this.fields, this.fields.length);
            if (this.chain != null) {
                sjo.chain = new Vector<RowSetWarning>(this.chain);
            }
            return sjo;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    private void setWarning(RowSetWarning e) {
        if (this.chain == null) {
            this.chain = new Vector();
        }
        this.chain.add(e);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields1 = s.readFields();
        Vector tmp = (Vector)fields1.get("chain", null);
        if (tmp != null) {
            this.chain = new Vector(tmp);
        }
        this.obj = fields1.get("obj", null);
        if (this.obj != null) {
            this.fields = this.obj.getClass().getFields();
            if (SerialJavaObject.hasStaticFields(this.fields)) {
                throw new IOException("Located static fields in object instance. Cannot serialize");
            }
        } else {
            throw new IOException("Object cannot be null!");
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put("obj", this.obj);
        fields.put("chain", this.chain);
        s.writeFields();
    }

    private static boolean hasStaticFields(Field[] fields) {
        for (Field field : fields) {
            if (field.getModifiers() != 8) continue;
            return true;
        }
        return false;
    }
}

