/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import javax.security.auth.DestroyFailedException;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.krb5.Krb5CredElement;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.krb5.Krb5Util;
import sun.security.jgss.krb5.ServiceCreds;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.PrincipalName;

public class Krb5AcceptCredential
implements Krb5CredElement {
    private final Krb5NameElement name;
    private final ServiceCreds screds;

    private Krb5AcceptCredential(Krb5NameElement name, ServiceCreds creds) {
        this.name = name;
        this.screds = creds;
    }

    static Krb5AcceptCredential getInstance(final GSSCaller caller, Krb5NameElement name) throws GSSException {
        String fullName;
        final String serverPrinc = name == null ? null : name.getKrb5PrincipalName().getName();
        final AccessControlContext acc = AccessController.getContext();
        ServiceCreds creds = null;
        try {
            creds = AccessController.doPrivileged(new PrivilegedExceptionAction<ServiceCreds>(){

                @Override
                public ServiceCreds run() throws Exception {
                    return Krb5Util.getServiceCreds(caller == GSSCaller.CALLER_UNKNOWN ? GSSCaller.CALLER_ACCEPT : caller, serverPrinc, acc);
                }
            });
        }
        catch (PrivilegedActionException e) {
            GSSException ge = new GSSException(13, -1, "Attempt to obtain new ACCEPT credentials failed!");
            ge.initCause(e.getException());
            throw ge;
        }
        if (creds == null) {
            throw new GSSException(13, -1, "Failed to find any Kerberos credentails");
        }
        if (name == null && (fullName = creds.getName()) != null) {
            name = Krb5NameElement.getInstance(fullName, Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
        }
        return new Krb5AcceptCredential(name, creds);
    }

    @Override
    public final GSSNameSpi getName() throws GSSException {
        return this.name;
    }

    @Override
    public int getInitLifetime() throws GSSException {
        return 0;
    }

    @Override
    public int getAcceptLifetime() throws GSSException {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isInitiatorCredential() throws GSSException {
        return false;
    }

    @Override
    public boolean isAcceptorCredential() throws GSSException {
        return true;
    }

    @Override
    public final Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    @Override
    public final Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }

    public EncryptionKey[] getKrb5EncryptionKeys(PrincipalName princ) {
        return this.screds.getEKeys(princ);
    }

    @Override
    public void dispose() throws GSSException {
        try {
            this.destroy();
        }
        catch (DestroyFailedException e) {
            GSSException gssException = new GSSException(11, -1, "Could not destroy credentials - " + e.getMessage());
            gssException.initCause(e);
        }
    }

    public void destroy() throws DestroyFailedException {
        this.screds.destroy();
    }

    @Override
    public GSSCredentialSpi impersonate(GSSNameSpi name) throws GSSException {
        Credentials cred = this.screds.getInitCred();
        if (cred != null) {
            return Krb5InitCredential.getInstance(this.name, cred).impersonate(name);
        }
        throw new GSSException(11, -1, "Only an initiate credentials can impersonate");
    }
}

