/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.security.AccessController;
import java.util.LinkedList;
import sun.security.action.GetBooleanAction;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class Realm
implements Cloneable {
    public static final boolean AUTODEDUCEREALM = AccessController.doPrivileged(new GetBooleanAction("sun.security.krb5.autodeducerealm"));
    private final String realm;

    public Realm(String name) throws RealmException {
        this.realm = Realm.parseRealm(name);
    }

    public static Realm getDefault() throws RealmException {
        try {
            return new Realm(Config.getInstance().getDefaultRealm());
        }
        catch (RealmException re) {
            throw re;
        }
        catch (KrbException ke) {
            throw new RealmException(ke);
        }
    }

    public Object clone() {
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Realm)) {
            return false;
        }
        Realm that = (Realm)obj;
        return this.realm.equals(that.realm);
    }

    public int hashCode() {
        return this.realm.hashCode();
    }

    public Realm(DerValue encoding) throws Asn1Exception, RealmException, IOException {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding can not be null");
        }
        this.realm = new KerberosString(encoding).toString();
        if (this.realm == null || this.realm.length() == 0) {
            throw new RealmException(601);
        }
        if (!Realm.isValidRealmString(this.realm)) {
            throw new RealmException(600);
        }
    }

    public String toString() {
        return this.realm;
    }

    public static String parseRealmAtSeparator(String name) throws RealmException {
        if (name == null) {
            throw new IllegalArgumentException("null input name is not allowed");
        }
        String temp = new String(name);
        String result = null;
        for (int i = 0; i < temp.length(); ++i) {
            if (temp.charAt(i) != '@' || i != 0 && temp.charAt(i - 1) == '\\') continue;
            if (i + 1 < temp.length()) {
                result = temp.substring(i + 1, temp.length());
                break;
            }
            throw new IllegalArgumentException("empty realm part not allowed");
        }
        if (result != null) {
            if (result.length() == 0) {
                throw new RealmException(601);
            }
            if (!Realm.isValidRealmString(result)) {
                throw new RealmException(600);
            }
        }
        return result;
    }

    public static String parseRealmComponent(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null input name is not allowed");
        }
        String temp = new String(name);
        String result = null;
        for (int i = 0; i < temp.length(); ++i) {
            if (temp.charAt(i) != '.' || i != 0 && temp.charAt(i - 1) == '\\') continue;
            if (i + 1 >= temp.length()) break;
            result = temp.substring(i + 1, temp.length());
            break;
        }
        return result;
    }

    protected static String parseRealm(String name) throws RealmException {
        String result = Realm.parseRealmAtSeparator(name);
        if (result == null) {
            result = name;
        }
        if (result == null || result.length() == 0) {
            throw new RealmException(601);
        }
        if (!Realm.isValidRealmString(result)) {
            throw new RealmException(600);
        }
        return result;
    }

    protected static boolean isValidRealmString(String name) {
        if (name == null) {
            return false;
        }
        if (name.length() == 0) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '/' && name.charAt(i) != '\u0000') continue;
            return false;
        }
        return true;
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream out = new DerOutputStream();
        out.putDerValue(new KerberosString(this.realm).toDerValue());
        return out.toByteArray();
    }

    public static Realm parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException, RealmException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new Realm(subDer);
    }

    public static String[] getRealmsList(String cRealm, String sRealm) {
        try {
            return Realm.parseCapaths(cRealm, sRealm);
        }
        catch (KrbException ke) {
            return Realm.parseHierarchy(cRealm, sRealm);
        }
    }

    private static String[] parseCapaths(String cRealm, String sRealm) throws KrbException {
        String value;
        Config cfg = Config.getInstance();
        if (!cfg.exists("capaths", cRealm, sRealm)) {
            throw new KrbException("No conf");
        }
        LinkedList<String> path = new LinkedList<String>();
        String head = sRealm;
        while ((value = cfg.getAll("capaths", cRealm, head)) != null) {
            String[] more = value.split("\\s+");
            boolean changed = false;
            for (int i = more.length - 1; i >= 0; --i) {
                if (path.contains(more[i]) || more[i].equals(".") || more[i].equals(cRealm) || more[i].equals(sRealm) || more[i].equals(head)) continue;
                changed = true;
                path.addFirst(more[i]);
            }
            if (!changed) break;
            head = (String)path.getFirst();
        }
        path.addFirst(cRealm);
        return path.toArray(new String[path.size()]);
    }

    private static String[] parseHierarchy(String cRealm, String sRealm) {
        int i;
        String[] cComponents = cRealm.split("\\.");
        String[] sComponents = sRealm.split("\\.");
        int cPos = cComponents.length;
        int sPos = sComponents.length;
        boolean hasCommon = false;
        --sPos;
        --cPos;
        while (sPos >= 0 && cPos >= 0 && sComponents[sPos].equals(cComponents[cPos])) {
            hasCommon = true;
            --sPos;
            --cPos;
        }
        LinkedList<String> path = new LinkedList<String>();
        for (i = 0; i <= cPos; ++i) {
            path.addLast(Realm.subStringFrom(cComponents, i));
        }
        if (hasCommon) {
            path.addLast(Realm.subStringFrom(cComponents, cPos + 1));
        }
        for (i = sPos; i >= 0; --i) {
            path.addLast(Realm.subStringFrom(sComponents, i));
        }
        path.removeLast();
        return path.toArray(new String[path.size()]);
    }

    private static String subStringFrom(String[] components, int from) {
        StringBuilder sb = new StringBuilder();
        for (int i = from; i < components.length; ++i) {
            if (sb.length() != 0) {
                sb.append('.');
            }
            sb.append(components[i]);
        }
        return sb.toString();
    }
}

