/*
 * Decompiled with CFR 0.152.
 */
package sun.util.resources;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicMarkableReference;
import sun.util.resources.OpenListResourceBundle;

public abstract class ParallelListResourceBundle
extends ResourceBundle {
    private volatile ConcurrentMap<String, Object> lookup;
    private volatile Set<String> keyset;
    private final AtomicMarkableReference<Object[][]> parallelContents = new AtomicMarkableReference<Object>(null, false);

    protected ParallelListResourceBundle() {
    }

    protected abstract Object[][] getContents();

    ResourceBundle getParent() {
        return this.parent;
    }

    public void setParallelContents(OpenListResourceBundle rb) {
        if (rb == null) {
            this.parallelContents.compareAndSet(null, null, false, true);
        } else {
            this.parallelContents.compareAndSet(null, rb.getContents(), false, false);
        }
    }

    boolean areParallelContentsComplete() {
        if (this.parallelContents.isMarked()) {
            return true;
        }
        boolean[] done = new boolean[1];
        Object[][] data = this.parallelContents.get(done);
        return data != null || done[0];
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        this.loadLookupTablesIfNecessary();
        return this.lookup.get(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.keySet());
    }

    @Override
    public boolean containsKey(String key) {
        return this.keySet().contains(key);
    }

    @Override
    protected Set<String> handleKeySet() {
        this.loadLookupTablesIfNecessary();
        return this.lookup.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> keySet() {
        KeySet ks;
        while ((ks = this.keyset) == null) {
            ks = new KeySet(this.handleKeySet(), this.parent);
            ParallelListResourceBundle parallelListResourceBundle = this;
            synchronized (parallelListResourceBundle) {
                if (this.keyset == null) {
                    this.keyset = ks;
                }
            }
        }
        return ks;
    }

    synchronized void resetKeySet() {
        this.keyset = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadLookupTablesIfNecessary() {
        Object[][] data;
        ConcurrentMap<String, Object> map = this.lookup;
        if (map == null) {
            map = new ConcurrentHashMap<String, Object>();
            for (Object[] item : this.getContents()) {
                map.put((String)item[0], item[1]);
            }
        }
        if ((data = this.parallelContents.getReference()) != null) {
            for (Object[] item : data) {
                map.putIfAbsent((String)item[0], item[1]);
            }
            this.parallelContents.set(null, true);
        }
        if (this.lookup == null) {
            ParallelListResourceBundle parallelListResourceBundle = this;
            synchronized (parallelListResourceBundle) {
                if (this.lookup == null) {
                    this.lookup = map;
                }
            }
        }
    }

    private static class KeySet
    extends AbstractSet<String> {
        private final Set<String> set;
        private final ResourceBundle parent;

        private KeySet(Set<String> set, ResourceBundle parent) {
            this.set = set;
            this.parent = parent;
        }

        @Override
        public boolean contains(Object o) {
            if (this.set.contains(o)) {
                return true;
            }
            return this.parent != null ? this.parent.containsKey((String)o) : false;
        }

        @Override
        public Iterator<String> iterator() {
            if (this.parent == null) {
                return this.set.iterator();
            }
            return new Iterator<String>(){
                private Iterator<String> itr;
                private boolean usingParent;
                {
                    this.itr = set.iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.itr.hasNext()) {
                        return true;
                    }
                    if (!this.usingParent) {
                        HashSet<String> nextset = new HashSet<String>(parent.keySet());
                        nextset.removeAll(set);
                        this.itr = nextset.iterator();
                        this.usingParent = true;
                    }
                    return this.itr.hasNext();
                }

                @Override
                public String next() {
                    if (this.hasNext()) {
                        return this.itr.next();
                    }
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            if (this.parent == null) {
                return this.set.size();
            }
            HashSet<String> allset = new HashSet<String>(this.set);
            allset.addAll(this.parent.keySet());
            return allset.size();
        }
    }
}

