package com.gbasedbt.mpdemo;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.gbasedbt.mpdemo.entity.User;
import com.gbasedbt.mpdemo.mapper.UserMapper;
import org.junit.jupiter.api.Test;
import org.springframework.boot.test.context.SpringBootTest;
import org.junit.Assert;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

@SpringBootTest
public class SampleTest {

    @Resource
    private UserMapper userMapper;

    @Test
    public void testSelect() {
        System.out.println("----- selectAll method test ------");
        List<User> userList = userMapper.selectList(null);
        Assert.assertEquals(99, userList.size());
        userList.forEach(System.out::println);
    }

    @Test
    public void testUpdate() {
        System.out.println("----- update row ------");
        User user = new User();
        user.setId(5L);
        user.setUpdatetime(LocalDateTime.now());
        userMapper.updateById(user);
    }

    @Test
    public void testPageSelect() {
        System.out.println("----- select Page -----");
        IPage<User> userIPage = userMapper.selectPage(new Page<>(3, 2), null);
        System.out.println(userIPage.toString());
    }

    @Test
    public void testPageUser() {
        System.out.println("------ page with where ----");
        IPage<User> userIPage = userMapper.queryUsers(12, new Page<>(-5, 5));
        System.out.println(userIPage.toString());
    }

}
