#****************************************************************************
# *
# *                               IBM INC.
# *
# *                           PROPRIETARY DATA
# *
# * Licensed Material - Property Of IBM
# *
# * "Restricted Materials of IBM"
# *
# * IBM Informix Client SDK
# *
# * (c)  Copyright IBM Corporation 2002. All rights reserved.
# *
# ****************************************************************************
# */

@echo off
rem This batch file is for renaming Informix ClientSDK component
rem c++ directories to cpp and vice versa under incl, lib and demo

rem This batch file should be run under %INFORMIXDIR%\bin directory

rem check if both c++ and cpp directories under lib, incl and demo
rem if both exist then report error and exit

rem Rename c++ or cpp directory under %INFORMIXDIR%\lib
cd ..
goto renlibdir

:renlibdir
cd lib
echo Renaming directory under %INFORMIXDIR%\lib
if exist c++\nul goto renlibc++dir
if exist cpp\nul goto renlibcppdir

:renlibc++dir
echo Renaming %INFORMIXDIR%\lib\c++ as %INFORMIXDIR%\lib\cpp
rename c++ cpp
goto incl

:renlibcppdir
echo Renaming %INFORMIXDIR%\lib\cpp as %INFORMIXDIR%\lib\c++
rename cpp c++
goto incl

:incl
rem Rename c++ or cpp directory under %INFORMIXDIR%\incl
cd ..
goto renincldir

:renincldir
cd incl
echo Renaming directory under %INFORMIXDIR%\incl
if exist c++\nul goto reninclc++dir
if exist cpp\nul goto reninclcppdir

:reninclc++dir
echo Renaming %INFORMIXDIR%\incl\c++ as %INFORMIXDIR%\incl\cpp
rename c++ cpp
goto demo

:reninclcppdir
echo Renaming %INFORMIXDIR%\incl\cpp as %INFORMIXDIR%\incl\c++
rename cpp c++
goto demo

:demo
rem Rename c++ or cpp directory under %INFORMIXDIR%\demo
cd ..
goto rendemodir

:rendemodir
cd demo
echo Renaming directory under %INFORMIXDIR%\demo
if exist c++\nul goto rendemoc++dir
if exist cpp\nul goto rendemocppdir

:rendemoc++dir
echo Renaming %INFORMIXDIR%\demo\c++ as %INFORMIXDIR%\demo\cpp
rename c++ cpp
goto end

:rendemocppdir
echo Renaming %INFORMIXDIR%\demo\cpp as %INFORMIXDIR%\demo\c++
rename cpp c++
goto end

:end
cd ..
cd bin
echo Successfully terminating batch program
pause
