/****************************************************************************
 *
 * Licensed Material - Property Of GBase
 *
 * "Restricted Materials of GBase"
 *
 * GBase Client SDK
 * Copyright GBASE  1997, 2008. All rights reserved.
 *
 *  Title:       sqlca.h
 *  Description: SQL Control Area
 *
 ***************************************************************************
 */

#ifndef SQLCA_INCL
#define SQLCA_INCL

#include "ifxtypes.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct sqlca_s
    {
    int4 sqlcode;
#ifdef DB2CLI
    char sqlerrm[600]; /* error message parameters */
#else /* DB2CLI */
    char sqlerrm[72]; /* error message parameters */
#endif /* DB2CLI */
    char sqlerrp[8];
    int4 sqlerrd[6];
		    /* 0 - estimated number of rows returned */
		    /* 1 - serial value after insert or  ISAM error code */
		    /* 2 - number of rows processed */
		    /* 3 - estimated cost */
		    /* 4 - offset of the error into the SQL statement */
		    /* 5 - rowid after insert  */
#ifdef _FGL_
    char sqlawarn[8];
#else
    struct sqlcaw_s
	{
	char sqlwarn0; /* = W if any of sqlwarn[1-7] = W */
	char sqlwarn1; /* = W if any truncation occurred or
				database has transactions or
			        no privileges revoked */
	char sqlwarn2; /* = W if a null value returned or
				ANSI database */
	char sqlwarn3; /* = W if no. in select list != no. in into list or
				turbo backend or no privileges granted */
	char sqlwarn4; /* = W if no where clause on prepared update, delete or
				incompatible float format */
	char sqlwarn5; /* = W if non-ANSI statement */
	char sqlwarn6; /* = W if server is in data replication secondary mode */
	char sqlwarn7; /* = W if database locale is different from proc_locale
                          = W if backend XPS and if explain avoid_execute is set
                              (for select, insert, delete and update only)
			*/
	} sqlwarn;
#endif
    } ifx_sqlca_t;

/* NOTE: 4gl assumes that the sqlwarn structure can be defined as
 *	sqlawarn -- an 8 character string, because single-char
 *	variables are not recognized in 4gl.
 *
 * If this structure should change, the code generated by 4gl compiler
 *	must also change
 */

#define SQLNOTFOUND 100

#ifndef IFX_THREAD
#ifdef DB2CLI
#define sqlca ifmxsqlca
extern struct sqlca_s sqlca;
#else /* DB2CLI */
extern struct sqlca_s sqlca;
#endif /* DB2CLI */

#ifndef DRDAHELP
extern int4 SQLCODE;
#endif

extern char SQLSTATE[];
#else /* IFX_THREAD */
extern int4 * ifx_sqlcode(void);
extern struct sqlca_s * ifx_sqlca(void);
/* ifx_sqlstate() declared in sqlhdr.h */
#define SQLCODE (*(ifx_sqlcode()))
#define SQLSTATE ((char *)(ifx_sqlstate()))
#define sqlca (*(ifx_sqlca()))
#endif /* IFX_THREAD */

#ifdef __cplusplus
}
#endif

#endif /* SQLCA_INCL */

