/****************************************************************************
 *
 *                               GBase.
 *
 *                           PROPRIETARY DATA
 *
 * Licensed Material - Property Of GBase
 *
 * "Restricted Materials of GBase"
 *
 * GBase Client SDK
 *
 * (c)  Copyright GBASE  2002. All rights reserved.
 *
 *  Title:	varchar.h
 *  Description:
 *		header file for varying length character data type
 *
 ***************************************************************************
 */
#ifndef VARCHAR_H_INCLUDED
#define VARCHAR_H_INCLUDED

#define ldvc(p) ((int4)(((p)[0]<<8)+((p)[1]&0xFF)))
#define stvc(i,p) ((p)[0]=(char)((i)>>8),\
                 (p)[1]=(char)(i))

/*
 * VARCHAR macros
 */

#define VCOFFSET        (2)
#define MAXVCLEN		(32767)
#define VCLENGTH(len)		(VCMAX(len)+VCOFFSET)
#define VCMIN(size)		(((size) >> 16) & 0x7FFF)
#define VCMAX(size)		((size) & 0x7FFF)
#define VCSIZ(max, min)		((((min) << 16) & 0x7FFF0000) + ((max) & 0x7FFF))

#endif /* VARCHAR_H_INCLUDED */
