#!/bin/bash
# filename: getLockTab.sh
# function: get sessions for table which locked.
# write by: liaosnet@gbasedbt.com  2022-03-15

if [ ! $# -eq 2 ]; then
  cat << EOF 2>/dev/null

  Usage: getLockTab.sh DBNAME TABNAME
  
EOF
  exit 1
fi

DBNAME=$(echo $1 | tr '[A-Z]' '[a-z]')
TABNAME=$(echo $2 | tr '[A-Z]' '[a-z]')

SESID=$(dbaccess sysmaster - << !SQL 2>/dev/null
set isolation to dirty read;
select owner as sesid
from syslocks
where dbsname = '${DBNAME}'
  and tabname = '${TABNAME}'
  group by owner;
!SQL
)

echo $SESID

exit 0
