#!/bin/bash

OPT=$#
if [ $OPT -lt 1 -o $OPT -gt 2 ]; then
  cat <<!

  Usage: dbcomm dbname [tabname]

!
  exit 1
fi

DBNAME=$1
TABNAME=$2

dbaccess ${DBNAME} - <<! >/dev/null 2>&1
select 1 from dual;
!
if [ ! $? -eq 0 ]; then
  cat <<!

  Database: ${DBNAME} not found or no connect permission.

!
  exit 2
fi

if [ $OPT -eq 1 ]; then
  # do all
  dbaccess ${DBNAME} - <<! 2>/dev/null
  -- tabcomm, delimiter '\t' (ctrl + i)
  unload to _tmp_table_comment.unl delimiter '	'
  select 'comment on table ' || tabname || ' is ''' || replace(comments, chr(39), '''''') || ''';' as comment from syscomments;
  -- colcomm, delimiter '\t' (ctrl + i)
  unload to _tmp_column_comment.unl delimiter '	'
  select 'comment on column ' || tabname || '.' || colname || ' is ''' || replace(comments, chr(39), '''''') || ''';' as comment 
  from syscolcomments;
!
else
  # do only $TABNAME
  if [ x"${DELIMIDENT:-x}" = xx ]; then
    TABNAME=$(echo $TABNAME | tr [A-Z] [a-z])
  fi
  dbaccess ${DBNAME} - <<! 2>/dev/null
  -- tabcomm, delimiter '\t' (ctrl + i)
  unload to _tmp_table_comment.unl delimiter '	'
  select 'comment on table ' || tabname || ' is ''' || replace(comments, chr(39), '''''') || ''';' as comment
  from syscomments
  where tabname = "${TABNAME}";
  -- colcomm, delimiter '\t' (ctrl + i)
  unload to _tmp_column_comment.unl delimiter '	'
  select 'comment on column ' || tabname || '.' || colname || ' is ''' || replace(comments, chr(39), '''''') || ''';' as comment
  from syscolcomments
  where tabname = "${TABNAME}";
!
fi

if [ -f _tmp_table_comment.unl ]; then
  cat _tmp_table_comment.unl
  rm -f _tmp_table_comment.unl
fi

if [ -f _tmp_column_comment.unl ]; then
  cat _tmp_column_comment.unl
  rm -f _tmp_column_comment.unl
fi

exit 0
