#!/bin/bash
##################################################################
# Filename: CheckEnv.sh
# Function: Check Environment for GBase 8s install.
# Write by: liaosnet@gbasedbt.com
# Version : 1.4.12   update date: 2025-04-16
##################################################################
##### Defind env
export LANG=C
_loginfo(){
  echo -e "[$(date +'%Y-%m-%d %H:%M:%S')] $*"
}

# ping CNNIC SDNS
ping -c 5 1.2.4.8
PINGOK=$?
##### yum install 
if [ ${PINGOK} -eq 0 -a -x /usr/bin/yum ]; then
  _loginfo "Try to execute yum install.."
  yum -y install unzip tar java-1.8.0-openjdk glibc-devel ncurses-libs ncurses-compat-libs libnsl libaio
elif [ ${PINGOK} -eq 0 -a -x /usr/bin/apt ]; then
  _loginfo "Try to execute apt install.."
  apt -y install unzip tar openjdk-8-jdk glibc-tools libncurses-dev libncurses5-dev libnsl-dev libaio-dev
fi

##### Tool Check
TOOLS="tar timeout unzip"
QPATH="/usr/bin /usr/sbin /bin /sbin"
for TOOL in $TOOLS
do
  FIND=""
  for QP in $QPATH
  do
    FIND=$(cd $QP && find . -name $TOOL)
    if [ ! x"${FIND}" = x ];then
      break;
    fi
  done
  if [ x"${FIND}" = x ];then
    _loginfo "$TOOL not found."
    exit 1
  fi
done

##### Lib Check
ARCH=$(lscpu | awk '/Architecture:/{print $2}')
LIBS="libc.so.6 libm.so.6 libnsl.so.1 libncurses.so.5 libtinfo.so.5"
QPATH=""

case $ARCH in 
  x86_64)
    # libs in /usr/lib64 (CentOS), or in /lib/x86_64-linux-gnu (Ubuntu 18.04)
    QPATH="/usr/lib64 /usr/lib /lib64 /lib"
    ;;
  aarch64)
    # libs in /lib/aarch64-linux-gnu
    QPATH="/lib /lib64 /usr/lib /usr/lib64"
    ;;
  *)
    QPATH="/lib64 /lib"
    ;;
esac

for LIB in $LIBS
do
  FIND=""
  for QP in $QPATH
  do
    if [ -d $QP ]; then
      FIND=$(cd $QP && find . -name $LIB)
    fi
    if [ ! x"${FIND}" = x ];then
      break
    elif [ x"${FIND}" = x -a x"${LIB}" = xlibncurses.so.5 ]; then
      L5FIND=$(cd $QP && find . -name "libncurses.so.6")
      if [ ! x"${L5FIND}" = x ]; then
        L5PREFIX=${QP}/${L5FIND:0:-15}
        cd ${L5PREFIX}
        [ -f libncurses.so.6 ] && ln -s libncurses.so.6 libncurses.so.5
        [ -f libtinfo.so.6 ] && ln -s libtinfo.so.6 libtinfo.so.5
        FIND="1"
      fi
    fi
  done 
  if [ x"${FIND}" = x ];then
    _loginfo "$LIB not found."
    if [ "x${LIB}" = "xlibnsl.so.1" ]; then
      _loginfo "libnsl.so.1 missing, if install need JDK/JRE may failue !"
    else
      exit 1
    fi
  fi
done

##### hostname 
HOSTNAME=$(hostname)
HOST=$(grep -i ${HOSTNAME} /etc/hosts)
if [ x"${HOST}" = x ];then
  _loginfo "${HOSTNAME} not define in /etc/hosts, auto add it."
  echo "127.0.0.1 ${HOSTNAME}" >> /etc/hosts
fi

#### nsswitch.conf
if [ -f /etc/nsswitch.conf ]; then
  NSSWITCH=$(grep '^hosts:.*files$' /etc/nsswitch.conf | wc -l)
  if [ ${NSSWITCH:-0} -eq 0 ]; then
    _loginfo "Change nsswitch.conf 'hosts:'."
    sed -i "0,/^hosts:.*/s//hosts:	files\n#&/g" /etc/nsswitch.conf
  fi
fi

#### core sysctl
# sem  32000   1024000000      500     32000
# kernel.shmall kernel.shmmax kernel.shmmni
_loginfo "===== Print KERNEL INFO =============="
sysctl -a 2>/dev/null| egrep '(kernel.shmall|kernel.shmm|kernel.sem )'
_loginfo "===== Print KERNEL INFO END =========="

# unlimit
_loginfo "===== Print ULIMIT INFO =============="
ulimit -a 2>/dev/null| egrep '(^open|^max user)'
_loginfo "===== Print ULIMIT INFO END =========="

exit 0
