#!/bin/bash
##################################################################
# Filename: CleanAll.sh
# Function: Clean GBase 8s Auto Install.
# Write by: liaosnet@gbasedbt.com
# Version : 1.4.10   update date: 2024-06-28
##################################################################
##### Define Parameter
##### Get Parameter
while [[ $# -gt 0 ]]
do
  key="$1"
  case $key in
    -u)
        USER_NAME="$2";   shift 2
        ;;
    *)
        cat <<!
Usage:
    CleanAll.sh [-u user]

        -u user    The user name for SYSDBA, gbasedbt/informix, default is gbasedbt

!
        exit 1
        ;;
  esac
done

USER_NAME=${USER_NAME:-gbasedbt}
USER_UPPER=$(echo $USER_NAME|tr [a-z] [A-Z])
WORKDIR=$(pwd)

#### do clean
id ${USER_NAME} >/dev/null 2>&1
if [ $? -gt 0 ];then
    echo "User: ${USER_NAME} not exists!" 
    exit 2
fi

INSTALL_DIR=$(head -n 1 /${USER_UPPER}TMP/.infxdirs)

su - ${USER_NAME} -c "onmode -ky" 2>/dev/null
su - ${USER_NAME} -c "onclean -ky" 2>/dev/null
ps -ef | awk '/oninit/ && $3==1{print "kill -9 "$2}' | sh 2>/dev/null
userdel -rf ${USER_NAME} 2>/dev/null
groupdel ${USER_NAME} 2>/dev/null
id dbaao 2>/dev/null
if [ $? -eq 0 ]; then
  userdel -rf dbaao 2>/dev/null
  groupdel dbaao 2>/dev/null
fi
id dbsso 2>/dev/null
if [ $? -eq 0 ]; then
  userdel -rf dbsso 2>/dev/null
  groupdel dbsso 2>/dev/null
fi

if [ -d "$INSTALL_DIR" -a ! x$INSTALL_DIR = x/ ]; then
  read -p "Drop directory [$INSTALL_DIR]? [Y/N] " ISDROP 
  if [ x"${ISDROP}" = x"Y" -o x"${ISDROP}" = x"y" ];then 
    rm -rf ${INSTALL_DIR} 2>/dev/null
  else
    echo "Directory [$INSTALL_DIR] not clean."
  fi
fi

if [ -d ${WORKDIR}/install ]; then
  rm -rf ${WORKDIR}/install 2>/dev/null
fi

exit 0
