/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.migration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

class DBConn {
    DBConn() {
    }

    static Connection getConn(String db, String cfg) {
        File file = DBConn.getCfgFile(cfg);
        Properties properties = new Properties();
        FileInputStream inputStream = null;
        Connection connection = null;
        String classname = null;
        String url = null;
        String user = null;
        String pass = null;
        db = "src".equalsIgnoreCase(db) ? "src" : "tgt";
        try {
            inputStream = new FileInputStream(file.toString());
            properties.load(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        classname = properties.getProperty(db + ".db.class");
        url = properties.getProperty(db + ".db.url");
        user = properties.getProperty(db + ".db.user");
        pass = properties.getProperty(db + ".db.pass");
        try {
            Class.forName(classname).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        if ("".equals(user) || user == null) {
            try {
                connection = DriverManager.getConnection(url);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            try {
                connection = DriverManager.getConnection(url, user, pass);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return connection;
    }

    static File getCfgFile(String cfg) {
        String path = null;
        if (cfg == null || "".equals(cfg)) {
            path = System.getProperty("user.dir");
            return new File(path + "/db.properties");
        }
        return new File(cfg);
    }
}

