/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.migration;

import com.gbasedbt.migration.DBConn;
import com.gbasedbt.migration.TabSchema;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class TabMigration {
    public static void main(String[] args) throws Exception {
        int i;
        String cfgfile = System.getProperty("cfgfile");
        Properties properties = new Properties();
        File file = DBConn.getCfgFile(cfgfile);
        FileInputStream inputStream = null;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        Statement statement = null;
        ResultSet resultSet = null;
        String sqlstr = null;
        String sqlout = null;
        String source = null;
        String target = null;
        List<Object> list_source = new ArrayList();
        List<Object> list_target = new ArrayList();
        long numcommit = 0L;
        long starttime = 0L;
        long finishtime = 0L;
        inputStream = new FileInputStream(file.toString());
        properties.load(inputStream);
        source = properties.getProperty("src.db.tab").toLowerCase();
        target = properties.getProperty("tgt.db.tab").toLowerCase();
        connection = DBConn.getConn("tgt", cfgfile);
        if (!TabMigration.isTabExist(connection, source)) {
            System.out.println("\u6e90\u5e93\u4e2d [" + source + "] \u8868\u4e0d\u5b58\u5728\uff01");
            return;
        }
        if (!TabMigration.isTabExist(connection, target)) {
            System.out.println("\u76ee\u6807\u5e93\u4e2d [" + target + "] \u8868\u4e0d\u5b58\u5728\uff01");
            return;
        }
        list_source = TabMigration.getTabSchameList(connection, source);
        list_target = TabMigration.getTabSchameList(connection, target);
        System.out.println("\u6e90\u5e93\u8868\uff1a " + source + " \u7684\u6570\u636e\u7ed3\u6784\u5b9a\u4e49");
        for (i = 0; i < list_source.size(); ++i) {
            System.out.println(((TabSchema)list_source.get(i)).toString());
        }
        System.out.println("\u76ee\u6807\u5e93\u8868\uff1a " + target + " \u7684\u6570\u636e\u7ed3\u6784\u5b9a\u4e49");
        for (i = 0; i < list_target.size(); ++i) {
            System.out.println(((TabSchema)list_target.get(i)).toString());
        }
        if (list_source.size() != list_target.size()) {
            System.out.println("\u6e90\u5e93\u8868 \u548c \u76ee\u6807\u5e93\u8868 \u7684\u5b57\u6bb5\u6570\u91cf\u4e0d\u4e00\u81f4\uff01");
            return;
        }
        starttime = System.currentTimeMillis();
        System.out.println("[" + starttime + "] \u5f00\u59cb\u8fc1\u79fb ################");
        sqlout = " select * from " + source;
        statement = connection.createStatement();
        sqlstr = " insert into " + target + " values (";
        for (i = 1; i <= list_target.size(); ++i) {
            sqlstr = sqlstr + "?,";
        }
        sqlstr = sqlstr.substring(0, sqlstr.length() - 1) + ");";
        preparedStatement = connection.prepareStatement(sqlstr);
        resultSet = statement.executeQuery(sqlout);
        while (resultSet.next()) {
            block12: for (i = 0; i < list_target.size(); ++i) {
                String maptabtype;
                switch (maptabtype = ((TabSchema)list_target.get(i)).getMapcoltype()) {
                    case "String": {
                        preparedStatement.setString(i + 1, resultSet.getString(i + 1));
                        continue block12;
                    }
                    case "Bytes": {
                        preparedStatement.setBytes(i + 1, resultSet.getBytes(i + 1));
                        continue block12;
                    }
                    default: {
                        preparedStatement.setObject(i + 1, resultSet.getObject(i + 1));
                    }
                }
            }
            preparedStatement.addBatch();
            if (++numcommit % 1000L != 0L) continue;
            preparedStatement.executeBatch();
            preparedStatement.clearBatch();
            System.out.println("[" + System.currentTimeMillis() + "] \u5f53\u524d\u63d0\u4ea4\u884c\u6570 [ " + numcommit + " ] ");
        }
        preparedStatement.executeBatch();
        preparedStatement.clearBatch();
        finishtime = System.currentTimeMillis();
        System.out.println("[" + finishtime + "] \u5199\u5165\u5230\u8868\uff1a " + target + " \u7684\u884c\u6570 [ " + numcommit + " ]\uff0c\u7528\u65f6\uff1a " + (finishtime - starttime) + " \u6beb\u79d2\u3002");
        preparedStatement.close();
        statement.close();
        ((InputStream)inputStream).close();
        connection.close();
    }

    private static boolean isTabExist(Connection connection, String tabname) throws SQLException {
        boolean istabexist = false;
        int count = 0;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String sqlstr = "select count(*) as tabcount from systables where tabname = ?";
        preparedStatement = connection.prepareStatement(sqlstr);
        preparedStatement.setString(1, tabname);
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            count = resultSet.getInt(1);
        }
        if (count == 1) {
            istabexist = true;
        }
        return istabexist;
    }

    private static List<TabSchema> getTabSchameList(Connection connection, String tabname) throws SQLException {
        ArrayList<TabSchema> list = new ArrayList<TabSchema>();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        String sqlstr = "select c.colno,c.colname,c.coltypename as coltype\nfrom systables t, syscolumnsext c\nwhere t.tabid = c.tabid\nand t.tabname = ? \norder by c.colno;";
        preparedStatement = connection.prepareStatement(sqlstr);
        preparedStatement.setString(1, tabname);
        resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            TabSchema tabSchema = new TabSchema();
            tabSchema.insert(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), TabMigration.getMappingColtype(resultSet.getString(3)));
            list.add(tabSchema);
        }
        return list;
    }

    private static String getMappingColtype(String coltype) {
        String mapcoltype = null;
        switch (coltype = coltype.substring(0, 4).toUpperCase()) {
            case "CHAR": 
            case "VARC": 
            case "TEXT": 
            case "CLOB": 
            case "LVAR": 
            case "NVAR": 
            case "NCHA": {
                mapcoltype = "String";
                break;
            }
            case "BYTE": 
            case "BLOB": {
                mapcoltype = "Bytes";
                break;
            }
            default: {
                mapcoltype = "Object";
            }
        }
        return mapcoltype;
    }
}

