/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.crypto.provider;

import com.gbasedbt.crypto.provider.FeedbackCipher;
import com.gbasedbt.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;

final class CipherFeedback
extends FeedbackCipher {
    private final byte[] k;
    private final byte[] register;
    private int numBytes;
    private byte[] registerSave = null;

    CipherFeedback(SymmetricCipher symmetricCipher, int n) {
        super(symmetricCipher);
        if (n > this.blockSize) {
            n = this.blockSize;
        }
        this.numBytes = n;
        this.k = new byte[this.blockSize];
        this.register = new byte[this.blockSize];
    }

    @Override
    String getFeedback() {
        return "CFB";
    }

    @Override
    void init(boolean bl, String string, byte[] byArray, byte[] byArray2) throws InvalidKeyException {
        if (byArray == null || byArray2 == null || byArray2.length != this.blockSize) {
            throw new InvalidKeyException("Internal error");
        }
        this.iv = byArray2;
        this.reset();
        this.embeddedCipher.init(false, string, byArray);
    }

    @Override
    void reset() {
        System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
    }

    @Override
    void save() {
        if (this.registerSave == null) {
            this.registerSave = new byte[this.blockSize];
        }
        System.arraycopy(this.register, 0, this.registerSave, 0, this.blockSize);
    }

    @Override
    void restore() {
        System.arraycopy(this.registerSave, 0, this.register, 0, this.blockSize);
    }

    @Override
    void encrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        block8: {
            int n4;
            int n5;
            int n6;
            int n7;
            block7: {
                int n8;
                n7 = this.blockSize - this.numBytes;
                n6 = n2 % this.numBytes;
                if (n7 != 0) break block7;
                for (n5 = n2 / this.numBytes; n5 > 0; --n5) {
                    this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                    for (n8 = 0; n8 < this.blockSize; ++n8) {
                        byte by = (byte)(this.k[n8] ^ byArray[n8 + n]);
                        byArray2[n8 + n3] = by;
                        this.register[n8] = by;
                    }
                    n += this.numBytes;
                    n3 += this.numBytes;
                }
                if (n6 <= 0) break block8;
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                for (n8 = 0; n8 < n6; ++n8) {
                    byte by = (byte)(this.k[n8] ^ byArray[n8 + n]);
                    byArray2[n8 + n3] = by;
                    this.register[n8] = by;
                }
                break block8;
            }
            while (n5 > 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, n7);
                for (n4 = 0; n4 < this.numBytes; ++n4) {
                    byte by = (byte)(this.k[n4] ^ byArray[n4 + n]);
                    byArray2[n4 + n3] = by;
                    this.register[n4 + n7] = by;
                }
                n += this.numBytes;
                n3 += this.numBytes;
                --n5;
            }
            if (n6 != 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, n7);
                for (n4 = 0; n4 < n6; ++n4) {
                    byte by = (byte)(this.k[n4] ^ byArray[n4 + n]);
                    byArray2[n4 + n3] = by;
                    this.register[n4 + n7] = by;
                }
            }
        }
    }

    @Override
    void decrypt(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        block8: {
            int n4;
            int n5;
            int n6;
            int n7;
            block7: {
                int n8;
                n7 = this.blockSize - this.numBytes;
                n6 = n2 % this.numBytes;
                if (n7 != 0) break block7;
                for (n5 = n2 / this.numBytes; n5 > 0; --n5) {
                    this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                    for (n8 = 0; n8 < this.blockSize; ++n8) {
                        this.register[n8] = byArray[n8 + n];
                        byArray2[n8 + n3] = (byte)(byArray[n8 + n] ^ this.k[n8]);
                    }
                    n3 += this.numBytes;
                    n += this.numBytes;
                }
                if (n6 <= 0) break block8;
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                for (n8 = 0; n8 < n6; ++n8) {
                    this.register[n8] = byArray[n8 + n];
                    byArray2[n8 + n3] = (byte)(byArray[n8 + n] ^ this.k[n8]);
                }
                break block8;
            }
            while (n5 > 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, n7);
                for (n4 = 0; n4 < this.numBytes; ++n4) {
                    this.register[n4 + n7] = byArray[n4 + n];
                    byArray2[n4 + n3] = (byte)(byArray[n4 + n] ^ this.k[n4]);
                }
                n3 += this.numBytes;
                n += this.numBytes;
                --n5;
            }
            if (n6 != 0) {
                this.embeddedCipher.encryptBlock(this.register, 0, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, n7);
                for (n4 = 0; n4 < n6; ++n4) {
                    this.register[n4 + n7] = byArray[n4 + n];
                    byArray2[n4 + n3] = (byte)(byArray[n4 + n] ^ this.k[n4]);
                }
            }
        }
    }
}

