/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.crypto.provider;

import com.gbasedbt.crypto.provider.CipherBlockChaining;
import com.gbasedbt.crypto.provider.SymmetricCipher;
import javax.crypto.IllegalBlockSizeException;

final class CipherTextStealing
extends CipherBlockChaining {
    CipherTextStealing(SymmetricCipher symmetricCipher) {
        super(symmetricCipher);
    }

    @Override
    String getFeedback() {
        return "CTS";
    }

    @Override
    void encryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException {
        if (n2 < this.blockSize) {
            throw new IllegalBlockSizeException("input is too short!");
        }
        if (n2 == this.blockSize) {
            this.encrypt(byArray, n, n2, byArray2, n3);
        } else {
            int n4 = n2 % this.blockSize;
            if (n4 == 0) {
                this.encrypt(byArray, n, n2, byArray2, n3);
                int n5 = n3 + n2 - this.blockSize;
                int n6 = n5 - this.blockSize;
                byte[] byArray3 = new byte[this.blockSize];
                System.arraycopy(byArray2, n5, byArray3, 0, this.blockSize);
                System.arraycopy(byArray2, n6, byArray2, n5, this.blockSize);
                System.arraycopy(byArray3, 0, byArray2, n6, this.blockSize);
            } else {
                int n7 = n2 - (this.blockSize + n4);
                if (n7 > 0) {
                    this.encrypt(byArray, n, n7, byArray2, n3);
                    n += n7;
                    n3 += n7;
                }
                byte[] byArray4 = new byte[this.blockSize];
                for (int i = 0; i < this.blockSize; ++i) {
                    byArray4[i] = (byte)(byArray[n + i] ^ this.r[i]);
                }
                byte[] byArray5 = new byte[this.blockSize];
                this.embeddedCipher.encryptBlock(byArray4, 0, byArray5, 0);
                System.arraycopy(byArray5, 0, byArray2, n3 + this.blockSize, n4);
                for (int i = 0; i < n4; ++i) {
                    byArray5[i] = (byte)(byArray[n + this.blockSize + i] ^ byArray5[i]);
                }
                this.embeddedCipher.encryptBlock(byArray5, 0, byArray2, n3);
            }
        }
    }

    @Override
    void decryptFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws IllegalBlockSizeException {
        if (n2 < this.blockSize) {
            throw new IllegalBlockSizeException("input is too short!");
        }
        if (n2 == this.blockSize) {
            this.decrypt(byArray, n, n2, byArray2, n3);
        } else {
            int n4 = n2 % this.blockSize;
            if (n4 == 0) {
                int n5 = n + n2 - this.blockSize;
                int n6 = n + n2 - 2 * this.blockSize;
                byte[] byArray3 = new byte[2 * this.blockSize];
                System.arraycopy(byArray, n5, byArray3, 0, this.blockSize);
                System.arraycopy(byArray, n6, byArray3, this.blockSize, this.blockSize);
                int n7 = n2 - 2 * this.blockSize;
                this.decrypt(byArray, n, n7, byArray2, n3);
                this.decrypt(byArray3, 0, 2 * this.blockSize, byArray2, n3 + n7);
            } else {
                int n8;
                int n9 = n2 - (this.blockSize + n4);
                if (n9 > 0) {
                    this.decrypt(byArray, n, n9, byArray2, n3);
                    n += n9;
                    n3 += n9;
                }
                byte[] byArray4 = new byte[this.blockSize];
                this.embeddedCipher.decryptBlock(byArray, n, byArray4, 0);
                for (n8 = 0; n8 < n4; ++n8) {
                    byArray2[n3 + this.blockSize + n8] = (byte)(byArray[n + this.blockSize + n8] ^ byArray4[n8]);
                }
                System.arraycopy(byArray, n + this.blockSize, byArray4, 0, n4);
                this.embeddedCipher.decryptBlock(byArray4, 0, byArray2, n3);
                for (n8 = 0; n8 < this.blockSize; ++n8) {
                    byArray2[n3 + n8] = (byte)(byArray2[n3 + n8] ^ this.r[n8]);
                }
            }
        }
    }
}

