/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.sun.rowset.CachedRowSetImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Vector;

public class IfxCachedRowSetImpl
extends CachedRowSetImpl {
    private boolean lastValueNull;
    private Vector<Object> rvh;
    private int cursorPos;
    private int absolutePos;
    private int numDeleted;
    private int numRows;

    @Override
    public void close() throws SQLException {
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.numRows = 0;
        this.numDeleted = 0;
    }

    @Override
    public void release() throws SQLException {
        this.cursorPos = 0;
        this.absolutePos = 0;
        this.numRows = 0;
        this.numDeleted = 0;
        super.close();
    }

    private void checkIndex(int n) throws SQLException {
        if (n < 1 || n > super.getMetaData().getColumnCount()) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcol").toString());
        }
    }

    private void checkCursor() throws SQLException {
        if (this.isAfterLast() || this.isBeforeFirst()) {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.invalidcp").toString());
        }
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        this.checkIndex(n);
        this.checkCursor();
        if (this.isBinary(super.getMetaData().getColumnType(n))) {
            Object object = this.getCurrentRow().getColumnObject(n);
            if (object == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = new InputStreamReader(new ByteArrayInputStream((byte[])object));
        } else if (this.isString(super.getMetaData().getColumnType(n))) {
            Object object = this.getCurrentRow().getColumnObject(n);
            if (object == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = new StringReader(object.toString());
        } else if (this.isClob(super.getMetaData().getColumnType(n))) {
            Object object = this.getCurrentRow().getColumnObject(n);
            if (object == null) {
                this.lastValueNull = true;
                return null;
            }
            this.charStream = ((Clob)object).getCharacterStream();
        } else {
            throw new SQLException(this.resBundle.handleGetObject("cachedrowsetimpl.dtypemismt").toString());
        }
        return this.charStream;
    }

    private boolean isString(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private boolean isClob(int n) {
        switch (n) {
            case 2005: {
                return true;
            }
        }
        return false;
    }

    private boolean isBinary(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: {
                return true;
            }
        }
        return false;
    }

    private boolean isTemporal(int n) {
        switch (n) {
            case 91: 
            case 92: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    private boolean isBoolean(int n) {
        switch (n) {
            case -7: 
            case 16: {
                return true;
            }
        }
        return false;
    }
}

