/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxColumnInfo;
import com.gbasedbt.jdbc.IfxComplexInput;
import com.gbasedbt.jdbc.IfxComplexOutput;
import com.gbasedbt.jdbc.IfxDateTime;
import com.gbasedbt.jdbc.IfxDecimal;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.jdbc.IfxResultSetMetaData;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.lang.IfxTypes;
import com.gbasedbt.lang.JavaToIfxType;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.IfxMessage;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import com.gbasedbt.util.stringUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

public abstract class IfxComplex
extends IfxObject {
    protected IfxComplexInput inputStream;
    protected IfxComplexOutput outputStream;
    private short identsize = 0;
    private boolean allocateNewByteArray = true;
    protected static final int IFX_CT_NULL = Integer.MIN_VALUE;
    protected static final short CLROW_HDRSZ = 136;
    protected static final short CLROW_ROWSZ = 414;
    protected static final short OLDCLROW_HDRSZ = 26;
    protected static final short OLDCLROW_ROWSZ = 84;

    IfxComplex() throws SQLException {
    }

    @Override
    public void clear() {
        super.setExtendedTypeName("");
        super.setExtendedOwner("");
    }

    @Override
    public void fromIfx(byte[] byArray) throws SQLException {
        this.allocateNewByteArray = false;
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) throws SQLException {
        int n3;
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[2];
        int n4 = 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplex.fromIfx() called");
            this.trace.writeTrace(2, "   fromIfx() offset: " + n);
            this.trace.writeTrace(2, "   fromIfx() length: " + n2);
        }
        this.clear();
        this.setIdentSize();
        byte[] byArray4 = new byte[this.identsize];
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "fromIfx() typeMap: " + this.typeMap);
        }
        n += 4;
        n += 4;
        n += 2;
        System.arraycopy(byArray, n += this.identsize, byArray3, 0, 2);
        int n5 = IfxToJavaType.IfxToJavaSmallInt(byArray3);
        n += 2;
        IfxColumnInfo[] ifxColumnInfoArray = new IfxColumnInfo[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            ifxColumnInfoArray[n3] = new IfxColumnInfo();
        }
        for (n3 = 0; n3 < n5; ++n3) {
            String string;
            System.arraycopy(byArray, n += 2, byArray3, 0, 2);
            ifxColumnInfoArray[n3].Levelno = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            n += 2;
            System.arraycopy(byArray, n += 2, byArray3, 0, 2);
            short s = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            System.arraycopy(byArray, n += 2, byArray4, 0, this.identsize);
            try {
                string = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray4, ((IfxSqliConnect)this.conn).encoption);
            }
            catch (IOException iOException) {
                throw IfxErrMsg.getSQLException(-79716, this.conn);
            }
            ifxColumnInfoArray[n3].ColName = stringUtil.fixLength(string, s, '\u0000');
            n += this.identsize;
            System.arraycopy(byArray, n += 2, byArray3, 0, 2);
            short s2 = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            IfxResultSetMetaData.setTypeBooleanFields(ifxColumnInfoArray[n3], s2);
            n += 2;
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    ifxType: " + s2);
            }
            System.arraycopy(byArray, n, byArray3, 0, 2);
            ifxColumnInfoArray[n3].ColLength = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            n += 2;
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    length: " + ifxColumnInfoArray[n3].ColLength);
            }
            System.arraycopy(byArray, n, byArray2, 0, 4);
            ifxColumnInfoArray[n3].ExtendedId = IfxToJavaType.IfxToJavaInt(byArray2);
            n += 4;
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    xid: " + ifxColumnInfoArray[n3].ExtendedId);
            }
            System.arraycopy(byArray, n += 2, byArray3, 0, 2);
            s = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            n += 2;
            if (s > 0 && (!IfxTypes.isComplexType(ifxColumnInfoArray[n3].SQLtype) || ifxColumnInfoArray[n3].IsNamedRow)) {
                System.arraycopy(byArray, n, byArray4, 0, this.identsize);
                try {
                    string = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray4, ((IfxSqliConnect)this.conn).encoption);
                }
                catch (IOException iOException) {
                    throw IfxErrMsg.getSQLException(-79716, this.conn);
                }
                ifxColumnInfoArray[n3].ExtendedName = stringUtil.fixLength(string, s, '\u0000');
            }
            System.arraycopy(byArray, n += this.identsize, byArray3, 0, 2);
            s = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            System.arraycopy(byArray, n += 2, byArray4, 0, this.identsize);
            try {
                string = ((IfxSqliConnect)this.conn).ifxtojava.IfxToJavaChar(byArray4, ((IfxSqliConnect)this.conn).encoption);
            }
            catch (IOException iOException) {
                throw IfxErrMsg.getSQLException(-79716, this.conn);
            }
            ifxColumnInfoArray[n3].ExtendedOwner = stringUtil.fixLength(string, s, '\u0000');
            if (ifxColumnInfoArray[n3].ExtendedOwner.equals("gbasedbt")) {
                ifxColumnInfoArray[n3].ExtendedOwner = "";
            }
            System.arraycopy(byArray, n += this.identsize, byArray3, 0, 2);
            ifxColumnInfoArray[n3].Alignment = IfxToJavaType.IfxToJavaSmallInt(byArray3);
            System.arraycopy(byArray, n += 2, byArray2, 0, 4);
            ifxColumnInfoArray[n3].SourceType = IfxToJavaType.IfxToJavaInt(byArray2);
            n += 4;
        }
        if (TraceFlag.compiletrace) {
            this.dumpTypeArray(ifxColumnInfoArray, 4);
        }
        System.arraycopy(byArray, n += 4, byArray2, 0, 4);
        n4 = IfxToJavaType.IfxToJavaInt(byArray2);
        n += 4;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "    serializedDataSize: " + n4);
        }
        System.arraycopy(byArray, n, byArray2, 0, 4);
        n3 = IfxToJavaType.IfxToJavaInt(byArray2);
        n += 4;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "    flags: " + n3);
        }
        if ((n3 & Integer.MIN_VALUE) != 0) {
            this.nullify();
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    is NULL");
            }
        } else {
            this.unnullify();
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "    is not NULL");
            }
        }
        Vector vector = new Vector();
        this.convertTypeArraytoVector(0, ifxColumnInfoArray, vector, ifxColumnInfoArray[0].Levelno);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "   ***** dump typeInfoVector begin *****");
            IfxComplex.dumpTypeInfoVector(vector, this.trace, 4);
            this.trace.writeTrace(2, "   ***** dump typeInfoVector end *****");
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "before IfxComplexInput() constructor");
            this.trace.writeTrace(2, "isNull(): " + this.isNull());
        }
        if (!this.isNull()) {
            byte[] byArray5;
            if (TraceFlag.compiletrace) {
                byArray5 = new byte[n4];
                System.arraycopy(byArray, n, byArray5, 0, n4);
                this.trace.writeTrace(2, "   fromIfx() data:");
                this.trace.writeTrace(2, byArray5, 'B');
            }
            if (this.allocateNewByteArray) {
                byArray5 = new byte[n4];
                System.arraycopy(byArray, n, byArray5, 0, n4);
                this.inputStream = new IfxComplexInput(byArray5, 0, n4, vector, false, this.conn);
            } else {
                this.inputStream = new IfxComplexInput(byArray, n, n4, vector, false, this.conn);
                this.allocateNewByteArray = false;
            }
            this.inputStream.setTypeMap(this.typeMap);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "after IfxComplexInput() constructor");
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplex.fromIfx() exited");
        }
    }

    private int convertTypeArraytoVector(int n, IfxColumnInfo[] ifxColumnInfoArray, Vector vector, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = null;
        IfxColumnInfo ifxColumnInfo2 = null;
        while (n < ifxColumnInfoArray.length) {
            if (n2 == ifxColumnInfoArray[n].Levelno) {
                ifxColumnInfo = (IfxColumnInfo)ifxColumnInfoArray[n].clone();
                vector.add(ifxColumnInfo);
                ++n;
                continue;
            }
            if (ifxColumnInfoArray[n].Levelno <= n2) break;
            ifxColumnInfo = (IfxColumnInfo)vector.lastElement();
            Vector<IfxColumnInfo> vector2 = new Vector<IfxColumnInfo>();
            ifxColumnInfo2 = (IfxColumnInfo)ifxColumnInfoArray[n].clone();
            vector2.add(ifxColumnInfo2);
            ifxColumnInfo.child = vector2;
            if (n >= ifxColumnInfoArray.length) continue;
            n = this.convertTypeArraytoVector(n + 1, ifxColumnInfoArray, vector2, ifxColumnInfoArray[n].Levelno);
        }
        return n;
    }

    public void fromIfx(byte[] byArray, IfxColumnInfo ifxColumnInfo, boolean bl) throws SQLException {
        byte[] byArray2 = new byte[2];
        int n = 0;
        int n2 = 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplex.fromIfx(byte [], IfxColumnInfo) entered");
        }
        this.clear();
        this.setIdentSize();
        if (bl) {
            this.nullify();
        } else {
            this.unnullify();
        }
        Vector<IfxColumnInfo> vector = new Vector<IfxColumnInfo>(1);
        vector.add(ifxColumnInfo);
        n2 = byArray.length;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "");
            this.trace.writeTrace(2, "");
            IfxComplex.dumpTypeInfoVector(vector, this.trace, 4);
            byte[] byArray3 = new byte[n2];
            System.arraycopy(byArray, n, byArray3, 0, n2);
            this.trace.writeTrace(2, "    *** complex type data dump begin ***");
            this.trace.writeTrace(2, "complex type data:");
            this.trace.writeTrace(2, byArray3, 'B');
            this.trace.writeTrace(2, "   *** complex type data dump end ***");
            this.trace.writeTrace(2, "");
            this.trace.writeTrace(2, "");
        }
        if (!this.isNull()) {
            this.inputStream = new IfxComplexInput(byArray, n, n2, vector, true, this.conn);
            this.inputStream.setTypeMap(this.typeMap);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplex.fromIfx(byte [], IfxColumnInfo) exited");
        }
    }

    @Override
    public byte[] toIfx() throws SQLException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplex.toIfx() entered");
        }
        if (this.isNull() || this.outputStream == null) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.setIdentSize();
        byte[] byArray = this.outputStream.getSerializedTypeInfo();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "  toIfx() bTypeInfoArray size: " + byArray.length);
        }
        int n = this.outputStream.getTypeCount();
        int n2 = this.identsize == 18 ? 26 + 84 * n : 136 + 414 * n;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "  toIfx() type size: " + n2);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "  toIfx() type count: " + n);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "  toIfx() outputStream.length(): " + this.outputStream.length());
        }
        int n3 = n2 + this.outputStream.length() + 12;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "  toIfx() totalSize: " + n3);
        }
        byte[] byArray2 = JavaToIfxType.JavaToIfxInt(n3);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byArray2 = JavaToIfxType.JavaToIfxInt(0);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byArray2 = JavaToIfxType.JavaToIfxSmallInt((short)0);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        String string = stringUtil.fixLength(null, this.identsize, '\u0000');
        try {
            byArray2 = stringUtil.getBytes(string, this.conn);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byArray2 = JavaToIfxType.JavaToIfxSmallInt((short)n);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
        byArray2 = JavaToIfxType.JavaToIfxInt(0);
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        byArray2 = JavaToIfxType.JavaToIfxInt(this.outputStream.length());
        byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        if (this.outputStream.length() > 0) {
            int n4 = 1;
            byArray2 = JavaToIfxType.JavaToIfxInt(n4);
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
            byArray2 = this.outputStream.toByteArray();
            byteArrayOutputStream.write(byArray2, 0, this.outputStream.length());
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "   toIfx() data:");
                this.trace.writeTrace(2, byArray2, 'B');
            }
        } else {
            byArray2 = JavaToIfxType.JavaToIfxInt(Integer.MIN_VALUE);
            byteArrayOutputStream.write(byArray2, 0, byArray2.length);
        }
        super.setExtendedTypeName(this.outputStream.getExtendedName());
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "    toIfx() bStream.size(): " + byteArrayOutputStream.size());
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxComplex.toIfx() exited");
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public byte[] toIfxTuple() throws SQLException {
        return this.toIfx();
    }

    private void setIdentSize() {
        if (this.identsize == 0) {
            this.identsize = this.conn.isLongID() ? (short)128 : (short)18;
        }
    }

    private void dumpTypeArray(IfxColumnInfo[] ifxColumnInfoArray, int n) {
        for (int i = 0; i < ifxColumnInfoArray.length; ++i) {
            this.trace.writeTrace(2, "index : ", i);
            ifxColumnInfoArray[i].dumpInfo(this.trace, n);
        }
    }

    static void dumpTypeInfoVector(Vector vector, Trace trace, int n) {
        if (TraceFlag.compiletrace) {
            for (int i = 0; i < vector.size(); ++i) {
                IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)vector.get(i);
                ifxColumnInfo.dumpInfo(trace, n);
                if (ifxColumnInfo.child == null) continue;
                IfxComplex.dumpTypeInfoVector(ifxColumnInfo.child, trace, n + 4);
            }
        }
    }

    static String getExtendedName(Vector vector, Trace trace, String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "IfxComplex(): getExtendedName() entered");
        }
        String string2 = "";
        if (vector == null) {
            throw IfxErrMsg.getLocSQLException(-79716, ": getExtendedName(Vector)", string);
        }
        if (vector.size() == 0) {
            return "";
        }
        IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)vector.get(0);
        if (ifxColumnInfo.IsNamedRow) {
            if (TraceFlag.compiletrace) {
                trace.writeTrace(2, "    colInfo.ExtendedName: " + ifxColumnInfo.ExtendedName);
            }
            string2 = ifxColumnInfo.ExtendedName;
        } else {
            string2 = IfxComplex.constructExtendedName(vector, string2, trace, string);
            string2.trim();
            string2 = string2.substring(0, string2.length() - 2);
            if (TraceFlag.compiletrace) {
                trace.writeTrace(2, "    constructed name: " + string2);
            }
        }
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "IfxComplex(): getExtendedName() exited");
        }
        return string2;
    }

    static String constructExtendedName(Vector vector, String string, Trace trace, String string2) throws SQLException {
        if (TraceFlag.compiletrace) {
            trace.writeTrace(1, "IfxComplex(): constructExtendedName() called");
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            IfxColumnInfo ifxColumnInfo = (IfxColumnInfo)vector.get(i);
            if (ifxColumnInfo.ColName != null) {
                string = string + ifxColumnInfo.ColName;
                string = string + " ";
            }
            if (ifxColumnInfo.SQLtype == 49) {
                ifxColumnInfo.SQLtype = 0;
                ifxColumnInfo.ColLength = 1;
            }
            if (ifxColumnInfo.ExtendedName != "" && ifxColumnInfo.ExtendedName != null) {
                if (TraceFlag.compiletrace) {
                    trace.writeTrace(2, "  colInfo.ExtendedName != empty string");
                    trace.writeTrace(2, "  colInfo.ExtendedName: " + ifxColumnInfo.ExtendedName);
                }
                if (ifxColumnInfo.ExtendedOwner != "" && ifxColumnInfo.ExtendedOwner != null) {
                    string = string + "'" + ifxColumnInfo.ExtendedOwner + "'.";
                }
                string = string + ifxColumnInfo.ExtendedName;
            } else {
                int n;
                String string3 = IfxTypes.IfxTypeToName(ifxColumnInfo.SQLtype);
                if (TraceFlag.compiletrace) {
                    trace.writeTrace(2, "  colInfo.SQLtype: " + ifxColumnInfo.SQLtype);
                    trace.writeTrace(2, "  typeName: " + string3);
                }
                if (string3.equals("unknown")) {
                    throw IfxErrMsg.getLocSQLException(-79716, string2);
                }
                string = string + string3;
                int n2 = ifxColumnInfo.SQLtype & 0xFF;
                if (n2 == 0 || n2 == 13 || n2 == 15 || n2 == 16) {
                    string = string + "(" + ifxColumnInfo.ColLength + ")";
                } else if (n2 == 10 || n2 == 14) {
                    string = string + " ";
                    string = string + IfxDateTime.getQualifierName((short)ifxColumnInfo.ColLength, n2);
                } else if ((n2 == 5 || n2 == 8) && (n = ifxColumnInfo.ColLength) != 0) {
                    int n3 = IfxDecimal.precTot(n);
                    int n4 = IfxDecimal.precDec(n);
                    string = n4 == 255 ? string + "(" + n3 + ")" : string + "(" + n3 + "," + n4 + ")";
                }
                string = string + " ";
            }
            if (TraceFlag.compiletrace) {
                trace.writeTrace(2, "    name before child check: " + string);
                trace.writeTrace(2, "    type before child check: " + ifxColumnInfo.SQLtype);
                trace.writeTrace(2, "    Nullable before child check: " + ifxColumnInfo.Nullable);
                trace.writeTrace(2, "    child before child check: " + ifxColumnInfo.child);
            }
            if (ifxColumnInfo.child != null && !ifxColumnInfo.IsNamedRow) {
                string = string + "( ";
                string = IfxComplex.constructExtendedName(ifxColumnInfo.child, string, trace, string2);
            }
            if (TraceFlag.compiletrace) {
                trace.writeTrace(2, "    colInfo.Nullable: " + ifxColumnInfo.Nullable);
            }
            if (ifxColumnInfo.Nullable == 0) {
                string = string + " not null";
            }
            if (i + 1 == vector.size()) {
                string = string + ") ";
            }
            if (!TraceFlag.compiletrace) continue;
            trace.writeTrace(2, "    name after child check: " + string);
        }
        return string;
    }

    static void badTypeException(int n, short s, Trace trace, String string) throws SQLException {
        String string2 = null;
        String string3 = null;
        string2 = IfxComplex.getTypeName(s);
        string3 = IfxComplex.getTypeName(n);
        if (TraceFlag.compiletrace) {
            trace.writeTrace(2, "    badTypeException source type: " + s);
            trace.writeTrace(2, "    badTypeException target type: " + n);
        }
        String string4 = IfxMessage.getMessage(-79776, string2, string3, string);
        throw new SQLException(string4);
    }

    private static String getTypeName(int n) {
        String string = "unknown";
        switch (n) {
            case 40: {
                string = "udt var";
                break;
            }
            case 41: {
                string = "udt fixed";
                break;
            }
            case 0: 
            case 13: 
            case 15: 
            case 16: 
            case 43: {
                string = "string type";
                break;
            }
            case 11: 
            case 12: {
                string = "text or byte";
                break;
            }
            default: {
                string = IfxTypes.IfxTypeToName(n);
            }
        }
        return string;
    }
}

