/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.util.TraceFlag;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class IfxDecimal
extends IfxObject {
    private BigDecimal value = null;
    private short encodedLength = 0;
    protected short dec_exp = 0;
    protected short dec_pos = (short)-1;
    protected short dec_ndgts = 0;
    protected byte[] dec_dgts;
    public static final String digChar = "0123456789";
    public static final int DECSIZE = 16;
    public static final short DECPOSNULL = -1;
    public static final short DECPOSPOSITIVE = 1;
    public static final short DECPOSNEGATIVE = 0;
    public static final short BYTESHIFT = 8;
    public static final short BYTEMASK = 255;
    public static final short BYTESIGNED = 128;
    public static final short BYTEMASK7 = 127;
    private static final short DEFAULT_DOUBLE_SCALE = 15;
    private static final short DEFAULT_FLOAT_SCALE = 6;

    public IfxDecimal() throws SQLException {
        this.setIfxType(5);
    }

    public IfxDecimal(BigDecimal bigDecimal) throws SQLException {
        this.encodedLength = 0;
        this.setIfxType(5);
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal;
            this.unnullify();
        }
    }

    public IfxDecimal(byte[] byArray) throws SQLException {
        this.encodedLength = 0;
        this.setIfxType(5);
        this.convBigDecimal(byArray, 0, byArray.length);
    }

    @Override
    public byte[] toIfx() {
        if (this.isNull()) {
            byte[] byArray = new byte[4];
            IfxDecimal.byfill(byArray, (byte)0);
            this.nullify();
            if (TraceFlag.compiletrace) {
                this.writeTrace(3, "toIfx(): value is null");
                this.writeTrace(3, byArray, 'H');
            }
            return byArray;
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(3, "toIfx(): value is not null and it is " + this.value);
        }
        short s = this.dec_pos;
        short s2 = this.dec_exp;
        short s3 = this.dec_ndgts;
        byte[] byArray = this.dec_dgts;
        short s4 = this.encodedLength;
        this.convFromBigDecimal(this.value);
        this.unnullify();
        byte[] byArray2 = this.convIfx(true);
        this.dec_pos = s;
        this.dec_exp = s2;
        this.dec_ndgts = s3;
        this.dec_dgts = byArray;
        this.encodedLength = s4;
        return byArray2;
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            int n = ((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1 + 1;
            byte[] byArray = new byte[n];
            IfxDecimal.byfill(byArray, (byte)0);
            this.nullify();
            return byArray;
        }
        this.convFromBigDecimal(this.value);
        this.unnullify();
        return this.convIfx(false);
    }

    @Override
    public void fromIfx(byte[] byArray, short s) {
        this.fromIfx(byArray, 0, byArray.length, s);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2, short s) {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxDecimal.toIfx() entering method");
            this.writeTrace(3, "   prec: " + s);
        }
        this.encodedLength = s;
        this.convBigDecimal(byArray, n, n2);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    @Override
    public Object toObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        if (this.isNull()) {
            return 0;
        }
        return (byte)this.value.doubleValue();
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        this.encodedLength = 0;
        if (by == null) {
            this.nullify();
        } else {
            this.fromByte((byte)by);
        }
    }

    public void fromByte(Byte by, int n) throws SQLException {
        this.encodedLength = 0;
        if (by == null) {
            this.nullify();
        } else {
            this.fromByte((byte)by);
            this.value = this.value.setScale(n, 4);
        }
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal((double)by);
        this.unnullify();
    }

    @Override
    public short toShort() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return (short)this.value.doubleValue();
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        this.encodedLength = (short)1280;
        if (s == null) {
            this.nullify();
        } else {
            this.fromShort((short)s);
        }
    }

    public void fromShort(Short s, int n) throws SQLException {
        this.encodedLength = (short)(1280 + n);
        if (s == null) {
            this.nullify();
        } else {
            this.fromShort((short)s);
            this.value = this.value.setScale(n, 4);
        }
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.encodedLength = (short)1280;
        this.value = new BigDecimal((double)s);
        this.unnullify();
    }

    @Override
    public int toInt() throws SQLException {
        if (this.isNull()) {
            return 0;
        }
        return this.value.intValue();
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        this.encodedLength = (short)2560;
        if (n == null) {
            this.nullify();
        } else {
            this.fromInt((int)n);
        }
    }

    public void fromInt(Integer n, int n2) throws SQLException {
        this.encodedLength = (short)(2560 + n2);
        if (n == null) {
            this.nullify();
        } else {
            this.fromInt((int)n);
            this.value = this.value.setScale(n2, 4);
        }
    }

    @Override
    public void fromInt(int n) throws SQLException {
        this.encodedLength = (short)2560;
        this.value = new BigDecimal((double)n);
        this.unnullify();
    }

    @Override
    public long toLong() throws SQLException {
        if (this.isNull()) {
            return 0L;
        }
        return this.value.longValue();
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        this.encodedLength = (short)4864;
        if (l == null) {
            this.nullify();
        } else {
            this.fromLong((long)l);
        }
    }

    public void fromLong(Long l, int n) throws SQLException {
        this.encodedLength = (short)(4864 + n);
        if (l == null) {
            this.nullify();
        } else {
            this.fromLong((long)l);
            this.value = this.value.setScale(n, 4);
        }
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.encodedLength = (short)4864;
        this.value = new BigDecimal(Long.toString(l));
        this.unnullify();
    }

    @Override
    public float toFloat() throws SQLException {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value.floatValue();
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        this.encodedLength = 0;
        if (f == null) {
            this.nullify();
        } else {
            this.fromFloat(f.floatValue());
        }
    }

    public void fromFloat(Float f, int n) throws SQLException {
        this.encodedLength = 0;
        if (f == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(f.toString());
            this.value = this.value.setScale(n, 4);
            this.unnullify();
        }
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal(Float.toString(f));
        this.unnullify();
    }

    @Override
    public double toDouble() throws SQLException {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value.doubleValue();
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        this.encodedLength = 0;
        if (d == null) {
            this.nullify();
        } else {
            this.fromDouble((double)d);
        }
    }

    public void fromDouble(Double d, int n) throws SQLException {
        this.encodedLength = 0;
        if (d == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(d.toString());
            this.value = this.value.setScale(n, 4);
            this.unnullify();
        }
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal(Double.toString(d));
        this.unnullify();
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        this.encodedLength = 0;
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal;
            this.unnullify();
        }
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal, int n) throws SQLException {
        this.encodedLength = 0;
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.setScale(n, 4);
            this.unnullify();
        }
    }

    public void fromDecimal(BigDecimal bigDecimal, int n, short s) throws SQLException {
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.setScale(n, 4);
            this.encodedLength = s;
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        if (this.isNull()) {
            return false;
        }
        return this.value.intValue() != 0;
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        this.encodedLength = 0;
        if (bl == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)bl);
        }
    }

    public void fromBoolean(Boolean bl, int n) throws SQLException {
        this.encodedLength = 0;
        if (bl == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)bl);
            this.value = this.value.setScale(n, 4);
        }
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        this.encodedLength = 0;
        this.value = new BigDecimal((double)(bl ? 1 : 0));
        this.unnullify();
    }

    @Override
    public String toString() {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxDecimal.toString() called");
            if (this.value != null) {
                this.writeTrace(2, "   value.getScale(): " + this.value.scale());
            }
        }
        if (this.isNull()) {
            return null;
        }
        return this.value.toString();
    }

    @Override
    public void fromString(String string) throws SQLException {
        this.encodedLength = 0;
        if (string == null || string.length() == 0) {
            this.nullify();
        } else {
            this.value = new BigDecimal(string.trim());
            this.unnullify();
        }
    }

    public void fromString(String string, int n) throws SQLException {
        this.encodedLength = 0;
        if (string == null) {
            this.nullify();
        } else {
            this.value = new BigDecimal(string.trim());
            this.value = this.value.setScale(n, 4);
            this.unnullify();
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        return object instanceof IfxDecimal && this.value.equals(((IfxDecimal)object).value);
    }

    public int getScale() {
        return this.value.scale();
    }

    @Override
    public short getEncodedLength() {
        if (this.encodedLength == 0 && !this.isNull) {
            this.computeEncodedLength();
            return this.encodedLength;
        }
        return this.encodedLength;
    }

    @Override
    public void setEncodedLength(int n) {
        this.encodedLength = (short)n;
    }

    private void convBigDecimal(byte[] byArray, int n, int n2) {
        String string;
        int n3 = n;
        if (byArray[n3] == 0 && byArray[n3 + 1] == 0) {
            this.value = null;
            return;
        }
        this.dec_ndgts = n == 0 ? (short)(n2 - n3 - 1) : (short)(((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1);
        this.dec_dgts = new byte[this.dec_ndgts];
        IfxDecimal.bycopy(byArray, n3 + 1, this.dec_dgts, 0);
        short s = byArray[n3];
        this.dec_pos = 1;
        if ((s & 0x80) == 0) {
            if (TraceFlag.compiletrace) {
                this.writeTrace(3, "decComplement(): before = {");
                this.writeTrace(3, this.dec_dgts, 'H');
                this.writeTrace(3, "}");
            }
            IfxDecimal.decComplement(this.dec_dgts, 0);
            if (TraceFlag.compiletrace) {
                this.writeTrace(3, "decComplement(): after = {");
                this.writeTrace(3, this.dec_dgts, 'H');
                this.writeTrace(3, "}");
            }
            s = (short)(s ^ 0x7F);
            this.dec_pos = 0;
        }
        this.dec_exp = s = (short)((s & 0x7F) - 64);
        if (TraceFlag.compiletrace) {
            this.writeTrace(3, "convBigDecimal(): encodedLength = " + this.encodedLength + " Internal network format = { ");
            this.writeTrace(3, byArray, n3, 'H', n2);
            this.writeTrace(3, "}");
        }
        int[] nArray = new int[1];
        if (this.encodedLength != 0) {
            nArray[0] = IfxDecimal.precDec(this.encodedLength);
            if (nArray[0] == 255) {
                nArray[0] = -1;
            }
        } else {
            nArray[0] = -1;
        }
        this.value = (string = this.stringValue(nArray)) == null ? null : new BigDecimal(new BigInteger(string), nArray[0]);
        if (TraceFlag.compiletrace) {
            this.writeTrace(3, "convBigDecimal(): value = " + this.value);
        }
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
        }
    }

    private void convFromBigDecimal(BigDecimal bigDecimal) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        this.dec_pos = 1;
        String string = bigDecimal.unscaledValue().toString();
        int n5 = bigDecimal.scale();
        int n6 = string.length();
        char c = string.charAt(0);
        if (c == '-') {
            this.dec_pos = 0;
            ++n2;
            --n6;
        } else if (c == '+') {
            ++n2;
            --n6;
        }
        n3 = n6 - n5;
        if (n3 % 2 != 0) {
            ++n6;
            this.dec_exp = (short)((n3 + 1) / 2);
            n4 = 1;
            bl = true;
        } else {
            this.dec_exp = (short)(n3 / 2);
        }
        byte[] byArray = new byte[n6];
        IfxDecimal.byfill(byArray, (byte)0);
        for (int i = n2; i < string.length(); ++i) {
            int n7 = digChar.indexOf(string.charAt(i));
            byArray[n4] = (byte)n7;
            ++n4;
        }
        n6 = (byArray = this.adjust(byArray, bl, n2, string, bigDecimal)).length;
        this.dec_ndgts = n6 % 2 == 1 ? (short)(n6 / 2 + 1) : (short)(n6 / 2);
        this.dec_dgts = new byte[this.dec_ndgts];
        for (n = 0; n < n6 / 2; ++n) {
            this.dec_dgts[n] = (byte)(byArray[2 * n] * 10 + byArray[2 * n + 1]);
        }
        if (n6 % 2 == 1) {
            this.dec_dgts[n] = (byte)(byArray[2 * n] * 10);
        }
        if (this.encodedLength == 0) {
            this.computeEncodedLength();
        } else {
            this.dec_ndgts = (short)(((this.encodedLength >> 8 & 0xFF) + (this.encodedLength & 0xFF & 1) + 3) / 2 - 1);
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(3, "convFromBigDecimal(): " + string);
            this.writeTrace(3, "convFromBigDecimal(): dec_pos = " + this.dec_pos);
            this.writeTrace(3, "convFromBigDecimal(): dec_exp = " + this.dec_exp);
            this.writeTrace(3, "convFromBigDecimal(): dec_ndgts = " + this.dec_ndgts);
            this.writeTrace(3, "dec_dgts = {");
            this.writeTrace(3, this.dec_dgts, 'H');
            this.writeTrace(3, "}");
        }
    }

    private byte[] adjust(byte[] byArray, boolean bl, int n, String string, BigDecimal bigDecimal) {
        int n2;
        Object object;
        int n3;
        int n4;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxDecimal.adjust() entering");
        }
        int n5 = 0;
        if (this.encodedLength != 0) {
            n4 = IfxDecimal.precTot(this.encodedLength);
            n3 = n4 / 2;
            if (n4 % 2 == 1) {
                ++n3;
            }
            n5 = IfxDecimal.precDec(this.encodedLength) / 2;
        } else {
            n4 = 32;
            n3 = 16;
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(3, "  adjust() totalDigits: " + n4);
            this.writeTrace(3, "  adjust() ndgtsGood: " + n3);
            this.writeTrace(3, "  adjust() unpack.length: " + byArray.length);
            this.writeTrace(3, "  adjust() str: " + string);
            object = "--";
            for (n2 = 0; n2 < byArray.length; ++n2) {
                object = (String)object + byArray[n2];
            }
            object = (String)object + "--";
            this.writeTrace(3, "  adjust() unpack to string: " + (String)object);
        }
        object = byArray;
        n2 = bl ? byArray.length - 1 : byArray.length;
        if (n2 > n4) {
            int n6;
            BigInteger bigInteger = bigDecimal.unscaledValue().abs();
            BigInteger bigInteger2 = new BigInteger("10");
            BigInteger bigInteger3 = new BigInteger("1");
            if (TraceFlag.compiletrace) {
                this.writeTrace(3, "  adjust() bi : " + bigInteger);
                this.writeTrace(3, "  adjust() biTen : " + bigInteger2);
                this.writeTrace(3, "  adjust() biDivide : " + bigInteger2);
                this.writeTrace(3, "  adjust() unpack.length : " + byArray.length);
                this.writeTrace(3, "  adjust() unpack.length - totalDigits: " + (byArray.length - n4));
            }
            for (n6 = 0; n6 < n2 - n4; ++n6) {
                bigInteger3 = bigInteger3.multiply(bigInteger2);
            }
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger3);
            if (TraceFlag.compiletrace) {
                this.writeTrace(3, "  adjust() biDivide : " + bigInteger3);
                this.writeTrace(3, "  adjust() biAndRemainder[0] : " + bigIntegerArray[0]);
                this.writeTrace(3, "  adjust() biAndRemainder[1] : " + bigIntegerArray[1]);
            }
            n6 = 0;
            int n7 = 0;
            if (bl) {
                ++n7;
            }
            if (byArray.length > n4 + n7) {
                n6 = byArray[n4 + n7];
            }
            n6 *= 10;
            if (byArray.length > n4 + n7 + 1) {
                n6 += byArray[n4 + n7 + 1];
            }
            if (n6 >= 50) {
                bigIntegerArray[0] = bigIntegerArray[0].add(new BigInteger("1"));
            }
            String string2 = bigIntegerArray[0].toString();
            if (TraceFlag.compiletrace) {
                this.writeTrace(3, "  new string: " + string2);
            }
            int n8 = 0;
            if (bl || string.charAt(n) == '0') {
                ++n8;
            }
            byte[] byArray2 = null;
            byArray2 = bl ? (n4 == 0 ? new byte[n4 + 2] : new byte[n4 + 1]) : new byte[n4];
            IfxDecimal.byfill(byArray2, (byte)0);
            int n9 = 0;
            while (n9 < string2.length()) {
                int n10 = digChar.indexOf(string2.charAt(n9));
                if (n10 != -1) {
                    byArray2[n8] = (byte)n10;
                }
                ++n9;
                ++n8;
            }
            object = byArray2;
        } else if (byArray.length < n4 && n5 != 0 && this.encodedLength != 0) {
            object = new byte[n4];
            IfxDecimal.byfill(object, (byte)0);
            System.arraycopy(byArray, 0, object, 0, byArray.length);
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxDecimal.adjust() leaving");
        }
        return object;
    }

    protected void computeEncodedLength() {
        if (this.dec_ndgts == 0 || this.dec_pos == -1) {
            this.encodedLength = 0;
            return;
        }
        int n = 2 * (this.dec_ndgts - this.dec_exp);
        int n2 = 2 * this.dec_ndgts;
        if (this.dec_dgts[this.dec_ndgts - 1] % 10 == 0) {
            --n;
            --n2;
        }
        if (this.dec_dgts[0] < 10) {
            --n2;
        }
        if (n < 0) {
            n2 += -n;
            n = 0;
        }
        this.encodedLength = (short)(((byte)n2 << 8) + n);
        if (TraceFlag.compiletrace) {
            this.writeTrace(3, "computeEncodedLength(): encodedLength = " + this.encodedLength);
            this.writeTrace(3, "computeEncodedLength(): scale = " + n);
            this.writeTrace(3, "computeEncodedLength(): prec = " + n2);
        }
    }

    protected int extractExponent(String string, int n) {
        int n2;
        int n3 = 0;
        boolean bl = true;
        for (n2 = n; n2 < string.length() && string.charAt(n2) != 'E'; ++n2) {
        }
        if (n2 == string.length()) {
            return n3;
        }
        if (string.charAt(++n2) == '+') {
            ++n2;
        } else if (string.charAt(n2) == '-') {
            ++n2;
            bl = false;
        }
        for (int i = n2; i < string.length(); ++i) {
            n3 = n3 * 10 + digChar.indexOf(string.charAt(i));
        }
        return bl ? n3 : -n3;
    }

    private byte[] convIfx(boolean bl) {
        int n = bl ? 2 : 0;
        byte[] byArray = new byte[this.dec_ndgts + 1 + n];
        boolean bl2 = false;
        IfxDecimal.byfill(byArray, (byte)0);
        if (bl) {
            int n2 = this.dec_ndgts + 1;
            byArray[0] = (byte)(n2 >> 8 & 0xFF);
            byArray[1] = (byte)(n2 & 0xFF);
        }
        if (this.dec_pos == -1) {
            return byArray;
        }
        byArray[n] = (byte)(this.dec_exp + 64 & 0x7F);
        IfxDecimal.bycopy(this.dec_dgts, 0, byArray, n + 1);
        if (this.dec_pos == 0) {
            if (this.dec_ndgts == 0) {
                int n3 = n;
                byArray[n3] = (byte)(byArray[n3] | 0x80);
            } else {
                IfxDecimal.decComplement(byArray, 1 + n);
                int n4 = n;
                byArray[n4] = (byte)(byArray[n4] ^ 0x7F);
            }
        } else {
            int n5 = n;
            byArray[n5] = (byte)(byArray[n5] | 0x80);
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(3, "convIfx(): dec_pos = " + this.dec_pos);
            this.writeTrace(3, "convIfx(): dec_exp = " + this.dec_exp);
            this.writeTrace(3, "convIfx(): dec_ndgts = " + this.dec_ndgts);
            this.writeTrace(3, "dec_dgts = {");
            this.writeTrace(3, this.dec_dgts, 'H');
            this.writeTrace(3, "}");
            this.writeTrace(3, "Infromix network format = {");
            this.writeTrace(3, byArray, 'H');
            this.writeTrace(3, "}");
        }
        return byArray;
    }

    private static byte[] byfill(byte[] byArray, byte by) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = by;
        }
        return byArray;
    }

    private static char[] charfill(char[] cArray, int n, int n2, char c) {
        for (int i = n; i <= n2 && i < cArray.length; ++i) {
            cArray[i] = c;
        }
        return cArray;
    }

    private static void bycopy(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = n2;
        for (int i = n; i < byArray.length && n3 < byArray2.length; ++i, ++n3) {
            byArray2[n3] = byArray[i];
        }
    }

    private static void charcopy(char[] cArray, int n, int n2, char[] cArray2, int n3) {
        int n4 = n3;
        for (int i = n; i < cArray.length && i <= n2 && n4 < cArray2.length; ++i, ++n4) {
            cArray2[n4] = cArray[i];
        }
    }

    private static byte[] decComplement(byte[] byArray, int n) {
        int n2 = 100;
        for (int i = byArray.length - 1; i >= n; --i) {
            if (byArray[i] == 0 && n2 == 100) continue;
            byArray[i] = (byte)(n2 - byArray[i]);
            n2 = 99;
        }
        return byArray;
    }

    private char[] sigdigToChar() {
        char[] cArray = new char[this.dec_ndgts * 2];
        for (int i = 0; i < this.dec_ndgts; ++i) {
            cArray[i * 2] = digChar.charAt(this.dec_dgts[i] / 10);
            cArray[i * 2 + 1] = digChar.charAt(this.dec_dgts[i] % 10);
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(3, "sigdigToChar(): digits = " + new String(cArray));
        }
        return cArray;
    }

    private String stringValue(int[] nArray) {
        int n;
        char[] cArray;
        int n2;
        int n3;
        if (this.dec_pos == -1) {
            return null;
        }
        if (this.dec_ndgts <= 0) {
            if (nArray[0] == -1) {
                nArray[0] = 0;
            }
            return "0";
        }
        int n4 = this.dec_exp * 2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        if (nArray[0] == -1) {
            if (n3 > n4) {
                for (n3 = this.dec_ndgts * 2; n3 > 0; n3 -= 2) {
                    if (n3 > n4 + 1 && this.dec_dgts[n3 / 2 - 1] == 0) {
                        continue;
                    }
                    if (n3 < n4 + 1 || this.dec_dgts[n3 / 2 - 1] % 10 != 0) break;
                    --n3;
                    break;
                }
                if (n3 <= 0) {
                    nArray[0] = 0;
                    return "0";
                }
                nArray[0] = n3 - n4;
            } else {
                nArray[0] = 0;
                n6 = n4 - n3;
            }
            n2 = n3 + n6;
        } else if (nArray[0] == n3 - n4) {
            n2 = n3;
        } else if (nArray[0] > n3 - n4) {
            n6 = nArray[0] - (n3 - n4);
            if (n4 < 0) {
                n7 = -n4;
                n2 = nArray[0];
            } else {
                n2 = n3 + n6;
            }
        } else if (n4 >= 0) {
            n2 = n4 + nArray[0];
            bl = true;
        } else {
            if (-n4 > nArray[0]) {
                return "0";
            }
            n2 = nArray[0];
            n7 = -n4;
            bl = true;
        }
        if (this.dec_pos == 0) {
            cArray = new char[1 + n2];
            cArray[0] = 45;
            n5 = 1;
        } else {
            cArray = new char[n2];
        }
        if (n7 > 0) {
            IfxDecimal.charfill(cArray, n5, n5 + n7 - 1, '0');
        }
        for (n = 0; n < this.dec_ndgts && n5 + n7 + n * 2 + 1 < cArray.length; ++n) {
            cArray[n5 + n7 + n * 2] = digChar.charAt(this.dec_dgts[n] / 10);
            cArray[n5 + n7 + n * 2 + 1] = digChar.charAt(this.dec_dgts[n] % 10);
        }
        if (n5 + n7 + n * 2 < cArray.length && n < this.dec_ndgts) {
            cArray[n5 + n7 + n * 2] = digChar.charAt(this.dec_dgts[n] / 10);
        }
        if (n6 > 0) {
            IfxDecimal.charfill(cArray, n5 + n7 + n3, cArray.length - 1, '0');
        } else if (bl) {
            boolean bl2 = false;
            if (n5 + n7 + n * 2 < cArray.length) {
                if (this.dec_dgts[n] % 10 >= 5) {
                    if (this.dec_dgts[n] / 10 == 9) {
                        cArray[n5 + n7 + n * 2] = 48;
                        bl2 = true;
                    } else {
                        cArray[n5 + n7 + n * 2] = digChar.charAt(digChar.indexOf(cArray[n5 + n7 + n * 2]) + 1);
                    }
                }
            } else if (this.dec_dgts[n] / 10 >= 5) {
                bl2 = true;
            }
            if (bl2) {
                int n8;
                for (n8 = n5 + n7 + (n - 1) * 2 + 1; n8 >= n5; --n8) {
                    if (cArray[n8] != '9') {
                        cArray[n8] = digChar.charAt(digChar.indexOf(cArray[n8]) + 1);
                        break;
                    }
                    cArray[n8] = 48;
                }
                if (n8 < n5) {
                    char[] cArray2 = new char[cArray.length + 1];
                    int n9 = 0;
                    if (n5 == 1) {
                        cArray2[n9++] = 45;
                    }
                    cArray2[n9++] = 49;
                    while (n9 < cArray2.length) {
                        cArray2[n9] = 48;
                        ++n9;
                    }
                    return new String(cArray2);
                }
            }
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(3, "stringValue(): dec_pos = " + this.dec_pos);
            this.writeTrace(3, "stringValue(): dec_exp = " + this.dec_exp);
            this.writeTrace(3, "stringValue(): dec_ndgts = " + this.dec_ndgts);
            this.writeTrace(3, "stringValue(): buf = " + cArray);
            this.writeTrace(3, "dec_dgts = {");
            this.writeTrace(3, this.dec_dgts, 'H');
            this.writeTrace(3, "}");
        }
        return new String(cArray);
    }

    private static char[] trimZerosFB(char[] cArray, int n) {
        int n2;
        int n3;
        for (n3 = n; n3 < cArray.length && cArray[n3] == '0'; ++n3) {
        }
        if (n3 == cArray.length) {
            char[] cArray2 = new char[2];
            cArray2[1] = 48;
            return cArray2;
        }
        for (n2 = cArray.length - 1; n2 >= n3 && cArray[n2] == '0'; --n2) {
        }
        char[] cArray3 = new char[n2 - n3 + 2];
        int n4 = 1;
        int n5 = n3;
        while (n5 <= n2) {
            cArray3[n4] = cArray[n5];
            ++n5;
            ++n4;
        }
        return cArray3;
    }

    protected static int precTot(int n) {
        return n >> 8 & 0xFF;
    }

    protected static int precDec(int n) {
        return n & 0xFF;
    }

    protected static int decLength(int n) {
        int n2 = IfxDecimal.precTot(n);
        int n3 = IfxDecimal.precDec(n);
        int n4 = (n2 + (n3 & 1) + 3) / 2;
        return n4;
    }

    protected static String getIfxTypeName(int n) {
        int n2 = IfxDecimal.precDec(n);
        if (n2 == 255) {
            return "decimal(16)";
        }
        return "decimal(" + IfxDecimal.precTot(n) + ", " + n2 + ")";
    }

    public int getPrecision() {
        return this.value.precision();
    }
}

