/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.lang.JavaToIfxType;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.TraceFlag;
import com.gbasedbt.util.memoryUtil;
import java.math.BigDecimal;
import java.sql.SQLException;

public class IfxFloat
extends IfxObject {
    private double value;

    IfxFloat() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat() constructor called");
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat() constructor exited");
        }
        this.setIfxType(3);
    }

    IfxFloat(double d) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat(double) constructor called");
        }
        this.setIfxType(3);
        this.value = d;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat(double) constructor exited");
        }
    }

    IfxFloat(Double d) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat(Double) constructor called");
        }
        this.setIfxType(3);
        if (d != null) {
            this.value = d;
            this.unnullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat(Double) constructor exited");
        }
    }

    IfxFloat(float f) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat(float) constructor called");
        }
        this.setIfxType(3);
        this.value = f;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat(float) constructor exited");
        }
    }

    IfxFloat(Float f) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat(Float) constructor called");
        }
        this.setIfxType(3);
        if (f != null) {
            this.value = f.floatValue();
            this.unnullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat(Float) constructor exited");
        }
    }

    @Override
    public byte[] toIfx() {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toIfx called/exited");
        }
        return JavaToIfxType.JavaToIfxDouble(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] byArray = new byte[8];
            memoryUtil.byfill(byArray, (byte)-1);
            return byArray;
        }
        return JavaToIfxType.JavaToIfxDouble(this.value);
    }

    @Override
    public void fromIfx(byte[] byArray) {
        this.fromIfx(byArray, 0, byArray.length);
    }

    @Override
    public void fromIfx(byte[] byArray, int n, int n2) {
        boolean bl = true;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromIfx called");
        }
        if (!(bl = IfxFloat.isIfxNull(byArray, n, n2))) {
            this.unnullify();
            this.value = IfxToJavaType.IfxToJavaDouble(byArray, n);
        } else {
            this.nullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromIfx exited");
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this.isNull() || object == null) {
            return false;
        }
        if (object instanceof IfxFloat) {
            IfxFloat ifxFloat = (IfxFloat)object;
            if (ifxFloat.isNull()) {
                return false;
            }
            return this.value == ifxFloat.value;
        }
        return false;
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return new Double(this.value);
    }

    @Override
    public byte toByte() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toByte called");
        }
        this.clearWarning();
        byte by = this.isNull() ? (byte)0 : (byte)this.value;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toByte exited");
        }
        return by;
    }

    @Override
    public void fromByte(byte by) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromByte called");
        }
        this.value = by;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromByte exited");
        }
    }

    @Override
    public void fromByte(Byte by) throws SQLException {
        if (by == null) {
            this.nullify();
        } else {
            this.value = by.doubleValue();
            this.unnullify();
        }
    }

    @Override
    public double toDouble() {
        if (this.isNull()) {
            return 0.0;
        }
        return this.value;
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.value = d;
        this.unnullify();
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.value = d;
            this.unnullify();
        }
    }

    @Override
    public short toShort() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toShort called");
        }
        this.clearWarning();
        if (this.isNull()) {
            short s = 0;
            return 0;
        }
        short s = (short)this.value;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toShort exited");
        }
        return s;
    }

    @Override
    public void fromShort(short s) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromShort called");
        }
        this.value = s;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromShort exited");
        }
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromShort called");
        }
        if (s == null) {
            this.nullify();
        } else {
            this.value = s.doubleValue();
            this.unnullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromShort exited");
        }
    }

    @Override
    public int toInt() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toInt called");
        }
        this.clearWarning();
        int n = this.isNull() ? 0 : (int)this.value;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toInt exited");
        }
        return n;
    }

    @Override
    public void fromInt(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromInt called");
        }
        this.value = n;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromInt exited");
        }
    }

    @Override
    public void fromInt(Integer n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromInt called");
        }
        if (n == null) {
            this.nullify();
        } else {
            this.value = n.doubleValue();
            this.unnullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromInt exited");
        }
    }

    @Override
    public long toLong() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toLong called");
        }
        this.clearWarning();
        long l = this.isNull() ? 0L : (long)this.value;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toLong exited");
        }
        return l;
    }

    @Override
    public void fromLong(long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromLong called");
        }
        this.value = l;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromLong exited");
        }
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromLong called");
        }
        if (l == null) {
            this.nullify();
        } else {
            this.value = l.doubleValue();
            this.unnullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromLong exited");
        }
    }

    @Override
    public float toFloat() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toFloat called");
        }
        this.clearWarning();
        float f = this.isNull() ? 0.0f : (float)this.value;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toFloat exited");
        }
        return f;
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromFloat called");
        }
        this.value = f;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromFloat exited");
        }
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromFloat called");
        }
        if (f == null) {
            this.nullify();
        } else {
            this.value = f.doubleValue();
            this.unnullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromFloat exited");
        }
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toDecimal called/exited");
        }
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.value);
    }

    @Override
    public void fromDecimal(BigDecimal bigDecimal) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromBigDecimal called");
        }
        if (bigDecimal == null) {
            this.nullify();
        } else {
            this.value = bigDecimal.doubleValue();
            this.unnullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromBigDecimal exited");
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        boolean bl;
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toBoolean called");
        }
        if (this.isNull()) {
            bl = false;
        } else {
            boolean bl2 = bl = this.value != 0.0;
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toBoolean exited");
        }
        return bl;
    }

    @Override
    public void fromBoolean(boolean bl) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromBoolean called");
        }
        this.value = bl ? 1 : 0;
        this.unnullify();
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromBoolean exited");
        }
    }

    @Override
    public void fromBoolean(Boolean bl) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromBoolean called");
        }
        if (bl == null) {
            this.nullify();
        } else {
            this.value = bl == true ? 1 : 0;
            this.unnullify();
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromBoolean exited");
        }
    }

    @Override
    public String toString() {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toString called");
        }
        String string = this.isNull() ? null : Double.toString(this.value);
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: toString exited");
        }
        return string;
    }

    @Override
    public void fromString(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromString called");
        }
        if (string == null || string.length() == 0) {
            this.nullify();
        } else {
            try {
                this.value = Double.valueOf(string.trim());
                this.unnullify();
            }
            catch (Exception exception) {
                this.nullify();
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxFloat: fromString exited");
        }
    }

    static boolean isIfxNull(double d) {
        byte[] byArray = JavaToIfxType.JavaToIfxDouble(d);
        return IfxFloat.isIfxNull(byArray);
    }

    static boolean isIfxNull(byte[] byArray) {
        return IfxFloat.isIfxNull(byArray, 0, byArray.length);
    }

    static boolean isIfxNull(byte[] byArray, int n, int n2) {
        for (int i = 0; i < 8; ++i) {
            if (byArray[i + n] == -1) continue;
            return false;
        }
        return true;
    }

    static double getIfxNull() {
        byte[] byArray = new byte[8];
        double d = 0.0;
        for (int i = 0; i < 8; ++i) {
            byArray[i] = -1;
            d = IfxToJavaType.IfxToJavaDouble(byArray);
        }
        return d;
    }
}

