/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxProtocol;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import com.gbasedbt.util.stringUtil;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxLocator {
    static final int IFX_LOCATOR_SIZE = 72;
    byte[] rawLocator = null;
    int blobSize = 0;
    IfxConnection conn = null;
    private IfxProtocol prot = null;
    private Trace trace = null;
    private static final String IFX_LO_INCREFCOUNT = "function gbasedbt.ifx_lo_increfcount(blob)";
    private static final String IFX_LO_DECREFCOUNT = "function gbasedbt.ifx_lo_decrefcount(blob)";
    private static final String LO_NAME = "blob";

    public IfxLocator() {
        if (this.rawLocator == null) {
            this.rawLocator = new byte[72];
        }
    }

    public IfxLocator(Connection connection) throws SQLException {
        if (this.rawLocator == null) {
            this.rawLocator = new byte[72];
        }
        this.conn = (IfxConnection)connection;
        if (TraceFlag.compiletrace) {
            this.setTrace(this.conn.getTrace());
        }
        try {
            Class[] classArray = new Class[]{this.conn.getClass()};
            Class<?> clazz = Class.forName(this.conn.getProtoClassName());
            Constructor<?> constructor = null;
            while (constructor == null) {
                try {
                    constructor = clazz.getConstructor(classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    classArray[0] = classArray[0].getSuperclass();
                    if (classArray[0] != null) continue;
                    throw noSuchMethodException;
                }
            }
            Object[] objectArray = new Object[]{this.conn};
            this.prot = (IfxProtocol)constructor.newInstance(objectArray);
            if (this.prot == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79735, exception.toString(), this.conn);
        }
    }

    public IfxLocator(byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw IfxErrMsg.getSQLException(-79701, "IfxLocator.IfxLocator(byte[]) : byteBuf is null", this.conn);
        }
        this.rawLocator = byArray;
    }

    IfxLocator(byte[] byArray, Connection connection) throws SQLException {
        if (this.rawLocator == null) {
            this.rawLocator = new byte[72];
        }
        System.arraycopy(byArray, 0, this.rawLocator, 0, 72);
        this.conn = (IfxConnection)connection;
        if (TraceFlag.compiletrace) {
            this.setTrace(this.conn.getTrace());
        }
        try {
            Class[] classArray = new Class[]{this.conn.getClass()};
            Class<?> clazz = Class.forName(this.conn.getProtoClassName());
            Constructor<?> constructor = null;
            while (constructor == null) {
                try {
                    constructor = clazz.getConstructor(classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    classArray[0] = classArray[0].getSuperclass();
                    if (classArray[0] != null) continue;
                    throw noSuchMethodException;
                }
            }
            Object[] objectArray = new Object[]{this.conn};
            this.prot = (IfxProtocol)constructor.newInstance(objectArray);
            if (this.prot == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79735, exception.toString(), this.conn);
        }
    }

    byte[] getRawLocator() {
        return this.rawLocator;
    }

    Connection getConnection() {
        return this.conn;
    }

    void setRawLocator(byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw IfxErrMsg.getSQLException(-79701, "IfxLocator.setRawLocator() : lo is null", this.conn);
        }
        if (this.rawLocator == null) {
            this.rawLocator = new byte[72];
        }
        System.arraycopy(byArray, 0, this.rawLocator, 0, 72);
    }

    int getBlobSize() {
        return this.blobSize;
    }

    void setBlobSize(int n) {
        this.blobSize = n;
    }

    public int incRefCount() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "incRefCount() entered. ");
        }
        if (this.prot == null || this.conn == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        if (this.rawLocator == null) {
            throw IfxErrMsg.getSQLException(-79814, this.conn);
        }
        if (!this.conn.isDirect()) {
            throw IfxErrMsg.getSQLException(-79700, "IfxLocator.incRefCount()", this.conn);
        }
        return this.prot.incRefCount(this.getRawLocator());
    }

    public int decRefCount() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "decRefCount() entered. ");
        }
        if (this.prot == null || this.conn == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        if (this.rawLocator == null) {
            throw IfxErrMsg.getSQLException(-79814, this.conn);
        }
        if (!this.conn.isDirect()) {
            throw IfxErrMsg.getSQLException(-79700, "IfxLocator.decRefCount()", this.conn);
        }
        return this.prot.decRefCount(this.getRawLocator());
    }

    void setTrace(Trace trace) {
        if (TraceFlag.compiletrace) {
            this.trace = trace;
        }
    }

    public String toString() {
        return stringUtil.toHexString(this.rawLocator);
    }

    public byte[] toBytes() {
        return this.getRawLocator();
    }
}

