/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfmxResultSet;
import com.gbasedbt.jdbc.IfxBSONObject;
import com.gbasedbt.jdbc.IfxBlob;
import com.gbasedbt.jdbc.IfxCallableStatement;
import com.gbasedbt.jdbc.IfxCblob;
import com.gbasedbt.jdbc.IfxCollection;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxDateTime;
import com.gbasedbt.jdbc.IfxFParam;
import com.gbasedbt.jdbc.IfxIntervalDF;
import com.gbasedbt.jdbc.IfxJSON;
import com.gbasedbt.jdbc.IfxLob;
import com.gbasedbt.jdbc.IfxLobDescriptor;
import com.gbasedbt.jdbc.IfxLocator;
import com.gbasedbt.jdbc.IfxLvarchar;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.jdbc.IfxPreparedStatement;
import com.gbasedbt.jdbc.IfxProtocol;
import com.gbasedbt.jdbc.IfxResultSetMetaData;
import com.gbasedbt.jdbc.IfxSmBlob;
import com.gbasedbt.jdbc.IfxSmartBlob;
import com.gbasedbt.jdbc.IfxSqli;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.jdbc.IfxStatement;
import com.gbasedbt.jdbc.IfxUpdateResultSet;
import com.gbasedbt.jdbc.ResultSet2;
import com.gbasedbt.jdbcx.IfxXAReusableConnection;
import com.gbasedbt.jdbcx.IfxXid;
import com.gbasedbt.lang.Interval;
import com.gbasedbt.lang.IntervalDF;
import com.gbasedbt.lang.IntervalYM;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.TraceFlag;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.transaction.xa.Xid;

public class IfxResultSet
extends IfxUpdateResultSet
implements IfmxResultSet,
ResultSet2 {
    static final int DIR_FIRST = 3;
    static final int DIR_LAST = 4;
    static final int DIR_ABSL = 6;
    static final int DIR_NEXT = 1;
    static final int DIR_PREV = 2;
    static final int DIR_RELT = 7;
    static final int DIR_CURR = 5;
    protected IfxProtocol prot;
    protected HashMap<String, Integer> nameToIdxTable;
    protected int curRowID;
    protected int lastRowID = -1;
    protected boolean scrollableEmptyResultSet = false;
    protected boolean lastColWasNull;
    protected Vector<IfxObject> colVector;
    protected Vector<String> keyNameVector;
    protected boolean noMoreRows;
    static final int IS_XA_TX = 1;
    private int txType;
    protected boolean isClosed;
    private Xid connectXid = null;
    private boolean pending = false;
    private int fetchSize = 0;
    private int tupleSizeReceived = 0;
    protected boolean withHold = false;

    IfxResultSet(IfxStatement ifxStatement, IfxConnection ifxConnection, IfxProtocol ifxProtocol) throws SQLException {
        this.conn = ifxConnection;
        this.prot = ifxProtocol;
        this.stmt = ifxStatement;
        this.fetchSize = ifxStatement.getFetchSize();
        if (ifxConnection instanceof IfxSqliConnect) {
            boolean bl = this.pending = !((IfxSqliConnect)ifxConnection).autoCommit;
        }
        if (ifxConnection.isXAConnection()) {
            this.connectXid = ((IfxXAReusableConnection)ifxConnection).getCurrentXid();
        }
        this.setResultSetTxType();
        if (TraceFlag.compiletrace) {
            this.trace = ifxConnection.getTrace();
            this.trace.writeTrace(99, "IfxResultSet: constructor exited");
        }
    }

    void init() {
        this.isClosed = false;
    }

    public void executeQuery() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeQuery() called");
        }
        this.executeQuery(false);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeQuery() exited");
        }
    }

    void executeQuery(boolean bl) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeQuery(boolean) called");
        }
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.setResultSetTxType();
        this.prot.executeStatementQuery(this.stmt, bl);
        this.curRowID = 0;
        this.lastRowID = 0;
        this.rsmd = (IfxResultSetMetaData)this.getMetaData();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeQuery(boolean) exited");
        }
    }

    void executeQuery(IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeQuery(IfxResultSetMetaData) called");
        }
        this.executeQuery(ifxResultSetMetaData, false);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeQuery(IfxResultSetMetaData) exited");
        }
    }

    void executeQuery(IfxResultSetMetaData ifxResultSetMetaData, boolean bl) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeQuery(IfxResultSetMetaData,boolean) called");
        }
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.setResultSetTxType();
        this.prot.executeStatementQuery(this.stmt, bl, ifxResultSetMetaData);
        this.curRowID = 0;
        this.lastRowID = 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeQuery(IfxResultSetMetaData,boolean) exited");
        }
    }

    int executeUpdate() throws SQLException {
        block7: {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(1, "IfxResultSet.executeUpdate() called");
            }
            if (this.prot == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
            this.clearWarnings();
            this.setResultSetTxType();
            if (!(this.stmt instanceof IfxPreparedStatement) || ((IfxSqliConnect)this.conn).usePut) break block7;
            Vector vector = ((IfxSqliConnect)this.conn).isBatchUpdatePerSpec() && this.stmt.executeBatchInProgress ? ((IfxPreparedStatement)this.stmt).getBatchParamVector() : ((IfxPreparedStatement)this.stmt).getVector();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                short s;
                IfxSmBlob ifxSmBlob;
                block9: {
                    block8: {
                        IfxObject ifxObject = (IfxObject)vector.elementAt(i);
                        if (!(ifxObject instanceof IfxSmBlob)) continue;
                        ifxSmBlob = (IfxSmBlob)ifxObject;
                        s = ifxSmBlob.blobType;
                        if (ifxSmBlob.sm_size < 0L) continue;
                        if (s == 2) break block8;
                        if (s != 1) break block9;
                    }
                    ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobInputStream, (int)ifxSmBlob.sm_size);
                    continue;
                }
                if (s != 3) continue;
                ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobCharInputStream, (int)ifxSmBlob.sm_size);
            }
        }
        this.prot.executeCommand(this.stmt);
        this.curRowID = 0;
        this.lastRowID = 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeUpdate() exited");
        }
        return this.prot.getNumberOfRowsProcessed();
    }

    Vector executeFastPath(String string, ResultSetMetaData resultSetMetaData, Vector vector, boolean bl, boolean bl2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeFastPath() called");
        }
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.clearWarnings();
        this.setResultSetTxType();
        ((IfxSqli)this.prot).executeFastPath(string, resultSetMetaData, vector, bl, bl2);
        this.curRowID = 0;
        this.lastRowID = 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeFastPath() exited");
        }
        return this.prot.getFPReturnVector();
    }

    IfxFParam getFParam() {
        return this.prot.getFParam();
    }

    boolean executeExecute(boolean bl) throws SQLException {
        block7: {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(1, "IfxResultSet.executeExecute() called");
            }
            if (this.prot == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
            this.clearWarnings();
            this.setResultSetTxType();
            if (!(this.stmt instanceof IfxPreparedStatement) || ((IfxSqliConnect)this.conn).usePut) break block7;
            Vector vector = ((IfxPreparedStatement)this.stmt).getVector();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                short s;
                IfxSmBlob ifxSmBlob;
                block9: {
                    block8: {
                        IfxObject ifxObject = (IfxObject)vector.elementAt(i);
                        if (!(ifxObject instanceof IfxSmBlob)) continue;
                        ifxSmBlob = (IfxSmBlob)ifxObject;
                        s = ifxSmBlob.blobType;
                        if (ifxSmBlob.sm_size < 0L) continue;
                        if (s == 2) break block8;
                        if (s != 1) break block9;
                    }
                    ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobInputStream, (int)ifxSmBlob.sm_size);
                    continue;
                }
                if (s != 3) continue;
                ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobCharInputStream, (int)ifxSmBlob.sm_size);
            }
        }
        this.prot.executeExecute(this.stmt, bl);
        this.curRowID = 0;
        this.lastRowID = 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeExecute() exited");
        }
        return this.prot.isResultSet();
    }

    boolean executeExecute(boolean bl, IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        block7: {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(1, "IfxResultSet.executeExecute() called");
            }
            if (this.prot == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
            this.clearWarnings();
            this.setResultSetTxType();
            if (!(this.stmt instanceof IfxPreparedStatement) || ((IfxSqliConnect)this.conn).usePut) break block7;
            Vector vector = ((IfxPreparedStatement)this.stmt).getVector();
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                short s;
                IfxSmBlob ifxSmBlob;
                block9: {
                    block8: {
                        IfxObject ifxObject = (IfxObject)vector.elementAt(i);
                        if (!(ifxObject instanceof IfxSmBlob)) continue;
                        ifxSmBlob = (IfxSmBlob)ifxObject;
                        s = ifxSmBlob.blobType;
                        if (ifxSmBlob.sm_size < 0L) continue;
                        if (s == 2) break block8;
                        if (s != 1) break block9;
                    }
                    ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobInputStream, (int)ifxSmBlob.sm_size);
                    continue;
                }
                if (s != 3) continue;
                ifxSmBlob.createBlobOnServer(ifxSmBlob.BlobCharInputStream, (int)ifxSmBlob.sm_size);
            }
        }
        this.prot.executeExecute(this.stmt, bl, ifxResultSetMetaData);
        this.curRowID = 0;
        this.lastRowID = 0;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeExecute() exited");
        }
        return this.prot.isResultSet();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean next() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.prot == null) {
            return false;
        }
        if (this.lastRowID == -1) {
            return false;
        }
        if (this.lastRowID != 0 && this.curRowID >= this.lastRowID) {
            if (this.curRowID == this.lastRowID) {
                ++this.curRowID;
            }
            return false;
        }
        var1_1 = this.stmt.getMaxRows();
        if (var1_1 != 0 && this.curRowID >= var1_1) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "ResultSet.next(): exceed maxRows", var1_1);
            }
            this.lastRowID = var1_1;
            this.curRowID = this.lastRowID + 1;
            return false;
        }
        v0 = var2_2 = this.stmt.getResultSetType() == 1004 ? 1 : 0;
        if (var2_2 == 1) {
            this.scrollableEmptyResultSet = false;
            var3_3 = this.prot.getaRow(this.stmt.getFetchDirection(), ++this.curRowID, 1, var2_2, this.stmt);
            if (!var3_3) {
                if (this.curRowID - 1 == 0 && this.lastRowID == 0) {
                    this.scrollableEmptyResultSet = true;
                }
                this.lastRowID = this.curRowID - 1;
            }
        } else {
            var3_3 = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 1, var2_2, this.stmt);
        }
        if (!var3_3) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "ResultSet.next(): tuple is null");
            }
            return false;
        }
        if (this.colVector == null) {
            try {
                this.colVector = new Vector<E>();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) ** GOTO lbl55
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) ** GOTO lbl55
                this.UpdateColVector = (Vector)this.colVector.clone();
                if (!TraceFlag.compiletrace) ** GOTO lbl55
                this.trace.writeTrace(3, "cloning UpdateColVector");
            }
            catch (SQLException var4_4) {
                throw var4_4;
            }
            catch (Exception var4_5) {
                var5_6 = IfxErrMsg.getSQLException(-79716, var4_5.toString(), this.conn);
                var5_6 = IfxErrMsg.setSQLExceptionCause(var5_6, var4_5);
                throw var5_6;
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() == 1008) {
                this.clearUpdateColVector();
            }
        }
lbl55:
        // 7 sources

        if (var2_2 != 1) {
            ++this.curRowID;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "ResultSet.next(): curRowID ", this.curRowID);
            this.trace.writeTrace(1, "IfxResultSet.next() exited");
        }
        return true;
    }

    @Override
    public int findColumn(String string) throws SQLException {
        Integer n;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.findColumn() called " + string);
        }
        if (this.nameToIdxTable == null) {
            if (this.rsmd == null) {
                this.getMetaData();
            }
            if (this.rsmd == null) {
                throw IfxErrMsg.getSQLException(-79737, this.conn);
            }
            int n2 = this.rsmd.getColumnCount();
            this.nameToIdxTable = new HashMap(n2);
            for (int i = 1; i <= n2; ++i) {
                this.nameToIdxTable.put(this.rsmd.getColumnName(i), i);
            }
        }
        if (!this.conn.isDelimIdentSet()) {
            if (this.conn != null && this.conn.isDirect()) {
                string = string.trim();
            }
            n = this.nameToIdxTable.get(string.toLowerCase());
        } else {
            n = this.nameToIdxTable.get(string);
        }
        if (n == null) {
            throw IfxErrMsg.getSQLException(-79738, this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.findColumn() exited");
        }
        return n;
    }

    IfxObject getValue(int n) throws SQLException {
        return this.getValue(n, null);
    }

    IfxObject getValue(int n, Calendar calendar) throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79868, this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getValue(int, Calendar) called");
        }
        if (this.colVector == null) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (n < 1 || n > this.colVector.size()) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        IfxObject ifxObject = this.colVector.elementAt(n - 1);
        if (ifxObject == null) {
            ifxObject = this.prot instanceof IfxSqli ? ((IfxSqli)this.prot).getColumnInRow(n, calendar) : this.prot.getColumnInRow(n);
            this.colVector.setElementAt(ifxObject, n - 1);
        } else {
            if (calendar != null && ifxObject instanceof IfxDateTime) {
                ((IfxDateTime)ifxObject).dbCalendar = calendar;
            }
            this.prot.loadColumnData(n, ifxObject);
        }
        if (ifxObject.isNull()) {
            this.lastColWasNull = true;
            return null;
        }
        this.lastColWasNull = false;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getValue() exited");
        }
        this.blobCheck(ifxObject);
        return ifxObject;
    }

    IfxObject getValueFastPath(int n) throws SQLException {
        IfxObject ifxObject = this.prot.getColumnInRow(n);
        return ifxObject;
    }

    @Override
    public String getString(int n) throws SQLException {
        String string;
        Object object;
        IfxObject ifxObject = this.getValue(n);
        IfxSqliConnect cfr_ignored_0 = (IfxSqliConnect)this.conn;
        IfxSqliConnect.GclEnv = true;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getString(int) called. ColumnIndex: ", n);
        }
        if (ifxObject == null) {
            return null;
        }
        if (ifxObject.getClass().getName().endsWith("IfxSmBlob")) {
            object = ((IfxSmBlob)ifxObject).toClob(4);
            string = object.getSubString(1L, (int)object.length());
            ((IfxLob)object).close();
        } else {
            string = ifxObject.toString();
            if (this.stmt != null) {
                int n2 = this.stmt.getMaxFieldSize();
                if (n2 > 0) {
                    int n3 = this.rsmd.getColumnType(n);
                    if (string.length() > n2 && (n3 == 1 || n3 == 12 || n3 == -1 || n3 == -2 || n3 == -3 || n3 == -4)) {
                        string = string.substring(0, n2);
                    }
                }
                if (this.conn.isITF()) {
                    if (ifxObject instanceof IfxIntervalDF) {
                        float f = 1.0E9f;
                        double d = 86400.0;
                        double d2 = ((IfxIntervalDF)ifxObject).value().getSeconds();
                        double d3 = ((IfxIntervalDF)ifxObject).value().getNanoSeconds();
                        double d4 = d3 / (double)f;
                        d4 = (d2 + d4) / d;
                        float f2 = Float.parseFloat(String.valueOf(d4));
                        string = String.valueOf(f2);
                    } else {
                        string = ifxObject.toString();
                    }
                } else {
                    string = ifxObject.toString();
                }
            }
        }
        object = ifxObject.getWarning();
        if (object != null) {
            this.prot.chainWarnings(new DataTruncation(n, false, true, ((DataTruncation)object).getDataSize(), ((DataTruncation)object).getTransferSize()));
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getString() exited.");
        }
        return string;
    }

    @Override
    public String getString(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getString(n);
    }

    @Override
    public Object getObject(int n) throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getObject(int) called. ColumnIndex: ", n);
        }
        Object object = null;
        if (this.conn != null) {
            object = this.getObject(n, this.conn.getTypeMap());
        } else {
            Map<String, Class<?>> map = null;
            object = this.getObject(n, map);
        }
        return object;
    }

    @Override
    public Object getObject(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n);
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getAsciiStream() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        InputStream inputStream = ifxObject.extendedID == 11 && ((IfxSqliConnect)this.conn).isConvText() ? ((IfxSqli)this.prot).toClobStream((IfxSmBlob)ifxObject) : ifxObject.toAsciiStream();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getAsciiStream() exited.");
        }
        return inputStream;
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getAsciiStream(n);
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getCharacterStream() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Reader reader = ifxObject.toCharacterStream();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getCharacterStream() exited.");
        }
        return reader;
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getCharacterStream(n);
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getBigDecimal() called. ColumnIndex", n);
            this.trace.writeTrace(1, "IfxResultSet.getBigDecimal() called. Scale", n2);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        BigDecimal bigDecimal = ifxObject.toDecimal().setScale(n2, 4);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getBigDecimal() exited.");
        }
        return bigDecimal;
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        int n2 = this.findColumn(string);
        return this.getBigDecimal(n2, n);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getBigDecimal() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        return ifxObject.toDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBigDecimal(n);
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getBoolean() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return false;
        }
        boolean bl = ifxObject.toBoolean();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getBoolean() exited");
        }
        return bl;
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBoolean(n);
    }

    @Override
    public short getShort(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getShort() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        short s = ifxObject.toShort();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "short value", s);
            this.trace.writeTrace(1, "IfxResultSet.getShort() exited");
        }
        return s;
    }

    @Override
    public short getShort(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getShort(n);
    }

    @Override
    public int getInt(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getInt() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        int n2 = ifxObject.toInt();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getInt() exited");
        }
        return n2;
    }

    @Override
    public int getInt(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInt(n);
    }

    @Override
    public long getLong(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getLong() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return 0L;
        }
        long l = ifxObject.toLong();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getLong() exited");
        }
        return l;
    }

    @Override
    public long getLong(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getLong(n);
    }

    @Override
    public float getFloat(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getFloat() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return 0.0f;
        }
        float f = 0.0f;
        if (this.conn.isITF()) {
            if (ifxObject instanceof IfxIntervalDF) {
                float f2 = 1.0E9f;
                double d = 86400.0;
                double d2 = ((IfxIntervalDF)ifxObject).value().getSeconds();
                double d3 = ((IfxIntervalDF)ifxObject).value().getNanoSeconds();
                double d4 = d3 / (double)f2;
                d4 = (d2 + d4) / d;
                f = Float.parseFloat(String.valueOf(d4));
            } else {
                f = ifxObject.toFloat();
            }
        } else {
            f = ifxObject.toFloat();
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getFloat() exited");
        }
        return f;
    }

    @Override
    public float getFloat(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getFloat(n);
    }

    @Override
    public byte getByte(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getByte() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return 0;
        }
        byte by = ifxObject.toByte();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getByte() exited");
        }
        return by;
    }

    @Override
    public byte getByte(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getByte(n);
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getBytes() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        byte[] byArray = ifxObject.toBytes();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getBytes() exited");
        }
        return byArray;
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBytes(n);
    }

    @Override
    public Date getDate(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getDate() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Date date = ifxObject.toDate();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getDate() exited");
        }
        return date;
    }

    @Override
    public Date getDate(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getDouble() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return 0.0;
        }
        double d = ifxObject.toDouble();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getDouble() exited");
        }
        return d;
    }

    @Override
    public double getDouble(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getDouble(n);
    }

    @Override
    public Time getTime(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getTime() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Time time = ifxObject.toTime();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getTime() exited");
        }
        return time;
    }

    @Override
    public Time getTime(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getTimestamp() called. ColumnIndex", n);
        }
        return this.getTimestamp(n, (Calendar)null);
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        IfxObject ifxObject = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getTimestamp() called. ColumnIndex,cal", n);
        }
        if ((ifxObject = this.getValue(n, calendar)) == null || ifxObject.isNull()) {
            return null;
        }
        ifxObject.setConnection(this.conn);
        Timestamp timestamp = ifxObject.toTimestamp();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getTimestmap() exited");
        }
        return timestamp;
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(int).", this.conn);
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getUnicodeStream(String).", this.conn);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getBinaryStream() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        InputStream inputStream = ifxObject.toBinaryStream();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getBinaryStream() exited");
        }
        return inputStream;
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBinaryStream(n);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.prot != null) {
            return this.prot.getWarnings();
        }
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        if (this.prot != null) {
            this.prot.clearWarnings();
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        if (this.stmt == null) {
            throw IfxErrMsg.getSQLException(-79740, this.conn);
        }
        return this.stmt.getCursorName();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        this.rsmd = (IfxResultSetMetaData)this.prot.getMetaData();
        return this.rsmd;
    }

    @Override
    public Object getObject(int n, Map<String, Class<?>> map) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        Object object = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getObject(int, Map) entered.");
        }
        if (ifxObject != null && !ifxObject.isNull()) {
            if (ifxObject instanceof IfxBSONObject && !map.containsKey("bson")) {
                map.put("bson", ifxObject.getClass());
            } else if (ifxObject instanceof IfxJSON && !map.containsKey("json")) {
                map.put("json", ifxObject.getClass());
            }
            ifxObject.setTypeMap(map);
            object = ifxObject.toObject();
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getObject() exited.");
        }
        return object;
    }

    public Object getObject(String string, Map map) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getObject(String, Map) called.");
        }
        int n = this.findColumn(string);
        return this.getObject(n, map);
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.lastColWasNull;
    }

    int getUpdateCount() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        if (this.isClosed() || this.prot.isResultSet()) {
            return -1;
        }
        return this.prot.getNumberOfRowsProcessed();
    }

    @Override
    public void close() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.close() called");
        }
        this.isClosed = true;
        if (this.prot != null && this.stmt.cursorOpen) {
            this.prot.executeClose(this.stmt);
        }
        if (!(this.stmt instanceof IfxPreparedStatement) && !(this.stmt instanceof IfxCallableStatement)) {
            this.closePrev();
        } else {
            this.clear();
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.close() exited");
        }
    }

    void clear() throws SQLException {
        if (this.nameToIdxTable != null) {
            this.nameToIdxTable.clear();
            this.nameToIdxTable = null;
        }
        this.lastColWasNull = false;
        this.curRowID = 0;
        this.lastRowID = 0;
        this.clearColumnVector();
        if (this.colVector != null) {
            this.colVector.removeAllElements();
            this.colVector = null;
        }
        if (this.keyNameVector != null) {
            this.keyNameVector.removeAllElements();
            this.keyNameVector = null;
        }
        if (this.WhereVal != null) {
            this.WhereVal.removeAllElements();
            this.WhereVal = null;
        }
        if (((IfxSqliConnect)this.conn).freeclobwithrs) {
            try {
                if (((IfxSqliConnect)this.conn).fileList != null) {
                    ((IfxSqliConnect)this.conn).deleteAllFiles();
                }
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), (IfxConnection)((IfxSqliConnect)this.conn));
            }
        }
    }

    void closePrev() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxResultSet.closePrev() called");
        }
        if (this.prot != null) {
            this.prot.executeRelease(this.stmt);
        }
        this.clear();
        if (this.UpdateColVector != null) {
            this.UpdateColVector.removeAllElements();
            this.UpdateColVector = null;
        }
    }

    private void clearColumnVector() {
        if (this.colVector != null) {
            int n = this.colVector.size();
            for (int i = 0; i < n; ++i) {
                IfxObject ifxObject = this.colVector.elementAt(i);
                if (ifxObject == null) continue;
                ifxObject.clear();
            }
        }
    }

    void closeNow() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxResultSet.closeNow() called");
        }
        this.clear();
        this.prot = null;
        this.stmt = null;
        if (this.UpdateColVector != null) {
            this.UpdateColVector.removeAllElements();
            this.UpdateColVector = null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxResultSet.closeNow() exited");
        }
    }

    protected void blobCheck(IfxObject ifxObject) throws SQLException {
        if (ifxObject instanceof IfxBlob) {
            IfxBlob ifxBlob = (IfxBlob)ifxObject;
            if (!ifxBlob.isBlobLoaded()) {
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(99, "IfxResultSet.IfxBlob() : - 1");
                }
                try {
                    this.prot.executeFetchBlob(ifxBlob);
                }
                catch (Exception exception) {
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(1, "IfxResultSet.blobCheck() : " + exception.getMessage());
                    }
                    SQLException sQLException = IfxErrMsg.getSQLException(-79701, this.conn);
                    if (exception instanceof SQLException) {
                        sQLException.setNextException((SQLException)exception);
                    }
                    sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
                    throw sQLException;
                }
                ifxBlob.setLoaded();
            } else if (TraceFlag.compiletrace) {
                this.trace.writeTrace(99, "IfxResultSet.IfxBlob() : - 2");
            }
        }
    }

    int getSerial() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.getSerialInsert();
    }

    long getSerial8() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.getSerial8Inserted();
    }

    @Override
    public Interval getInterval(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getInterval() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Interval interval = ifxObject.toInterval();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getInterval() exited");
        }
        return interval;
    }

    @Override
    public Interval getInterval(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getInterval(n);
    }

    @Override
    public IntervalYM getIntervalYM(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getIntervalYM() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        IntervalYM intervalYM = ifxObject.toIntervalYM();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getIntervalYM() exited");
        }
        return intervalYM;
    }

    @Override
    public IntervalYM getIntervalYM(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getIntervalYM(n);
    }

    @Override
    public IntervalDF getIntervalDF(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getIntervalDF() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        IntervalDF intervalDF = ifxObject.toIntervalDF();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getIntervalDF() exited");
        }
        return intervalDF;
    }

    @Override
    public IntervalDF getIntervalDF(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getIntervalDF(n);
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    boolean isAccessible() {
        Xid xid;
        if (!this.conn.inXATransaction() && this.connectXid == null) {
            return true;
        }
        return this.conn.inXATransaction() && this.connectXid != null && IfxXid.equals(this.connectXid, xid = ((IfxXAReusableConnection)this.conn).getCurrentXid());
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxResultSet.isBeforeFirst() called");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.curRowID > 0 || this.lastRowID == -1) {
            return false;
        }
        int n = ((IfxSqli)this.prot).getNumberOfTuplesReceived();
        int n2 = ((IfxSqli)this.prot).getNumberOfFetches();
        if (n == 0 && n2 == 0 && this.first()) {
            this.previous();
        }
        if (((IfxSqli)this.prot).getNumberOfTuplesReceived() == 0) {
            this.lastRowID = -1;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxResultSet.isAfterLast() called");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.curRowID < 1 || this.lastRowID < 1) {
            return false;
        }
        return this.curRowID == this.lastRowID + 1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxResultSet.isFirst() called");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        return this.lastRowID > -1 && this.curRowID == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxResultSet.isLast() called");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.lastRowID == -1) {
            return false;
        }
        if (this.lastRowID == 0) {
            int n = this.curRowID;
            boolean bl = this.last();
            this.lastRowID = this.curRowID;
            if (n == 0) {
                this.curRowID = 0;
            } else {
                bl = this.absolute(n);
            }
        }
        return this.curRowID > 0 && this.curRowID == this.lastRowID;
    }

    @Override
    public void beforeFirst() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxResultSet.beforeFirst() called");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        if (this.curRowID == 0) {
            return;
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        this.curRowID = 0;
        if (this.absolute(1)) {
            this.previous();
        }
    }

    @Override
    public void afterLast() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxResultSet.afterLast() called");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.lastRowID != 0) {
            this.curRowID = this.lastRowID + 1;
        } else {
            if (((IfxSqli)this.prot).getNumberOfFetches() != 0 && ((IfxSqli)this.prot).getNumberOfTuplesReceived() == 0) {
                this.lastRowID = -1;
                return;
            }
            boolean bl = this.last();
            if (bl) {
                this.curRowID = this.lastRowID + 1;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean first() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.first() called");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.lastRowID < 0) {
            return false;
        }
        var1_1 = this.prot.getaRow(this.stmt.getFetchDirection(), 1, 6, 1, this.stmt);
        if (!var1_1) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "ResultSet.first(): tuple is null");
            }
            this.lastRowID = -1;
            return false;
        }
        this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector<E>();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) ** GOTO lbl37
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) ** GOTO lbl37
                this.UpdateColVector = (Vector)this.colVector.clone();
                if (!TraceFlag.compiletrace) ** GOTO lbl37
                this.trace.writeTrace(3, "cloning UpdateColVector");
            }
            catch (SQLException var2_2) {
                throw var2_2;
            }
            catch (Exception var2_3) {
                throw IfxErrMsg.getSQLException(-79716, var2_3.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() == 1008) {
                this.clearUpdateColVector();
            }
        }
lbl37:
        // 7 sources

        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.first() exited");
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean last() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.last() called");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        var1_1 = false;
        if (this.lastRowID == -1) {
            return false;
        }
        var1_1 = this.lastRowID == 0 ? this.prot.getaRow(this.stmt.getFetchDirection(), 0, 4, 1, this.stmt) : this.prot.getaRow(this.stmt.getFetchDirection(), this.lastRowID, 6, 1, this.stmt);
        if (!var1_1) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "ResultSet.last(): tuple is null");
            }
            this.lastRowID = -1;
            return false;
        }
        this.lastRowID = this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector<E>();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) ** GOTO lbl38
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) ** GOTO lbl38
                this.UpdateColVector = (Vector)this.colVector.clone();
                if (!TraceFlag.compiletrace) ** GOTO lbl38
                this.trace.writeTrace(3, "cloning UpdateColVector");
            }
            catch (SQLException var2_2) {
                throw var2_2;
            }
            catch (Exception var2_3) {
                throw IfxErrMsg.getSQLException(-79716, var2_3.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() == 1008) {
                this.clearUpdateColVector();
            }
        }
lbl38:
        // 7 sources

        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.last() exited");
        }
        return true;
    }

    @Override
    public int getRow() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getRow() called");
        }
        if (this.scrollableEmptyResultSet) {
            return 0;
        }
        if (this.lastRowID > 0 && this.curRowID > this.lastRowID) {
            return 0;
        }
        return this.curRowID;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean absolute(int var1_1) throws SQLException {
        var2_2 = false;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.absolute() called");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (var1_1 == 0) {
            this.beforeFirst();
            return false;
        }
        if (this.lastRowID == -1) {
            return false;
        }
        if (var1_1 > 0) {
            if (this.lastRowID > 0 && var1_1 > this.lastRowID) {
                this.afterLast();
                return false;
            }
            var2_2 = this.prot.getaRow(this.stmt.getFetchDirection(), var1_1, 6, 1, this.stmt);
        } else if (var1_1 < 0) {
            if (this.lastRowID == 0 && !this.last()) {
                return false;
            }
            this.curRowID = this.lastRowID + var1_1 + 1;
            if (this.curRowID < 1) {
                this.curRowID = 0;
                return false;
            }
            var2_2 = this.prot.getaRow(this.stmt.getFetchDirection(), this.curRowID, 6, 1, this.stmt);
        }
        if (!var2_2) {
            this.afterLast();
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "ResultSet.next(): tuple is null");
            }
            return false;
        }
        this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector<E>();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) ** GOTO lbl54
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) ** GOTO lbl54
                this.UpdateColVector = (Vector)this.colVector.clone();
                if (!TraceFlag.compiletrace) ** GOTO lbl54
                this.trace.writeTrace(3, "cloning UpdateColVector");
            }
            catch (SQLException var3_3) {
                throw var3_3;
            }
            catch (Exception var3_4) {
                throw IfxErrMsg.getSQLException(-79716, var3_4.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() == 1008) {
                this.clearUpdateColVector();
            }
        }
lbl54:
        // 7 sources

        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.absolute() exited");
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean relative(int var1_1) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.relative() called");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        if (var1_1 == 0) {
            return true;
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.curRowID == 0) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        if (this.lastRowID > 0 && this.curRowID > this.lastRowID) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        var2_2 = this.curRowID + var1_1;
        if (var2_2 < 1) {
            this.beforeFirst();
            return false;
        }
        if (this.lastRowID > 0 && var2_2 > this.lastRowID) {
            this.afterLast();
            return false;
        }
        var3_3 = this.prot.getaRow(this.stmt.getFetchDirection(), var2_2, 6, 1, this.stmt);
        if (!var3_3) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "ResultSet.relative(): tuple is null");
            }
            this.afterLast();
            return false;
        }
        this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector<E>();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) ** GOTO lbl48
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) ** GOTO lbl48
                this.UpdateColVector = (Vector)this.colVector.clone();
                if (!TraceFlag.compiletrace) ** GOTO lbl48
                this.trace.writeTrace(3, "cloning UpdateColVector");
            }
            catch (SQLException var4_4) {
                throw var4_4;
            }
            catch (Exception var4_5) {
                throw IfxErrMsg.getSQLException(-79716, var4_5.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() == 1008) {
                this.clearUpdateColVector();
            }
        }
lbl48:
        // 7 sources

        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.relative() exited");
        }
        return true;
    }

    public boolean current() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.current() called");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        return this.curRowID != 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean previous() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.previous() called");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79878, this.conn);
        }
        if (!this.isAccessible()) {
            throw IfxErrMsg.getSQLException(-259, this.conn);
        }
        this.clearWarnings();
        if (this.stmt.getResultSetType() == 1003) {
            throw IfxErrMsg.getSQLException(-79767, this.conn);
        }
        if (this.lastRowID < 0 || this.curRowID <= 0) {
            return false;
        }
        this.curRowID += -1;
        var1_1 = this.prot.getaRow(this.stmt.getFetchDirection(), this.curRowID, 6, 1, this.stmt);
        if (!var1_1) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "ResultSet.previous(): tuple is null");
            }
            return false;
        }
        this.curRowID = this.prot.getTupid();
        if (this.colVector == null) {
            try {
                this.colVector = new Vector<E>();
                this.colVector.setSize(this.getMetaData().getColumnCount());
                if (this.stmt.getResultSetConcurrency() != 1008) ** GOTO lbl37
                this.MoveToInsert = false;
                if (this.UpdateColVector != null) ** GOTO lbl37
                this.UpdateColVector = (Vector)this.colVector.clone();
                if (!TraceFlag.compiletrace) ** GOTO lbl37
                this.trace.writeTrace(3, "cloning UpdateColVector");
            }
            catch (SQLException var2_2) {
                throw var2_2;
            }
            catch (Exception var2_3) {
                throw IfxErrMsg.getSQLException(-79716, var2_3.toString(), this.conn);
            }
        } else {
            this.clearColumnVector();
            if (this.stmt.getResultSetConcurrency() == 1008) {
                this.clearUpdateColVector();
            }
        }
lbl37:
        // 7 sources

        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.previous() exited");
        }
        return true;
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        this.stmt.setFetchDirection(n);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(99, "IfxResultSet:setFetchSize()");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79868, this.conn);
        }
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79700, ": ResultSet.setFetchSize(int).", this.conn);
        }
        this.fetchSize = n;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxStatement:getFetchSize()");
        }
        if (this.isClosed) {
            throw IfxErrMsg.getSQLException(-79868, this.conn);
        }
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getType()");
        }
        return this.stmt.getResultSetType();
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getConcurrency()");
        }
        return this.stmt.getResultSetConcurrency();
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.stmt;
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getRef(int).", this.conn);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getBlob() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        Blob blob = ifxObject.toBlob();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getBlob() exited.");
        }
        return blob;
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        Clob clob;
        IfxObject ifxObject = this.getValue(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getClob() called. ColumnIndex", n);
        }
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        int n2 = this.rsmd.getColumnType(n);
        if (n2 == -1 && ifxObject instanceof IfxLvarchar) {
            IfxLvarchar ifxLvarchar = (IfxLvarchar)ifxObject;
            byte[] byArray = ifxLvarchar.toBytes();
            IfxLobDescriptor ifxLobDescriptor = new IfxLobDescriptor(this.conn);
            IfxLocator ifxLocator = new IfxLocator();
            IfxSmartBlob ifxSmartBlob = new IfxSmartBlob(this.conn);
            int n3 = ifxSmartBlob.IfxLoCreate(ifxLobDescriptor, 8, ifxLocator);
            ifxSmartBlob.IfxLoWrite(n3, byArray);
            ifxSmartBlob.IfxLoClose(n3);
            IfxCblob ifxCblob = new IfxCblob(this.conn, ifxLocator);
            ifxCblob.setSize(byArray.length);
            clob = ifxCblob;
        } else {
            clob = ifxObject.toClob();
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getClob() exited.");
        }
        return clob;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        IfxCollection ifxCollection = (IfxCollection)this.getValue(n);
        Array array = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getArray(int) entered.");
        }
        if (ifxCollection != null && !ifxCollection.isNull()) {
            array = ifxCollection.toArray();
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.getArray() exited.");
        }
        return array;
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": ResultSet.getRef(String).", this.conn);
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getBlob(n);
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getClob(n);
    }

    @Override
    public Array getArray(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getArray(n);
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        Date date = this.getDate(n);
        if (date == null) {
            return null;
        }
        Calendar calendar2 = Calendar.getInstance();
        if (calendar == null) {
            calendar = calendar2;
        }
        calendar2.setTime(date);
        long l = date.getTime();
        long l2 = l + (long)(calendar2.get(15) + calendar2.get(16));
        long l3 = l2 - (long)(calendar.get(15) + calendar.get(16));
        return new Date(l3);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getDate(n, calendar);
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        Time time = this.getTime(n);
        if (time == null) {
            return null;
        }
        long l = time.getTime() + (long)calendar.get(15) + (long)calendar.get(16);
        return new Time(l);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTime(n, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        int n = this.findColumn(string);
        return this.getTimestamp(n, calendar);
    }

    private void getRSPKeys(String string, boolean bl, boolean bl2) throws SQLException {
        Object object;
        int n;
        int n2;
        String string2 = null;
        ResultSet resultSet = null;
        DatabaseMetaData databaseMetaData = this.conn.getMetaData();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "ResultSet.getRSPKeys entered");
        }
        int n3 = string.indexOf(58);
        int n4 = string.indexOf(46);
        if (n3 < 0 && n4 < 0 || n3 == 0 || n4 == 0 || n4 + 1 == string.length() || n3 + 1 == string.length() || n4 > 0 && n3 + 1 >= n4) {
            string5 = string;
        } else {
            int n5 = 0;
            if (n3 > 0) {
                string3 = string.substring(0, n3);
                n5 = n3 + 1;
            }
            if (n4 > 0) {
                string4 = string.substring(n5, n4);
                n5 = n4 + 1;
            }
            string5 = string.substring(n5);
        }
        if (!bl) {
            int n6;
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("insert into ").append(string).append("(");
            boolean bl3 = false;
            int n7 = 0;
            for (n6 = 0; n6 < this.UpdateColVector.size(); ++n6) {
                IfxObject ifxObject = (IfxObject)this.UpdateColVector.elementAt(n6);
                if (ifxObject == null || !ifxObject.get_used_in_update()) continue;
                if (bl3) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(this.rsmd.getColumnName(n6 + 1));
                bl3 = true;
                ++n7;
            }
            stringBuffer.append(") values (");
            bl3 = false;
            for (n6 = 0; n6 < n7; ++n6) {
                if (bl3) {
                    stringBuffer.append(",");
                }
                stringBuffer.append("?");
                bl3 = true;
            }
            stringBuffer.append(");");
            this.insertCmd = stringBuffer.toString();
            return;
        }
        if (this.keyNameVector == null) {
            this.keyNameVector = new Vector();
            this.WhereVal = new Vector();
            if (this.rsmd.findrowid() != -1) {
                this.keyNameVector.add("rowid");
                this.WhereVal.add(this.getValue(this.rsmd.rowidx));
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "found rowid");
                }
            } else {
                string2 = this.rsmd.findserial();
                if (string2 != null) {
                    this.keyNameVector.add(string2);
                    this.WhereVal.add(this.getValue(this.rsmd.serialidx));
                    if (TraceFlag.compiletrace) {
                        this.trace.writeTrace(3, "found serial");
                    }
                } else {
                    resultSet = databaseMetaData.getPrimaryKeys(string3, string4, string5);
                    if (resultSet != null) {
                        while (resultSet.next()) {
                            String string6 = resultSet.getString(4);
                            this.keyNameVector.add(string6);
                            n2 = this.findColumn(string6);
                            this.WhereVal.add(this.getValue(n2));
                        }
                        resultSet.close();
                        if (TraceFlag.compiletrace) {
                            this.trace.writeTrace(3, "found primary key");
                        }
                    }
                }
            }
            if (this.keyNameVector.size() == 0) {
                throw IfxErrMsg.getSQLException(-79817, this.conn);
            }
        } else {
            this.WhereVal.removeAllElements();
            if (this.rsmd.rowidx != -1) {
                this.WhereVal.add(this.getValue(this.rsmd.rowidx));
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "found rowid");
                }
            } else if (this.rsmd.serialidx != -1) {
                this.WhereVal.add(this.getValue(this.rsmd.serialidx));
                if (TraceFlag.compiletrace) {
                    this.trace.writeTrace(3, "found serial");
                }
            } else {
                for (n = 0; n < this.keyNameVector.size(); ++n) {
                    String string7 = this.keyNameVector.elementAt(n);
                    n2 = this.findColumn(string7);
                    this.WhereVal.add(this.getValue(n2));
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        n2 = 0;
        stringBuffer.append("update ").append(string).append(" set ");
        for (n = 0; n < this.UpdateColVector.size(); ++n) {
            object = (IfxObject)this.UpdateColVector.elementAt(n);
            if (object == null || !((IfxObject)object).get_used_in_update()) continue;
            if (n2 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.rsmd.getColumnName(n + 1)).append(" = ? ");
            n2 = 1;
        }
        object = new StringBuffer(200);
        ((StringBuffer)object).append("delete from ").append(string).append(" ");
        StringBuffer stringBuffer2 = new StringBuffer(200);
        stringBuffer2.append("where ");
        if (bl2) {
            stringBuffer2.append("current of " + this.stmt.getCursorName() + " ;");
        } else {
            for (n = 0; n < this.keyNameVector.size(); ++n) {
                stringBuffer2.append(this.keyNameVector.elementAt(n)).append(" = ?");
                if (n < this.keyNameVector.size() - 1) {
                    stringBuffer2.append(" and ");
                    continue;
                }
                stringBuffer2.append(" ");
            }
            stringBuffer2.append(";");
        }
        ((StringBuffer)object).append(stringBuffer2.toString());
        stringBuffer.append(stringBuffer2.toString());
        this.updateCmd = stringBuffer.toString();
        this.deleteCmd = ((StringBuffer)object).toString();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "updateCmd is ", this.updateCmd);
            this.trace.writeTrace(3, "deleteCmd is ", this.deleteCmd);
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "ResultSet.getRSPKeys exited");
        }
    }

    private void validateUpdateCall(boolean bl) throws SQLException {
        String string = null;
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "ResultSet.validate_update_call entered");
        }
        if (this.stmt.getResultSetConcurrency() != 1008) {
            throw IfxErrMsg.getSQLException(-79818, this.conn);
        }
        if (this.UpdateColVector == null || this.updatecanceled) {
            throw IfxErrMsg.getSQLException(-79739, this.conn);
        }
        string = this.stmt != null ? IfxResultSetMetaData.parseTableName(this.stmt.commandString) : this.rsmd.getTableName(1);
        if (string == null) {
            throw IfxErrMsg.getSQLException(-79816, this.conn);
        }
        this.isForUpdateClause = false;
        String string2 = this.stmt.commandString.toUpperCase().trim();
        if (string2 != null && string2.startsWith("SELECT")) {
            if (string2.endsWith(";")) {
                string2 = string2.substring(0, string2.indexOf(";"));
            }
            this.isForUpdateClause = string2.endsWith("FOR UPDATE");
        }
        this.getRSPKeys(string, bl, this.isForUpdateClause);
        this.updatecanceled = false;
    }

    @Override
    public void insertRow() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "ResultSet.insertRow entered");
        }
        if (!this.MoveToInsert) {
            throw IfxErrMsg.getSQLException(-79815, this.conn);
        }
        this.validateUpdateCall(false);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "insertCmd is ", this.insertCmd);
        }
        super.insertRow();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "ResultSet.insertRow exited");
        }
    }

    @Override
    public void updateRow() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "ResultSet.updateRow entered");
        }
        if (this.MoveToInsert) {
            throw IfxErrMsg.getSQLException(-79819, this.conn);
        }
        this.validateUpdateCall(true);
        super.updateRow();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "ResultSet.updateRow exited");
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "ResultSet.deleteRow entered");
        }
        if (this.MoveToInsert) {
            throw IfxErrMsg.getSQLException(-79819, this.conn);
        }
        this.validateUpdateCall(true);
        super.deleteRow();
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "ResultSet.deleteRow exited");
        }
    }

    int getTupleBufferSize() {
        return ((IfxSqli)this.prot).getTupleBufferSize(0);
    }

    int getTupleSize() throws SQLException {
        return ((IfxSqli)this.prot).getTupleSize();
    }

    public IfxProtocol getProtocol() {
        return this.prot;
    }

    @Override
    public URL getURL(int n) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getURL(int)", this.conn);
    }

    @Override
    public URL getURL(String string) throws SQLException {
        int n = this.findColumn(string);
        return this.getURL(n);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateRef(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateRef(int)", this.conn);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateRef(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateRef(String)", this.conn);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        this.updateArray(this.findColumn(string), array);
    }

    public void releaseBlob() {
        if (((IfxSqliConnect)this.conn).autoCommit) {
            ((IfxSqliConnect)this.conn).releaseBlob();
        }
    }

    private void setResultSetTxType() {
        this.txType = this.conn.isXAConnection() && this.conn.inXATransaction() ? 1 : 0;
    }

    IfxResultSetMetaData executeDescribeInput() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeDescribeInput() called");
        }
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.executeDescribeInput();
    }

    IfxResultSetMetaData executeFPDescribe(boolean bl, String string, int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSet.executeFPDescribe() called");
        }
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.executeFPDescribe(null, bl, string, n);
    }

    void setPending(boolean bl) {
        this.pending = bl;
    }

    boolean isPending() {
        return this.pending;
    }

    @Override
    public String getUnloadString(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        if (ifxObject == null || ifxObject.isNull()) {
            return null;
        }
        ifxObject.setConnection(this.conn);
        return ifxObject.toUnloadString();
    }

    public int getNumberOfFetches() {
        return ((IfxSqli)this.prot).getNumberOfFetches();
    }

    int calculateFetchBufferSize() throws SQLException {
        if (this.rsmd == null) {
            return this.tupleSizeReceived;
        }
        IfxStatement ifxStatement = (IfxStatement)this.getStatement();
        int n = this.getFetchSize();
        int n2 = ifxStatement.getMaxRows();
        if (n == 0 && n2 == 0) {
            return 0;
        }
        int n3 = n;
        if (n2 != 0) {
            n3 = n != 0 ? Math.min(n, n2) : n2;
        }
        int n4 = this.rsmd.getColumnCount();
        int n5 = this.rsmd.getColumnStartPosition(n4) + this.rsmd.getColumnLength(n4);
        if (this.rsmd.isVariableLengthType(n4)) {
            n5 += 5;
        }
        int n6 = Math.max(n5, this.rsmd.getTupleSize());
        n6 = Math.max(n6, this.tupleSizeReceived);
        return n3 * n6;
    }

    protected void setTupleSizeReceived(int n) {
        this.tupleSizeReceived = n;
    }

    long getBigSerial() throws SQLException {
        if (this.prot == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        return this.prot.getBigSerialInserted();
    }

    @Override
    public int getHoldability() throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getHoldability()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getHoldability()", this.conn);
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getNCharacterStream(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getNCharacterStream(int)", this.conn);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getNCharacterStream(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getNCharacterStream(String)", this.conn);
    }

    @Override
    public NClob getNClob(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getNClob(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getNClob(int)", this.conn);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getNClob(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getNClob(String)", this.conn);
    }

    @Override
    public String getNString(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getNString(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getNString(int)", this.conn);
    }

    @Override
    public String getNString(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getNString(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getNString(String)", this.conn);
    }

    @Override
    public RowId getRowId(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getRowId(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getRowId(int)", this.conn);
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getRowId(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getRowId(String)", this.conn);
    }

    @Override
    public SQLXML getSQLXML(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getSQLXML(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getSQLXML(int)", this.conn);
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getSQLXML(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getSQLXML(String)", this.conn);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateAsciiStream(int , InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateAsciiStream(int , InputStream)", this.conn);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateAsciiStream(String , InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateAsciiStream(String, InputStream)", this.conn);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateAsciiStream(int, InputStream , long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateAsciiStream(int, InputStream, long)", this.conn);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateAsciiStream(String, InputStream , long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateAsciiStream(String, InputStream , long)", this.conn);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateBinaryStream(int , InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateBinaryStream(int , InputStream)", this.conn);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateBinaryStream(String , InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateBinaryStream(String, InputStream)", this.conn);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateBinaryStream(int, InputStream , long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateBinaryStream(int, InputStream, long)", this.conn);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateBinaryStream(String, InputStream , long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateBinaryStream(String, InputStream , long)", this.conn);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateBlob(int, InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateBlob(int, InputStream)", this.conn);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateBlob(String, InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateBlob(String, InputStream)", this.conn);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateBlob(int, InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateBlob(int, InputStream)", this.conn);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateBlob(String, InputStream)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateBlob(String, InputStream)", this.conn);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateCharacterStream(int, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateCharacterStream(int, Reader)", this.conn);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateCharacterStream(String, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateCharacterStream(String, Reader)", this.conn);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateCharacterStream(int, Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateCharacterStream(int, Reader, long)", this.conn);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateCharacterStream(String, Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateCharacterStream(String, Reader, long)", this.conn);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateClob(int, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateClob(int, Reader)", this.conn);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateClob(String, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateClob(String, Reader)", this.conn);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateClob(int, Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateClob(int, Reader, long)", this.conn);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateClob(String, Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateClob(String, Reader, long)", this.conn);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateNCharacterStream(int, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateNCharacterStream(int, Reader)", this.conn);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateNCharacterStream(String, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateNCharacterStream(String, Reader)", this.conn);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateNCharacterStream(int, Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateNCharacterStream(int, Reader, long)", this.conn);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateNCharacterStream(String, Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateNCharacterStream(String, Reader, long)", this.conn);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateNClob(int, NClob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateNClob(int, NClob)", this.conn);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateNClob(String, NClob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateNClob(String, NClob)", this.conn);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateNClob(int, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateNClob(int, Reader)", this.conn);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateNClob(String, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateNClob(String, Reader)", this.conn);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateNClob(int, Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateNClob(int, Reader, long)", this.conn);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateNClob(String, Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateNClob(String, Reader, long)", this.conn);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateNString(int, String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateNString(int, String)", this.conn);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateNString(String, String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateNString(String , String)", this.conn);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateRowId(int, RowId)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateRowId(int, RowId)", this.conn);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateRowId(String, RowId)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateRowId(String, RowId)", this.conn);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateSQLXML(int, SQLXML)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateSQLXML(int, SQLXML)", this.conn);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:updateSQLXML(String, SQLXML)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.updateSQLXML(String, SQLXML)", this.conn);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:isWrapperFor(Class)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.isWrapperFor(Class)", this.conn);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:unwrap(Class<T>)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.unwrap(Class<T>)", this.conn);
    }

    @Override
    public IfxBSONObject getIfxBSONObject(int n) throws SQLException {
        IfxObject ifxObject = this.getValue(n);
        IfxBSONObject ifxBSONObject = null;
        if (ifxObject instanceof IfxBSONObject) {
            if (this.conn != null) {
                ifxBSONObject = (IfxBSONObject)this.getObject(n, this.conn.getTypeMap());
            } else {
                Map<String, Class<?>> map = null;
                ifxBSONObject = (IfxBSONObject)this.getObject(n, map);
            }
        } else {
            throw IfxErrMsg.getSQLMinorException(-79741, -80040, this.conn);
        }
        return ifxBSONObject;
    }

    @Override
    public IfxBSONObject getIfxBSONObject(String string) throws SQLException {
        return this.getIfxBSONObject(this.findColumn(string));
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        if (clazz.equals(String.class)) {
            return (T)this.getString(n);
        }
        if (clazz.equals(BigDecimal.class)) {
            return (T)this.getBigDecimal(n);
        }
        if (clazz.equals(BigInteger.class)) {
            return (T)BigInteger.valueOf(this.getLong(n));
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return (T)Boolean.valueOf(this.getBoolean(n));
        }
        if (clazz.equals(Byte.class) || clazz.equals(Byte.TYPE)) {
            return (T)Byte.valueOf(this.getByte(n));
        }
        if (clazz.equals(Short.class) || clazz.equals(Short.TYPE)) {
            return (T)Short.valueOf(this.getShort(n));
        }
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.getInt(n));
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.getLong(n));
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.getFloat(n));
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.getDouble(n));
        }
        if (clazz.equals(byte[].class)) {
            return (T)this.getBytes(n);
        }
        if (clazz.equals(Date.class)) {
            return (T)this.getDate(n);
        }
        if (clazz.equals(Time.class)) {
            return (T)this.getTime(n);
        }
        if (clazz.equals(Timestamp.class)) {
            return (T)this.getTimestamp(n);
        }
        if (clazz.equals(Clob.class)) {
            return (T)this.getClob(n);
        }
        if (clazz.equals(Blob.class)) {
            return (T)this.getBlob(n);
        }
        if (clazz.equals(Array.class)) {
            return (T)this.getArray(n);
        }
        if (clazz.equals(Ref.class)) {
            return (T)this.getRef(n);
        }
        if (clazz.equals(URL.class)) {
            return (T)this.getURL(n);
        }
        if (clazz.equals(RowId.class)) {
            return (T)this.getRowId(n);
        }
        if (clazz.equals(NClob.class)) {
            return (T)this.getNClob(n);
        }
        if (clazz.equals(SQLXML.class)) {
            return (T)this.getSQLXML(n);
        }
        if (clazz.equals(NClob.class)) {
            return (T)this.getNClob(n);
        }
        if (clazz.equals(LocalDateTime.class)) {
            Timestamp timestamp = this.getTimestamp(n);
            if (timestamp != null) {
                return (T)timestamp.toLocalDateTime();
            }
            return null;
        }
        if (clazz.equals(LocalDate.class)) {
            Date date = this.getDate(n);
            if (date != null) {
                return (T)date.toLocalDate();
            }
            return null;
        }
        if (clazz.equals(LocalTime.class)) {
            Time time = this.getTime(n);
            if (time != null) {
                return (T)time.toLocalTime();
            }
            return null;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSet:getObject(int, Class<T>)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxResultSet.getObject(int, Class<T>) type of " + clazz, this.conn);
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        int n = this.findColumn(string);
        return this.getObject(n, clazz);
    }
}

