/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.Driver;
import com.gbasedbt.jdbc.IfmxResultSetMetaData;
import com.gbasedbt.jdbc.IfxColumnInfo;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxDatabaseMetaData;
import com.gbasedbt.jdbc.IfxDateTime;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.lang.IfxTypes;
import com.gbasedbt.lang.Interval;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxResultSetMetaData
implements IfmxResultSetMetaData {
    Vector<IfxColumnInfo> cinfoVector = new Vector();
    protected boolean hasVariableLengthColumns;
    protected boolean hasVariableLengthCharColumns = false;
    short textByteColumnCount;
    private int tupleSize;
    private int numberofcol;
    protected boolean delimIdent = false;
    protected IfxConnection conn;
    protected Trace trace = null;
    protected int serialidx;
    protected int rowidx;
    String routineDbName;
    int namedFlags;
    int numArgsRoutine;
    int fpHandle;
    private Map<Integer, Integer> columnTypeMap = new HashMap<Integer, Integer>();

    public IfxResultSetMetaData(int n, IfxConnection ifxConnection) {
        try {
            this.setColumnCount(n);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.textByteColumnCount = 0;
        this.conn = ifxConnection;
        this.trace = this.conn.getTrace();
        this.numArgsRoutine = -1;
        this.routineDbName = null;
        this.fpHandle = -1;
        this.columnTypeMap = new HashMap<Integer, Integer>();
    }

    IfxResultSetMetaData(IfxResultSetMetaData ifxResultSetMetaData) throws SQLException {
        this.numberofcol = ifxResultSetMetaData.numberofcol;
        if (this.numberofcol > 0) {
            this.cinfoVector.setSize(this.numberofcol);
        } else {
            this.cinfoVector.setSize(20);
        }
        for (int i = 0; i < this.numberofcol; ++i) {
            this.cinfoVector.setElementAt((IfxColumnInfo)ifxResultSetMetaData.getColumnInfo(i + 1).clone(), i);
        }
        this.hasVariableLengthColumns = ifxResultSetMetaData.hasVariableLengthColumns;
        this.textByteColumnCount = ifxResultSetMetaData.textByteColumnCount;
        this.delimIdent = ifxResultSetMetaData.delimIdent;
        this.conn = ifxResultSetMetaData.conn;
        this.trace = ifxResultSetMetaData.trace;
        this.numArgsRoutine = ifxResultSetMetaData.numArgsRoutine;
        this.routineDbName = ifxResultSetMetaData.routineDbName;
        this.fpHandle = ifxResultSetMetaData.fpHandle;
        this.columnTypeMap = ifxResultSetMetaData.columnTypeMap;
    }

    IfxResultSetMetaData(IfxConnection ifxConnection, Vector vector) throws SQLException {
        this.conn = ifxConnection;
        this.delimIdent = ifxConnection.isDelimIdentSet();
        this.trace = ifxConnection.getTrace();
        this.cinfoVector = vector;
        this.numberofcol = vector.size();
        for (int i = 1; i <= this.numberofcol; ++i) {
            if (!this.isVariableLengthType(i)) continue;
            this.hasVariableLengthColumns = true;
            break;
        }
        this.setTextByteColumnCount();
        this.columnTypeMap = new HashMap<Integer, Integer>();
    }

    public Vector getColumnInfoVector() throws SQLException {
        return this.cinfoVector;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.numberofcol;
    }

    IfxColumnInfo getColumnInfo(int n) throws SQLException {
        if (n < 1 || n > this.numberofcol) {
            throw IfxErrMsg.getSQLException(-79703, this.conn);
        }
        return this.cinfoVector.elementAt(n - 1);
    }

    private IfxColumnInfo getColumnInfo(int n, boolean bl) throws SQLException {
        if (bl && n > this.numberofcol) {
            if (n > this.cinfoVector.size()) {
                this.cinfoVector.setSize(n + 20);
            }
            for (int i = 0; i < n - this.numberofcol; ++i) {
                this.cinfoVector.setElementAt(new IfxColumnInfo(), this.numberofcol + i);
            }
            this.numberofcol = n;
        }
        return this.getColumnInfo(n);
    }

    public int getColumnLength(int n) throws SQLException {
        return this.getColumnInfo(n).getAdjustedColumnLength();
    }

    @Override
    public int getColumnStartPosition(int n) throws SQLException {
        return this.getColumnInfo((int)n).ColStartPos;
    }

    @Override
    public int getColumnExtendedId(int n) throws SQLException {
        return this.getColumnInfo((int)n).ExtendedId;
    }

    @Override
    public String getExtendedName(int n) throws SQLException {
        return this.getColumnInfo((int)n).ExtendedName;
    }

    @Override
    public String getExtendedOwnerName(int n) throws SQLException {
        return this.getColumnInfo((int)n).ExtendedOwner;
    }

    @Override
    public short getReference(int n) throws SQLException {
        return this.getColumnInfo((int)n).Reference;
    }

    @Override
    public int getAlignment(int n) throws SQLException {
        return this.getColumnInfo((int)n).Alignment;
    }

    @Override
    public int getSourceType(int n) throws SQLException {
        return this.getColumnInfo((int)n).SourceType;
    }

    @Override
    public boolean isAutoIncrement(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.SQLtype == 6 || ifxColumnInfo.SQLtype == 18;
    }

    @Override
    public boolean isCaseSensitive(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return this.delimIdent;
    }

    @Override
    public boolean isSearchable(int n) throws SQLException {
        return this.getColumnInfo(n).isSearchable();
    }

    @Override
    public boolean isCurrency(int n) throws SQLException {
        return this.getColumnInfo((int)n).SQLtype == 8;
    }

    @Override
    public int isNullable(int n) throws SQLException {
        return this.getColumnInfo((int)n).Nullable;
    }

    @Override
    public boolean isSigned(int n) throws SQLException {
        return this.getColumnInfo(n).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        if (ifxColumnInfo.ColumnDisplaySize == -1) {
            ifxColumnInfo.ColumnDisplaySize = IfxDatabaseMetaData.getJDBCColumnSize((short)ifxColumnInfo.SQLtype, (short)ifxColumnInfo.ExtendedId, ifxColumnInfo.ColLength);
        }
        return ifxColumnInfo.ColumnDisplaySize;
    }

    @Override
    public String getColumnLabel(int n) throws SQLException {
        return this.getColumnInfo((int)n).ColName;
    }

    @Override
    public String getColumnName(int n) throws SQLException {
        return this.getColumnInfo((int)n).ColName;
    }

    @Override
    public String getSchemaName(int n) throws SQLException {
        return " ";
    }

    @Override
    public int getPrecision(int n) throws SQLException {
        return this.getColumnInfo((int)n).DecimalDigits;
    }

    @Override
    public int getEncodedLength(int n) throws SQLException {
        return this.getColumnInfo((int)n).ColLength;
    }

    @Override
    public int getScale(int n) throws SQLException {
        return this.getColumnInfo((int)n).RightDecimal;
    }

    @Override
    public String getTableName(int n) throws SQLException {
        return this.getColumnInfo((int)n).TableName;
    }

    @Override
    public String getCatalogName(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return " ";
    }

    @Override
    public int getColumnType(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        if (ifxColumnInfo.ExtendedName.equals("boolean")) {
            if (Driver.compareJDKVersion("1.4") < 0) {
                return 1111;
            }
            return 16;
        }
        if (ifxColumnInfo.ExtendedName.equals("lvarchar")) {
            return -1;
        }
        if (ifxColumnInfo.IsDistinct) {
            return 2001;
        }
        if (ifxColumnInfo.ExtendedName.equals("clob")) {
            return 2005;
        }
        if (ifxColumnInfo.ExtendedName.equals("blob")) {
            return 2004;
        }
        if (ifxColumnInfo.SQLtype == 10) {
            byte by = IfxDateTime.getStartCode((short)ifxColumnInfo.ColLength);
            if (by >= 6) {
                return 92;
            }
            return 93;
        }
        if (ifxColumnInfo.SQLtype == 4 && !this.conn.getMapReal()) {
            return 6;
        }
        return IfxTypes.FromIfxToJDBCType(ifxColumnInfo.SQLtype);
    }

    @Override
    public int getIfxColumnType(int n) throws SQLException {
        if (this.columnTypeMap.containsKey(n)) {
            return this.columnTypeMap.get(n);
        }
        int n2 = this.getColumnInfo((int)n).SQLtype;
        this.columnTypeMap.put(n, n2);
        return n2;
    }

    @Override
    public String getColumnTypeName(int n) throws SQLException {
        Object var2_2 = null;
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        if (ifxColumnInfo.SQLtype == 52 || ifxColumnInfo.SQLtype == 53) {
            return ifxColumnInfo.DataSourceName;
        }
        if (this.conn.isITF() && ifxColumnInfo.getDataSourceName().contains("interval")) {
            ifxColumnInfo.setDataSourceName("float");
        }
        if (ifxColumnInfo.SQLtype > 18 && (ifxColumnInfo.SQLtype != 52 || ifxColumnInfo.SQLtype != 53) || ifxColumnInfo.IsDistinct) {
            return ifxColumnInfo.ExtendedName;
        }
        return ifxColumnInfo.DataSourceName;
    }

    @Override
    public boolean isReadOnly(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return false;
    }

    @Override
    public boolean isWritable(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return true;
    }

    @Override
    public boolean isDefinitelyWritable(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return true;
    }

    @Override
    public boolean isDistinct(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.IsDistinct;
    }

    @Override
    public boolean isNamedRow(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.IsNamedRow;
    }

    @Override
    public IfmxResultSetMetaData getChild(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        if (ifxColumnInfo.child == null) {
            return null;
        }
        IfxResultSetMetaData ifxResultSetMetaData = new IfxResultSetMetaData(this.conn, ifxColumnInfo.child);
        return ifxResultSetMetaData;
    }

    @Override
    public short getLevelNo(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.Levelno;
    }

    @Override
    public short getSeqNo(int n) throws SQLException {
        return this.getColumnInfo((int)n).Seqno;
    }

    @Override
    public short getParentNo(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.Parentno;
    }

    @Override
    public short getFieldNo(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.Fieldno;
    }

    byte getArgumentFlags(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.ArgumentFlags;
    }

    String getArgumentName(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return ifxColumnInfo.ArgumentName;
    }

    public void setEncodedLength(int n, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSetMetaData.setEncodedLength() entered");
        }
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.ColLength = n2;
        if (ifxColumnInfo.SQLtype == 10 || ifxColumnInfo.SQLtype == 14) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "len=" + n2);
                this.trace.writeTrace(3, "datasourcename(before)=" + ifxColumnInfo.DataSourceName);
            }
            ifxColumnInfo.DataSourceName = ifxColumnInfo.DataSourceName + " " + IfxDateTime.getQualifierName((short)n2, ifxColumnInfo.SQLtype);
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(3, "datasourcename(after)=" + ifxColumnInfo.DataSourceName);
            }
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSetMetaData.setEncodedLength() exited");
        }
    }

    public void setNullable(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.Nullable = n2;
    }

    public void setAutoIncrement(int n, short s) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.autoIncrement = s;
    }

    void setMaxWidth(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.MaxWidth = n2;
    }

    void setColtitle(int n, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.Coltitle = string == null ? new String("") : new String(string);
    }

    public void setColumnName(int n, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.ColName = string == null ? new String("") : new String(string);
    }

    public void setDecimalDigits(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.DecimalDigits = n2;
    }

    public void setRightDecimal(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.RightDecimal = n2;
    }

    public void setTableName(int n, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.TableName = string == null ? new String("") : new String(string);
    }

    void setArgumentFlags(int n, byte by) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.ArgumentFlags = by;
    }

    void setArgumentName(int n, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.ArgumentName = string == null ? new String("") : new String(string);
    }

    public boolean isVariableLengthType(int n) throws SQLException {
        return this.getColumnInfo(n, true).isVariableLengthType((IfxSqliConnect)this.conn);
    }

    boolean usingIMPEXP() throws SQLException {
        boolean bl = false;
        for (int i = 1; i <= this.getColumnCount(); ++i) {
            IfxColumnInfo ifxColumnInfo = this.getColumnInfo(i);
            if (ifxColumnInfo.SQLtype != 46) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void setIfxColumnType(int n, int n2) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        if (IfxResultSetMetaData.setTypeBooleanFields(ifxColumnInfo, n2)) {
            this.hasVariableLengthColumns = true;
        }
        if (!this.hasVariableLengthColumns && this.isVariableLengthType(n)) {
            this.hasVariableLengthColumns = true;
        }
        this.setDataSourceName(n, IfxTypes.IfxTypeToName(ifxColumnInfo.SQLtype));
    }

    public static boolean setTypeBooleanFields(IfxColumnInfo ifxColumnInfo, int n) {
        boolean bl = false;
        ifxColumnInfo.Nullable = (n & 0x100) > 0 ? 0 : 1;
        if ((n & 0x800) > 0) {
            ifxColumnInfo.IsDistinct = true;
            bl = true;
        }
        if ((n & 0x1000) > 0) {
            ifxColumnInfo.IsNamedRow = true;
        }
        ifxColumnInfo.SQLtype = n & 0xFF;
        return bl;
    }

    public void setDataSourceName(int n, String string) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxSqli: setDataSourceName() called");
        }
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.DataSourceName = string == null ? new String("") : new String(string);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(3, "    DataSourceName=" + ifxColumnInfo.DataSourceName);
            this.trace.writeTrace(1, "IfxSqli: setDataSourceName() exited");
        }
    }

    void setSourceType(int n, int n2) throws SQLException {
        this.getColumnInfo((int)n, (boolean)true).SourceType = n2;
    }

    void setColumnStartPosition(int n, int n2) throws SQLException {
        this.getColumnInfo((int)n, (boolean)true).ColStartPos = n2;
    }

    void setColumnExtendedId(int n, int n2) throws SQLException {
        this.getColumnInfo((int)n, (boolean)true).ExtendedId = n2;
    }

    void setExtendedName(int n, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.ExtendedName = string == null ? new String("") : new String(string);
    }

    void setExtendedOwnerName(int n, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.ExtendedOwner = string == null ? new String("") : new String(string);
    }

    void setReference(int n, short s) throws SQLException {
        this.getColumnInfo((int)n, (boolean)true).Reference = s;
    }

    void setAlignment(int n, short s) throws SQLException {
        this.getColumnInfo((int)n, (boolean)true).Alignment = s;
    }

    public void setColumnCount(int n) throws SQLException {
        this.numberofcol = n;
        if (n > 0) {
            this.cinfoVector.setSize(n);
        } else {
            this.cinfoVector.setSize(20);
        }
        for (int i = 0; i < n; ++i) {
            this.cinfoVector.setElementAt(new IfxColumnInfo(), i);
        }
    }

    void setBlobColAsUDT(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        if (ifxColumnInfo.SQLtype != 102 && ifxColumnInfo.SQLtype != 101) {
            return;
        }
        ifxColumnInfo.ExtendedId = 0;
        ifxColumnInfo.SQLtype = 41;
    }

    void setColInfo(int n, int n2, String string, String string2, int n3, String string3, int n4, int n5, int n6, String string4, String string5, int n7, int n8) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        try {
            ifxColumnInfo.ColLength = n5;
            ifxColumnInfo.MaxWidth = n2;
            ifxColumnInfo.Coltitle = string == null ? new String("") : new String(string);
            ifxColumnInfo.ColName = ifxColumnInfo.Coltitle;
            ifxColumnInfo.TableName = string2 == null ? new String("") : new String(string2);
            if (n3 == 41 && n6 == 10) {
                this.setIfxColumnType(n, 102);
            } else if (n3 == 41 && n6 == 11) {
                this.setIfxColumnType(n, 101);
            } else {
                this.setIfxColumnType(n, n3);
            }
            ifxColumnInfo.DataSourceName = string3 == null ? new String("") : new String(string3);
            ifxColumnInfo.SourceType = n4;
            ifxColumnInfo.ExtendedId = n6;
            ifxColumnInfo.ExtendedName = string5 == null ? new String("") : new String(string5);
            ifxColumnInfo.ExtendedOwner = string4 == null ? new String("") : new String(string4);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79750, this.conn);
        }
        ifxColumnInfo.Nullable = n7;
        this.delimIdent = n8 == 1;
    }

    void setColInfo(int n, int n2, byte[] byArray, byte[] byArray2, int n3, byte[] byArray3, int n4, int n5, int n6, byte[] byArray4, byte[] byArray5, int n7, int n8, String string) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        try {
            ifxColumnInfo.ColLength = n5;
            ifxColumnInfo.MaxWidth = n2;
            ifxColumnInfo.Coltitle = byArray == null ? new String("") : (string == null ? new String(byArray) : new String(byArray, string));
            ifxColumnInfo.ColName = ifxColumnInfo.Coltitle;
            ifxColumnInfo.TableName = byArray2 == null ? new String("") : (string == null ? new String(byArray2) : new String(byArray2, string));
            if (n3 == 41 && n6 == 10) {
                this.setIfxColumnType(n, 102);
            } else if (n3 == 41 && n6 == 11) {
                this.setIfxColumnType(n, 101);
            } else {
                this.setIfxColumnType(n, n3);
            }
            ifxColumnInfo.DataSourceName = byArray3 == null ? new String("") : (string == null ? new String(byArray3) : new String(byArray3, string));
            ifxColumnInfo.SourceType = n4;
            ifxColumnInfo.ExtendedId = n6;
            ifxColumnInfo.ExtendedName = byArray5 == null ? new String("") : (string == null ? new String(byArray5) : new String(byArray5, string));
            ifxColumnInfo.ExtendedOwner = byArray4 == null ? new String("") : (string == null ? new String(byArray4) : new String(byArray4, string));
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79750, this.conn);
        }
        ifxColumnInfo.Nullable = n7;
        this.delimIdent = n8 == 1;
    }

    void setDistinct(int n, boolean bl) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.IsDistinct = bl;
    }

    public void setDelimIdent(boolean bl) {
        this.delimIdent = bl;
    }

    public boolean getDelimIdent() {
        return this.delimIdent;
    }

    public IfxConnection getConnection() {
        return this.conn;
    }

    void copyColumnInfo(int n, IfxColumnInfo ifxColumnInfo) throws SQLException {
        IfxColumnInfo ifxColumnInfo2 = this.getColumnInfo(n, true);
        this.cinfoVector.setElementAt(ifxColumnInfo, n - 1);
    }

    public void cloneColumnInfo(int n, IfxColumnInfo ifxColumnInfo) throws SQLException {
        this.cinfoVector.setElementAt((IfxColumnInfo)ifxColumnInfo.clone(), n - 1);
    }

    @Override
    public String getColumnClassName(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        Map<String, Class<?>> map = this.conn.getTypeMap();
        String string = null;
        Class<?> clazz = null;
        if (ifxColumnInfo.IsDistinct && map != null && !map.isEmpty() && (clazz = map.get(ifxColumnInfo.ExtendedName)) != null) {
            string = new String(clazz.getName());
        } else if (map != null && !map.isEmpty() && (clazz = map.get(IfxTypes.IfxTypeToName(ifxColumnInfo.SQLtype))) != null) {
            string = new String(clazz.getName());
        } else {
            switch (ifxColumnInfo.SQLtype) {
                case 10: {
                    short s = (short)this.getEncodedLength(n);
                    if (IfxDateTime.getStartCode(s) >= 6) {
                        string = new String("java.sql.Time");
                        break;
                    }
                    string = new String("java.sql.Timestamp");
                    break;
                }
                case 14: {
                    short s = (short)this.getEncodedLength(n);
                    if (Interval.getStartCode(s) < 4) {
                        string = new String("com.gbasedbt.jdbc.IntervalYM");
                        break;
                    }
                    string = new String("com.gbasedbt.jdbc.IntervalDF");
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 52: 
                case 53: {
                    string = IfxTypes.FromIfxTypeToJava(ifxColumnInfo.SQLtype);
                    break;
                }
                case 40: 
                case 41: {
                    if (ifxColumnInfo.ExtendedName.equals("boolean")) {
                        string = new String("java.lang.Boolean");
                    } else if (ifxColumnInfo.ExtendedName.equals("lvarchar")) {
                        string = new String("java.lang.String");
                    } else if (ifxColumnInfo.ExtendedName.equals("clob")) {
                        string = new String("com.gbasedbt.jdbc.IfxCblob");
                    } else if (ifxColumnInfo.ExtendedName.equals("blob")) {
                        string = new String("com.gbasedbt.jdbc.IfxBblob");
                    }
                    if (string != null) break;
                    if (ifxColumnInfo.SourceType == 5) {
                        string = new String("java.lang.Boolean");
                        break;
                    }
                    if (ifxColumnInfo.SourceType == 1) {
                        string = new String("java.lang.String");
                        break;
                    }
                    if (ifxColumnInfo.SourceType == 11) {
                        string = new String("com.gbasedbt.jdbc.IfxCblob");
                        break;
                    }
                    if (ifxColumnInfo.SourceType == 10) {
                        string = new String("com.gbasedbt.jdbc.IfxBblob");
                        break;
                    }
                    if (map != null && !map.isEmpty() && (clazz = map.get(ifxColumnInfo.ExtendedName)) != null) {
                        string = new String(clazz.getName());
                        break;
                    }
                    string = new String("java.sql.SQLData");
                    break;
                }
                default: {
                    string = new String("unknown classname");
                }
            }
        }
        return string;
    }

    public void setTextByteColumnCount() throws SQLException {
        this.textByteColumnCount = 0;
        for (int i = 1; i <= this.getColumnCount(); ++i) {
            IfxColumnInfo ifxColumnInfo = this.getColumnInfo(i, true);
            if (ifxColumnInfo.SQLtype != 11 && ifxColumnInfo.SQLtype != 12 && (ifxColumnInfo.SQLtype != 41 || ifxColumnInfo.ExtendedId != 10 && ifxColumnInfo.ExtendedId != 11)) continue;
            this.textByteColumnCount = (short)(this.textByteColumnCount + 1);
        }
    }

    boolean needSvrConv(int n) throws SQLException {
        int n2 = this.getIfxColumnType(n);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "needSvrConv(i): colType: " + n2);
            this.trace.writeTrace(2, "needSvrConv(i): ExtendedId: " + this.getColumnExtendedId(n));
        }
        if (n2 == 41 || n2 == 40 && this.getColumnExtendedId(n) != 1 || n2 == 19 || n2 == 21 || n2 == 20 || n2 == 22) {
            if (TraceFlag.compiletrace) {
                this.trace.writeTrace(2, "needSvrConv(i) for " + n + ": true");
            }
            return true;
        }
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "needSvrConv(i) for " + n + ": false");
        }
        return false;
    }

    public static String parseTableName(String string) {
        String string2 = "";
        int n = -1;
        if (string == null) {
            return string2;
        }
        try {
            String string3 = string.toUpperCase().trim();
            int n2 = -1;
            if (string3.startsWith("SELECT")) {
                n2 = IfxResultSetMetaData.getIndexOfFrom(string3);
                n = 2;
            } else if (string3.startsWith("UPDATE")) {
                n2 = 0;
                n = 4;
            } else if (string3.startsWith("INSERT")) {
                n = 6;
                n2 = string3.indexOf("INTO");
            } else {
                n = -1;
            }
            if (n2 == -1) {
                return string2;
            }
            String string4 = string.substring(n2);
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            switch (n) {
                case 2: {
                    String string5 = stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) {
                        return string2;
                    }
                    string5 = stringTokenizer.nextToken();
                    if (string5.startsWith("(")) {
                        return string2;
                    }
                    if (string5.endsWith(",")) {
                        return string2;
                    }
                    if (string5.indexOf(44) != -1) {
                        return string2;
                    }
                    if (string5.endsWith(";")) {
                        return string5.replace(';', ' ').trim();
                    }
                    if (!stringTokenizer.hasMoreTokens()) {
                        return string5;
                    }
                    String string6 = stringTokenizer.nextToken();
                    if (string6.equalsIgnoreCase("AS")) {
                        if (stringTokenizer.hasMoreTokens()) {
                            string6 = stringTokenizer.nextToken();
                        } else {
                            return string2;
                        }
                    }
                    if (string6.equals(";")) {
                        return string5;
                    }
                    if (string6.endsWith(";")) {
                        return string5;
                    }
                    if (string6.indexOf(44) != -1) {
                        return string2;
                    }
                    if (string6.equalsIgnoreCase("LEFT") || string6.equalsIgnoreCase("RIGHT") || string6.equalsIgnoreCase("FULL") || string6.equalsIgnoreCase("INNER") || string6.equalsIgnoreCase("CROSS") || string6.equalsIgnoreCase("JOIN") || string6.equalsIgnoreCase("OUTER") || string6.equalsIgnoreCase("UNION")) {
                        return string2;
                    }
                    if (!stringTokenizer.hasMoreTokens()) {
                        return string5;
                    }
                    String string7 = stringTokenizer.nextToken();
                    if (string7.equals(";")) {
                        return string5;
                    }
                    if (string7.equals(",")) {
                        return string2;
                    }
                    if (string7.startsWith(",")) {
                        return string2;
                    }
                    if (string7.equalsIgnoreCase("LEFT") || string7.equalsIgnoreCase("RIGHT") || string7.equalsIgnoreCase("FULL") || string7.equalsIgnoreCase("INNER") || string7.equalsIgnoreCase("CROSS") || string7.equalsIgnoreCase("JOIN") || string7.equalsIgnoreCase("OUTER") || string7.equalsIgnoreCase("UNION")) {
                        return string2;
                    }
                    return string5;
                }
                case 6: {
                    String string8 = stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) {
                        return "";
                    }
                    string8 = stringTokenizer.nextToken();
                    int n3 = string8.indexOf(40);
                    if (n3 != -1) {
                        return string8.substring(0, n3);
                    }
                    return string8;
                }
                case 4: {
                    String string9 = stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) {
                        return string2;
                    }
                    string9 = stringTokenizer.nextToken();
                    return string9;
                }
            }
            return string2;
        }
        catch (Exception exception) {
            return string2;
        }
    }

    private static int getIndexOfFrom(String string) {
        int n = -1;
        try {
            int n2 = 0;
            int n3 = 0;
            while ((n = string.indexOf("FROM", n2)) != -1) {
                for (int i = n2; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c == '(') {
                        ++n3;
                    }
                    if (c != ')') continue;
                    if (n3 <= 0) {
                        return -1;
                    }
                    --n3;
                }
                if (n3 != 0) {
                    n2 = n + 4;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            return -1;
        }
        return n;
    }

    public void parseSetTableName(String string) throws SQLException {
        String string2 = IfxResultSetMetaData.parseTableName(string);
        if (string2 != null) {
            for (int i = 1; i <= this.numberofcol; ++i) {
                this.setTableName(i, string2);
            }
        }
    }

    protected int findrowid() throws SQLException {
        this.rowidx = -1;
        for (int i = 1; i <= this.numberofcol; ++i) {
            if (!this.getColumnName(i).equals("rowid")) continue;
            this.rowidx = i;
            return this.rowidx;
        }
        return -1;
    }

    protected String findserial() throws SQLException {
        this.serialidx = -1;
        for (int i = 1; i <= this.numberofcol; ++i) {
            int n = this.getIfxColumnType(i);
            if (n != 6 && n != 18) continue;
            this.serialidx = i;
            return this.getColumnName(this.serialidx);
        }
        return null;
    }

    protected void setTupleSize(int n) {
        this.tupleSize = n;
    }

    protected int getTupleSize() {
        return this.tupleSize;
    }

    protected int getMode(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSetMetaData.getMode() entered");
        }
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSetMetaData.getMode() exited ");
        }
        return ifxColumnInfo.colMode;
    }

    protected void setMode(int n, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSetMetaData.setMode() entered");
        }
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n, true);
        ifxColumnInfo.colMode = n2 == 0 ? 1 : (n2 == 1 ? 4 : (n2 == 2 ? 2 : n2));
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(1, "IfxResultSetMetaData.setMode() exited ");
        }
    }

    boolean hasDefaultValue(int n) throws SQLException {
        IfxColumnInfo ifxColumnInfo = this.getColumnInfo(n);
        return (ifxColumnInfo.ArgumentFlags & 1) != 0;
    }

    boolean wasRoutineUnique() {
        return (this.namedFlags & 2) != 0;
    }

    public boolean isWrapperFor(Class clazz) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSetMetaData:isWrapperFor(Class)not supported with server");
        }
        throw IfxErrMsg.getSQLException(-79882, ": IfxResultSetMetaData.isWrapperFor(Class)", this.conn);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxResultSetMetaData:unwrap(Class<T>)not supported with server");
        }
        throw IfxErrMsg.getSQLException(-79882, ": IfxResultSetMetaData.unwrap(Class<T>)", this.conn);
    }

    public void setVectorVariableLengthTypeCheckFalse() {
        int n;
        if (this.cinfoVector != null && (n = this.cinfoVector.size()) > 0) {
            for (int i = 0; i < n; ++i) {
                IfxColumnInfo ifxColumnInfo = this.cinfoVector.elementAt(i);
                if (ifxColumnInfo == null) continue;
                ifxColumnInfo.setVariableLengthTypeCheckFalse();
            }
        }
    }

    public Map getColumnTypeMap() {
        return this.columnTypeMap;
    }
}

