/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.asf.IfxDataInputStream;
import com.gbasedbt.jdbc.IfxColumnInfo;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxObject;
import com.gbasedbt.jdbc.IfxResultSetMetaData;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.jdbc.IfxValue;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.lang.IfxTypes;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.io.ByteArrayOutputStream;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Vector;

class IfxRowColumn {
    IfxConnection conn;
    ByteArrayOutputStream bStream;
    byte[] tuple;
    IfxResultSetMetaData rsmd;
    int offset;
    Vector<ColumnInfo> colInfoVector;
    private int initialSize;
    private int currDataSize;
    private boolean dataInStream;
    Trace trace;

    IfxRowColumn(IfxConnection ifxConnection, IfxResultSetMetaData ifxResultSetMetaData, int n) throws SQLException {
        this.rsmd = ifxResultSetMetaData;
        this.conn = ifxConnection;
        try {
            this.initialSize = this.rsmd.hasVariableLengthColumns ? n + 1024 : n;
            this.tuple = new byte[this.initialSize];
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    IfxRowColumn(IfxConnection ifxConnection, IfxResultSetMetaData ifxResultSetMetaData) {
        this.conn = ifxConnection;
        this.rsmd = ifxResultSetMetaData;
    }

    void readTuple(IfxDataInputStream ifxDataInputStream, int n, int n2) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(1, "IfxRowColumn.readTuple() entered");
            this.writeTrace(2, "    currDataSize = " + this.currDataSize);
            this.writeTrace(2, "    initialSize = " + this.initialSize);
            this.writeTrace(2, "    offset = " + n);
            this.writeTrace(2, "    size = " + n2);
        }
        if (this.dataInStream || this.currDataSize + n2 > this.initialSize) {
            try {
                byte[] byArray = new byte[n2];
                if (!this.dataInStream) {
                    if (this.bStream == null) {
                        this.bStream = new ByteArrayOutputStream();
                    }
                    if (this.currDataSize > 0) {
                        this.bStream.write(this.tuple, 0, this.currDataSize);
                    }
                    this.dataInStream = true;
                }
                ifxDataInputStream.readPadded(byArray, 0, n2);
                this.bStream.write(byArray, 0, n2);
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        try {
            ifxDataInputStream.readPadded(this.tuple, n, n2);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        this.currDataSize += n2;
        if (TraceFlag.compiletrace) {
            this.writeTrace(2, "    currDataSize: " + this.currDataSize);
            this.writeTrace(1, "IfxRowColumn.readTuple() exited");
        }
    }

    void setOffsetInTuple(int n) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(2, "IfxRowColumn.setOffsetInTuple(): offset = " + n);
        }
        this.offset = n;
        if (this.rsmd.hasVariableLengthColumns || this.rsmd.hasVariableLengthCharColumns) {
            int n2 = n;
            int n3 = 0;
            if (this.colInfoVector == null) {
                this.colInfoVector = new Vector();
                this.colInfoVector.setSize(this.rsmd.getColumnCount());
            }
            for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                int n4;
                Object object;
                int n5 = this.rsmd.getIfxColumnType(i);
                int n6 = this.rsmd.getColumnLength(i);
                if (TraceFlag.compiletrace) {
                    this.writeTrace(2, "setOffsetInTuple():");
                    this.writeTrace(2, "   i = " + i + ", colType = " + n5 + ", colLen = " + n6 + ", rowOffset = " + n2 + ", colOffset = " + n3);
                }
                if (n5 == 40 || n5 == 41 || n5 == 45 || n5 == 43 || n5 == 46) {
                    object = new byte[4];
                    if (this.dataInStream) {
                        this.tuple = this.bStream.toByteArray();
                        this.dataInStream = false;
                        this.bStream.reset();
                    }
                    System.arraycopy(this.tuple, n2 + 1, object, 0, 4);
                    n4 = IfxToJavaType.IfxToJavaInt(object);
                    n6 = 5 + n4;
                } else if (n5 == 13 || n5 == 16) {
                    object = new byte[2];
                    if (((IfxSqliConnect)this.conn).isVarcharVarLenSupported()) {
                        if (this.dataInStream) {
                            this.tuple = this.bStream.toByteArray();
                            this.dataInStream = false;
                            this.bStream.reset();
                        }
                        System.arraycopy(this.tuple, n2, object, 0, 2);
                        n4 = IfxToJavaType.IfxToJavaSmallInt(object);
                        n6 = 2 + n4;
                        if (TraceFlag.compiletrace) {
                            this.writeTrace(2, "varchar data length: " + n6);
                        }
                    } else {
                        ++n6;
                    }
                } else if (IfxTypes.isComplexType(n5)) {
                    object = new byte[4];
                    if (this.dataInStream) {
                        this.tuple = this.bStream.toByteArray();
                        this.dataInStream = false;
                        this.bStream.reset();
                    }
                    System.arraycopy(this.tuple, n2, object, 0, 4);
                    n4 = IfxToJavaType.IfxToJavaInt(object);
                    n6 = n4 + 4;
                    if (TraceFlag.compiletrace) {
                        this.writeTrace(2, "data length: " + n6);
                    }
                }
                n2 += n6;
                object = new ColumnInfo(n3, n6);
                this.colInfoVector.setElementAt((ColumnInfo)object, i - 1);
                n3 += n6;
            }
        }
    }

    void setMetaData(IfxResultSetMetaData ifxResultSetMetaData) {
        this.rsmd = ifxResultSetMetaData;
    }

    public IfxResultSetMetaData getMetaData() {
        return this.rsmd;
    }

    void setTrace(Trace trace) {
        if (TraceFlag.compiletrace) {
            this.trace = trace;
        }
    }

    IfxObject getColumn(int n) throws SQLException {
        return this.getColumn(n, null);
    }

    IfxObject getColumn(int n, Calendar calendar) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.writeTrace(99, "Entering IfxRowColumn.getRowColumn()");
        }
        IfxObject ifxObject = IfxValue.makeInstance(this.conn, this.rsmd.getColumnInfo(n), calendar);
        this.loadColumnData(n, ifxObject);
        return ifxObject;
    }

    void loadColumnData(int n, IfxObject ifxObject) throws SQLException {
        int n2;
        int n3;
        Object object;
        int n4 = this.rsmd.getIfxColumnType(n);
        ifxObject.clear();
        if (this.colInfoVector != null) {
            if (n > this.colInfoVector.size()) {
                throw IfxErrMsg.getSQLException(-79703, this.conn);
            }
            object = this.colInfoVector.elementAt(n - 1);
            n3 = ((ColumnInfo)object).len;
            n2 = ((ColumnInfo)object).startPos;
            if (!(this.rsmd.hasVariableLengthColumns || n4 != 13 && n4 != 16)) {
                n3 += 2;
            }
        } else {
            object = this.rsmd.getColumnInfo(n);
            if (((IfxColumnInfo)object).isIfxColLenSet) {
                n3 = ((IfxColumnInfo)object).ifxColLen;
                n2 = ((IfxColumnInfo)object).ColStartPos;
            } else {
                n2 = this.rsmd.getColumnStartPosition(n);
                switch (n4) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 17: 
                    case 52: {
                        n3 = 1;
                        break;
                    }
                    default: {
                        n3 = this.rsmd.getColumnLength(n);
                    }
                }
                if (!(this.rsmd.hasVariableLengthColumns || n4 != 13 && n4 != 16)) {
                    n3 += 2;
                }
                ((IfxColumnInfo)object).ifxColLen = n3;
                ((IfxColumnInfo)object).isIfxColLenSet = true;
            }
        }
        if (TraceFlag.compiletrace) {
            object = new String("IfxRowData.getAllColumns(): idx = " + n + ", SQLType = " + this.rsmd.getIfxColumnType(n) + ", Column Length = " + n3);
            this.writeTrace(3, (String)object);
        }
        if ((object = (Object)(this.dataInStream ? this.bStream.toByteArray() : this.tuple)) != null && n3 > 0) {
            try {
                switch (n4) {
                    case 5: 
                    case 8: 
                    case 10: 
                    case 14: {
                        ifxObject.fromIfx((byte[])object, this.offset + n2, n3, (short)this.rsmd.getEncodedLength(n));
                        break;
                    }
                    default: {
                        ifxObject.fromIfx((byte[])object, this.offset + n2, n3);
                        break;
                    }
                }
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (Exception exception) {
                throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
            }
        }
        if (TraceFlag.compiletrace) {
            this.writeTrace(99, "Exiting IfxRowColumn.getRowColumn()");
        }
    }

    private void writeTrace(int n, String string) {
        if (TraceFlag.compiletrace && this.trace != null) {
            this.trace.writeTrace(n, string);
        }
    }

    byte[] getTupleData() {
        if (!this.dataInStream) {
            return this.tuple;
        }
        return this.bStream.toByteArray();
    }

    void reset() {
        if (this.dataInStream) {
            this.dataInStream = false;
            this.bStream.reset();
        }
        this.currDataSize = 0;
    }

    void clear() {
        this.reset();
        this.rsmd = null;
    }

    int getInitialSize() {
        return this.initialSize;
    }

    class ColumnInfo {
        int startPos;
        int len;

        ColumnInfo(int n, int n2) {
            this.startPos = n;
            this.len = n2;
        }
    }
}

