/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.asf.IfxDataInputStream;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxFloat;
import com.gbasedbt.jdbc.IfxSmallFloat;
import com.gbasedbt.lang.IfxToJavaType;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

abstract class IfxSQLInput
implements SQLInput {
    protected IfxConnection conn;
    ByteArrayInputStream bStream;
    IfxDataInputStream is;
    private Map map;
    protected boolean isNull = false;
    protected byte[] buf = null;
    protected int totalLength;
    protected int unreadLength;
    protected int currentPos = 0;
    private int startPos = 0;
    protected Trace trace = null;

    IfxSQLInput(IfxConnection ifxConnection, byte[] byArray, int n, int n2) throws SQLException {
        this.setConnection(ifxConnection);
        this.bStream = new ByteArrayInputStream(byArray, n, n2);
        this.is = new IfxDataInputStream(this.bStream);
        if (ifxConnection != null) {
            this.is.setClientLocale(ifxConnection.getclLocale());
        }
        this.unreadLength = this.totalLength = n2;
        this.buf = byArray;
        this.startPos = n;
    }

    void setConnection(IfxConnection ifxConnection) throws SQLException {
        this.conn = ifxConnection;
        if (TraceFlag.compiletrace) {
            if (ifxConnection == null) {
                System.out.println("IfxComplexInput() connection is null");
            } else {
                this.trace = ifxConnection.getTrace();
                if (this.trace == null) {
                    throw IfxErrMsg.getSQLException(-79716, ifxConnection);
                }
            }
        }
    }

    void setTypeMap(Map map) {
        this.map = map;
    }

    byte[] toByteArray() throws SQLException {
        byte[] byArray = new byte[this.totalLength];
        System.arraycopy(this.buf, this.startPos, byArray, 0, this.totalLength);
        return byArray;
    }

    protected void skipBytes(int n) throws SQLException {
        try {
            this.is.skipBytes(n);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    protected int currentPosition() {
        return this.totalLength - this.bStream.available();
    }

    public int length() {
        return this.totalLength;
    }

    protected int available() {
        return this.bStream.available();
    }

    protected void reset() {
        this.bStream.reset();
        this.currentPos = 0;
    }

    protected void checkLength(int n) throws SQLException {
        if (this.unreadLength < n) {
            throw IfxErrMsg.getSQLException(-79772, this.conn);
        }
        this.unreadLength -= n;
    }

    @Override
    public String readString() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readString().", this.conn);
    }

    @Override
    public boolean readBoolean() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBoolean().", this.conn);
    }

    @Override
    public byte readByte() throws SQLException {
        return (byte)this.readShort();
    }

    @Override
    public short readShort() throws SQLException {
        this.checkLength(2);
        this.isNull = false;
        try {
            short s = this.is.readShort();
            if (s == Short.MIN_VALUE) {
                this.isNull = true;
                s = 0;
            }
            this.currentPos += 2;
            return s;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public int readInt() throws SQLException {
        this.checkLength(4);
        this.isNull = false;
        try {
            int n = this.is.readInt();
            if (n == Integer.MIN_VALUE) {
                this.isNull = true;
                n = 0;
            }
            this.currentPos += 4;
            return n;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public long readLong() throws SQLException {
        this.checkLength(10);
        this.isNull = false;
        try {
            long l = this.is.readLongInt();
            if (l == Long.MIN_VALUE) {
                this.isNull = true;
                l = 0L;
            }
            this.currentPos += 10;
            return l;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public long readLongBigint() throws SQLException {
        this.checkLength(8);
        this.isNull = false;
        try {
            long l = this.is.readLongBigint();
            if (l == Long.MIN_VALUE) {
                this.isNull = true;
                l = 0L;
            }
            this.currentPos += 8;
            return l;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public float readFloat() throws SQLException {
        this.checkLength(4);
        byte[] byArray = new byte[4];
        this.isNull = true;
        try {
            this.bStream.read(byArray, 0, 4);
            this.currentPos += 4;
            this.isNull = IfxSmallFloat.isIfxNull(byArray);
            if (this.isNull) {
                return 0.0f;
            }
            return IfxToJavaType.IfxToJavaReal(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public double readDouble() throws SQLException {
        this.checkLength(8);
        byte[] byArray = new byte[8];
        this.isNull = true;
        try {
            this.bStream.read(byArray, 0, 8);
            this.isNull = IfxFloat.isIfxNull(byArray);
            if (this.isNull) {
                return 0.0;
            }
            return IfxToJavaType.IfxToJavaDouble(byArray);
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBigDecimal().", this.conn);
    }

    @Override
    public byte[] readBytes() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBytes().", this.conn);
    }

    public byte[] readBytes(int n) throws SQLException {
        byte[] byArray;
        if (this.unreadLength < n) {
            n = this.unreadLength;
        }
        this.checkLength(n);
        try {
            byArray = new byte[n];
            this.is.readFully(byArray, 0, n);
            this.currentPos += n;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
        return byArray;
    }

    @Override
    public Date readDate() throws SQLException {
        this.checkLength(4);
        try {
            Date date = this.is.readDate();
            this.currentPos += 4;
            if (date == null) {
                this.isNull = true;
                return null;
            }
            return date;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public Time readTime() throws SQLException {
        try {
            Timestamp timestamp = this.readTimestamp();
            if (timestamp == null) {
                this.isNull = true;
                return null;
            }
            return new Time(timestamp.getTime());
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readTimestamp().", this.conn);
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readCharacterStream().", this.conn);
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readAsciiStream().", this.conn);
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBinaryStream().", this.conn);
    }

    @Override
    public Object readObject() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readObject().", this.conn);
    }

    @Override
    public Ref readRef() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readRef().", this.conn);
    }

    @Override
    public Blob readBlob() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBlob().", this.conn);
    }

    @Override
    public Clob readClob() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readClob().", this.conn);
    }

    @Override
    public Array readArray() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readArray().", this.conn);
    }

    @Override
    public boolean wasNull() {
        return this.isNull;
    }
}

