/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.asf.IfxDataOutputStream;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.util.IfxByteArrayOutputStream;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

abstract class IfxSQLOutput
implements SQLOutput {
    IfxByteArrayOutputStream bStream = new IfxByteArrayOutputStream();
    IfxDataOutputStream os = new IfxDataOutputStream(this.bStream);
    protected IfxConnection conn;
    protected Trace trace = null;
    private boolean randomAccess = true;

    IfxSQLOutput() {
    }

    IfxSQLOutput(IfxConnection ifxConnection) throws SQLException {
        this.setConnection(ifxConnection);
    }

    void setConnection(IfxConnection ifxConnection) throws SQLException {
        this.conn = ifxConnection;
        if (ifxConnection == null) {
            throw IfxErrMsg.getSQLException(-79716, ifxConnection);
        }
        if (TraceFlag.compiletrace) {
            this.trace = ifxConnection.getTrace();
            if (this.trace == null) {
                throw IfxErrMsg.getSQLException(-79716, ifxConnection);
            }
        }
    }

    void reset() {
        this.bStream.reset();
    }

    int length() {
        return this.bStream.size();
    }

    public byte[] toByteArray() {
        return this.bStream.toByteArray();
    }

    @Override
    public void writeString(String string) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeString(String).", this.conn);
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeBoolean(boolean).", this.conn);
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        this.writeShort(by);
    }

    @Override
    public void writeShort(short s) throws SQLException {
        try {
            this.os.writeShort(s);
            this.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeInt(int n) throws SQLException {
        try {
            this.os.writeInt(n);
            this.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeLong(long l) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeLong(long).", this.conn);
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        try {
            this.os.writeReal(f);
            this.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        try {
            this.os.writeDouble(d);
            this.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeBigDecimal(BigDecimal).", this.conn);
    }

    @Override
    public void writeBytes(byte[] byArray) throws SQLException {
        try {
            this.os.write(byArray);
            this.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    public void writeBytes(byte[] byArray, int n) throws SQLException {
        try {
            int n2 = n - byArray.length;
            this.os.write(byArray);
            while (n2-- > 0) {
                this.os.write(0);
            }
            this.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        try {
            this.os.writeDate(date);
            this.adjustTotalDataSize();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        try {
            this.writeTimestamp(new Timestamp(time.getTime()));
        }
        catch (Exception exception) {
            throw IfxErrMsg.getSQLException(-79716, exception.toString(), this.conn);
        }
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeTimestamp(Timestamp).", this.conn);
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeCharacterStream(Reader).", this.conn);
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeAsciiStream(InputStream).", this.conn);
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeBinaryStream(InputStream).", this.conn);
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeObject(SQLData).", this.conn);
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeRef(Ref).", this.conn);
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeBlob(Blob).", this.conn);
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeClob(Clob).", this.conn);
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeStruct(Struct).", this.conn);
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLOutput.writeArray(Array).", this.conn);
    }

    void setRandomAccess(boolean bl) {
        this.randomAccess = bl;
    }

    void adjustTotalDataSize() {
        if (this.randomAccess) {
            this.bStream.adjustTotalDataSize();
        }
    }
}

