/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfmxSavepoint;
import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxResultSet;
import com.gbasedbt.util.IfxErrMsg;
import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class IfxSavepoint
implements IfmxSavepoint {
    int savepointId_ = 0;
    String savepointName_ = null;
    IfxConnection connection_;
    private ArrayList resultSetList = null;

    IfxSavepoint(IfxConnection ifxConnection, String string) {
        this.connection_ = ifxConnection;
        this.savepointName_ = string;
    }

    IfxSavepoint(IfxConnection ifxConnection, int n) {
        this.connection_ = ifxConnection;
        this.savepointId_ = n;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.savepointId_ != 0) {
            return this.savepointId_;
        }
        throw IfxErrMsg.getSQLException(-79894, this.connection_);
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.savepointName_ != null) {
            return this.savepointName_;
        }
        throw IfxErrMsg.getSQLException(-79895, this.connection_);
    }

    protected void addResultSet(ResultSet resultSet) {
        if (this.resultSetList == null) {
            this.resultSetList = new ArrayList(10);
        }
        WeakReference<ResultSet> weakReference = new WeakReference<ResultSet>(resultSet);
        this.resultSetList.add(weakReference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResultSet() throws SQLException {
        if (this.resultSetList != null) {
            ArrayList arrayList = this.resultSetList;
            synchronized (arrayList) {
                WeakReference weakReference2 = null;
                ResultSet resultSet = null;
                for (WeakReference weakReference2 : this.resultSetList) {
                    resultSet = (ResultSet)weakReference2.get();
                    if (resultSet == null) continue;
                    try {
                        ((IfxResultSet)resultSet).isClosed = true;
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {
                        if (sQLException.getErrorCode() != -259) continue;
                        ((IfxResultSet)resultSet).stmt.cursorOpen = true;
                    }
                }
            }
        }
    }
}

