/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbc.IfxInputStream;
import com.gbasedbt.jdbc.IfxOutputStream;
import com.gbasedbt.jdbc.IfxSqliConnect;
import com.gbasedbt.util.IfxErrMsg;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;

public class IfxTmpFile {
    private File tempFile = null;
    private String fileName = null;
    private int refCount = 0;
    private String locale = null;

    IfxTmpFile(IfxConnection ifxConnection) throws SQLException {
        this.setConnection(ifxConnection);
        try {
            File file;
            String string = ifxConnection.getJDBCTempDir();
            if (string == null || string.length() == 0) {
                string = System.getProperty("user.dir");
            }
            final File file2 = new File(string);
            this.tempFile = file = (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    File file = File.createTempFile("IfxTmpFile_", "", file2);
                    return file;
                }
            });
            if (file != null) {
                this.fileName = file.getPath();
                ((IfxSqliConnect)ifxConnection).addToFileList(this.tempFile);
            }
        }
        catch (Exception exception) {
            SQLException sQLException = IfxErrMsg.getSQLException(-79716, exception.toString(), this.locale);
            sQLException = IfxErrMsg.setSQLExceptionCause(sQLException, exception);
            throw sQLException;
        }
    }

    protected String getFileName() {
        return this.fileName;
    }

    protected synchronized int incRefCount() {
        ++this.refCount;
        return this.refCount;
    }

    protected synchronized void close() {
        if (this.refCount == 0) {
            try {
                String string = this.fileName;
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        File file = new File(IfxTmpFile.this.fileName);
                        file.delete();
                        return null;
                    }
                });
            }
            catch (Exception exception) {}
        } else {
            --this.refCount;
        }
    }

    private void setConnection(IfxConnection ifxConnection) {
        if (ifxConnection != null) {
            this.locale = ifxConnection.getclLocale();
        }
    }

    int length() throws Exception {
        final File file = this.tempFile;
        Integer n = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                Integer n = (int)file.length();
                return n;
            }
        });
        return n;
    }

    IfxInputStream getInputStream() throws Exception {
        final IfxTmpFile ifxTmpFile = this;
        IfxInputStream ifxInputStream = (IfxInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                IfxInputStream ifxInputStream = new IfxInputStream(ifxTmpFile);
                IfxTmpFile.this.incRefCount();
                return ifxInputStream;
            }
        });
        return ifxInputStream;
    }

    IfxOutputStream getOutputStream() throws Exception {
        final IfxTmpFile ifxTmpFile = this;
        IfxOutputStream ifxOutputStream = (IfxOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                IfxOutputStream ifxOutputStream = new IfxOutputStream(ifxTmpFile);
                IfxTmpFile.this.incRefCount();
                return ifxOutputStream;
            }
        });
        return ifxOutputStream;
    }
}

