/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class UuvOptManager {
    private static boolean isUpdateDb = false;
    private static int initialCapacity = 1100;
    private static String optVal = "0";
    private static Map<String, Integer> optSqlItem = new LinkedHashMap<String, Integer>();
    private static List<Map<List<String>, Map<String, Object>>> xuca_uuv_opt_list = new ArrayList<Map<List<String>, Map<String, Object>>>();
    private static List<String[]> xuca_uuv_opt_heaer_List = new ArrayList<String[]>();
    private static String targetPaymentSql0 = "SELECTw_name,w_street_1,w_street_2,w_city,w_state,w_zipFROMbmsql_warehouseWHEREw_id=?";
    private static String targetPaymentSql1 = "SELECTd_name,d_street_1,d_street_2,d_city,d_state,d_zipFROMbmsql_districtWHEREd_w_id=?ANDd_id=?";
    private static String targetPaymentSql2 = "UPDATEbmsql_warehouseSETw_ytd=w_ytd+?WHEREw_id=?";
    private static String targetPaymentSql3 = "UPDATEbmsql_districtSETd_ytd=d_ytd+?WHEREd_w_id=?ANDd_id=?";
    private static Map<Integer, LinkedBlockingQueue<Map<List<String>, Double>>> updateSqlValMap = new HashMap<Integer, LinkedBlockingQueue<Map<List<String>, Double>>>();
    private static Map<Integer, Map<List<String>, Double>> updateSqlCalValMap = new HashMap<Integer, Map<List<String>, Double>>();
    private static Map<List<String>, Map<String, Object>> p_xuca_uuv_opt_0 = new HashMap<List<String>, Map<String, Object>>();
    private static Map<List<String>, Map<String, Object>> p_xuca_uuv_opt_1 = new HashMap<List<String>, Map<String, Object>>();
    private static Thread t1 = null;
    private static Thread t2 = null;
    int index = -1;
    private List<String> pstSetVal = new ArrayList<String>();

    public static String getOptVal() {
        return optVal;
    }

    public static void init(int n, String string) {
        initialCapacity = n;
        optVal = string;
        if (optVal.equals("5")) {
            targetPaymentSql2 = "";
            targetPaymentSql3 = "";
        }
        optSqlItem.put(targetPaymentSql0.toLowerCase(), 0);
        optSqlItem.put(targetPaymentSql1.toLowerCase(), 1);
        optSqlItem.put(targetPaymentSql2.toLowerCase(), 2);
        optSqlItem.put(targetPaymentSql3.toLowerCase(), 3);
        xuca_uuv_opt_list.add(p_xuca_uuv_opt_0);
        xuca_uuv_opt_list.add(p_xuca_uuv_opt_1);
        xuca_uuv_opt_list.add(p_xuca_uuv_opt_0);
        xuca_uuv_opt_list.add(p_xuca_uuv_opt_1);
        updateSqlValMap.put(2, new LinkedBlockingQueue(5000));
        updateSqlValMap.put(3, new LinkedBlockingQueue(5000));
        updateSqlCalValMap.put(2, new HashMap(initialCapacity));
        updateSqlCalValMap.put(3, new HashMap(initialCapacity));
    }

    public static synchronized void initThread() {
        if (t1 == null) {
            t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    LinkedBlockingQueue linkedBlockingQueue = (LinkedBlockingQueue)updateSqlValMap.get(2);
                    Map map = (Map)updateSqlCalValMap.get(2);
                    Map map2 = null;
                    try {
                        while ((map2 = (Map)linkedBlockingQueue.take()) != null && map2.size() == 1) {
                            for (List list : map2.keySet()) {
                                Double d = (Double)map.get(list) + (Double)map2.get(list);
                                map.put(list, d);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        System.exit(-1);
                    }
                }
            });
            t1.start();
        }
        if (t2 == null) {
            t2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    LinkedBlockingQueue linkedBlockingQueue = (LinkedBlockingQueue)updateSqlValMap.get(3);
                    Map map = (Map)updateSqlCalValMap.get(3);
                    Map map2 = null;
                    try {
                        while ((map2 = (Map)linkedBlockingQueue.take()) != null && map2.size() == 1) {
                            for (List list : map2.keySet()) {
                                Double d = (Double)map.get(list) + (Double)map2.get(list);
                                map.put(list, d);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        System.exit(-1);
                    }
                }
            });
            t2.start();
        }
    }

    public void setIsUpdatedb(boolean bl) {
        isUpdateDb = bl;
    }

    private String formatSql(String string) {
        return string.replaceAll(" ", "").replaceAll("\n", "").replaceAll("\r", "").replaceAll("\t", "").toLowerCase();
    }

    public boolean isUseUuv() {
        return this.index >= 0;
    }

    private void resetUseUuv() {
        this.index = -1;
    }

    public int getIndex() {
        return this.index;
    }

    public int getSqlIndex(String string) {
        Integer n = optSqlItem.get(string);
        if (n != null && n >= 0) {
            this.index = n;
            return n;
        }
        return -1;
    }

    public static Map<Integer, LinkedBlockingQueue<Map<List<String>, Double>>> getAllUpdValmap() {
        return updateSqlValMap;
    }

    public LinkedBlockingQueue<Map<List<String>, Double>> getUpdValmap(int n) {
        return updateSqlValMap.get(n);
    }

    public void setEndFlagToqueue(int n) throws SQLException {
        try {
            updateSqlValMap.get(n).put(new HashMap());
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public boolean isEndForThread(int n) {
        if (n == 2) {
            return !t1.isAlive();
        }
        if (n == 3) {
            return !t2.isAlive();
        }
        return true;
    }

    public Map<List<String>, Double> getUpdCalValmap(int n) {
        return updateSqlCalValMap.get(n);
    }

    public List<Map<List<String>, Map<String, Object>>> getUUvOptList() {
        return xuca_uuv_opt_list;
    }

    public Map<List<String>, Map<String, Object>> getUuvOpt(int n) {
        return xuca_uuv_opt_list.get(n);
    }

    public String[] getUuvHeader(int n) {
        return xuca_uuv_opt_heaer_List.get(n);
    }

    public void initxuca_uuv_opt(int n, Connection connection) throws SQLException {
        switch (n) {
            case 0: {
                this.initP_xuca_uuv_opt_0(connection);
                break;
            }
            case 1: {
                this.initP_xuca_uuv_opt_1(connection);
                break;
            }
        }
    }

    private void initP_xuca_uuv_opt_0(Connection connection) throws SQLException {
        String string = "SELECT w_id,w_name,w_ytd FROM bmsql_warehouse";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            arrayList.add(resultSet.getString("w_id"));
            hashMap.put("w_name", resultSet.getString("w_name"));
            p_xuca_uuv_opt_0.put(arrayList, hashMap);
            updateSqlCalValMap.get(2).put(arrayList, resultSet.getDouble("w_ytd"));
        }
        resultSet.close();
        statement.close();
    }

    private void initP_xuca_uuv_opt_1(Connection connection) throws SQLException {
        String string = "SELECT d_w_id,d_id, d_name,d_ytd FROM bmsql_district";
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        while (resultSet.next()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            arrayList.add(resultSet.getString("d_w_id"));
            arrayList.add(resultSet.getString("d_id"));
            hashMap.put("d_name", resultSet.getString("d_name"));
            p_xuca_uuv_opt_1.put(arrayList, hashMap);
            updateSqlCalValMap.get(3).put(arrayList, resultSet.getDouble("d_ytd"));
        }
        resultSet.close();
        statement.close();
    }

    public void addKey(String string) {
        this.pstSetVal.add(string);
    }

    public void resetKey() {
        this.pstSetVal.clear();
    }

    public List<String> getKey() {
        return this.pstSetVal;
    }

    public void reset() {
        this.resetKey();
        this.resetUseUuv();
    }

    public int update() throws InterruptedException {
        List<String> list = this.getKey();
        if (this.index == 2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(list.get(1));
            Map<String, Object> map = this.getUuvOpt(this.index).get(arrayList);
            if (map != null) {
                HashMap<ArrayList<String>, Double> hashMap = new HashMap<ArrayList<String>, Double>();
                hashMap.put(arrayList, Double.valueOf(list.get(0)));
                this.getUpdValmap(this.index).put(hashMap);
                return 1;
            }
        } else if (this.index == 3) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(list.get(1));
            arrayList.add(list.get(2));
            Map<String, Object> map = this.getUuvOpt(this.index).get(arrayList);
            if (map != null) {
                HashMap<ArrayList<String>, Double> hashMap = new HashMap<ArrayList<String>, Double>();
                hashMap.put(arrayList, Double.valueOf(list.get(0)));
                this.getUpdValmap(this.index).put(hashMap);
                return 1;
            }
        }
        return 0;
    }

    private static Double calDoubleVal(List<Double> list) {
        Double d = 0.0;
        for (Double d2 : list) {
            d = d + d2;
        }
        return d;
    }

    public static void updatedb(Connection connection, Map<List<String>, Double> map, int n) throws SQLException {
        if (!isUpdateDb) {
            return;
        }
        PreparedStatement preparedStatement = null;
        int n2 = 500;
        int n3 = 0;
        if (n == 2) {
            String string = "UPDATE bmsql_warehouse  SET w_ytd=? WHERE w_id=?";
            preparedStatement = connection.prepareStatement(string);
            for (List<String> list : map.keySet()) {
                Double d = map.get(list);
                preparedStatement.setDouble(1, d);
                preparedStatement.setString(2, list.get(0));
                preparedStatement.addBatch();
                if (++n3 % n2 != 0) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
            preparedStatement.executeBatch();
            preparedStatement.clearBatch();
        } else if (n == 3) {
            String string = "UPDATE bmsql_district SET d_ytd=? WHERE d_w_id=? AND d_id=?";
            preparedStatement = connection.prepareStatement(string);
            for (List<String> list : map.keySet()) {
                Double d = map.get(list);
                preparedStatement.setDouble(1, d);
                preparedStatement.setString(2, list.get(0));
                preparedStatement.setString(3, list.get(1));
                preparedStatement.addBatch();
                if (++n3 % n2 != 0) continue;
                preparedStatement.executeBatch();
                preparedStatement.clearBatch();
            }
            preparedStatement.executeBatch();
            preparedStatement.clearBatch();
        }
        connection.commit();
        preparedStatement.close();
    }
}

