/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbc;

import com.gbasedbt.jdbc.Driver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public class Version {
    public static String GBASE_JDBC_RELEASE_VERSION = "100.100";
    public static String GBASE_SERVER_VERSION = "100.100";
    public static String VER_RETAIN_SERVER_VERSION = "12.10.FC4G1";

    public static void main(String[] stringArray) {
        try {
            System.out.println("GBase JDBC Driver Version " + Driver.getJDBCVersion());
        }
        catch (SQLException sQLException) {
            System.out.println("GBase error code: " + sQLException.getErrorCode() + "\n" + sQLException.toString());
        }
    }

    private static String getSerialNumber() {
        String string;
        ResourceBundle resourceBundle;
        try {
            resourceBundle = ResourceBundle.getBundle("com.gbasedbt.jdbc.SerialNumber");
        }
        catch (MissingResourceException missingResourceException) {
            return "(Unregistered Version)";
        }
        if (resourceBundle == null) {
            return "(Unregistered Version)";
        }
        try {
            string = resourceBundle.getString("SSN");
        }
        catch (MissingResourceException missingResourceException) {
            return "(Unregistered Version)";
        }
        return string;
    }

    public static String printBuildDate() {
        return "2022-08-30";
    }

    static {
        if (GBASE_JDBC_RELEASE_VERSION.equalsIgnoreCase("100.100")) {
            Properties properties = null;
            InputStream inputStream = null;
            try {
                URL uRL = Version.class.getResource("version.properties");
                inputStream = uRL.openStream();
                properties = new Properties();
                properties.load(inputStream);
                GBASE_JDBC_RELEASE_VERSION = properties.getProperty("jdbc_release_version").trim();
                GBASE_SERVER_VERSION = properties.getProperty("server_version").trim();
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }
}

