/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.jdbcx;

import com.gbasedbt.jdbc.IfxConnection;
import com.gbasedbt.jdbcx.IfxConnectionPoolDataSource;
import com.gbasedbt.jdbcx.IfxConnectionPoolManager;
import com.gbasedbt.jdbcx.IfxCoreDataSource;
import com.gbasedbt.jdbcx.IfxDataSourceFactory;
import com.gbasedbt.util.IfxErrMsg;
import com.gbasedbt.util.Trace;
import com.gbasedbt.util.TraceFlag;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class IfxDataSource
extends IfxCoreDataSource
implements DataSource,
Referenceable {
    private IfxConnectionPoolManager cpm = null;
    String cpdsName = null;
    private Constructor<?> cons = null;
    private Trace trace = null;

    public IfxDataSource() throws SQLException {
    }

    public IfxDataSource(IfxConnectionPoolDataSource ifxConnectionPoolDataSource) throws SQLException {
        this.cpdsName = null;
        this.cpm = null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.cpm == null) {
            String string = this.getUser();
            String string2 = this.getPassword();
            if (string == null && string2 == null || string != null && string2 != null) {
                return this.getSqliConnection(string, string2);
            }
            throw IfxErrMsg.getLocSQLException(-79811, this.getIfxCLIENT_LOCALE());
        }
        return this.cpm.getConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        if (this.cpm == null) {
            return this.getSqliConnection(string, string2);
        }
        return this.cpm.getConnection(string, string2);
    }

    private Connection getSqliConnection(String string, String string2) throws SQLException {
        IfxConnection ifxConnection;
        String string3 = "";
        String string4 = null;
        String string5 = null;
        String string6 = null;
        Properties properties = this.getDsProperties();
        string4 = properties.getProperty("IFXHOST");
        string5 = properties.getProperty("PORTNO");
        string6 = properties.getProperty("CONNECTIONCLASS");
        if (string6.equals("com.gbasedbt.jdbc.IfxSqliConnect") && string4 != null && string5 != null) {
            string3 = string4 + ":" + string5;
        }
        try {
            Class[] classArray = null;
            Object[] objectArray = null;
            if (this.cons == null) {
                if (string6.equals("com.gbasedbt.jdbc.IfxSqliConnect")) {
                    classArray = new Class[]{string == null ? String.valueOf("").getClass() : string.getClass(), string2 == null ? String.valueOf("").getClass() : string2.getClass(), string3.getClass(), properties.getClass()};
                    Class<?> clazz = Class.forName(string6);
                    this.cons = clazz.getConstructor(classArray);
                } else {
                    classArray = new Class[]{string3.getClass(), properties.getClass()};
                    Class<?> clazz = Class.forName(string6);
                    this.cons = clazz.getConstructor(classArray);
                }
            }
            if (string3.equals("")) {
                string3 = null;
            }
            objectArray = string6.equals("com.gbasedbt.jdbc.IfxSqliConnect") ? new Object[]{string, string2, string3, properties} : new Object[]{string3, properties};
            ifxConnection = (IfxConnection)this.cons.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (SQLException)invocationTargetException.getTargetException();
        }
        catch (Exception exception) {
            throw IfxErrMsg.getLocSQLException(-79704, exception.toString(), this.getIfxCLIENT_LOCALE());
        }
        if (TraceFlag.compiletrace) {
            this.trace = ifxConnection.getTrace();
            this.trace.writeTrace(1, "IfxDataSource: This has NO Connection Pool");
            this.trace.writeTrace(1, "IfxDataSource: getSqliConnection() exited");
        }
        return ifxConnection;
    }

    void getCPM() throws SQLException {
        try {
            this.cpdsName = this.getDataSourceName();
            if (this.cpdsName != null) {
                this.cpm = new IfxConnectionPoolManager(this.cpdsName);
                this.cpm.startPoolService();
            } else {
                this.cpm = null;
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw IfxErrMsg.getLocSQLException(-79716, exception.toString(), this.getIfxCLIENT_LOCALE());
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeProperties(byteArrayOutputStream);
            return new Reference(IfxDataSource.class.getName(), new StringRefAddr("DSProperties", new String(byteArrayOutputStream.toByteArray(), "ISO8859_1")), IfxDataSourceFactory.class.getName(), null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getCPMFreeCount() {
        if (this.cpm != null) {
            return this.cpm.getFreeCount();
        }
        return 0;
    }

    public IfxConnectionPoolDataSource getCPDS() {
        if (this.cpm != null) {
            return this.cpm.getCPDS();
        }
        return null;
    }

    public void activateHDRPool_Primary() throws SQLException {
        if (this.cpm != null) {
            this.cpm.switchActivePool("PRIMARY");
        }
    }

    public void activateHDRPool_Secondary() throws SQLException {
        if (this.cpm != null) {
            this.cpm.switchActivePool("SECONDARY");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDataSource:isWrapperFor(Class)not supported");
        }
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (TraceFlag.compiletrace) {
            this.trace.writeTrace(2, "IfxDataSource:unwrap(Class<T>)not supported");
        }
        return null;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

