/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.json;

public class Base64Codec {
    private static final int BYTES_PER_UNENCODED_BLOCK = 3;
    private static final int BYTES_PER_ENCODED_BLOCK = 4;
    private static final int SixBitMask = 63;
    private static final byte PAD = 61;
    private static final byte[] EncodeTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final int[] DecodeTable = new int[128];

    public byte[] decode(String string) {
        int n = string.endsWith("==") ? 2 : (string.endsWith("=") ? 1 : 0);
        byte[] byArray = new byte[string.length() * 3 / 4 - n];
        int n2 = 255;
        int n3 = 0;
        for (int i = 0; i < string.length(); i += 4) {
            int n4 = DecodeTable[string.charAt(i)];
            int n5 = DecodeTable[string.charAt(i + 1)];
            byArray[n3++] = (byte)((n4 << 2 | n5 >> 4) & n2);
            if (n3 >= byArray.length) {
                return byArray;
            }
            int n6 = DecodeTable[string.charAt(i + 2)];
            byArray[n3++] = (byte)((n5 << 4 | n6 >> 2) & n2);
            if (n3 >= byArray.length) {
                return byArray;
            }
            int n7 = DecodeTable[string.charAt(i + 3)];
            byArray[n3++] = (byte)((n6 << 6 | n7) & n2);
        }
        return byArray;
    }

    public String encode(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length / 3 * 4 + (byArray.length % 3 == 0 ? 0 : 4);
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        for (int n5 : byArray) {
            n = (n + 1) % 3;
            if (n5 < 0) {
                n5 += 256;
            }
            n2 = (n2 << 8) + n5;
            if (0 != n) continue;
            byArray2[n4++] = EncodeTable[n2 >> 18 & 0x3F];
            byArray2[n4++] = EncodeTable[n2 >> 12 & 0x3F];
            byArray2[n4++] = EncodeTable[n2 >> 6 & 0x3F];
            byArray2[n4++] = EncodeTable[n2 & 0x3F];
        }
        switch (n) {
            case 1: {
                byArray2[n4++] = EncodeTable[n2 >> 2 & 0x3F];
                byArray2[n4++] = EncodeTable[n2 << 4 & 0x3F];
                byArray2[n4++] = 61;
                byArray2[n4] = 61;
                break;
            }
            case 2: {
                byArray2[n4++] = EncodeTable[n2 >> 10 & 0x3F];
                byArray2[n4++] = EncodeTable[n2 >> 4 & 0x3F];
                byArray2[n4++] = EncodeTable[n2 << 2 & 0x3F];
                byArray2[n4] = 61;
            }
        }
        return new String(byArray2);
    }

    static {
        for (int i = 0; i < EncodeTable.length; ++i) {
            Base64Codec.DecodeTable[Base64Codec.EncodeTable[i]] = i;
        }
    }
}

