/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.json;

import com.gbasedbt.json.Base64Codec;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.BasicBSONList;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.DBRef;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class JSONCallback
extends BasicBSONCallback {
    private boolean _lastArray = false;
    public static final String _msDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String _secDateFormat = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    @Override
    public BSONObject create() {
        return new BasicBSONObject();
    }

    @Override
    protected BSONObject createList() {
        return new BasicBSONList();
    }

    @Override
    public void objectStart(boolean bl, String string) {
        this._lastArray = bl;
        super.objectStart(bl, string);
    }

    @Override
    public Object objectDone() {
        String string = this.curName();
        Object object = super.objectDone();
        if (this._lastArray) {
            return object;
        }
        BSONObject bSONObject = (BSONObject)object;
        if (bSONObject.containsField("$oid")) {
            object = new ObjectId((String)bSONObject.get("$oid"));
        } else if (bSONObject.containsField("$date")) {
            if (bSONObject.get("$date") instanceof Number) {
                object = new Date(((Number)bSONObject.get("$date")).longValue());
            } else {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(_msDateFormat);
                simpleDateFormat.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
                object = simpleDateFormat.parse(bSONObject.get("$date").toString(), new ParsePosition(0));
                if (object == null) {
                    simpleDateFormat = new SimpleDateFormat(_secDateFormat);
                    simpleDateFormat.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
                    object = simpleDateFormat.parse(bSONObject.get("$date").toString(), new ParsePosition(0));
                }
            }
        } else if (bSONObject.containsField("$regex")) {
            object = Pattern.compile((String)bSONObject.get("$regex"), BSON.regexFlags((String)bSONObject.get("$options")));
        } else if (bSONObject.containsField("$ts")) {
            Integer n = ((Number)bSONObject.get("$ts")).intValue();
            Integer n2 = ((Number)bSONObject.get("$inc")).intValue();
            object = new BSONTimestamp(n, (int)n2);
        } else if (bSONObject.containsField("$timestamp")) {
            BSONObject bSONObject2 = (BSONObject)bSONObject.get("$timestamp");
            Integer n = ((Number)bSONObject2.get("t")).intValue();
            Integer n3 = ((Number)bSONObject2.get("i")).intValue();
            object = new BSONTimestamp(n, (int)n3);
        } else if (bSONObject.containsField("$code")) {
            object = bSONObject.containsField("$scope") ? new CodeWScope((String)bSONObject.get("$code"), (BSONObject)bSONObject.get("$scope")) : new Code((String)bSONObject.get("$code"));
        } else if (bSONObject.containsField("$ref")) {
            object = new DBRef((String)bSONObject.get("$ref"), bSONObject.get("$id"));
        } else if (bSONObject.containsField("$minKey")) {
            object = new MinKey();
        } else if (bSONObject.containsField("$maxKey")) {
            object = new MaxKey();
        } else if (bSONObject.containsField("$uuid")) {
            object = UUID.fromString((String)bSONObject.get("$uuid"));
        } else if (bSONObject.containsField("$binary")) {
            int n = (Integer)bSONObject.get("$type");
            byte[] byArray = new Base64Codec().decode((String)bSONObject.get("$binary"));
            object = new Binary((byte)n, byArray);
        }
        if (!this.isStackEmpty()) {
            this._put(string, object);
        } else {
            object = !BSON.hasDecodeHooks() ? object : BSON.applyDecodingHooks(object);
            this.setRoot(object);
        }
        return object;
    }
}

