/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.json;

import com.gbasedbt.json.JSONCallback;
import com.gbasedbt.json.JSONParseException;
import org.bson.BSONCallback;

class JSONParser {
    String s;
    int pos = 0;
    BSONCallback _callback;

    public JSONParser(String string) {
        this(string, null);
    }

    public JSONParser(String string, BSONCallback bSONCallback) {
        this.s = string;
        this._callback = bSONCallback == null ? new JSONCallback() : bSONCallback;
    }

    public Object parse() {
        return this.parse(null);
    }

    protected Object parse(String string) {
        Object object = null;
        char c = this.get();
        switch (c) {
            case 'n': {
                this.read('n');
                this.read('u');
                this.read('l');
                this.read('l');
                object = null;
                break;
            }
            case 'N': {
                this.read('N');
                this.read('a');
                this.read('N');
                object = Double.NaN;
                break;
            }
            case 't': {
                this.read('t');
                this.read('r');
                this.read('u');
                this.read('e');
                object = true;
                break;
            }
            case 'f': {
                this.read('f');
                this.read('a');
                this.read('l');
                this.read('s');
                this.read('e');
                object = false;
                break;
            }
            case '\"': 
            case '\'': {
                object = this.parseString(true);
                break;
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                object = this.parseNumber();
                break;
            }
            case '[': {
                object = this.parseArray(string);
                break;
            }
            case '{': {
                object = this.parseObject(string);
                break;
            }
            default: {
                throw new JSONParseException(this.s, this.pos);
            }
        }
        return object;
    }

    public Object parseObject() {
        return this.parseObject(null);
    }

    protected Object parseObject(String string) {
        if (string != null) {
            this._callback.objectStart(string);
        } else {
            this._callback.objectStart();
        }
        this.read('{');
        char c = this.get();
        while (this.get() != '}') {
            String string2 = this.parseString(false);
            this.read(':');
            Object object = this.parse(string2);
            this.doCallback(string2, object);
            c = this.get();
            if (c != ',') break;
            this.read(',');
        }
        this.read('}');
        return this._callback.objectDone();
    }

    protected void doCallback(String string, Object object) {
        if (object == null) {
            this._callback.gotNull(string);
        } else if (object instanceof String) {
            this._callback.gotString(string, (String)object);
        } else if (object instanceof Boolean) {
            this._callback.gotBoolean(string, (Boolean)object);
        } else if (object instanceof Integer) {
            this._callback.gotInt(string, (Integer)object);
        } else if (object instanceof Long) {
            this._callback.gotLong(string, (Long)object);
        } else if (object instanceof Double) {
            this._callback.gotDouble(string, (Double)object);
        }
    }

    public void read(char c) {
        if (!this.check(c)) {
            throw new JSONParseException(this.s, this.pos);
        }
        ++this.pos;
    }

    public char read() {
        if (this.pos >= this.s.length()) {
            throw new IllegalStateException("string done");
        }
        return this.s.charAt(this.pos++);
    }

    public void readHex() {
        if (this.pos < this.s.length() && (this.s.charAt(this.pos) >= '0' && this.s.charAt(this.pos) <= '9' || this.s.charAt(this.pos) >= 'A' && this.s.charAt(this.pos) <= 'F' || this.s.charAt(this.pos) >= 'a' && this.s.charAt(this.pos) <= 'f')) {
            ++this.pos;
        } else {
            throw new JSONParseException(this.s, this.pos);
        }
    }

    public boolean check(char c) {
        return this.get() == c;
    }

    public void skipWS() {
        while (this.pos < this.s.length() && Character.isWhitespace(this.s.charAt(this.pos))) {
            ++this.pos;
        }
    }

    public char get() {
        this.skipWS();
        if (this.pos < this.s.length()) {
            return this.s.charAt(this.pos);
        }
        return '\uffff';
    }

    public String parseString(boolean bl) {
        char c = '\u0000';
        if (this.check('\'')) {
            c = '\'';
        } else if (this.check('\"')) {
            c = '\"';
        } else if (bl) {
            throw new JSONParseException(this.s, this.pos);
        }
        if (c > '\u0000') {
            this.read(c);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.pos;
        block9: while (this.pos < this.s.length()) {
            char c2 = this.s.charAt(this.pos);
            if (c <= '\u0000' ? c2 == ':' || c2 == ' ' : c2 == c) break;
            if (c2 == '\\') {
                ++this.pos;
                char c3 = this.get();
                char c4 = '\u0000';
                switch (c3) {
                    case 'u': {
                        stringBuilder.append(this.s.substring(n, this.pos - 1));
                        int n2 = ++this.pos;
                        this.readHex();
                        this.readHex();
                        this.readHex();
                        this.readHex();
                        int n3 = Integer.parseInt(this.s.substring(n2, n2 + 4), 16);
                        stringBuilder.append((char)n3);
                        n = this.pos;
                        continue block9;
                    }
                    case 'n': {
                        c4 = '\n';
                        break;
                    }
                    case 'r': {
                        c4 = '\r';
                        break;
                    }
                    case 't': {
                        c4 = '\t';
                        break;
                    }
                    case 'b': {
                        c4 = '\b';
                        break;
                    }
                    case '\"': {
                        c4 = '\"';
                        break;
                    }
                    case '\\': {
                        c4 = '\\';
                    }
                }
                stringBuilder.append(this.s.substring(n, this.pos - 1));
                if (c4 != '\u0000') {
                    stringBuilder.append(c4);
                }
                n = ++this.pos;
                continue;
            }
            ++this.pos;
        }
        stringBuilder.append(this.s.substring(n, this.pos));
        if (c > '\u0000') {
            this.read(c);
        }
        return stringBuilder.toString();
    }

    public Number parseNumber() {
        char c = this.get();
        int n = this.pos;
        boolean bl = false;
        if (this.check('-') || this.check('+')) {
            ++this.pos;
        }
        block7: while (this.pos < this.s.length()) {
            switch (this.s.charAt(this.pos)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++this.pos;
                    continue block7;
                }
                case '.': {
                    bl = true;
                    this.parseFraction();
                    continue block7;
                }
                case 'E': 
                case 'e': {
                    bl = true;
                    this.parseExponent();
                    continue block7;
                }
            }
        }
        try {
            if (bl) {
                return Double.valueOf(this.s.substring(n, this.pos));
            }
            Long l = Long.valueOf(this.s.substring(n, this.pos));
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return l.intValue();
            }
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSONParseException(this.s, n, numberFormatException);
        }
    }

    public void parseFraction() {
        ++this.pos;
        block4: while (this.pos < this.s.length()) {
            switch (this.s.charAt(this.pos)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++this.pos;
                    continue block4;
                }
                case 'E': 
                case 'e': {
                    this.parseExponent();
                    continue block4;
                }
            }
            break;
        }
    }

    public void parseExponent() {
        ++this.pos;
        if (this.check('-') || this.check('+')) {
            ++this.pos;
        }
        block3: while (this.pos < this.s.length()) {
            switch (this.s.charAt(this.pos)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++this.pos;
                    continue block3;
                }
            }
            break;
        }
    }

    public Object parseArray() {
        return this.parseArray(null);
    }

    protected Object parseArray(String string) {
        if (string != null) {
            this._callback.arrayStart(string);
        } else {
            this._callback.arrayStart();
        }
        this.read('[');
        int n = 0;
        char c = this.get();
        while (c != ']') {
            String string2 = String.valueOf(n++);
            Object object = this.parse(string2);
            this.doCallback(string2, object);
            c = this.get();
            if (c == ',') {
                this.read(',');
                continue;
            }
            if (c == ']') break;
            throw new JSONParseException(this.s, this.pos);
        }
        this.read(']');
        return this._callback.arrayDone();
    }
}

