/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.json;

import com.gbasedbt.json.AbstractObjectSerializer;
import com.gbasedbt.json.Base64Codec;
import com.gbasedbt.json.Bytes;
import com.gbasedbt.json.ClassMapBasedObjectSerializer;
import com.gbasedbt.json.JSON;
import com.gbasedbt.json.ObjectSerializer;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.DBRefBase;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;

public class JSONSerializers {
    private JSONSerializers() {
    }

    public static ObjectSerializer getLegacy() {
        return JSONSerializers.getLegacy(false);
    }

    public static ObjectSerializer getLegacy(boolean bl) {
        ClassMapBasedObjectSerializer classMapBasedObjectSerializer = JSONSerializers.addCommonSerializers(bl);
        classMapBasedObjectSerializer.addObjectSerializer(Date.class, new LegacyDateSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(BSONTimestamp.class, new LegacyBSONTimestampSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(Binary.class, new LegacyBinarySerializer());
        classMapBasedObjectSerializer.addObjectSerializer(byte[].class, new LegacyBinarySerializer());
        return classMapBasedObjectSerializer;
    }

    public static ObjectSerializer getStrict() {
        return JSONSerializers.getStrict(false);
    }

    public static ObjectSerializer getStrict(boolean bl) {
        ClassMapBasedObjectSerializer classMapBasedObjectSerializer = JSONSerializers.addCommonSerializers(bl);
        classMapBasedObjectSerializer.addObjectSerializer(Date.class, new DateSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(BSONTimestamp.class, new BSONTimestampSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(Binary.class, new BinarySerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(byte[].class, new ByteArraySerializer(classMapBasedObjectSerializer, bl));
        return classMapBasedObjectSerializer;
    }

    public static ObjectSerializer getGBasedbt() {
        return JSONSerializers.getGBasedbt(false);
    }

    public static ObjectSerializer getGBasedbt(boolean bl) {
        ClassMapBasedObjectSerializer classMapBasedObjectSerializer = JSONSerializers.addCommonSerializers(bl);
        classMapBasedObjectSerializer.addObjectSerializer(ObjectId.class, new GBasedbtObjectIdSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(Date.class, new GBasedbtDateSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(BSONTimestamp.class, new LegacyBSONTimestampSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(Binary.class, new LegacyBinarySerializer());
        classMapBasedObjectSerializer.addObjectSerializer(byte[].class, new LegacyBinarySerializer());
        return classMapBasedObjectSerializer;
    }

    static ClassMapBasedObjectSerializer addCommonSerializers(boolean bl) {
        ClassMapBasedObjectSerializer classMapBasedObjectSerializer = new ClassMapBasedObjectSerializer();
        classMapBasedObjectSerializer.addObjectSerializer(Object[].class, new ObjectArraySerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(Boolean.class, new ToStringSerializer());
        classMapBasedObjectSerializer.addObjectSerializer(Code.class, new CodeSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(CodeWScope.class, new CodeWScopeSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(BSONObject.class, new BSONObjectSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(DBRefBase.class, new DBRefBaseSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(Iterable.class, new IterableSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(Map.class, new MapSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(MaxKey.class, new MaxKeySerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(MinKey.class, new MinKeySerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(Number.class, new ToStringSerializer());
        classMapBasedObjectSerializer.addObjectSerializer(ObjectId.class, new ObjectIdSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(Pattern.class, new PatternSerializer(classMapBasedObjectSerializer, bl));
        classMapBasedObjectSerializer.addObjectSerializer(String.class, new StringSerializer());
        classMapBasedObjectSerializer.addObjectSerializer(UUID.class, new UUIDSerializer(classMapBasedObjectSerializer, bl));
        return classMapBasedObjectSerializer;
    }

    private static class ByteArraySerializer
    extends BinarySerializerBase {
        ByteArraySerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            this.serialize((byte[])object, (byte)0, stringBuilder);
        }
    }

    private static class BinarySerializer
    extends BinarySerializerBase {
        BinarySerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            Binary binary = (Binary)object;
            this.serialize(binary.getData(), binary.getType(), stringBuilder);
        }
    }

    private static abstract class BinarySerializerBase
    extends CompoundObjectSerializer {
        BinarySerializerBase(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        protected void serialize(byte[] byArray, byte by, StringBuilder stringBuilder) {
            BasicBSONObject basicBSONObject = new BasicBSONObject();
            basicBSONObject.put("$binary", (Object)new Base64Codec().encode(byArray));
            basicBSONObject.put("$type", (Object)by);
            this.serializer.serialize(basicBSONObject, stringBuilder);
        }
    }

    private static class DateSerializer
    extends CompoundObjectSerializer {
        DateSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            Date date = (Date)object;
            this.serializer.serialize(new BasicBSONObject("$date", (Object)date.getTime()), stringBuilder);
        }
    }

    private static class BSONTimestampSerializer
    extends CompoundObjectSerializer {
        BSONTimestampSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            BSONTimestamp bSONTimestamp = (BSONTimestamp)object;
            BasicBSONObject basicBSONObject = new BasicBSONObject();
            basicBSONObject.put("t", (Object)bSONTimestamp.getTime());
            basicBSONObject.put("i", (Object)bSONTimestamp.getInc());
            BasicBSONObject basicBSONObject2 = new BasicBSONObject();
            basicBSONObject2.put("$timestamp", (Object)basicBSONObject);
            this.serializer.serialize(basicBSONObject2, stringBuilder);
        }
    }

    private static class UUIDSerializer
    extends CompoundObjectSerializer {
        UUIDSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            UUID uUID = (UUID)object;
            BasicBSONObject basicBSONObject = new BasicBSONObject();
            basicBSONObject.put("$uuid", (Object)uUID.toString());
            this.serializer.serialize(basicBSONObject, stringBuilder);
        }
    }

    private static class StringSerializer
    extends AbstractObjectSerializer {
        private StringSerializer() {
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            JSON.string(stringBuilder, (String)object);
        }
    }

    private static class PatternSerializer
    extends CompoundObjectSerializer {
        PatternSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            BasicBSONObject basicBSONObject = new BasicBSONObject();
            basicBSONObject.put("$regex", (Object)object.toString());
            if (((Pattern)object).flags() != 0) {
                basicBSONObject.put("$options", (Object)Bytes.regexFlags(((Pattern)object).flags()));
            }
            this.serializer.serialize(basicBSONObject, stringBuilder);
        }
    }

    private static class GBasedbtObjectIdSerializer
    extends CompoundObjectSerializer {
        GBasedbtObjectIdSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            stringBuilder.append("ObjectId(\"" + object.toString() + "\")");
        }
    }

    private static class ObjectIdSerializer
    extends CompoundObjectSerializer {
        ObjectIdSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            this.serializer.serialize(new BasicBSONObject("$oid", object.toString()), stringBuilder);
        }
    }

    private static class MinKeySerializer
    extends CompoundObjectSerializer {
        MinKeySerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            this.serializer.serialize(new BasicBSONObject("$minKey", (Object)1), stringBuilder);
        }
    }

    private static class MaxKeySerializer
    extends CompoundObjectSerializer {
        MaxKeySerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            this.serializer.serialize(new BasicBSONObject("$maxKey", (Object)1), stringBuilder);
        }
    }

    private static class MapSerializer
    extends CompoundObjectSerializer {
        MapSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            boolean bl = true;
            if (this.minify) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append("{ ");
            }
            Map map = (Map)object;
            for (Map.Entry entry : map.entrySet()) {
                if (bl) {
                    bl = false;
                } else if (this.minify) {
                    stringBuilder.append(",");
                } else {
                    stringBuilder.append(" , ");
                }
                JSON.string(stringBuilder, (String)entry.getKey());
                if (this.minify) {
                    stringBuilder.append(":");
                } else {
                    stringBuilder.append(" : ");
                }
                this.serializer.serialize(entry.getValue(), stringBuilder);
            }
            if (this.minify) {
                stringBuilder.append("}");
            } else {
                stringBuilder.append(" }");
            }
        }
    }

    private static class IterableSerializer
    extends CompoundObjectSerializer {
        IterableSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            boolean bl = true;
            if (this.minify) {
                stringBuilder.append("[");
            } else {
                stringBuilder.append("[ ");
            }
            for (Object t : (Iterable)object) {
                if (bl) {
                    bl = false;
                } else if (this.minify) {
                    stringBuilder.append(",");
                } else {
                    stringBuilder.append(" , ");
                }
                this.serializer.serialize(t, stringBuilder);
            }
            if (this.minify) {
                stringBuilder.append("]");
            } else {
                stringBuilder.append(" ]");
            }
        }
    }

    private static class DBRefBaseSerializer
    extends CompoundObjectSerializer {
        DBRefBaseSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            DBRefBase dBRefBase = (DBRefBase)object;
            BasicBSONObject basicBSONObject = new BasicBSONObject();
            basicBSONObject.put("$ref", (Object)dBRefBase.getRef());
            basicBSONObject.put("$id", dBRefBase.getId());
            this.serializer.serialize(basicBSONObject, stringBuilder);
        }
    }

    private static class BSONObjectSerializer
    extends CompoundObjectSerializer {
        BSONObjectSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            boolean bl = true;
            if (this.minify) {
                stringBuilder.append("{");
            } else {
                stringBuilder.append("{ ");
            }
            BSONObject bSONObject = (BSONObject)object;
            Iterator<String> iterator = bSONObject.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next();
                if (bl) {
                    bl = false;
                } else if (this.minify) {
                    stringBuilder.append(",");
                } else {
                    stringBuilder.append(" , ");
                }
                JSON.string(stringBuilder, string2);
                if (this.minify) {
                    stringBuilder.append(":");
                } else {
                    stringBuilder.append(" : ");
                }
                this.serializer.serialize(bSONObject.get(string2), stringBuilder);
            }
            if (this.minify) {
                stringBuilder.append("}");
            } else {
                stringBuilder.append(" }");
            }
        }
    }

    private static class GBasedbtDateSerializer
    extends CompoundObjectSerializer {
        GBasedbtDateSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            Date date = (Date)object;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
            stringBuilder.append("ISODate(\"");
            stringBuilder.append(simpleDateFormat.format(date));
            stringBuilder.append("\")");
        }
    }

    private static class LegacyDateSerializer
    extends CompoundObjectSerializer {
        LegacyDateSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            Date date = (Date)object;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            simpleDateFormat.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
            this.serializer.serialize(new BasicBSONObject("$date", simpleDateFormat.format(date)), stringBuilder);
        }
    }

    private static class CodeWScopeSerializer
    extends CompoundObjectSerializer {
        CodeWScopeSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            CodeWScope codeWScope = (CodeWScope)object;
            BasicBSONObject basicBSONObject = new BasicBSONObject();
            basicBSONObject.put("$code", (Object)codeWScope.getCode());
            basicBSONObject.put("$scope", (Object)codeWScope.getScope());
            this.serializer.serialize(basicBSONObject, stringBuilder);
        }
    }

    private static class CodeSerializer
    extends CompoundObjectSerializer {
        CodeSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            Code code = (Code)object;
            BasicBSONObject basicBSONObject = new BasicBSONObject();
            basicBSONObject.put("$code", (Object)code.getCode());
            this.serializer.serialize(basicBSONObject, stringBuilder);
        }
    }

    private static class LegacyBSONTimestampSerializer
    extends CompoundObjectSerializer {
        LegacyBSONTimestampSerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            BSONTimestamp bSONTimestamp = (BSONTimestamp)object;
            BasicBSONObject basicBSONObject = new BasicBSONObject();
            basicBSONObject.put("$ts", (Object)bSONTimestamp.getTime());
            basicBSONObject.put("$inc", (Object)bSONTimestamp.getInc());
            this.serializer.serialize(basicBSONObject, stringBuilder);
        }
    }

    private static class ToStringSerializer
    extends AbstractObjectSerializer {
        private ToStringSerializer() {
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            stringBuilder.append(object.toString());
        }
    }

    private static class ObjectArraySerializer
    extends CompoundObjectSerializer {
        ObjectArraySerializer(ObjectSerializer objectSerializer, boolean bl) {
            super(objectSerializer, bl);
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            if (this.minify) {
                stringBuilder.append("[");
            } else {
                stringBuilder.append("[ ");
            }
            for (int i = 0; i < Array.getLength(object); ++i) {
                if (i > 0) {
                    if (this.minify) {
                        stringBuilder.append(",");
                    } else {
                        stringBuilder.append(" , ");
                    }
                }
                this.serializer.serialize(Array.get(object, i), stringBuilder);
            }
            if (this.minify) {
                stringBuilder.append("]");
            } else {
                stringBuilder.append(" ]");
            }
        }
    }

    private static class LegacyBinarySerializer
    extends AbstractObjectSerializer {
        private LegacyBinarySerializer() {
        }

        @Override
        public void serialize(Object object, StringBuilder stringBuilder) {
            stringBuilder.append("<Binary Data>");
        }
    }

    private static abstract class CompoundObjectSerializer
    extends AbstractObjectSerializer {
        protected final ObjectSerializer serializer;
        protected final boolean minify;

        CompoundObjectSerializer(ObjectSerializer objectSerializer, boolean bl) {
            this.serializer = objectSerializer;
            this.minify = bl;
        }
    }
}

