/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.rws;

import com.gbasedbt.rws.RwsDataSource;
import com.gbasedbt.rws.ThreadContext;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import javax.sql.DataSource;

public class RwsUtil {
    public static String formatSql(String string) {
        String string2 = null;
        string2 = RwsUtil.stripComments(string, "'\"", "'\"", true, false, true, true);
        if ((string2 = string2.toLowerCase().replaceAll("\r\n", " ").replaceAll("\r", " ").replaceAll("\n", " ").replaceAll("\t", " ").replaceAll("\\(", "").replaceAll("\\)", "").trim()).endsWith(";")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        string2.trim();
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String stripComments(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        StringReader stringReader = new StringReader(string);
        char c = '\u0000';
        boolean bl5 = false;
        int n = -1;
        int n2 = 0;
        char c2 = '\u0000';
        try {
            block2: while ((c2 = stringReader.read()) != '\uffffffff') {
                char c3;
                block22: {
                    block23: {
                        block20: {
                            block21: {
                                if (n != -1 && c2 == string3.charAt(n) && !bl5) {
                                    c = '\u0000';
                                    n = -1;
                                } else {
                                    n2 = string2.indexOf(c2);
                                    if (n2 != -1 && !bl5 && c == '\u0000') {
                                        n = n2;
                                        c = c2;
                                    }
                                }
                                if (c != '\u0000' || c2 != '/' || !bl2 && !bl) break block20;
                                c2 = stringReader.read();
                                if (c2 != '*' || !bl) break block21;
                                c3 = '\u0000';
                                break block22;
                            }
                            if (c2 == '/' && bl2) {
                                while ((c2 = stringReader.read()) != '\n' && c2 != '\r' && c2 >= '\u0000') {
                                }
                            }
                            break block23;
                        }
                        if (c == '\u0000' && c2 == '#' && bl3) {
                            while ((c2 = stringReader.read()) != '\n' && c2 != '\r' && c2 >= '\u0000') {
                            }
                        } else if (c == '\u0000' && c2 == '-' && bl4) {
                            c2 = stringReader.read();
                            if (c2 == '\uffffffff' || c2 != '-') {
                                stringBuilder.append('-');
                                if (c2 == '\uffffffff') continue;
                                stringBuilder.append(c2);
                                continue;
                            }
                            while ((c2 = stringReader.read()) != '\n' && c2 != '\r' && c2 >= '\u0000') {
                            }
                        }
                    }
                    if (c2 == '\uffffffff') continue;
                    stringBuilder.append(c2);
                    continue;
                }
                while ((c2 = stringReader.read()) != '/' || c3 != '*') {
                    if (c2 == '\r') {
                        c2 = stringReader.read();
                        if (c2 == '\n') {
                            c2 = stringReader.read();
                        }
                    } else if (c2 == '\n') {
                        c2 = stringReader.read();
                    }
                    if (c2 < '\u0000') continue block2;
                    c3 = c2;
                }
            }
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static String nodeType(Connection connection, boolean bl) {
        String string = null;
        Boolean bl2 = RwsUtil.getAutoCommit(connection);
        if (bl2.booleanValue()) {
            string = bl ? "slave" : "master";
        } else {
            Boolean bl3 = RwsUtil.getDml(connection);
            if (bl3.booleanValue()) {
                string = "master";
            } else if (bl) {
                string = "slave";
            } else {
                string = "master";
                ThreadContext.setDmlTrue(RwsUtil.dmlKey(connection));
            }
        }
        return string;
    }

    public static Object getConnection(Connection connection, String string, Class<?> clazz) {
        Object var3_3 = null;
        Object object = null;
        String string2 = connection + "_" + string;
        try {
            if (ThreadContext.get(string2) != null) {
                object = ThreadContext.get(string2);
            } else {
                object = RwsUtil.get(string);
                ThreadContext.put(string2, object);
            }
            Wrapper wrapper = (Wrapper)object;
            var3_3 = wrapper.unwrap(clazz);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        return var3_3;
    }

    private static Connection get(String string) {
        Connection connection = null;
        try {
            DataSource dataSource = RwsDataSource.getDataSource(string);
            connection = dataSource.getConnection();
            return connection;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new RuntimeException(sQLException);
        }
    }

    private static Boolean getAutoCommit(Connection connection) {
        Boolean bl = false;
        try {
            bl = connection.getAutoCommit();
            return bl;
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw new RuntimeException(sQLException);
        }
    }

    private static Boolean getDml(Object object) {
        return ThreadContext.getDml(RwsUtil.dmlKey(object));
    }

    public static void removeDml() {
        ThreadContext.removeDml();
    }

    private static String dmlKey(Object object) {
        String string = object + "_dml";
        return string;
    }

    public static void putProtocol(Connection connection, Statement statement, Object object) {
        String string = RwsUtil.protocolKey(connection, statement);
        ThreadContext.put(string, object);
    }

    public static Object getProtocol(Connection connection, Statement statement) {
        String string = RwsUtil.protocolKey(connection, statement);
        return ThreadContext.get(string);
    }

    private static String protocolKey(Connection connection, Statement statement) {
        String string = connection + "_" + statement;
        return string;
    }

    public static void close(Object object) {
        Connection connection = (Connection)ThreadContext.get(object + "_slave");
        try {
            if (connection != null && !connection.isClosed()) {
                connection.setAutoCommit(true);
                connection.close();
                ThreadContext.remove(object + "_slave");
            }
            ThreadContext.remove();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

