/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.rws;

import java.util.HashMap;
import java.util.Map;

public abstract class ThreadContext {
    private static final ThreadLocal<Map<Object, Object>> resources = new InheritableThreadLocalMap();
    private static final ThreadLocal<Map<String, Boolean>> isDmlMap = new InheritableThreadLocalMap2();

    protected ThreadContext() {
    }

    public static Map<Object, Object> getResources() {
        return resources != null ? new HashMap<Object, Object>(resources.get()) : null;
    }

    public static void setResources(Map<? extends Object, ? extends Object> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        resources.get().clear();
        resources.get().putAll(map);
    }

    private static Object getValue(Object object) {
        return resources.get().get(object);
    }

    public static Object get(Object object) {
        Object object2 = ThreadContext.getValue(object);
        return object2;
    }

    public static void put(Object object, Object object2) {
        if (object == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (object2 == null) {
            ThreadContext.remove(object);
            return;
        }
        resources.get().put(object, object2);
    }

    public static Object remove(Object object) {
        Object object2 = resources.get().remove(object);
        return object2;
    }

    public static void remove() {
        resources.remove();
    }

    public static void setDmlFalse(String string) {
        isDmlMap.get().put(string, Boolean.FALSE);
    }

    public static void setDmlTrue(String string) {
        isDmlMap.get().put(string, Boolean.TRUE);
    }

    public static Boolean getDml(String string) {
        Boolean bl = isDmlMap.get().get(string);
        if (bl == null) {
            ThreadContext.setDmlFalse(string);
            return Boolean.FALSE;
        }
        return bl;
    }

    public static void removeDml() {
        isDmlMap.remove();
    }

    private static final class InheritableThreadLocalMap2<T extends Map<String, Boolean>>
    extends InheritableThreadLocal<Map<String, Boolean>> {
        private InheritableThreadLocalMap2() {
        }

        @Override
        protected Map<String, Boolean> initialValue() {
            return new HashMap<String, Boolean>();
        }

        @Override
        protected Map<String, Boolean> childValue(Map<String, Boolean> map) {
            if (map != null) {
                return (Map)((HashMap)map).clone();
            }
            return null;
        }
    }

    private static final class InheritableThreadLocalMap<T extends Map<Object, Object>>
    extends InheritableThreadLocal<Map<Object, Object>> {
        private InheritableThreadLocalMap() {
        }

        @Override
        protected Map<Object, Object> initialValue() {
            return new HashMap<Object, Object>();
        }

        @Override
        protected Map<Object, Object> childValue(Map<Object, Object> map) {
            if (map != null) {
                return (Map)((HashMap)map).clone();
            }
            return null;
        }
    }
}

