/*
 * Decompiled with CFR 0.152.
 */
package com.gbasedbt.util;

import com.gbasedbt.util.TraceFlag;
import com.gbasedbt.util.TraceOS;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class Trace {
    private final int DEF_TRACE_LEVEL = 0;
    private final int HEX_SIZE = 22;
    private final int HEX_ASCII_SIZE = 16;
    private int traceLevel = 0;
    private String traceFile = null;
    private TraceOS dataOS;

    public Trace() {
        this.traceLevel = 0;
        this.traceFile = null;
    }

    public void resetTrace() {
        this.closeTraceFile();
        this.traceFile = null;
        this.traceLevel = 0;
    }

    public Trace(int n, String string) {
        if (n == 0) {
            return;
        }
        if (string == null) {
            this.traceLevel = 0;
            System.err.println("Trace file is null, setting trace level to 0");
            return;
        }
        try {
            this.dataOS = new TraceOS(new PrintWriter((Writer)new BufferedWriter(new FileWriter(string, true)), true));
        }
        catch (Exception exception) {
            System.err.println("Cannot Open FileOutputStream for Trace" + exception.toString());
            System.err.println("No Tracing will be done");
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        if (this.dataOS.checkError()) {
            this.resetTrace();
        } else {
            this.traceLevel = n;
            this.traceFile = string;
        }
    }

    public void setTraceLevel(int n) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        this.traceLevel = n;
    }

    public synchronized void setNewTraceFile(int n, String string) {
        this.closeTraceFile();
        if (n == 0) {
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        if (string == null) {
            System.err.println("Filename is null, resetting Trace\n");
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        try {
            this.dataOS = new TraceOS(new PrintWriter((Writer)new BufferedWriter(new FileWriter(string, true)), true));
        }
        catch (Exception exception) {
            System.err.println("Cannot reOpen FileOutputStream for Trace" + exception.toString());
            System.err.println("No Tracing will be done");
            this.traceLevel = 0;
            this.traceFile = null;
            return;
        }
        if (this.dataOS.checkError()) {
            this.resetTrace();
        } else {
            this.traceLevel = n;
            this.traceFile = string;
        }
    }

    public String getTraceFile() {
        if (TraceFlag.compiletrace) {
            return this.traceFile;
        }
        return null;
    }

    public int getTraceLevel() {
        if (TraceFlag.compiletrace) {
            return this.traceLevel;
        }
        return 0;
    }

    public synchronized void setTraceOS(TraceOS traceOS) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.dataOS != null && !this.dataOS.equals(traceOS)) {
            this.closeTraceFile();
        }
        this.dataOS = traceOS;
    }

    public TraceOS getTraceOS() {
        if (TraceFlag.compiletrace) {
            return this.dataOS;
        }
        return null;
    }

    public void closeTraceFile() {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.flush();
            this.dataOS.close();
        }
    }

    public void writeTrace(int n, String string) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(string);
        }
    }

    public void writeTrace(int n, String string, String string2) {
        this.writeTrace(n, string + string2);
    }

    public void writeTrace(int n, String string, int n2) {
        this.writeTrace(n, string + n2);
    }

    public void writeTrace(int n, int n2) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(n2);
        }
    }

    public void writeTrace(int n, String string, short s) {
        this.writeTrace(n, string + s);
    }

    public void writeTrace(int n, short s) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(s);
        }
    }

    public void writeTrace(int n, String string, double d) {
        this.writeTrace(n, string + d);
    }

    public void writeTrace(int n, double d) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(d);
        }
    }

    public void writeTrace(int n, String string, float f) {
        this.writeTrace(n, string + f);
    }

    public void writeTrace(int n, float f) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(f);
        }
    }

    public void writeTrace(int n, String string, long l) {
        this.writeTrace(n, string + l);
    }

    public void writeTrace(int n, long l) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(l);
        }
    }

    public void writeTrace(int n, String string, boolean bl) {
        this.writeTrace(n, string + bl);
    }

    public void writeTrace(int n, boolean bl) {
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n) {
            return;
        }
        if (this.dataOS != null) {
            this.dataOS.println(bl);
        }
    }

    public void writeTrace(int n, byte[] byArray, char c) {
        this.writeTrace(n, byArray, c, byArray.length);
    }

    public void writeTrace(int n, byte[] byArray, char c, int n2) {
        this.writeTrace(n, byArray, 0, c, n2);
    }

    public void writeTrace(int n, byte[] byArray, int n2, char c, int n3) {
        int n4 = 0;
        boolean bl = true;
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = null;
        int n5 = 22;
        if (!TraceFlag.compiletrace) {
            return;
        }
        if (this.traceLevel < n) {
            return;
        }
        if (c == 'b' || c == 'B') {
            bl = false;
            n5 = 16;
            stringBuffer = new StringBuffer(n5);
        }
        stringBuffer2 = new StringBuffer(n5 * 4);
        try {
            if (bl) {
                this.dataOS.println("=================================-========================================");
                this.dataOS.println("Index:   Hex:");
            } else {
                this.dataOS.println("========================================================      ================");
                this.dataOS.println("Index:   Hex:                                                 Ascii:\n");
            }
            if (this.dataOS == null) {
                this.dataOS.println("   ***** NULL data *****  ");
                return;
            }
            int n6 = 0;
            while (n6 < n3) {
                Byte by = new Byte(byArray[n6 + n2]);
                int n7 = by.intValue();
                if (n4 == 0) {
                    stringBuffer2.append("0x");
                    if (n6 < 16) {
                        stringBuffer2.append("000");
                    } else if (n6 < 256) {
                        stringBuffer2.append("00");
                    } else if (n6 < 4096) {
                        stringBuffer2.append("0");
                    }
                    stringBuffer2.append(Integer.toHexString(n6));
                    stringBuffer2.append(":  ");
                }
                if ((n7 &= 0xFF) < 16) {
                    stringBuffer2.append("0");
                }
                stringBuffer2.append(Integer.toHexString(n7));
                stringBuffer2.append(" ");
                if (!bl) {
                    if ((n7 &= 0xFF) >= 32 && n7 <= 126) {
                        Character c2 = new Character((char)n7);
                        stringBuffer.append(c2.toString());
                    } else {
                        stringBuffer.append(".");
                    }
                }
                if (n4 == n5 - 1) {
                    this.dataOS.print(stringBuffer2.toString());
                    stringBuffer2 = new StringBuffer(n5 * 4);
                    if (!bl) {
                        this.dataOS.print("     ");
                        this.dataOS.print(stringBuffer.toString());
                        stringBuffer = new StringBuffer(n5);
                    }
                    this.dataOS.println("");
                    n4 = -1;
                }
                ++n6;
                ++n4;
            }
            if (n4 > -1) {
                this.dataOS.print(stringBuffer2.toString());
                if (!bl) {
                    while (n4 < n5) {
                        this.dataOS.print("   ");
                        ++n4;
                    }
                    this.dataOS.print("     ");
                    this.dataOS.print(stringBuffer.toString());
                }
            }
            this.dataOS.println("");
            if (bl) {
                this.dataOS.println("==========================================================================");
            } else {
                this.dataOS.println("==============================================================================");
            }
            this.dataOS.println("");
        }
        catch (Exception exception) {
            System.out.println("Exception in writeTrace...");
            System.out.println("Trying to create a Table ...\n");
        }
    }
}

