/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import com.gbasedbt.jdbc.IfxBSONObject;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.nio.Buffer;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.OutputBuffer;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.CodeWScope;
import org.bson.types.DBRefBase;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;
import org.bson.util.MyAsserts;

public class BasicBSONEncoder
implements BSONEncoder {
    static final boolean DEBUG = false;
    protected OutputBuffer _buf;

    @Override
    public byte[] encode(BSONObject bSONObject) {
        BasicOutputBuffer basicOutputBuffer = new BasicOutputBuffer();
        this.set(basicOutputBuffer);
        this.putObject(bSONObject);
        this.done();
        return basicOutputBuffer.toByteArray();
    }

    @Override
    public void set(OutputBuffer outputBuffer) {
        if (this._buf != null) {
            throw new IllegalStateException("in the middle of something");
        }
        this._buf = outputBuffer;
    }

    @Override
    public void done() {
        this._buf = null;
    }

    protected boolean handleSpecialObjects(String string, BSONObject bSONObject) {
        return false;
    }

    protected boolean putSpecial(String string, Object object) {
        return false;
    }

    @Override
    public int putObject(BSONObject bSONObject) {
        return this.putObject(null, bSONObject);
    }

    protected int putObject(String string, BSONObject bSONObject) {
        boolean bl;
        if (bSONObject == null) {
            throw new NullPointerException("can't save a null object");
        }
        int n = this._buf.getPosition();
        byte by = 3;
        if (bSONObject instanceof List) {
            by = 4;
        }
        if (this.handleSpecialObjects(string, bSONObject)) {
            return this._buf.getPosition() - n;
        }
        if (string != null) {
            this._put(by, string);
        }
        if (bSONObject instanceof IfxBSONObject) {
            this._buf.write(((IfxBSONObject)bSONObject).getBytes());
            return this._buf.getPosition() - n;
        }
        int n2 = this._buf.getPosition();
        this._buf.writeInt(0);
        List list = null;
        boolean bl2 = bl = by == 3 && string == null;
        if (by == 3) {
            Iterator<Object> iterator;
            if (bl && bSONObject.containsField("_id")) {
                this._putObjectField("_id", bSONObject.get("_id"));
            }
            if ((iterator = bSONObject.get("_transientFields")) instanceof List) {
                list = (List)((Object)iterator);
            }
        }
        if (bSONObject instanceof Map) {
            for (Map.Entry entry : ((Map)((Object)bSONObject)).entrySet()) {
                if (bl && ((String)entry.getKey()).equals("_id") || list != null && list.contains(entry.getKey())) continue;
                this._putObjectField((String)entry.getKey(), entry.getValue());
            }
        } else {
            for (String string2 : bSONObject.keySet()) {
                if (bl && string2.equals("_id") || list != null && list.contains(string2)) continue;
                Object object = bSONObject.get(string2);
                this._putObjectField(string2, object);
            }
        }
        this._buf.write(0);
        this._buf.writeInt(n2, this._buf.getPosition() - n2);
        return this._buf.getPosition() - n;
    }

    protected void _putObjectField(String string, Object object) {
        if (string.equals("_transientFields")) {
            return;
        }
        if (string.equals("$where") && object instanceof String) {
            this._put((byte)13, string);
            this._putValueString(object.toString());
            return;
        }
        if ((object = BSON.applyEncodingHooks(object)) == null) {
            this.putNull(string);
        } else if (object instanceof Date) {
            this.putDate(string, (Date)object);
        } else if (object instanceof Number) {
            this.putNumber(string, (Number)object);
        } else if (object instanceof Character) {
            this.putString(string, object.toString());
        } else if (object instanceof String) {
            this.putString(string, object.toString());
        } else if (object instanceof ObjectId) {
            this.putObjectId(string, (ObjectId)object);
        } else if (object instanceof BSONObject) {
            this.putObject(string, (BSONObject)object);
        } else if (object instanceof Boolean) {
            this.putBoolean(string, (Boolean)object);
        } else if (object instanceof Pattern) {
            this.putPattern(string, (Pattern)object);
        } else if (object instanceof Map) {
            this.putMap(string, (Map)object);
        } else if (object instanceof Iterable) {
            this.putIterable(string, (Iterable)object);
        } else if (object instanceof byte[]) {
            this.putBinary(string, (byte[])object);
        } else if (object instanceof Binary) {
            this.putBinary(string, (Binary)object);
        } else if (object instanceof UUID) {
            this.putUUID(string, (UUID)object);
        } else if (object.getClass().isArray()) {
            this.putArray(string, object);
        } else if (object instanceof Symbol) {
            this.putSymbol(string, (Symbol)object);
        } else if (object instanceof BSONTimestamp) {
            this.putTimestamp(string, (BSONTimestamp)object);
        } else if (object instanceof CodeWScope) {
            this.putCodeWScope(string, (CodeWScope)object);
        } else if (object instanceof Code) {
            this.putCode(string, (Code)object);
        } else if (object instanceof DBRefBase) {
            BasicBSONObject basicBSONObject = new BasicBSONObject();
            basicBSONObject.put("$ref", (Object)((DBRefBase)object).getRef());
            basicBSONObject.put("$id", ((DBRefBase)object).getId());
            this.putObject(string, basicBSONObject);
        } else if (object instanceof MinKey) {
            this.putMinKey(string);
        } else if (object instanceof MaxKey) {
            this.putMaxKey(string);
        } else if (!this.putSpecial(string, object)) {
            throw new IllegalArgumentException("can't serialize " + object.getClass());
        }
    }

    private void putArray(String string, Object object) {
        this._put((byte)4, string);
        int n = this._buf.getPosition();
        this._buf.writeInt(0);
        int n2 = Array.getLength(object);
        for (int i = 0; i < n2; ++i) {
            this._putObjectField(String.valueOf(i), Array.get(object, i));
        }
        this._buf.write(0);
        this._buf.writeInt(n, this._buf.getPosition() - n);
    }

    private void putIterable(String string, Iterable iterable) {
        this._put((byte)4, string);
        int n = this._buf.getPosition();
        this._buf.writeInt(0);
        int n2 = 0;
        for (Object t : iterable) {
            this._putObjectField(String.valueOf(n2), t);
            ++n2;
        }
        this._buf.write(0);
        this._buf.writeInt(n, this._buf.getPosition() - n);
    }

    private void putMap(String string, Map map) {
        this._put((byte)3, string);
        int n = this._buf.getPosition();
        this._buf.writeInt(0);
        for (Map.Entry entry : map.entrySet()) {
            this._putObjectField(entry.getKey().toString(), entry.getValue());
        }
        this._buf.write(0);
        this._buf.writeInt(n, this._buf.getPosition() - n);
    }

    protected void putNull(String string) {
        this._put((byte)10, string);
    }

    protected void putUndefined(String string) {
        this._put((byte)6, string);
    }

    protected void putTimestamp(String string, BSONTimestamp bSONTimestamp) {
        this._put((byte)17, string);
        this._buf.writeInt(bSONTimestamp.getInc());
        this._buf.writeInt(bSONTimestamp.getTime());
    }

    protected void putCodeWScope(String string, CodeWScope codeWScope) {
        this._put((byte)15, string);
        int n = this._buf.getPosition();
        this._buf.writeInt(0);
        this._putValueString(codeWScope.getCode());
        this.putObject(codeWScope.getScope());
        this._buf.writeInt(n, this._buf.getPosition() - n);
    }

    protected void putCode(String string, Code code) {
        this._put((byte)13, string);
        int n = this._buf.getPosition();
        this._putValueString(code.getCode());
    }

    protected void putBoolean(String string, Boolean bl) {
        this._put((byte)8, string);
        this._buf.write(bl != false ? 1 : 0);
    }

    protected void putDate(String string, Date date) {
        this._put((byte)9, string);
        this._buf.writeLong(date.getTime());
    }

    protected void putNumber(String string, Number number) {
        if (number instanceof Integer || number instanceof Short || number instanceof Byte || number instanceof AtomicInteger) {
            this._put((byte)16, string);
            this._buf.writeInt(number.intValue());
        } else if (number instanceof Long || number instanceof AtomicLong) {
            this._put((byte)18, string);
            this._buf.writeLong(number.longValue());
        } else if (number instanceof Float || number instanceof Double) {
            this._put((byte)1, string);
            this._buf.writeDouble(number.doubleValue());
        } else if (number instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)number;
            if (bigDecimal.scale() <= 0) {
                if (bigDecimal.precision() - bigDecimal.scale() <= 9) {
                    this._put((byte)16, string);
                    this._buf.writeInt(number.intValue());
                } else {
                    this._put((byte)18, string);
                    this._buf.writeLong(number.longValue());
                }
            } else {
                this._put((byte)1, string);
                this._buf.writeDouble(number.doubleValue());
            }
        } else {
            throw new IllegalArgumentException("can't serialize " + number.getClass());
        }
    }

    protected void putBinary(String string, byte[] byArray) {
        this.putBinary(string, 0, byArray);
    }

    protected void putBinary(String string, Binary binary) {
        this.putBinary(string, binary.getType(), binary.getData());
    }

    private void putBinary(String string, int n, byte[] byArray) {
        this._put((byte)5, string);
        int n2 = byArray.length;
        if (n == 2) {
            n2 += 4;
        }
        this._buf.writeInt(n2);
        this._buf.write(n);
        if (n == 2) {
            this._buf.writeInt(n2 - 4);
        }
        int n3 = this._buf.getPosition();
        this._buf.write(byArray);
        int n4 = this._buf.getPosition();
        MyAsserts.assertEquals(n4 - n3, byArray.length);
    }

    protected void putUUID(String string, UUID uUID) {
        this._put((byte)5, string);
        this._buf.writeInt(16);
        this._buf.write(3);
        this._buf.writeLong(uUID.getMostSignificantBits());
        this._buf.writeLong(uUID.getLeastSignificantBits());
    }

    protected void putSymbol(String string, Symbol symbol) {
        this._putString(string, symbol.getSymbol(), (byte)14);
    }

    protected void putString(String string, String string2) {
        this._putString(string, string2, (byte)2);
    }

    private void _putString(String string, String string2, byte by) {
        this._put(by, string);
        this._putValueString(string2);
    }

    protected void putObjectId(String string, ObjectId objectId) {
        this._put((byte)7, string);
        this._buf.writeIntBE(objectId._time());
        this._buf.writeIntBE(objectId._machine());
        this._buf.writeIntBE(objectId._inc());
    }

    private void putPattern(String string, Pattern pattern) {
        this._put((byte)11, string);
        this._put(pattern.pattern());
        this._put(BSON.regexFlags(pattern.flags()));
    }

    private void putMinKey(String string) {
        this._put((byte)-1, string);
    }

    private void putMaxKey(String string) {
        this._put((byte)127, string);
    }

    protected void _put(byte by, String string) {
        this._buf.write(by);
        this._put(string);
    }

    protected void _putValueString(String string) {
        int n = this._buf.getPosition();
        this._buf.writeInt(0);
        int n2 = this._put(string);
        this._buf.writeInt(n, n2);
    }

    void _reset(Buffer buffer) {
        buffer.position(0);
        buffer.limit(buffer.capacity());
    }

    protected int _put(String string) {
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (int i = 0; i < n2; i += Character.charCount(n)) {
            n = Character.codePointAt(string, i);
            if (n < 128) {
                this._buf.write((byte)n);
                ++n3;
                continue;
            }
            if (n < 2048) {
                this._buf.write((byte)(192 + (n >> 6)));
                this._buf.write((byte)(128 + (n & 0x3F)));
                n3 += 2;
                continue;
            }
            if (n < 65536) {
                this._buf.write((byte)(224 + (n >> 12)));
                this._buf.write((byte)(128 + (n >> 6 & 0x3F)));
                this._buf.write((byte)(128 + (n & 0x3F)));
                n3 += 3;
                continue;
            }
            this._buf.write((byte)(240 + (n >> 18)));
            this._buf.write((byte)(128 + (n >> 12 & 0x3F)));
            this._buf.write((byte)(128 + (n >> 6 & 0x3F)));
            this._buf.write((byte)(128 + (n & 0x3F)));
            n3 += 4;
        }
        this._buf.write(0);
        return ++n3;
    }

    public void writeInt(int n) {
        this._buf.writeInt(n);
    }

    public void writeLong(long l) {
        this._buf.writeLong(l);
    }

    public void writeCString(String string) {
        this._put(string);
    }
}

