/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import com.gbasedbt.json.JSON;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BSON;
import org.bson.BSONObject;
import org.bson.types.ObjectId;

public class BasicBSONObject
extends LinkedHashMap<String, Object>
implements BSONObject {
    private static final long serialVersionUID = -4415279469780082174L;

    public BasicBSONObject() {
    }

    public BasicBSONObject(int n) {
        super(n);
    }

    public BasicBSONObject(String string, Object object) {
        this.put(string, object);
    }

    public BasicBSONObject(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Map<String, Object> toMap() {
        return new LinkedHashMap<String, Object>(this);
    }

    @Override
    public Object removeField(String string) {
        return this.remove(string);
    }

    @Override
    public boolean containsField(String string) {
        return super.containsKey(string);
    }

    @Override
    @Deprecated
    public boolean containsKey(String string) {
        return this.containsField(string);
    }

    @Override
    public Object get(String string) {
        return super.get(string);
    }

    public int getInt(String string) {
        Object object = this.get(string);
        if (object == null) {
            throw new NullPointerException("no value for: " + string);
        }
        return BSON.toInt(object);
    }

    public int getInt(String string, int n) {
        Object object = this.get(string);
        if (object == null) {
            return n;
        }
        return BSON.toInt(object);
    }

    public long getLong(String string) {
        Object object = this.get(string);
        return ((Number)object).longValue();
    }

    public long getLong(String string, long l) {
        Object object = this.get(string);
        if (object == null) {
            return l;
        }
        return ((Number)object).longValue();
    }

    public double getDouble(String string) {
        Object object = this.get(string);
        return ((Number)object).doubleValue();
    }

    public double getDouble(String string, double d) {
        Object object = this.get(string);
        if (object == null) {
            return d;
        }
        return ((Number)object).doubleValue();
    }

    public String getString(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public String getString(String string, String string2) {
        Object object = this.get(string);
        if (object == null) {
            return string2;
        }
        return object.toString();
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(string, false);
    }

    public boolean getBoolean(String string, boolean bl) {
        Object object = this.get(string);
        if (object == null) {
            return bl;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() > 0;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new IllegalArgumentException("can't coerce to bool:" + object.getClass());
    }

    public ObjectId getObjectId(String string) {
        return (ObjectId)this.get(string);
    }

    public ObjectId getObjectId(String string, ObjectId objectId) {
        Object object = this.get(string);
        return object != null ? (ObjectId)object : objectId;
    }

    public Date getDate(String string) {
        return (Date)this.get(string);
    }

    public Date getDate(String string, Date date) {
        Object object = this.get(string);
        return object != null ? (Date)object : date;
    }

    @Override
    public Object put(String string, Object object) {
        return super.put(string, object);
    }

    @Override
    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAll(BSONObject bSONObject) {
        for (String string : bSONObject.keySet()) {
            this.put(string, bSONObject.get(string));
        }
    }

    public BasicBSONObject append(String string, Object object) {
        this.put(string, object);
        return this;
    }

    @Override
    public String toString() {
        return JSON.serialize(this);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof BSONObject)) {
            return false;
        }
        BSONObject bSONObject = (BSONObject)object;
        if (!this.keySet().equals(bSONObject.keySet())) {
            return false;
        }
        for (String string : this.keySet()) {
            Object object2 = this.get(string);
            Object object3 = bSONObject.get(string);
            if (object2 == null && object3 != null) {
                return false;
            }
            if (object3 == null) {
                if (object2 == null) continue;
                return false;
            }
            if (object2 instanceof Number && object3 instanceof Number) {
                if (((Number)object2).doubleValue() == ((Number)object3).doubleValue()) continue;
                return false;
            }
            if (object2 instanceof Pattern && object3 instanceof Pattern) {
                Pattern pattern = (Pattern)object2;
                Pattern pattern2 = (Pattern)object3;
                if (pattern.pattern().equals(pattern2.pattern()) && pattern.flags() == pattern2.flags()) continue;
                return false;
            }
            if (object2.equals(object3)) continue;
            return false;
        }
        return true;
    }
}

