/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bson.util.Util;

public abstract class OutputBuffer
extends OutputStream {
    @Override
    public abstract void write(byte[] var1);

    @Override
    public abstract void write(byte[] var1, int var2, int var3);

    @Override
    public abstract void write(int var1);

    public abstract int getPosition();

    public abstract void setPosition(int var1);

    public abstract void seekEnd();

    public abstract void seekStart();

    public abstract int size();

    public abstract int pipe(OutputStream var1) throws IOException;

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(this.size());
            this.pipe(byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new RuntimeException("should be impossible", iOException);
        }
    }

    public String asString() {
        return new String(this.toByteArray());
    }

    public String asString(String string) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), string);
    }

    public String hex() {
        final StringBuilder stringBuilder = new StringBuilder();
        try {
            this.pipe(new OutputStream(){

                @Override
                public void write(int n) {
                    String string = Integer.toHexString(0xFF & n);
                    if (string.length() < 2) {
                        stringBuilder.append("0");
                    }
                    stringBuilder.append(string);
                }
            });
        }
        catch (IOException iOException) {
            throw new RuntimeException("impossible");
        }
        return stringBuilder.toString();
    }

    public String md5() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("Error - this implementation of Java doesn't support MD5.");
        }
        messageDigest.reset();
        try {
            this.pipe(new OutputStream(){

                @Override
                public void write(byte[] byArray, int n, int n2) {
                    messageDigest.update(byArray, n, n2);
                }

                @Override
                public void write(int n) {
                    messageDigest.update((byte)(n & 0xFF));
                }
            });
        }
        catch (IOException iOException) {
            throw new RuntimeException("impossible");
        }
        return Util.toHex(messageDigest.digest());
    }

    public void writeInt(int n) {
        this.write(n >> 0);
        this.write(n >> 8);
        this.write(n >> 16);
        this.write(n >> 24);
    }

    public void writeIntBE(int n) {
        this.write(n >> 24);
        this.write(n >> 16);
        this.write(n >> 8);
        this.write(n);
    }

    public void writeInt(int n, int n2) {
        int n3 = this.getPosition();
        this.setPosition(n);
        this.writeInt(n2);
        this.setPosition(n3);
    }

    public void writeLong(long l) {
        this.write((byte)(0xFFL & l >> 0));
        this.write((byte)(0xFFL & l >> 8));
        this.write((byte)(0xFFL & l >> 16));
        this.write((byte)(0xFFL & l >> 24));
        this.write((byte)(0xFFL & l >> 32));
        this.write((byte)(0xFFL & l >> 40));
        this.write((byte)(0xFFL & l >> 48));
        this.write((byte)(0xFFL & l >> 56));
    }

    public void writeDouble(double d) {
        this.writeLong(Double.doubleToRawLongBits(d));
    }

    public String toString() {
        return this.getClass().getName() + " size: " + this.size() + " pos: " + this.getPosition();
    }
}

