/*
 * Decompiled with CFR 0.152.
 */
package org.bson.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.bson.io.OutputBuffer;
import org.bson.io.UTF8Encoding;
import org.bson.util.SimplePool;

public class PoolOutputBuffer
extends OutputBuffer {
    public static final int BUF_SIZE = 16384;
    final byte[] _mine = new byte[16384];
    final char[] _chars = new char[16384];
    final List<byte[]> _fromPool = new ArrayList<byte[]>();
    final UTF8Encoding _encoding = new UTF8Encoding();
    private static final String DEFAULT_ENCODING_1 = "UTF-8";
    private static final String DEFAULT_ENCODING_2 = "UTF8";
    private final Position _cur = new Position();
    private final Position _end = new Position();
    private static SimplePool<byte[]> _extra = new SimplePool<byte[]>(640){

        @Override
        protected byte[] createNew() {
            return new byte[16384];
        }
    };

    public PoolOutputBuffer() {
        this.reset();
    }

    public void reset() {
        this._cur.reset();
        this._end.reset();
        for (int i = 0; i < this._fromPool.size(); ++i) {
            _extra.done(this._fromPool.get(i));
        }
        this._fromPool.clear();
    }

    @Override
    public int getPosition() {
        return this._cur.pos();
    }

    @Override
    public void setPosition(int n) {
        this._cur.reset(n);
    }

    @Override
    public void seekEnd() {
        this._cur.reset(this._end);
    }

    @Override
    public void seekStart() {
        this._cur.reset();
    }

    @Override
    public int size() {
        return this._end.pos();
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        while (n2 > 0) {
            byte[] byArray2 = this._cur();
            int n3 = Math.min(byArray2.length - this._cur.y, n2);
            System.arraycopy(byArray, n, byArray2, this._cur.y, n3);
            this._cur.inc(n3);
            n2 -= n3;
            n += n3;
            this._afterWrite();
        }
    }

    @Override
    public void write(int n) {
        byte[] byArray = this._cur();
        byArray[this._cur.getAndInc()] = (byte)(n & 0xFF);
        this._afterWrite();
    }

    void _afterWrite() {
        if (this._cur.pos() < this._end.pos()) {
            if (this._cur.y == 16384) {
                this._cur.nextBuffer();
            }
            return;
        }
        this._end.reset(this._cur);
        if (this._end.y < 16384) {
            return;
        }
        this._fromPool.add(_extra.get());
        this._end.nextBuffer();
        this._cur.reset(this._end);
    }

    byte[] _cur() {
        return this._get(this._cur.x);
    }

    byte[] _get(int n) {
        if (n < 0) {
            return this._mine;
        }
        return this._fromPool.get(n);
    }

    @Override
    public int pipe(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new NullPointerException("out is null");
        }
        int n = 0;
        for (int i = -1; i < this._fromPool.size(); ++i) {
            byte[] byArray = this._get(i);
            int n2 = this._end.len(i);
            outputStream.write(byArray, 0, n2);
            n += n2;
        }
        return n;
    }

    public String asAscii() {
        if (this._fromPool.size() > 0) {
            return super.asString();
        }
        int n = this.size();
        char[] cArray = n < this._chars.length ? this._chars : new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)this._mine[i];
        }
        return new String(cArray, 0, n);
    }

    @Override
    public String asString(String string) throws UnsupportedEncodingException {
        if (this._fromPool.size() > 0) {
            return super.asString(string);
        }
        if (string.equals(DEFAULT_ENCODING_1) || string.equals(DEFAULT_ENCODING_2)) {
            try {
                return this._encoding.decode(this._mine, 0, this.size());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new String(this._mine, 0, this.size(), string);
    }

    static class Position {
        int x;
        int y;

        Position() {
            this.reset();
        }

        void reset() {
            this.x = -1;
            this.y = 0;
        }

        void reset(Position position) {
            this.x = position.x;
            this.y = position.y;
        }

        void reset(int n) {
            this.x = n / 16384 - 1;
            this.y = n % 16384;
        }

        int pos() {
            return (this.x + 1) * 16384 + this.y;
        }

        int getAndInc() {
            return this.y++;
        }

        void inc(int n) {
            this.y += n;
            if (this.y > 16384) {
                throw new IllegalArgumentException("something is wrong");
            }
        }

        void nextBuffer() {
            if (this.y != 16384) {
                throw new IllegalArgumentException("broken");
            }
            ++this.x;
            this.y = 0;
        }

        int len(int n) {
            if (n < this.x) {
                return 16384;
            }
            return this.y;
        }

        public String toString() {
            return this.x + "," + this.y;
        }
    }
}

